# Chanter Kit

![Language](https://img.shields.io/static/v1?label=language&message=english%20%7C%20french%20%7C%20&color=informational)

**Autor** : **Adul**

**Update** : **Deratiseur**

[Link to readme](https://github.com/The-Gate-Project/Chanter_Kit/blob/main/ChanterKit/Readme-ChanterKit.txt)

[Link to original mod on SHS](http://www.shsforums.net/files/file/763-chanter-priestly-bard-kit-v14a/)

[Link to original forum on SHS](http://www.shsforums.net/topic/39877-chanter-priestly-bard-kit-v14a/)

Playable Bard (monk/priest) kit for Baldur's Gate II:
Baldur's Gate, BG : EE, Baldur's Gate II, BG2: EE, Icewind Dale: EE, Baldur's Gate Trilogy (BGT) and the Enhanced Edition Trilogy (EET).


## Description:
------------


MAIN COMPONENT: [Chanter Kit]

Chanters are monk-priests who specialize in the keeping and telling of
ancient lore. Imbued by divine power and primordial secrets, their
chants bear powerful magical properties that can aid allies or smite
enemies.

Advantages:
- Has access to a selection of priest spells.
- Can cast spells in armor.
- Immune to effects that cause casting failure.
- Has access to a number of chants. A chant works like a bard song and
  affects all nearby allies.
  Level 1: Sanctum (+2 to all saves, protection from fear)
  Level 6: Contegitas (+33% fire, cold, lightning, and acid resistance)
  Level 9: Omnimens (immunity to charm, confusion, and hold effects)
  Level 14: Salve (heal 1 HP each round, immunity to level drain)
  Level 17: Veritas (removes all nearby illusions and grants true seeing)

Disadvantages:
- Cannot learn or cast wizard spells.
- Cannot pick pockets.
- No proficiency in two-weapon fighting.


OPTIONAL COMPONENT: [Chanter gains cleric stronghold instead of bard one]

This requires the main component to be installed, and it allows a chanter
protagonist to claim the temple stronghold. As with clerics, the
character's alignment determines which temple approaches them.

Without this component the chanter gains the playhouse like all bards do.


**The componant two has been reviewed to not overwrite files, but it's still experimental and bug report are welcome**

 
<details>
  <summary>Previous comment from the autor :</summary>
This component patches some dialog files and replaces several scripts.
For reference, see the full list of modified files below:

BHARVAL.DLG; BHNALLA.DLG; BHOISIG.DLG; BORINALL.DLG; BOUNHA.DLG;
BRUS2.DLG; GAELAN.DLG; HAERDA.DLG; RAELIS.DLG; SCSAIN.DLG; TRAVIN.DLG;
AR0900.BCS; AR0901.BCS; AR0902.BCS; AR0904.BCS; AR2905.BCS; ARVAL.BCS;
NALLABIR.BCS; OISIG.BCS

To ensure compatibility, you should install this component AFTER the BG2
BG2 Fixpack. (If you install both mods, that is.)

</details>


## Install:
--------

Extract archive contents into your game directory
Run setup-ChanterKit.exe
Follow the prompt


## Version History:
----------------

v 1.0: 

- Initial release  

v 1.1:  

- Fixed an error that prevented the chanter from gaining access to the Sanitas chant at level 14  

v 1.2: 

- Solved an issue that caused character creation to become stuck at the spell selection screen unless starting a chanter at level 1  

v 1.3:  

- Fixed a bug that prevented a new chanter character from being set up properly at the start of the game

v 1.3a:  

- Fixed a critical error introduced in version 1.3  

v 1.4:  

- Added a new component that allows chanters to claim the cleric stronghold instead of the bard one  

- Added new functionality to restore deleted spells to the chanter's spellbook at level up and when switching between chants ('Quest' level spells cannot be restored this way)  

- Fixed an error that caused some of the chanter's abilities to expire under certain conditions  

- The chanter's Alchemy, Scribe Scrolls, and Magic Flute high level abilities have been altered to produce items more relevant to the chanter's role

- Increased the extent of the elemental resistances bestowed by the Contegitas chant from 20% to 33%  

- Reduced the total number of spells a level 40 chanter can memorize by one spell for each spell level  

- Renamed the following chanter abilities:   
	- Consilium   -> Omnimens  
	- Magic Flute -> Mystic Flute  
	- Purgatorium -> Expulses  
	- Sanitas     -> Salve  

- Changed the in-game descriptions for several chanter abilities  

v 1.4a: 

- Fixed a bug that caused first level chanter characters to cast Magic Missile on themselves after character creation and when switching between chants (don't ask)  

V 1.5: 

- Trayfied and adapted for the EE games (by deratiseur)  

V 1.6: 

- Add EET compatibility (by deratiseur)      

V 1.7: 

- Update WeiDU  
- Add readme.md    
- Add InfinityAutoPackager thanks to AL|EN  
- Add metadata and label for Project Infinity  
- Upload on The Gate Project
- Attempt to avoid files from being overwritten by the second component   
- ReUpdate fl#add_kit_ee.tpa to last version (2017)
- Corrected kit name not displayed correctly  

