(* CygWin Arch-Specific Definitions *)

(* Query the Windows Registry to find out about Infinity Engine games. *)
let unixifydir str = Str.global_replace (Str.regexp (Str.quote "\\")) "/" str

external registry_path : unit -> string = "get_bg2main_path" 
external bg_registry_path : unit -> string = "get_bgmain_path" 
external iwd_registry_path : unit -> string = "get_iwdmain_path" 
external iwd2_registry_path : unit -> string = "get_iwd2main_path" 
external pst_registry_path : unit -> string = "get_pstmain_path" 

let registry_paths = ref [ 
  unixifydir (registry_path ()) ;
  unixifydir (bg_registry_path ()) ;
  unixifydir (iwd_registry_path ()) ;
  unixifydir (iwd2_registry_path ()) ;
  unixifydir (pst_registry_path ()) ; 
  "C:/Program Files/Black Isle/BGII - SoA/" 
] 

(* no slash removal: helps make shell scripts work better *)
let slash_to_backslash s = s 

(* how to view a text file *)
let view_command = "less" 

let do_auto_update = false 

(* handle AT_EXIT ~VIEW mydir\myfile.txt~ *)
let handle_view_command s =
  let view_regexp = Str.regexp_case_fold "^VIEW" in
  if Str.string_match view_regexp s 0 then begin
    (* first, replace VIEW with my view command *) 
    let result = Str.replace_first view_regexp view_command s in 
    (* next, for unix, replace \ with / *)
    Str.global_replace (Str.regexp (Str.quote "\\")) "/" result 
  end else s 

let glob str fn = failwith "no globbing support"

let create_process_env = Unix.create_process_env

let biff_path_separator = "\\\\"
