(* Mac OSX Arch-Specific Definitions *)

let registry_paths = ref [ "\\BGII - SoA\\" ] 

(* no slash removal: helps make shell scripts work better *)
let slash_to_backslash s = s 

(* how to view a text file *)
(* let view_command = "open -a /Applications/TextEdit.app/"  *)
let view_command = "open"

let do_auto_update = false 

(* handle AT_EXIT ~VIEW mydir\myfile.txt~ *)
let handle_view_command s =
  let view_regexp = Str.regexp_case_fold "^VIEW" in
  if Str.string_match view_regexp s 0 then begin
    (* first, replace VIEW with my view command *) 
    let result = Str.replace_first view_regexp view_command s in 
    (* next, for osx, replace \ with / *)
    Str.global_replace (Str.regexp (Str.quote "\\")) "/" result 
  end else s 

let glob str fn = failwith "no globbing support"

let create_process_env = Unix.create_process_env

let biff_path_separator = ":"
