(* Generic Unix Definitions *)

let registry_paths = ref [ "\\BGII - SoA\\" ] 

(* no slash removal: helps make shell scripts work better *)
let slash_to_backslash s = s 

(* how to view a text file *)
let view_command = "less" 

let do_auto_update = false 

(* handle AT_EXIT ~VIEW mydir\myfile.txt~ *)
let handle_view_command s =
  let view_regexp = Str.regexp_case_fold "^VIEW" in
  if Str.string_match view_regexp s 0 then begin
    (* first, replace VIEW with my view command *) 
    let result = Str.replace_first view_regexp view_command s in 
    (* next, for unix, replace \ with / *)
    Str.global_replace (Str.regexp (Str.quote "\\")) "/" result 
  end else s 

let glob str fn = failwith "no globbing support"

let biff_path_separator = "\\\\" (* unix, but BG2 runs on Windows *)

let create_process_env = Unix.create_process_env
