{
open Util
open Bafparser

(*
** Keyword hashtable
*)

let string_of lb = (Lexing.lexeme lb) 

let lexicon = Hashtbl.create 211
let _ = List.iter 
    (fun (key, token) -> Hashtbl.add lexicon key token)
    [ 
      ("IF", IF) ;
      ("THEN", THEN) ;
      ("END", END) ;
      ("RESPONSE", RESPONSE) ;
      ("ANYONE", ANYONE) ;
      ("ACTIONOVERRIDE", ACTIONOVERRIDE) ;
    ]
} 

let blank = [' ' '\012' '\r']

rule initial = parse 	
  "/*"  { adj lexbuf ; let _ = comment lexbuf in initial lexbuf}
| "//"  { adj lexbuf ; endline lexbuf }
| blank	{ adj lexbuf ; initial lexbuf}
| '\t'  { tab (); initial lexbuf }
| '\n'  { newline (); initial lexbuf }
| '('   { adj lexbuf ; LPAREN } 
| ')'   { adj lexbuf ; RPAREN } 
| '!'   { adj lexbuf ; NOT } 
| '#'   { adj lexbuf ; HASH } 
| ','   { adj lexbuf ; COMMA } 
| '.'   { adj lexbuf ; PERIOD } 
| '['   { adj lexbuf ; LBRACKET } 
| ']'   { adj lexbuf ; RBRACKET } 
| eof   { EOF }
| '~'[^'~']*'~' 
| '%'[^'%']*'%' { str_adj lexbuf ; TILDE_STRING(strip (string_of lexbuf))}
| '@'['0'-'9']+ { adj lexbuf ;
      let str = string_of lexbuf in
      let str = String.sub str 1 ((String.length str) - 1) in
      TRANS_REF((Int32.of_string str)) }
| '"'[^'"']*'"'  { str_adj lexbuf ; STRING(strip (string_of lexbuf)) } 
| ['A'-'Z''a'-'z']['0'-'9''A'-'Z''a'-'z''#''_''-']* { 
    adj lexbuf ; 
    try Hashtbl.find lexicon (string_of lexbuf) 
    with _ -> begin
      try Hashtbl.find lexicon (String.uppercase (string_of lexbuf))
      with _ -> SYMBOL(string_of lexbuf)
    end }
| ['-']?("0x")?['0'-'9']+ { adj lexbuf ;
      let str = string_of lexbuf in
      INTEGER((Int32.of_string str)) }
and comment = parse 	
      "*/"	{ adj lexbuf ; () }
|     '\n'      { newline (); comment lexbuf }
|     "/*"      { adj lexbuf ; let _ = comment lexbuf in comment lexbuf } 
|     eof       { lex_error "unterminated comment" } 
|     _ 	{ adj lexbuf ; comment lexbuf }
and endline = parse 
        '\n' 			{ newline (); initial lexbuf}
|	_			{ adj lexbuf ; endline lexbuf}
|       eof                     { EOF }
