(*
 * Weimer's BG2 -> IWD2 automatic converter
 *)

open Util

let weiback_version = 5

let copy_one_file src dst =
  let buff = load_file src in
  let oc = open_out_bin dst in
  output_string oc buff ;
  close_out oc

let iterdir s f =
  let s_d_h = try Unix.opendir s
              with _ -> failwith ("cannot open directory " ^ s) in
  begin try
    while true do
      let s' = Unix.readdir s_d_h in
      let filename = (s ^ "/" ^ s') in
      try f filename with _ -> () 
    done
  with e -> (Unix.closedir s_d_h ) end

(*let fixup_save () =
    let old_buff = try
    load_file "save/000000002-final-save/baldur.gam" with e ->
    (log_and_print "Could not load baldur.gam in final save directory\nComplete the game and try again!\n" ; exit 1)
    in
    log_and_print "Baldur.gam successfully loaded in final save directory\n";
    let buff = load_file "bg1tutu/backup/baldur.gam" in
    let charname_entry = String.sub old_buff 0xb4 352 in
    let charname_off = int_of_str_off old_buff 0xb8 in
    let charname_size = int_of_str_off old_buff 0xbc in
    let charname_cre = String.sub old_buff charname_off charname_size in
    write_int buff 0x20 0xb4;
    let before = Str.string_before buff 0xb4 in
    let after = Str.string_after buff 0xb4 in
    let new_buff = before ^ charname_entry ^ charname_cre ^ after in
    write_int new_buff 0x24 1;
    let unknown = int_of_str_off new_buff 0x28 in
    let non_party_global = int_of_str_off new_buff 0x30 in
    let journal_entry = int_of_str_off new_buff 0x50 in
    let familiar = int_of_str_off new_buff 0x68 in
    write_int new_buff 0x28 (unknown + charname_size + 352);
    write_int new_buff 0x30 (non_party_global + charname_size + 352);
    write_int new_buff 0x38 (non_party_global + charname_size + 352);
    write_int new_buff 0x50 (journal_entry + charname_size + 352);
    String.blit "AR0602" 0 new_buff 0x58 6;
    write_byte new_buff 0x64 0x4;
    write_short new_buff 0x74 0x06AB;
    write_int new_buff 0x68 (familiar + charname_size + 352);
    write_int new_buff 0x6c charname_size;
    write_int new_buff 0x78 charname_size;
    write_int new_buff 0xb8 0x214;
    
    (* Clean up the stats (e.g. Like Favourite Weapon, etc. *)
    let offset = 0xb4 in
    write_short new_buff offset 0; (* Unselected *)
    write_short new_buff (offset + 0xc8 - offset) 0x1; (* Orientation *)
    String.blit "AR0602" 0 new_buff (offset + 0xcc - offset) 6;
    write_short new_buff 0xd4 3741; (* X Co-ordinate *)
    write_short new_buff 0xd6 2801; (* Y Co-ordinate *)
    write_short new_buff 0xd8 3230; (* X Recticle *)
    write_short new_buff 0xda 2628; (* Y Recticle *)
    write_int new_buff (offset + 0x198 - offset) (Int32.to_int Int32.minus_one); (* Powerful foe *)
    write_int new_buff (offset + 0x19c - offset) 0; (* XP *)
    
    for i = 0 to 3 do
    write_int new_buff (offset + (0x1ac - offset) + (i * 4)) 0
    done;

    for i = 0 to 7 do
    write_int new_buff (offset + (0x1bc - offset) + (i * 4)) 0
    done;

    for i = 0 to 3 do
    write_short new_buff (offset + (0x1dc - offset) + (i * 2)) 0
    done;

    for i = 0 to 7 do
    write_int new_buff (offset + (0x1e4 - offset) + (i * 4)) 0
    done;

    for i = 0 to 3 do
    write_short new_buff (offset + (0x204 - offset) + (i * 2)) 0
    done;
    
    (*(* Clean up CHARNAME's CRE *)
    let off = 0x214 in
    let effects_off = int_of_str_off new_buff 0x4d8 in
    let actual_effects_off = effects_off + off in
    let neffects = int_of_str_off new_buff 0x4dc in

    let effects_length = neffects * 264 in
    let effects_chunk = String.sub new_buff actual_effects_off effects_length in

    let effect_keep = ref "" in
    for i = 0 to neffects - 1 do
    let str_chunk = String.sub effects_chunk (i * 264) 264 in
    log_and_print "%d is the length of the chunk" (String.length str_chunk);
    let opcode = int_of_str_off str_chunk 0x8 in
    match opcode with
    | 233 -> effect_keep := str_chunk ^ !effect_keep
    | _ -> ()
    done;
    
    let keep_length = String.length !effect_keep in

    write_int new_buff 0x4dc (keep_length / 264);
    write_int new_buff 0x4e0 0;
    write_int new_buff 0x4e4 0;
    write_int new_buff 0xbc (charname_size + keep_length - effects_length);

    let re_before = Str.string_before new_buff actual_effects_off in
    let sub_after = int_of_str_off new_buff 0x30 in
    let re_after = Str.string_after new_buff sub_after in
    let ultra_buff = re_before ^ !effect_keep ^ re_after in

    let unknown = int_of_str_off ultra_buff 0x28 in
    let non_party_global = int_of_str_off ultra_buff 0x30 in
    let journal_entry = int_of_str_off ultra_buff 0x50 in
    let familiar = int_of_str_off ultra_buff 0x68 in
    write_int ultra_buff 0x28 (unknown + keep_length - effects_length);
    write_int ultra_buff 0x30 (non_party_global + keep_length - effects_length);
    write_int ultra_buff 0x38 (non_party_global + keep_length - effects_length);
    write_int ultra_buff 0x50 (journal_entry + keep_length - effects_length);
    write_int ultra_buff 0x68 (familiar + keep_length - effects_length);
    write_int ultra_buff 0x6c (charname_size + keep_length - effects_length);
    write_int ultra_buff 0x78 (charname_size + keep_length - effects_length);*)
    
    log_and_print "Creating bg1tutu-transition directory\n";
    try
    Unix.mkdir "save/bg1tutu-transition" 511
    with e -> log_and_print "save/bg1tutu_transition already exists...skipping\n";

    log_and_print "Splicing <CHARNAME> into baldur.gam and saving it into bg1tutu-transition\n";
    let oc = open_out_bin "save/bg1tutu-transition/baldur.gam" in
    output_string oc new_buff;
    close_out oc;

    let por_buff = load_file "save/000000002-final-save/portrt0.bmp" in
    let oc = open_out_bin "save/bg1tutu-transition/portrt0.bmp" in
    output_string oc por_buff;
    close_out oc;
    
    let baldur_buff = load_file "save/000000002-final-save/baldur.bmp" in
    let oc = open_out_bin "save/bg1tutu-transition/baldur.bmp" in
    output_string oc baldur_buff;
    close_out oc;
    
    if file_size "data/25dialog.bif" > 0 then begin
    let save_buff = load_file "bg1tutu/tob/baldur.sav" in
    let oc = open_out_bin "save/bg1tutu-transition/baldur.sav" in
    output_string oc save_buff;
    let wmp_buff = load_file "bg1tutu/tob/worldmap.wmp" in
    let oc = open_out_bin "save/bg1tutu-transition/worldmap.wmp" in
    output_string oc wmp_buff;
    let arbuff = load_file "bg1tutu/tob/ar0602.bcs" in
    let oc = open_out_bin "override/ar0602.bcs" in
    output_string oc arbuff;
    close_out oc
    end else begin
    let save_buff = load_file "bg1tutu/bgii/baldur.sav" in
    let oc = open_out_bin "save/bg1tutu-transition/baldur.sav" in
    output_string oc save_buff;
    let wmp_buff = load_file "bg1tutu/bgii/worldmap.wmp" in
    let oc = open_out_bin "save/bg1tutu-transition/worldmap.wmp" in
    output_string oc wmp_buff;
    let arbuff = load_file "bg1tutu/tob/ar0602.bcs" in
    let oc = open_out_bin "override/ar0602.bcs" in
    output_string oc arbuff
    end*)

let bring_back_files () =
   log_and_print "Deleting the contents of the override folder...\n";
   let s = "override/" in
      iterdir s (fun filename ->
      if file_size filename > 0 then
      Unix.unlink filename
      );
   
   log_and_print "Removing Tutufix backups...\n";
   for i = 0 to 6 do
   if is_directory ("bg1tutu/tutufix/backup/" ^ (string_of_int i)) then
   let s = "bg1tutu/tutufix/backup/" ^ (string_of_int i) ^ "/" in
      iterdir s (fun filename ->
      if not (is_directory filename) then
      Unix.unlink filename
      );
   done;

   log_and_print "Removing Tutufix backup directories...\n";
   for i = 0 to 6 do
   if is_directory ("bg1tutu/tutufix/backup/" ^ (string_of_int i)) then
   Unix.rmdir ("bg1tutu/tutufix/backup/" ^ (string_of_int i));
   done;

   if file_size "dialog.tlk" > 0 then begin
   log_and_print "Removing dialog.tlk...\n";
   Unix.unlink "dialog.tlk"
   end ;

   if file_size "dialogf.tlk" > 0 then begin
   log_and_print "Removing dialogf.tlk...\n";
   Unix.unlink "dialogf.tlk"
   end;

   if file_size "chitin.key" > 0 then begin
   log_and_print "Removing chitin.key...\n";
   Unix.unlink "chitin.key"
   end;

   if file_size "baldur.ini" > 0 then begin
   log_and_print "Removing baldur.ini...\n";
   Unix.unlink "baldur.ini"
   end;

   if file_size "bgmain.exe" > 0 then begin
   log_and_print "Removing BGMain.exe...\n";
   Unix.unlink "bgmain.exe"
   end;

   if file_size "bg1tutu.log" > 0 then
   Unix.unlink "bg1tutu.log";

   if file_size "weidu.log" > 0 then
   Unix.unlink "weidu.log";

   if file_size "SETUP-TUTUFIX.DEBUG" > 0 then
   Unix.unlink "SETUP-TUTUFIX.DEBUG";

   let buff = load_file "bg1tutu/bringback" in
   if file_size (buff ^ "/baldur.ini") > 0 then begin
   log_and_print "Removing BG baldur.ini...\n";
   Unix.unlink (buff ^ "/baldur.ini")
   end;

   let filename = "bg1tutu/backup/dialog.tlk" in
   let dst = (Filename.basename filename) in
   if file_size filename > 0 then begin
   log_and_print "Copying dialog.tlk back...\n";
   copy_one_file filename dst
   end;

   let filename = "bg1tutu/backup/dialogf.tlk" in
   let dst = (Filename.basename filename) in
   if file_size filename > 0 then begin
   log_and_print "Copying dialogf.tlk back...\n";
   copy_one_file filename dst
   end;

   let filename = "bg1tutu/backup/chitin.key" in
   let dst = (Filename.basename filename) in
   if file_size filename > 0 then begin
   log_and_print "Copying chitin.key back...\n";
   copy_one_file filename dst
   end;

   let filename = "bg1tutu/backup/BGMain.exe" in
   let dst = (Filename.basename filename) in
   if file_size filename > 0 then begin
   log_and_print "Copying BGMain.exe back...\n";
   copy_one_file filename dst
   end;

   let filename = "bg1tutu/backup/bg2baldur.ini" in
   let dst = (Filename.basename "baldur.ini") in
   if file_size filename > 0 then begin
   log_and_print "Copying baldur.ini back to BGII directory...\n";
   copy_one_file filename dst
   end;

   let buff = load_file "bg1tutu/bringback" in
   let filename = "bg1tutu/backup/bg1baldur.ini" in
   if file_size filename > 0 then begin
   log_and_print "Copying baldur.ini back to BG1 directory...\n";
   copy_one_file filename (buff ^ "/" ^ "baldur.ini")
   end;

   log_and_print "Copying override contents back...\nPlease be patient...\n";
   let s = "bg1tutu/backup/override/" in
       iterdir s (fun filename ->
        let dst = "override/" ^
          (Filename.basename filename) in
        if file_size filename > 0 then copy_one_file filename dst
      );

   log_and_print "Deleting backups files in bg1tutu/backup...\n";
   let s = "bg1tutu/backup/override/" in
      iterdir s (fun filename ->
      if file_size filename > 0 then
      Unix.unlink filename
      );

   Unix.rmdir "bg1tutu/backup/override" ;

   let s = "bg1tutu/backup/" in
      iterdir s (fun filename ->
      if file_size filename > 0 then
      Unix.unlink filename
      );

   Unix.unlink "bg1tutu/bringback"

let main () = begin

  init_log "bg1tutu_restore.log";

  log_and_print "\t\tBG1Tutu Restore (version %d)\n" weiback_version ;
  
  bring_back_files () ;

  (* fixup_save () ; *)

end

;;

(try
  Stats2.time "main" main ()
with e ->
  log_and_print "\nERROR: %s\n" (Printexc.to_string e) ) 

;;

exit 0 ;;
