type biff_file = {
  res_loc : int;
  res_offset : int;
  res_size : int;
  res_type : int;
} 
and biff_tis = {
  tis_loc : int;
  tis_offset : int;
  tis_number_of_tiles : int;
  tis_size_of_one_tile : int;
  tis_type : int;
} 
and biff = {
  fd : Unix.file_descr;
  files : biff_file array;
  tilesets : biff_tis array;
  filename : string;
  compressed : bool;
} 
val save_biff : Key.key -> string -> string list -> Key.key
val load_biff : string -> biff
val extract_file : biff -> int -> string
val extract_tis : biff -> int -> string
val copy_file : biff -> int -> out_channel -> bool -> unit
