{
open Util
open Dparser

(*
** Keyword hashtable
*)

let string_of lb = (Lexing.lexeme lb) 

let lexicon = Hashtbl.create 211
let _ = List.iter 
    (fun (key, token) -> Hashtbl.add lexicon key token)
    [ 
      ("ASK_EVERY_COMPONENT", ASK_EVERY_COMPONENT); 
      ("ACTION_IF", ACTION_IF) ;
      ("PATCH_IF", PATCH_IF) ;
	  ("ADD_CRE_ITEM", ADD_CRE_ITEM) ;
      ("ADD_KIT", ADD_KIT) ;
	  ("ADD_KNOWN_SPELL", ADD_KNOWN_SPELL) ;
      ("ADD_MUSIC", ADD_MUSIC) ;
      ("ADD_PROJECTILE", ADD_PROJECTILE) ;
      ("ADD_STATE_TRIGGER", ADD_STATE_TRIGGER) ;
      ("ADD_TRANS_TRIGGER", ADD_TRANS_TRIGGER) ;
      ("ADD_TRANS_ACTION", ADD_TRANS_ACTION) ;
      ("ALLOW_MISSING", ALLOW_MISSING) ; 
      ("ALWAYS", ALWAYS) ; 
      ("APPEND", APPEND); 
      ("APPENDI", APPENDI); 
      ("BUT_ONLY_IF_IT_CHANGES", BUT_ONLY_IF_IT_CHANGES); 
      ("DEPRECATED", DEPRECATED); 
      ("DESIGNATED", DESIGNATED); 
      ("GLOB", GLOB); 
      ("EQUIP", EQUIP);
      ("TWOHANDED", TWOHANDED); 
	  ("ADD_MAP_NOTE", ADD_MAP_NOTE); 
      ("ADD_STORE_ITEM", ADD_STORE_ITEM);
      ("APPEND_COL", APPEND_COL); 
      ("AT_EXIT", AT_EXIT); 
      ("AT_INTERACTIVE_EXIT", AT_INTERACTIVE_EXIT); 
      ("AT_INTERACTIVE_UNINSTALL", AT_INTERACTIVE_UNINSTALL); 
      ("AT_UNINSTALL", AT_UNINSTALL); 
      ("AUTHOR", AUTHOR); 
      ("SET", SET); 
      ("AUTO_TRA", AUTO_TRA); 
      ("A_S_T", ADD_STATE_TRIGGER) ;
      ("A_T_T", ADD_TRANS_TRIGGER) ;
      ("BACKUP", BACKUP) ;
      ("BEGIN", BEGIN) ;
      ("CHAIN", CHAIN3);
      ("CHAIN2", CHAIN2);
      ("CHAIN3", CHAIN3);
      ("COMPILE", COMPILE);
      ("COMPILE_BAF_TO_BCS", COMPILE_BAF_TO_BCS);
      ("COMPILE_D_TO_DLG", COMPILE_D_TO_DLG);
      ("DECOMPILE_BCS_TO_BAF", DECOMPILE_BCS_TO_BAF);
      ("DECOMPILE_DLG_TO_D", DECOMPILE_DLG_TO_D);
      ("COPY", COPY);
      ("COPY_EXISTING", COPY_EXISTING);
      ("COPY_EXISTING_REGEXP", COPY_EXISTING_REGEXP);
      ("COPY_RANDOM", COPY_RANDOM);
      ("COPY_TRANS", COPY_TRANS);
      ("DELETE_BYTES", DELETE_BYTES);
      ("DO", DO) ;
      ("ELSE", ELSE) ;
      ("END", END) ;
      ("SET_2DA_ENTRY", SET_2DA_ENTRY) ;
      ("EXIT", EXIT) ;
      ("EXTEND_BOTTOM", EXTEND_BOTTOM) ; ("EXTEND",EXTEND_BOTTOM) ; 
      ("EXTEND_TOP", EXTEND_TOP) ;
      ("EXTEND_TOP_REGEXP", EXTEND_TOP_REGEXP);
      ("EXTEND_BOTTOM_REGEXP", EXTEND_BOTTOM_REGEXP);
      ("EXTERN", EXTERN) ;
      ("FAIL", FAIL);
      ("FLAGS", FLAGS);
      ("FORBID_FILE", FORBID_FILE) ; 
      ("FOR", FOR) ; 
      ("GOTO", GOTO) ;
      ("IF", IF) ;
      ("IF_SIZE_IS", IF_SIZE_IS) ;
      ("IF_EVAL", IF_EVAL) ;
      ("INSERT_BYTES", INSERT_BYTES);
      ("INSERT_FILE", INSERT_FILE);
      ("INTERJECT", INTERJECT);
      ("INTERJECT_COPY_TRANS", INTERJECT_COPY_TRANS);
      ("INTERJECT_COPY_TRANS2", INTERJECT_COPY_TRANS2);
      ("I_C_T", INTERJECT_COPY_TRANS);
      ("I_C_T2", INTERJECT_COPY_TRANS2);
      ("I_S_I", IF_SIZE_IS) ;
      ("JOURNAL", JOURNAL) ;
      ("SOLVED_JOURNAL", SOLVED_JOURNAL) ;
      ("UNSOLVED_JOURNAL", UNSOLVED_JOURNAL) ;
      ("LANGUAGE", LANGUAGE) ;
      ("MENU_STYLE", MENU_STYLE) ;
      ("MKDIR", MKDIR) ;
      ("NO_LOG_RECORD", NO_LOG_RECORD) ; 
      ("ADD_GAME_NPC", PATCH_GAM) ;
      ("PATCH_GAM", PATCH_GAM) ;
      ("PRINT", PRINT);
      ("RANDOM_SEED", RANDOM_SEED);
      ("RANDOM", RANDOM);
      ("READ_ASCII", READ_ASCII);
      ("READ_BYTE", READ_BYTE) ;
      ("READ_SHORT", READ_SHORT) ;
      ("READ_LONG", READ_LONG) ;
      ("READ_2DA_ENTRY", READ_2DA_ENTRY) ;
      ("REMOVE_KNOWN_SPELL", REMOVE_KNOWN_SPELL) ;
      ("REPLACE", REPLACE) ;
      ("REPLACE_EVALUATE", REPLACE_EVALUATE) ;
      ("REPLACE_ACTION_TEXT", REPLACE_ACTION_TEXT) ;
      ("REPLACE_ACTION_TEXT_REGEXP", REPLACE_ACTION_TEXT_REGEXP) ;
      ("REPLACE_ACTION_TEXT_PROCESS", REPLACE_ACTION_TEXT_PROCESS) ;
      ("REPLACE_ACTION_TEXT_PROCESS_REGEXP", 
          REPLACE_ACTION_TEXT_PROCESS_REGEXP) ;
      ("REPLACE_BCS_BLOCK", REPLACE_BCS_BLOCK) ;
      ("REPLACE_BCS_BLOCK_REGEXP", REPLACE_BCS_BLOCK_REGEXP) ;
      ("APPLY_BCS_PATCH", APPLY_BCS_PATCH) ;
      ("APPLY_BCS_PATCH_OR_COPY", APPLY_BCS_PATCH_OR_COPY) ;
      ("REPLACE_SAY", REPLACE_SAY) ;
      ("REPLACE_STATE_TRIGGER", REPLACE_STATE_TRIGGER) ;
      ("REPLACE_TEXTUALLY", REPLACE_TEXTUALLY) ;
      ("REPLACE_TRIGGER_TEXT", REPLACE_TRIGGER_TEXT) ;
      ("REPLACE_TRIGGER_TEXT_REGEXP", REPLACE_TRIGGER_TEXT_REGEXP) ;
      ("REPLY", REPLY) ;
      ("REQUIRE_FILE", REQUIRE_FILE) ;
      ("REQUIRE_PREDICATE", REQUIRE_PREDICATE) ;
      ("REQUIRE_COMPONENT", REQUIRE_COMPONENT) ;
      ("FORBID_COMPONENT", FORBID_COMPONENT) ;
      ("R_A_T", REPLACE_ACTION_TEXT) ;
      ("R_B_B", REPLACE_BCS_BLOCK) ;
      ("R_B_B_RE", REPLACE_BCS_BLOCK_REGEXP) ;
      ("A_B_P", APPLY_BCS_PATCH) ;
      ("R_S_T", REPLACE_STATE_TRIGGER) ;
      ("R_T_T", REPLACE_TRIGGER_TEXT) ;
      ("SAY", SAY) ;
      ("SET_WEIGHT", SET_WEIGHT) ;
      ("STRING_SET", STRING_SET) ;
      ("STRING_COMPARE", STRING_EQUAL) ;
      ("STRING_COMPARE_CASE", STRING_EQUAL_CASE) ;
      ("SCRIPT_STYLE", SCRIPT_STYLE) ;
      ("STR_CMP", STRING_EQUAL) ;
      ("SUBCOMPONENT", SUBCOMPONENT) ;
      ("SUB_COMPONENT", SUBCOMPONENT) ;
      ("THEN", THEN) ;
      ("UNLESS", UNLESS) ;
      ("USING", USING) ;
      ("UNINSTALL", UNINSTALL) ;
      ("WEIGHT", WEIGHT) ;
      ("WRITE_ASCII", WRITE_ASCII) ;
      ("WRITE_EVALUATED_ASCII", WRITE_EVALUATED_ASCII) ;
      ("WHILE", WHILE) ;
      ("WRITE_BYTE", WRITE_BYTE) ;
      ("WRITE_FILE", WRITE_FILE) ;
      ("WRITE_LONG", WRITE_LONG) ;
      ("WRITE_SHORT", WRITE_SHORT) ;

      (* predicates *) 
      ("FILE_EXISTS", FILE_EXISTS ) ;
      ("FILE_MD5", FILE_MD5 ) ;
      ("FILE_EXISTS_IN_GAME", FILE_EXISTS_IN_GAME ) ;
      ("FILE_SIZE", FILE_SIZE ) ;
      ("FILE_CONTAINS", FILE_CONTAINS ) ;
      ("AND", AND) ;
      ("OR", OR) ;
      ("NOT", NOT) ;

      ("BAND", BAND) ;
      ("BOR", BOR) ;
      ("BNOT", BNOT) ;
      ("BXOR", BXOR) ;
      ("BLSL", BLSL) ;
      ("BLSR", BLSR) ;
      ("BASR", BASR) ;
    ] 

(*
** Buffer processor
*)
 



} 

let decdigit = ['0'-'9']
let octdigit = ['0'-'7']
let letter = ['a' - 'z' 'A'-'Z']

let blank = [' ' '\012' '\r']

rule initial = parse 	
  "/*"  { adj lexbuf ; let _ = comment lexbuf in initial lexbuf}
| "//"  { adj lexbuf ; endline lexbuf }
| blank	{ adj lexbuf ; initial lexbuf}
| '\t'  { tab (); initial lexbuf }
| '\n'  { newline (); initial lexbuf }
| '('   { adj lexbuf ; LPAREN } 
| ')'   { adj lexbuf ; RPAREN } 
| '?'   { adj lexbuf ; QUESTION } 
| ':'   { adj lexbuf ; COLON } 
| ';'   { adj lexbuf ; SEMICOLON } 
| '+'   { adj lexbuf ; PLUS } 
| '-'   { adj lexbuf ; MINUS } 
| '*'   { adj lexbuf ; TIMES } 
| '/'   { adj lexbuf ; DIVIDE } 
| '='   { adj lexbuf ; EQUALS } 
| '>'   { adj lexbuf ; GT } 
| '<'   { adj lexbuf ; LT } 
| '+'   { adj lexbuf ; PLUS } 
| '^'   { adj lexbuf ; STRING_CONCAT } 
| ">="   { adj lexbuf ; GTE } 
| "<="   { adj lexbuf ; LTE } 
| "=="  { adj lexbuf ; EQUALSEQUALS } 
| "["[^']']*"]" { str_adj lexbuf ; SOUND(strip (string_of lexbuf)) }
| "~"[^'~']*"~"  
| '"'[^'"']*'"'  
| '%'[^'%']*'%'  { str_adj lexbuf ; STRING(strip (string_of lexbuf)) } 
| ['0'-'9''A'-'Z''a'-'z''_']['0'-'9''A'-'Z''a'-'z''#''_''-''.']* { 
    adj lexbuf ; try Hashtbl.find lexicon (string_of lexbuf) 
    with _ -> STRING(string_of lexbuf) }
| '#'['-']?['0'-'9']+ { adj lexbuf ;
      let str = string_of lexbuf in
      let str = String.sub str 1 ((String.length str) - 1) in
      STRING_REF((int_of_string str)) }
| '!'['-']?['0'-'9']+ { adj lexbuf ;
      let str = string_of lexbuf in
      let str = String.sub str 1 ((String.length str) - 1) in
      FORCED_STRING_REF((int_of_string str)) }
| '@'['-']?['0'-'9']+ { adj lexbuf ;
      let str = string_of lexbuf in
      let str = String.sub str 1 ((String.length str) - 1) in
      TRANS_REF((int_of_string str)) }
| "<<<<<<<<" [' ']* ([^'\n']* as name) '\n' { 
  adj lexbuf ; 
  let buf = Buffer.create 10240 in 
  inlined name buf lexbuf } 
| eof   { EOF }
| _	{ lex_error (Printf.sprintf "invalid character [%s]" (string_of
lexbuf)) }
and comment = parse 	
      "*/"	{ adj lexbuf ; () }
|     '\n'      { newline (); comment lexbuf }
|     "/*"      { adj lexbuf ; let _ = comment lexbuf in comment lexbuf } 
|     eof       { lex_error "unterminated comment" } 
|     _ 	{ adj lexbuf ; comment lexbuf }
and inlined name buf = parse 
|     ">>>>>>>>"{ adj lexbuf ; 
                  INLINED_FILE(name,(Buffer.contents buf)) }
|     eof       { lex_error "unterminated inlined file" } 
|     '\n'      { newline (); Buffer.add_char buf '\n' ; 
                  inlined name buf lexbuf } 
|     _         { adj lexbuf ; 
                  let str = string_of lexbuf in
                  Buffer.add_string buf str ;
                  inlined name buf lexbuf } 
and endline = parse 
        '\n' 			{ newline (); initial lexbuf}
|	_			{ adj lexbuf ; endline lexbuf}
|       eof                     { EOF }
