(* Variable Substitution *)

let system_vars = Hashtbl.create 255
let user_vars = Hashtbl.create 255

let debug_assign = ref false 

let add_var (name : string) (value : string) = 
  let var_name = "%" ^ name ^ "%" in 
  let reg = Str.regexp (Str.quote var_name) in 
  (if (!debug_assign) then 
    Util.log_and_print "Processing SET ~%s~ = ~%s~\n" name value) ; 
  Hashtbl.replace user_vars var_name (reg,value) 

let remove_var (name : string) = 
  let var_name = "%" ^ name ^ "%" in 
  let reg = Str.regexp (Str.quote var_name) in 
  (if (!debug_assign) then 
    Util.log_and_print "Processing UNSET ~%s~\n" name ) ; 
  Hashtbl.remove user_vars var_name 

let substitute str = 
  let str' = Hashtbl.fold (fun n (r,v) acc -> 
    Str.global_substitute r (fun _ -> v) acc)  user_vars str  in
  Hashtbl.fold (fun n (r,v) acc -> 
    Str.global_substitute r (fun _ -> v) acc)  system_vars str' 

let substitute_user_vars_only str = 
  Hashtbl.fold (fun n (r,v) acc -> 
    Str.global_substitute r (fun _ -> v) acc) user_vars str 

let assoc name value = 
  let reg = Str.regexp ("^" ^ name ^ "$") in 
  let value = string_of_int value in 
  Hashtbl.replace system_vars name (reg,value) 

let _ = 
  assoc "AREA_CITY" 0252 ;
  assoc "AREA_DAY" 0260 ;
  assoc "AREA_DUNGEON" 0256 ;
  assoc "AREA_FOREST" 0248 ;
  assoc "AREA_NIGHT" 0264 ;
  assoc "ATTACK1" 0220 ;
  assoc "ATTACK2" 0224 ;
  assoc "ATTACK3" 0228 ;
  assoc "ATTACK4" 0232 ;
  assoc "BATTLE_CRY1" 0200 ;
  assoc "BATTLE_CRY2" 0204 ;
  assoc "BATTLE_CRY3" 0208 ;
  assoc "BATTLE_CRY4" 0212 ;
  assoc "BATTLE_CRY5" 0216 ;
  assoc "BIO"  0x1cc ;
  assoc "BORED" 0196 ;
  assoc "COMPLIMENT1" 0352 ;
  assoc "COMPLIMENT2" 0356 ;
  assoc "COMPLIMENT3" 0360 ;
  assoc "CRITICAL_HIT" 0424 ;
  assoc "CRITICAL_MISS" 0428 ;
  assoc "DAMAGE" 0236 ;
  assoc "DESC"  0x54 ;
  assoc "DIALOGUE_DEFAULT" 0412 ;
  assoc "DIALOGUE_HOSTILE" 0408 ;
  assoc "DYING" 0240 ;
  assoc "EXISTANCE1" 0444 ;
  assoc "EXISTANCE2" 0448 ;
  assoc "EXISTANCE3" 0452 ;
  assoc "EXISTANCE4" 0456 ;
  assoc "EXISTANCE5" 0460 ;
  assoc "HAPPY" 0172 ;
  assoc "HURT" 0244 ;
  assoc "IDENTIFIED_DESC"  0x54 ;
  assoc "INITIAL_MEETING" 0164 ;
  assoc "INSULT" 0340 ;
  assoc "INTERACTION1" 0320 ;
  assoc "INTERACTION2" 0324 ;
  assoc "INTERACTION3" 0328 ;
  assoc "INTERACTION4" 0332 ;
  assoc "INTERACTION5" 0336 ;
  assoc "INVENTORY_FULL" 0436 ;
  assoc "LEADER" 0188 ;
  assoc "MISCELLANEOUS" 0384 ;
  assoc "MORALE" 0168 ;
  assoc "NAME1" 8 ;
  assoc "NAME2" 12 ;
  assoc "PICKED_POCKET" 0440 ;
  assoc "REACT_TO_DIE_GENERAL" 0376 ;
  assoc "REACT_TO_DIE_SPECIFIC" 0380 ;
  assoc "RESPONSE_TO_COMPLIMENT2" 0388 ;
  assoc "RESPONSE_TO_COMPLIMENT3" 0392 ;
  assoc "RESPONSE_TO_INSULT1" 0396 ;
  assoc "RESPONSE_TO_INSULT2" 0400 ;
  assoc "RESPONSE_TO_INSULT3" 0404 ;
  assoc "SELECT_ACTION1" 0292 ;
  assoc "SELECT_ACTION2" 0296 ;
  assoc "SELECT_ACTION3" 0300 ;
  assoc "SELECT_ACTION4" 0304 ;
  assoc "SELECT_ACTION5" 0308 ;
  assoc "SELECT_ACTION6" 0312 ;
  assoc "SELECT_ACTION7" 0316 ;
  assoc "SELECT_COMMON1" 0268 ;
  assoc "SELECT_COMMON2" 0272 ;
  assoc "SELECT_COMMON3" 0276 ;
  assoc "SELECT_COMMON4" 0280 ;
  assoc "SELECT_COMMON5" 0284 ;
  assoc "SELECT_COMMON6" 0288 ;
  assoc "SELECT_RARE1" 0416 ;
  assoc "SELECT_RARE2" 0420 ;
  assoc "SPECIAL1" 0364 ;
  assoc "SPECIAL2" 0368 ;
  assoc "SPECIAL3" 0372 ;
  assoc "TARGET_IMMUNE" 0432 ;
  assoc "TIRED" 0192 ;
  assoc "UNHAPPY_ANNOYED" 0176 ;
  assoc "UNHAPPY_BREAKING" 0184 ;
  assoc "UNHAPPY_SERIOUS" 0180 ;
  assoc "UNIDENTIFIED_DESC" 0080 ;
  assoc "HIDDEN_IN_SHADOWS" 0444 ;
  assoc "SPELL_DISRUPTED" 0448 ;
  assoc "SET_A_TRAP" 0452 ;
  assoc "STORE_NAME" 12 ;

  assoc "SCRIPT_OVERRIDE" 0x248 ;
  assoc "SCRIPT_CLASS" 0x250 ;
  assoc "SCRIPT_RACE" 0x258 ;
  assoc "SCRIPT_GENERAL" 0x260 ;
  assoc "SCRIPT_DEFAULT" 0x268 ;
  assoc "DEATHVAR" 0x280 ;
  assoc "DIALOG" 0x2cc ;
  assoc "AREA_SCRIPT" 0x94 ;
  assoc "SCRIPT_AREA" 0x94 ;

  assoc "PORTRAIT_SMALL" 0x34 ;
  assoc "PORTRAIT_LARGE" 0x3c ;

  ()

