#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <caml/mlvalues.h>
#include <caml/fail.h>
#include <caml/alloc.h>
#include <caml/memory.h>
#include <caml/callback.h>

#include <zlib.h>


/* ERROR REPORTING */
/* raise the Caml exception */
static void raise_mlgz_exn(const char *msg) 
{
  static value * exn = NULL;
  if(exn == NULL)
    exn = caml_named_value ("mlgz_exn");
  raise_with_string(*exn, (char *)msg) ;
}

value mlgz_uncompress(value v_src, value v_pos, value v_len, value unc_len)
{
  value v_ret;
  int level, pos, len, out_buf_len, r;
  uLong out_len;
  const char *in_buf;
  char *out_buf;

  pos = Int_val(v_pos);
  len = Int_val(v_len);
  in_buf = String_val(v_src) + pos;
  if(pos < 0 || len < 0 || pos + len > string_length(v_src))
    invalid_argument("Gz.uncompress");

   /* out_buf_len = len * 2; */
  out_buf_len = unc_len ; 
  /*
   out_buf = malloc(out_buf_len); 
   */

  v_ret = alloc_string(Int_val(unc_len));
  out_buf = String_val(v_ret); 

  if(out_buf == NULL)
    raise_out_of_memory();
  while(1) {
    out_len = out_buf_len;
    r = uncompress(out_buf, &out_len, in_buf, len);
    if(r == Z_OK) {
      break;
    } else if(r == Z_BUF_ERROR) {
      char *new_buf;

      printf("uncompress 1\n"); fflush(stdout);
      raise_mlgz_exn("uncompress");
      out_buf_len *= 2;
      new_buf = realloc(out_buf, out_buf_len);
      if(new_buf == NULL) {
	free(out_buf);
	raise_out_of_memory();
      }
      out_buf = new_buf;
    } else if(r == Z_MEM_ERROR) { 
      printf("uncompress 3\n"); fflush(stdout);
      free(out_buf);
      raise_out_of_memory();
    } else {
      printf("WeiDU: ZLIB: Warning! Problem decompressing block.\n");
      fflush(stdout); 
      out_len = Int_val(unc_len);
      break; 
    }
  }
  if (Int_val(unc_len) != out_len)
      raise_mlgz_exn("wrong uncompressed size");

  /*
   v_ret = alloc_string(out_len);
   memcpy(String_val(v_ret), out_buf, out_len);
   free(out_buf);
   */
  return v_ret ;
}
