#!/bin/sh

tiz_files="ar0011.tiz ar0309.tiz ar0403.tiz ar0512.tiz ar0700.tiz ar1304.tiz ar1901.tiz ar2100.tiz ar2401.tiz"

for file in $tiz_files; do
  echo Converting $file
  eeconv/tisunpack -s -f -o override/${file%.tiz}.tis eeconv/areas/$file
done

am_ogg_files="AM0011.ogg AM0028.ogg AM0309.ogg AM0500.ogg AM1304.ogg AM1304N.ogg AM1901.ogg AM2200.ogg AM2207.ogg AM2806.ogg AM2806A.ogg"
lh_ogg_files="lh0403a.ogg lh2100b.ogg lh2401.ogg lhBAR4n.ogg lhICE1.ogg lhICE2.ogg lhLRD3.ogg lhMIS12a.ogg lhMIS12b.ogg lhMIS12c.ogg lhMNK3.ogg lhMNK4.ogg lhMNK5.ogg lhMS10a.ogg lhMS10b.ogg lhSCRN1.ogg lhSCRN2.ogg lhSHOP1.ogg lhTER1.ogg lhTER2.ogg"
sp_ogg_files="SPIN724.ogg"

for file in $am_ogg_files; do
  echo Converting $file
  eeconv/sox eeconv/audio/$file override/${file%.ogg}.wav
done
for file in $lh_ogg_files; do
  echo Converting $file
  eeconv/sox eeconv/audio/$file override/${file%.ogg}.wav
done
for file in $sp_ogg_files; do
  echo Converting $file
  eeconv/sox eeconv/audio/$file override/${file%.ogg}.wav
done
