/*
 * Copyright 2006-2007 Multi Install Tool contributors. All Rights Reserved.
 *
 * You are permitted to redistribute this code under the terms of the GNU General
 * Public License, version 2 or any later version. A copy of this license may be
 * found in the file 'gpl.txt'.
 */

public final class CaseInsensitiveFileFilter implements java.io.FileFilter{
	private final String filename;

	public CaseInsensitiveFileFilter(String filename){
		this.filename = filename.toString();
	}

	public boolean accept(java.io.File file){
		if(filename.endsWith("*") && file.getName().startsWith(
		                 filename.substring(0, filename.length() - 2))){
			return true;
		}
		return file.getName().equalsIgnoreCase(filename);
	}
}
