/*
 * Copyright 2006-2007 Multi Install Tool contributors. All Rights Reserved.
 *
 * You are permitted to redistribute this code under the terms of the GNU General
 * Public License, version 2 or any later version. A copy of this license may be
 * found in the file 'gpl.txt'.
 */
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.io.UnsupportedEncodingException;

/**
 * Provides data to clone an Infinity Engine game.
 * @author Lennon Victor Cook
 * @date 2006 - 05 - 29
 */
public final class CloningData{
	// I would read this all in from files, but Java is too crap
	private static CloningData[] instances = new CloningData[]{
		new CloningData(
			"BG2SOA",
			"bgmain.exe",
			"baldur.ini",
			7385134,
			6928600,
			6925640,
			6925656,
			"baldur.ico",
			"bgconfig.exe",
			"bggltest.exe",
			"bgdxtest.exe",
			"script compiler"
		),

		new CloningData(
			"BG2SOA_PATCHED",
			"bgmain.exe",
			"baldur.ini",
			7405614,
			6953208,
			6950248,
			6950264,
			"baldur.ico",
			"bgconfig.exe",
			"bggltest.exe",
			"bgdxtest.exe",
			"script compiler"
		),

		new CloningData(
			"BG2TOB_PATCHED",
			"bgmain.exe",
			"baldur.ini",
			7839790,
			7367092,
			7364100,
			7364116,
			"baldur.ico",
			"bgconfig.exe",
			"bggltest.exe",
			"bgdxtest.exe",
			"script compiler"
		),
	
		// Put ini in requiredFiles for Mac games, because it doesn't need patching
		new CloningData(
			"BG2_MACOSX",
			"Baldur's Gate 2 Mac OS X",
			null,
			-1,
			-1,
			-1,
			-1,
			"baldur.ini"
		),

		new CloningData(
			"BG2_TOB_MACOSX",
			"Baldur's Gate II",
			null,
			-1,
			-1,
			-1,
			-1,
			"baldur.ini"
		),
		
		new CloningData(
			"BG1_MACOSX",
			"Baldur's Gate*",
			null,
			-1,
			-1,
			-1,
			-1,
			"baldur.ini"
		),
		
		new CloningData(
			"BG1_TOTSC_MACOSX",
			"Tales of the Sword Coast",
			null,
			-1,
			-1,
			-1,
			-1,
			"baldur.ini"
		),
	
		new CloningData(
			"IWD1_MACOSX",
			"Icewind Dale",
			null,
			-1,
			-1,
			-1,
			-1,
			"icewind.ini"
		),
	
		new CloningData(
			"IWD1",
			"idmain.exe",
			"icewind.ini",
			6295552,
			0x5dca58,
			0x5dc874,
			0x5dc860,
			"config.exe",
			"mpicewind.mpi",
			"3dfx.dll",
			"language.ini"
		),

		new CloningData(
			"IWD1_PATCHED",
			"idmain.exe",
			"icewind.ini",
			6287360,
			0x5da874,
			0x5daa58,
			0x5da860,
			"config.exe",
			"mpicewind.mpi",
			"3dfx.dll",
			"language.ini"
		)
	};

	/** Maps source dirs to the instance used to copy them */
	private static Map<String, CloningData> dirs = new java.util.HashMap<String, CloningData>();

	public static CloningData instanceFor(File source)
	  throws FileNotFoundException, IOException{
		cond: if(!dirs.containsKey(source.getPath())){
			// Look up folders once to avoid excessive disk activity
			for(CloningData possible : instances){
				List neededFiles = new ArrayList(possible.files.length + 2);
				neededFiles.addAll(Arrays.asList(possible.files));
				if(possible.iniName != null){
					neededFiles.add(possible.iniName);
				}
				neededFiles.add(possible.exeName);

				for(Object fileobj : neededFiles){
					String file = fileobj.toString();
					if(source.listFiles(
						new CaseInsensitiveFileFilter(
							file
						)
					).length == 0){
						continue;	
					}
				}
				java.io.FileFilter exeFilter =
				  new CaseInsensitiveFileFilter(possible.exeName);
				if(source.listFiles(exeFilter)[0].length() != 
				     (long) possible.exeSize
				     && (possible.exeSize != -1
				       || FileSystem.canLink()) ){
					continue;
				}

				dirs.put(source.getPath(), possible);
				break cond;
			}
			dirs.put(source.getPath(), null);
		}
		return dirs.get(source.getPath());
	}

	/** Common files to be copied for all games. */
	public static final String[] commonFiles = new String[]{
		"dialog.tlk",
		"scripts",
		"override",
		"sounds",
		"chitin.key"
	};

	public final String gameName;
	public final String exeName;
	public final String iniName;
	public final String[] files;
	public final int exeSize;
	public final int musicOffset;
	public final int maleTlkOffset;
	public final int femaleTlkOffset;

	private CloningData(String gameName, String exeName, String iniName, 
	                      int exeSize, int musicOffset, int maleTlkOffset, 
	                      int femaleTlkOffset, String...files){
		this.gameName = gameName;
		this.exeName = exeName;
		this.iniName = iniName;
		this.exeSize = exeSize;
		this.musicOffset = musicOffset;
		this.maleTlkOffset = maleTlkOffset;
		this.femaleTlkOffset = femaleTlkOffset;
		this.files = files;
	}
}
