/*
 * Copyright 2006-2007 Multi Install Tool contributors. All Rights Reserved.
 *
 * You are permitted to redistribute this code under the terms of the GNU General
 * Public License, version 2 or any later version. A copy of this license may be
 * found in the file 'gpl.txt'.
 */

import javax.swing.*;
import java.awt.*;

public class MultiGUI{
	public MultiGUI(MultiInstall connectee){
		JPanel sourcePanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		sourcePanel.add(new JLabel("Source:"));
		JTextField source = new JTextField(50);
		connectee.source = source;
		source.addCaretListener(connectee.updateSource);
		sourcePanel.add(source);
		JButton sourceBrowser = new JButton(connectee.browseForSource);
		sourceBrowser.setText("Browse");
		sourcePanel.add(sourceBrowser);
		
		JPanel sinkPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		sinkPanel.add(new JLabel("Sink:"));
		JTextField sink = new JTextField(50);
		sink.addCaretListener(connectee.updateSink);
		connectee.sink = sink;
		sinkPanel.add(sink);
		JButton sinkBrowser = new JButton(connectee.browseForSink);
		sinkBrowser.setText("Browse");
		sinkPanel.add(sinkBrowser);
		
		JPanel optionsPanel = new JPanel(new GridLayout(2, 0));
		
		JCheckBox music = new JCheckBox("Music"); 
		optionsPanel.add(music);
		connectee.music = music;

		JCheckBox data = new JCheckBox("Data"); 
		optionsPanel.add(data); 
		connectee.data = data;

		JCheckBox portraits = new JCheckBox("Portraits"); 
		optionsPanel.add(portraits); 
		connectee.portraits = portraits;

		JCheckBox characters = new JCheckBox("Characters"); 
		optionsPanel.add(characters); 
		connectee.characters = characters;
	
		JCheckBox save = new JCheckBox("Save"); 
		optionsPanel.add(save); 
		connectee.save = save;
		
		JPanel toolbar = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		JButton cancel = new JButton(connectee.cancel);
		cancel.setText("Cancel");
		toolbar.add(cancel);
		
		JButton doClone = new JButton(connectee.doClone);
		doClone.setText("Go");
		toolbar.add(doClone);
	
		JProgressBar progress = new JProgressBar();
		progress.setStringPainted(true);
		connectee.progress = progress;
		
		JPanel inner = new JPanel(new GridLayout(4, 1));
		inner.add(sourcePanel);
		inner.add(sinkPanel);
		inner.add(optionsPanel);
		inner.add(toolbar);

		JFrame window = new JFrame("Multi-Install Tool");
		window.setLayout(new BorderLayout());
		window.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		window.add(inner, BorderLayout.CENTER);
		window.add(progress, BorderLayout.PAGE_END);
		connectee.window = window;
	}	
}
