# Brew Potions
This component will allow any class-based caster to brew the magic they memorize into potions.



## Table of Contents
1. [Process](#process)
1. [Base Game Potions](#base-game-potions)
   1. [Base Game Categories](#base-game-categories)
   1. [Base Game Recipes](#base-game-recipes)
1. [New Potions](#new-potions)
   1. [New Potions Categories](#new-potions-categories)
   1. [New Potions Recipes](#new-potions-recipes)



## Process
1. Purchase alchemy kit from a spell shop.
1. Identify the item
1. Begin dialog with the alchemy kit
1. Select the option to brew a potion:
   ![Scribe Tools Main Menu](.images/brew_potion-main_menu.png)
1. Select the category of potion to brew:
   ![Select Spell Circle](.images/brew_potion-category.png)
1. Select the subcategory of potion to brew (many potions; had to separate them to make dialog menu usable):
   ![Select Spell Circle](.images/brew_potion-subcategory.png)
1. Select which potion to brew:
   ![Select Which Spell](.images/brew_potion-select_potion.png)
1. Select the potion recipe you want to use:
   ![Select Which Spell](.images/brew_potion-select_recipe.png)
1. Confirm you want to spend time and gold to brew the potion:
   ![Spell Copy Confirmation](.images/brew_potion-confirmation.png)
1. Watch the small cutscene similar to Cespenar and Cromwell



## Base Game Potions
The default state of the mod with no other options, you will be able to brew potions that exist in the base game.


### Base Game Categories
|  Game(s)/Mods  |                   Potion                 |   Category  |     Sub-Category     |
| -------------- | ---------------------------------------- | ----------- | -------------------- |
|  BG1, BG2, IWD | Oil of Fiery Burning                     | Bomb        | Damage               |
|  BG1, BG2, IWD | Potion of Explosions                     | Bomb        | Damage               |
|  BG1, BG2, IWD | Potion of Fire Breath                    | Bomb        | Damage               |
|  IWD           | Flaming Oil                              | Bomb        | Damage               |
|                |                                          |             |                      |
|  BG1, BG2, IWD | Potion of Healing                        | Cure        | Healing              |
|  BG1, BG2, IWD | Potion of Extra Healing                  | Cure        | Healing              |
|  IWD           | Potion of Extra Healing                  | Cure        | Healing              |
|  IWD           | Spirit Essence                           | Cure        | Healing              |
|  BG1, BG2, IWD | Potion of Superior Healing               | Cure        | Healing              |
|  BG1, BG2, IWD | Elixer of Health                         | Cure        | Restorative          |
|  BG1, BG2, IWD | Andidote                                 | Cure        | Restorative          |
|  IWD           | Mummy's Tea                              | Cure        | Restorative          |
|  IWD           | Oil of Null Effect                       | Cure        | Restorative          |
|  BG1, BG2, IWD | Potion of Regeneration                   | Cure        | Regeneration         |
|                |                                          |             |                      |
|  BG1, BG2, IWD | Potion of Invulnerability                | Defense     | Armor                |
|  BG1, BG2, IWD | Potion of Defense                        | Defense     | Armor                |
|  BG1, BG2, IWD | Potion of Stone Form                     | Defense     | Armor                |
|  IWD           | Oil of the Serpent's Scales              | Defense     | Armor                |
|  BG1, BG2, IWD | Potion of Magic Shielding                | Defense     | Damage Resistance    |
|  BG1, BG2, IWD | Potion of Fire Resistance                | Defense     | Energy Resistance    |
|  BG1, BG2, IWD | Potion of Absorption                     | Defense     | Energy Resistance    |
|  BG1, BG2, IWD | Protection from Cold                     | Defense     | Energy Resistance    |
|  BG1, BG2, IWD | Potion of Insulation                     | Defense     | Energy Resistance    |
|  BG1, BG2, IWD | Potion of Magic Protection               | Defense     | Magic Resistance     |
|  BG1, BG2, IWD | Potion of Clarity                        | Defense     | Mental Defense       |
|  BG1, BG2, IWD | Potion of Magic Blocking                 | Defense     | Spell Immunity       |
|  BG1, BG2, IWD | Potion of Mirrored Eyes                  | Defense     | Status Immunity      |
|  BG1, BG2, IWD | Potion of Free Action                    | Defense     | Status Immunity      |
|                |                                          |             |                      |
|  BG1, BG2, IWD | Potion of Infravision                    | Enhancement | Detection            |
|  BG2           | Potion of Clairvoyance                   | Enhancement | Detection            |
|  BG1, BG2, IWD | Potion of Invisibility                   | Enhancement | Invisibility         |
|  BG1, BG2, IWD | Potion of Master Thievery                | Enhancement | Skill Boost          |
|  BG1, BG2, IWD | Potion of Perception                     | Enhancement | Skill Boost          |
|  BG1, BG2, IWD | Potion of Power                          | Enhancement | Skill Boost          |
|  BG1, BG2, IWD | Potion of Mind Focusing                  | Enhancement | Stat Boost           |
|  BG1, BG2, IWD | Potion of Agility (18)                   | Enhancement | Stat Boost           |
|  BG1, BG2, IWD | Potion of Fortitude (18)                 | Enhancement | Stat Boost           |
|  BG1, BG2, IWD | Potion of Genius (18)                    | Enhancement | Stat Boost           |
|  BG1, BG2, IWD | Potion of Insight (18)                   | Enhancement | Stat Boost           |
|  BG1           | Potion of Persuasiveness                 | Enhancement | Stat Boost           |
|  BG1, BG2, IWD | Potion of Strength (18)                  | Enhancement | Stat Boost: Strength |
|  BG1, BG2, IWD | Potion of Hill Giant Strength (19)       | Enhancement | Stat Boost: Strength |
|  BG1, BG2, IWD | Potion of Stone Giant Strength (20)      | Enhancement | Stat Boost: Strength |
|  BG1, BG2, IWD | Potion of Frost Giant Strength (21)      | Enhancement | Stat Boost: Strength |
|  BG1, BG2, IWD | Potion of Fire Giant Strength (22)       | Enhancement | Stat Boost: Strength |
|  BG1, BG2, IWD | Potion of Cloud Giant Strength (23)      | Enhancement | Stat Boost: Strength |
|  BG1, BG2, IWD | Potion of Storm Giant Strength (24)      | Enhancement | Stat Boost: Strength |
|  IWD           | Potion of Action Transferenc             | Enhancement | Stat Transfer        |
|  IWD           | Potion of Resistance                     | Enhancement | Stat Increase        |
|  IWD           | Potion of Greater Resistance             | Enhancement | Stat Increase        |
|  IWD           | Potion of Magical Resistance             | Enhancement | Stat Increase        |
|  IWD           | Potion of Constitution                   | Enhancement | Stat Increase        |
|  IWD           | Potion of Strength Transference          | Enhancement | Stat Transfer        |
|  IWD           | Potion of Arcane Absorption              | Enhancement | Stat Increase        |
|  IWD           | Potion of Life Transference              | Enhancement | Stat Transfer        |
|  IWD           | Potion of Aura Enhancement               | Enhancement | Stat Increase        |
|  IWD           | Potion of Dissipation                    | Enhancement | Stat Increase        |
|  IWD           | Potion of Holy Transference              | Enhancement | Stat Transfer        |
|                |                                          |             |                      |
|  BG1, BG2, IWD | Potion of Heroism                        | Offense     | Attack Bonus         |
|  IWD           | Oil of Second Chances                    | Offense     | Damage Boost         |
|  BG1, BG2, IWD | Oil of Speed                             | Offense     | Haste                |


### Base Game Recipes
| Game(s)/Mods  |                   Potion                 |                                         Recipe                                     | Req. Caster Level | Yield | Hours |
| ------------- | ---------------------------------------- | ---------------------------------------------------------------------------------- | ----------------- | ----- | ----- |
| BG1, BG2, IWD |    Potion of Fire Resistance             | `Protection from Fire` Wizard spell                                                |              5    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Fire Resistance             | `Fireshield (Red) Wizard` spell                                                    |              7    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Fire Resistance             | `Protection from the Elements` Wizard spell                                        |             12    |    2  |     8 |
| BG1, BG2, IWD |    Potion of Fire Resistance             | `Protection from Energy` Wizard spell                                              |             16    |    2  |     8 |
| BG1, BG2, IWD |    Potion of Fire Resistance             | `Protection from Fire and Cold` Priest spell                                       |              3    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Fire Resistance             | `Protection from Fire` Priest spell                                                |              5    |    2  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Strength` Wizard spell                                                            |              3    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Strength of One` Priest spell                                                     |              5    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Holy Power` Priest spell                                                          |              7    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Champion's Strength` Priest spell                                                 |              9    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Draw Upon Holy Might` Priest spell                                                |              3    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Righteous Magic` Priest spell                                                     |              3    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Draw Upon Holy Might` Priest spell                                                |              9    |    2  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Righteous Magic` Priest spell                                                     |              9    |    2  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Draw Upon Holy Might` Priest spell                                                |             15    |    3  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Righteous Magic` Priest spell                                                     |             15    |    3  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Draw Upon Holy Might` Priest spell                                                |             21    |    4  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Righteous Magic` Priest spell                                                     |             21    |    4  |     8 |
| BG1, BG2, IWD |    Potion of Strength (18)               | `Animal Rage` Priest spell                                                         |             21    |    4  |     8 |
| IWD(ification)|    Potion of Strength (18)               | `Iron Body` Wizard spell                                                           |             16    |    4  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Draw Upon Holy Might` Priest spell                                                |              6    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Righteous Magic` Priest spell                                                     |              6    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Draw Upon Holy Might` Priest spell                                                |             15    |    2  |    10 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Righteous Magic` Priest spell                                                     |             15    |    2  |    10 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Draw Upon Holy Might` Priest spell                                                |             24    |    3  |    10 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Righteous Magic` Priest spell                                                     |             24    |    3  |    10 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Animal Rage` Priest spell                                                         |             21    |    4  |     8 |
| BG1, BG2, IWD |    Potion of Hill Giant Strength (19)    | `Champion's Strength` Priest spell                                                 |              9    |    4  |     8 |
| IWD(ification)|    Potion of Hill Giant Strength (19)    | `Iron Body` Wizard spell                                                           |             16    |    3  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Stone Giant Strength (20)   | `Draw Upon Holy Might` Priest spell                                                |              9    |    1  |    12 |
| BG1, BG2, IWD |    Potion of Stone Giant Strength (20)   | `Righteous Magic` Priest spell                                                     |              9    |    1  |    12 |
| BG1, BG2, IWD |    Potion of Stone Giant Strength (20)   | `Draw Upon Holy Might` Priest spell                                                |             18    |    2  |    12 |
| BG1, BG2, IWD |    Potion of Stone Giant Strength (20)   | `Righteous Magic` Priest spell                                                     |             18    |    2  |    12 |
| BG1, BG2, IWD |    Potion of Stone Giant Strength (20)   | `Champion's Strength` Priest spell                                                 |              9    |    2  |    12 |
| IWD(ification)|    Potion of Stone Giant Strength (20)   | `Iron Body` Wizard spell                                                           |             16    |    2  |    12 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Frost Giant Strength (21)   | `Draw Upon Holy Might` Priest spell                                                |             12    |    1  |    14 |
| BG1, BG2, IWD |    Potion of Frost Giant Strength (21)   | `Righteous Magic` Priest spell                                                     |             12    |    1  |    14 |
| BG1, BG2, IWD |    Potion of Frost Giant Strength (21)   | `Draw Upon Holy Might` Priest spell                                                |             24    |    2  |    14 |
| BG1, BG2, IWD |    Potion of Frost Giant Strength (21)   | `Righteous Magic` Priest spell                                                     |             24    |    2  |    14 |
| BG1, BG2, IWD |    Potion of Frost Giant Strength (21)   | `Champion's Strength` Priest spell                                                 |              9    |    2  |    14 |
| IWD(ification)|    Potion of Frost Giant Strength (21)   | `Iron Body` Wizard spell                                                           |             16    |    2  |    14 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Fire Giant Strength (22)    | `Draw Upon Holy Might` Priest spell                                                |             15    |    1  |    16 |
| BG1, BG2, IWD |    Potion of Fire Giant Strength (22)    | `Righteous Magic` Priest spell                                                     |             15    |    1  |    16 |
| BG1, BG2, IWD |    Potion of Fire Giant Strength (22)    | `Champion's Strength` Priest spell                                                 |              9    |    1  |    16 |
| IWD(ification)|    Potion of Fire Giant Strength (21)    | `Iron Body` Wizard spell                                                           |             16    |    1  |    16 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Cloud Giant Strength (23)   | `Draw Upon Holy Might` Priest spell                                                |             18    |    1  |    18 |
| BG1, BG2, IWD |    Potion of Cloud Giant Strength (23)   | `Righteous Magic` Priest spell                                                     |             18    |    1  |    18 |
| BG1, BG2, IWD |    Potion of Cloud Giant Strength (23)   | `Champion's Strength` Priest spell                                                 |              9    |    1  |    18 |
| IWD(ification)|    Potion of Cloud Giant Strength (23)   | `Iron Body` Wizard spell                                                           |             16    |    1  |    18 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Storm Giant Strength (24)   | `Draw Upon Holy Might` Priest spell                                                |             21    |    1  |    24 |
| BG1, BG2, IWD |    Potion of Storm Giant Strength (24)   | `Righteous Magic` Priest spell                                                     |             21    |    1  |    24 |
| BG1, BG2, IWD |    Potion of Storm Giant Strength (24)   | `Champion's Strength` Priest spell                                                 |              9    |    1  |    24 |
| IWD(ification)|    Potion of Storm Giant Strength (23)   | `Iron Body` Wizard spell                                                           |             16    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Healing                     | `Cure Light Wounds` Priest Spell                                                   |              1    |    1  |     2 |
| BG1, BG2, IWD |    Potion of Healing                     | `Cure Medium Wounds` Priest Spell                                                  |              5    |    2  |     2 |
| BG1, BG2, IWD |    Potion of Healing                     | `Cure Serious Wounds` Priest Spell                                                 |              7    |    3  |     2 |
| BG1, BG2, IWD |    Potion of Healing                     | `Cure Critical Wounds` Priest Spell                                                |              9    |    4  |     2 |
| BG1, BG2, IWD |    Potion of Healing                     | `Heal` Priest Spell                                                                |             11    |    6  |     2 |
| BG1, BG2, IWD |    Potion of Healing                     | `Greater Restoration` Priest Spell                                                 |             14    |    6  |     2 |
| BG1, BG2, IWD |    Potion of Healing                     | `Cure Light Wounds` Innate ability                                                 |              0    |    1  |     2 |
| BG2           |    Potion of Healing                     | `Mass Healing` Bhaalspawn ability                                                  |              0    |    5  |     4 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Heroism                     | `Tenser's Transformation` Wizard Spell                                             |             12    |    1  |    48 |
| BG1, BG2, IWD |    Potion of Heroism                     | `Holy Power` Priest Spell                                                          |              7    |    1  |    48 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Invisibility                | `Invisibility` Wizard Spell                                                        |              3    |    1  |     4 |
| BG1, BG2, IWD |    Potion of Invisibility                | `Invisibility 10' Radius` Wizard Spell                                             |              5    |    2  |     4 |
| BG1, BG2, IWD |    Potion of Invisibility                | `Improved Invisibility` Wizard Spell                                               |              7    |    2  |     4 |
| BG1, BG2, IWD |    Potion of Invisibility                | `Shadow Door` Wizard Spell                                                         |              9    |    2  |     4 |
| BG1, BG2, IWD |    Potion of Invisibility                | `Mass Invisibility` Wizard Spell                                                   |             14    |    4  |     4 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Invulnerability             | `Barkskin` and `Chant` Priest Spells                                               |              3    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Invulnerability             | `Luck` and `Spirit Armor` Wizard Spells                                            |              7    |    1  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Oil of Fiery Burning                  | `Fireball` Wizard Spell                                                            |              5    |    1  |     6 |
| BG1, BG2, IWD |    Oil of Fiery Burning                  | `Delayed Blast Fireball` Wizard Spell                                              |             14    |    2  |     6 |
| BG1, BG2, IWD |    Oil of Fiery Burning                  | `Dragon's Breath` Wizard Spell                                                     |             18    |    5  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Oil of Speed                          | `Haste` Wizard Spell                                                               |              5    |    1  |     6 |
| BG1, BG2, IWD |    Oil of Speed                          | `Haste` Ranger Spell                                                               |              5    |    1  |     6 |
| BG1, BG2, IWD |    Oil of Speed                          | `Improved Haste` Wizard Spell                                                      |             12    |    2  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Elixer of Health                      | `Cure Disease` and `Cure Medium Wounds` Priest Spells                              |              5    |    1  |     4 |
| BG1, BG2, IWD |    Elixer of Health                      | `Neutralize Poison` Priest spell                                                   |              7    |    1  |     4 |
| BG1, BG2, IWD |    Elixer of Health                      | `Heal` Priest spell                                                                |             11    |    3  |     4 |
| BG1, BG2, IWD |    Elixer of Health                      | `Greater Restoration` Priest spell                                                 |             14    |    4  |     4 |
| BG2           |    Elixer of Health                      | `Mass Healing` Bhaalspawn ability                                                  |              0    |    5  |     4 |
| OlvynSpells   |    Elixer of Health                      | `Mass Heal` Priest spell                                                           |             15    |    5  |     4 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Absorption                  | `Protection from Electricity` and `Protection from Normal Weapons` Wizard spells   |              9    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Absorption                  | `Protection from the Elements` and `Protection from Normal Weapons` Wizard spells  |             14    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Absorption                  | `Protection from Energy` and `Protection from Normal Weapons` Wizard spells        |             16    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Absorption                  | `Protection from Lightning` and `Aid` Priest spells                                |              7    |    1  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Agility (18)                | `Draw Upon Holy Might` Priest spell                                                |              3    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Agility (18)                | `Draw Upon Holy Might` Priest spell                                                |              9    |    2  |    10 |
| BG1, BG2, IWD |    Potion of Agility (18)                | `Draw Upon Holy Might` Priest spell                                                |             15    |    3  |    10 |
| BG1, BG2, IWD |    Potion of Agility (18)                | `Draw Upon Holy Might` Priest spell                                                |             21    |    4  |    10 |
| IWD(ification)|    Potion of Agility (18)                | `Cat's Grace` Wizard spell                                                         |             16    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Andidote                              | `Neutralize Poison` Priest spell                                                   |              7    |    1  |     4 |
| BG1, BG2, IWD |    Andidote                              | `Heal` Priest spell                                                                |             11    |    2  |     4 |
| BG1, BG2, IWD |    Andidote                              | `Greater Restoration` Priest spell                                                 |             14    |    4  |     4 |
| BG1, BG2, IWD |    Andidote                              | `Slow Poison` Priest spell                                                         |              3    |    1  |     4 |
| BG1, BG2, IWD |    Andidote                              | `Slow Poison` Innate ability                                                       |              0    |    1  |     4 |
| BG2           |    Andidote                              | `Mass Healing` Bhaalspawn ability                                                  |              0    |    5  |     4 |
| OlvynSpells   |    Andidote                              | `Mass Heal` Priest spell                                                           |             15    |    6  |     4 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Clarity                     | `Spiritual Clarity` Priest spell                                                   |              5    |    2  |     6 |
| BG1, BG2, IWD |    Potion of Clarity                     | `Chaotic Commands` Priest spell                                                    |              9    |    1  |     6 |
| BG1, BG2, IWD |    Potion of Clarity                     | `Heal` Priest spell                                                                |             11    |    3  |     6 |
| BG1, BG2, IWD |    Potion of Clarity                     | `Greater Restoration` Priest spell                                                 |             14    |    3  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Protection from Cold                  | `Protection from Cold` Wizard spell                                                |              5    |    1  |     8 |
| BG1, BG2, IWD |    Protection from Cold                  | `Fireshield (Blue)` Wizard spell                                                   |              7    |    1  |     8 |
| BG1, BG2, IWD |    Protection from Cold                  | `Protection from the Elements` Wizard spell                                        |             14    |    2  |     8 |
| BG1, BG2, IWD |    Protection from Cold                  | `Protection from Energy` Wizard spell                                              |             16    |    3  |     8 |
| BG1, BG2, IWD |    Protection from Cold                  | `Protection from Fire and Cold` Priest spell                                       |              3    |    1  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Defense                     | `Armor`, `Ghost Armor` and `Spirit Armor` Wizard spells                            |              7    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Defense                     | `Barkskin` Priest spell                                                            |             16    |    1  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Explosions                  | `Fireball` Wizard Spell                                                            |              5    |    1  |     8 |
| BG1, BG2, IWD |    Potion of Explosions                  | `Delayed Blast Fireball` Wizard Spell                                              |             14    |    2  |     8 |
| BG1, BG2, IWD |    Potion of Explosions                  | `Dragon's Breath` Wizard Spell                                                     |             18    |    5  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Fire Breath                 | `Agannazar's Scorcher` Wizard Spell                                                |              3    |    1  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Fortitude (18)              | `Draw Upon Holy Might` Priest spell                                                |              3    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Fortitude (18)              | `Draw Upon Holy Might` Priest spell                                                |              9    |    2  |    10 |
| BG1, BG2, IWD |    Potion of Fortitude (18)              | `Draw Upon Holy Might` Priest spell                                                |             15    |    3  |    10 |
| BG1, BG2, IWD |    Potion of Fortitude (18)              | `Draw Upon Holy Might` Priest spell                                                |             21    |    4  |    10 |
| IWD(ification)|    Potion of Fortitude (18)              | `Trollish Fortitude` Wizard spell                                                  |             16    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Genius (18)                 | `Limited Wish` Wizard spell                                                        |             14    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Genius (18)                 | `Wish` Wizard spell                                                                |             18    |    3  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Insulation                  | `Protection from Electricity` Wizard spell                                         |              9    |    2  |    10 |
| BG1, BG2, IWD |    Potion of Insulation                  | `Protection from the Elements` Wizard spell                                        |             14    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Insulation                  | `Protection from Energy` Wizard spell                                              |             16    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Insulation                  | `Protection from Lightning` Priest spell                                           |              7    |    2  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Magic Blocking              | `Globe of Invulnerability` and `Minor Globe of Invulnerability` Wizard Spells      |             12    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Magic Protection            | `Protection From Magic Energy` Wizard spell                                        |             12    |    2  |    24 |
| BG1, BG2, IWD |    Potion of Magic Protection            | `Protection From Energy` Wizard spell                                              |             16    |    1  |    24 |
| BG1, BG2, IWD |    Potion of Magic Protection            | `Magic Resistance` Priest spell                                                    |             20    |    2  |    24 |
| IWD(ification)|    Potion of Magic Protection            | `Greater Shield of Lathander` Priest spell                                         |             20    |    2  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Magic Shielding             | `Limited Wish` Wizard spell                                                        |             14    |    1  |    24 |
| BG1, BG2, IWD |    Potion of Magic Shielding             | `Wish` Wizard spell                                                                |             18    |    3  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Magic Protection            | `Protection From Magic Energy` Wizard spell                                        |             12    |    1  |    24 |
| BG1, BG2, IWD |    Potion of Magic Protection            | `Protection From Energy` Wizard spell                                              |             16    |    1  |    24 |
| BG1, BG2, IWD |    Potion of Magic Protection            | `Magic Resistance` Priest spell                                                    |             20    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Master Thievery             | `Find Traps` Priest Spell and `Luck` Wizard Spell                                  |              3    |    1  |    16 |
| BG1, BG2, IWD |    Potion of Master Thievery             | `Knock` and `Luck` Wizard Spells                                                   |              3    |    1  |    16 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Mind Focusing               | `Draw Upon Holy Might` Priest spell                                                |              9    |    1  |    12 |
| BG1, BG2, IWD |    Potion of Mind Focusing               | `Limited Wish` Wizard spell                                                        |             14    |    1  |    12 |
| BG1, BG2, IWD |    Potion of Mind Focusing               | `Wish` Wizard spell                                                                |             18    |    3  |    12 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Mirrored Eyes               | `Protection from Petrification` and `Stone to Flesh` Wizard Spells                 |             12    |    1  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Perception                  | `Find Traps` Priest Spell and `Luck` Wizard Spell                                  |              3    |    1  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Power                       | `Aid` and `Find Traps` Priest Spells and `Luck` Wizard Spell                       |              3    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Regeneration                | `Regeneration` Priest spell                                                        |             14    |    2  |    10 |
| IWD(ification)|    Potion of Regeneration                | `Trollish Fortitude` Wizard spell                                                  |             16    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Insight (18)                | `Limited Wish` Wizard spell                                                        |             14    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Insight (18)                | `Wish` Wizard spell                                                                |             18    |    3  |    10 |
| BG1, BG2, IWD |    Potion of Insight (18)                | `True Seeing` Priest Spell and `Detect Illusion` Wizard Spell                      |              9    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Free Action                 | `Free Action` Priest spell                                                         |              7    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Stone Form                  | `Barkskin` Priest spell                                                            |              3    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Stone Form                  | `Stoneskin` Wizard spell                                                           |              7    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Stone Form                  | `Flesh to Stone` Wizard spell                                                      |             12    |    1  |    10 |
| BG1, BG2, IWD |    Potion of Stone Form                  | `Iron Skins` Priest spell                                                          |              9    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Extra Healing               | `Cure Critical Wounds` Priest Spell                                                |              9    |    1  |     6 |
| BG1, BG2, IWD |    Potion of Extra Healing               | `Heal` Priest Spell                                                                |             11    |    3  |     6 |
| BG1, BG2, IWD |    Potion of Extra Healing               | `Greater Restoration` Priest Spell                                                 |             14    |    4  |     6 |
| OlvynSpells   |    Potion of Extra Healing               | `Mass Heal` Priest spell                                                           |             15    |    4  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |    Potion of Superior Healing            | `Cure Serious Wounds` and `Cure Critical Wounds` Priest Spells                     |              9    |    1  |    12 |
| BG1, BG2, IWD |    Potion of Superior Healing            | `Heal` Priest Spell                                                                |             11    |    2  |    12 |
| BG1, BG2, IWD |    Potion of Superior Healing            | `Greater Restoration` Priest Spell                                                 |             14    |    3  |    12 |
| OlvynSpells   |    Potion of Superior Healing            | `Mass Heal` Priest spell                                                           |             15    |    3  |    12 |
|               |                                          |                                                                                    |                   |       |       |
| BG1 (SoD)     |   Potion of Persuasiveness               | `Friends` Wizard Spell                                                             |              1    |    1  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| BG2           |   Potion of Clairvoyance                 | `Detect Invisibility` Wizard Spell                                                 |              3    |    1  |     8 |
| BG2           |   Potion of Clairvoyance                 | `Detect Illusion` Wizard Spell                                                     |              5    |    2  |     8 |
| BG2           |   Potion of Clairvoyance                 | `Oracle` Wizard Spell                                                              |              9    |    3  |     8 |
| BG2           |   Potion of Clairvoyance                 | `True Sight` Wizard Spell                                                          |             12    |    4  |     8 |
| BG2           |   Potion of Clairvoyance                 | `Invisibility Purge` Priest Spell                                                  |              5    |    1  |     8 |
| BG2           |   Potion of Clairvoyance                 | `True Seeing` Priest Spell                                                         |              9    |    3  |     8 |
|               |                                          |                                                                                    |                   |       |       |
| BG1, BG2, IWD |   Potion of Infravision                  | `Infravision` Wizard Spell                                                         |              1    |    1  |     4 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Mummy's Tea                              | `Curse Disease` Priest Spell                                                       |              5    |    1  |    12 |
| IWD           | Mummy's Tea                              | `Heal` Priest Spell                                                                |             11    |    3  |    12 |
| IWD           | Mummy's Tea                              | `Greater Restoration` Priest Spell                                                 |             14    |    4  |    12 |
| IWD           | Mummy's Tea                              | `Neutralize Poison` Priest spell                                                   |              7    |    2  |     4 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Flaming Oil                              | `Burning Hands` Wizard Spell                                                       |              1    |    1  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Oil of Second Chances                    | `Bless` and `Remove Curse` Priest Spells and `Luck` Wizard Spell                   |              5    |    1  |    24 |
| IWD           | Oil of Second Chances                    | `Bless` Priest Spell and `Luck` and `Remove Curse`  Wizard Spell                   |              7    |    1  |    24 |
| IWD           | Oil of Second Chances                    | `Chant` and `Remove Curse` Priest Spells and `Luck` Wizard Spell                   |              5    |    1  |    24 |
| IWD           | Oil of Second Chances                    | `Chant` Priest Spell and `Luck` and `Remove Curse`  Wizard Spell                   |              7    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Extra Healing                  | `Cure Serious Wounds` Priest Spell                                                 |              7    |    1  |     6 |
| IWD           | Potion of Extra Healing                  | `Cure Critical Wounds` Priest Spell                                                |              9    |    1  |     6 |
| IWD           | Potion of Extra Healing                  | `Heal` Priest Spell                                                                |             11    |    3  |     6 |
| IWD           | Potion of Extra Healing                  | `Greater Restoration` Priest Spell                                                 |             14    |    4  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Oil of Null Effect                       | `Dispel Magic` Priest Spell                                                        |              5    |    1  |     6 |
| IWD           | Oil of Null Effect                       | `Dispel Magic` Wizard Spell                                                        |              5    |    1  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Oil of the Serpent's Scales              | `Barkskin` Priest Spell                                                            |              3    |    1  |    10 |
| IWD           | Oil of the Serpent's Scales              | `Armor` Wizard Spell                                                               |              1    |    1  |    10 |
| IWD           | Oil of the Serpent's Scales              | `Ghost Armor` Wizard Spell                                                         |              5    |    1  |    10 |
| IWD           | Oil of the Serpent's Scales              | `Spirit Armor` Wizard Spell                                                        |              7    |    2  |    10 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Extra Healing                  | `Cure Critical Wounds` Priest Spell                                                |              9    |    1  |     6 |
| IWD           | Potion of Extra Healing                  | `Heal` Priest Spell                                                                |             11    |    3  |     6 |
| IWD           | Potion of Extra Healing                  | `Greater Restoration` Priest Spell                                                 |             14    |    4  |     6 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Action                         | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Resistance                     | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Greater Resistance             | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Magical Resistance             | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Constitution                   | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Strength Transference          | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Arcane Absorption              | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Life Transference              | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Aura Enhancement               | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Dissipation                    | `Wish` Wizard spell                                                                |             18    |    1  |    24 |
|               |                                          |                                                                                    |                   |       |       |
| IWD           | Potion of Holy Transference              | `Wish` Wizard spell                                                                |             18    |    1  |    24 |



## New Potions
All new potions will be pulled in for crafting if that component is installed.

### New Potions Categories
|  Game(s)/Mods  |                        Potion                     |   Category  |     Sub-Category     |
| -------------- | ------------------------------------------------- | ----------- | -------------------- |
| BG1, BG2, IWD  | Writhing Fog                                      | Bomb        | Damage               |
| IWD(ification) | Snilloc's Snowball Swarm                          | Bomb        | Damage               |
| IWD(ification) | Spike Growth                                      | Bomb        | Damage               |
| BG1, BG2, IWD  | Spirit Fire                                       | Bomb        | Damage               |
| IWD(ification) | Spike Stones                                      | Bomb        | Damage               |
| BG1, BG2, IWD  | Death Fog                                         | Bomb        | Damage               |
| BG1, BG2, IWD  | Chain Lightning                                   | Bomb        | Damage               |
| BG1, BG2, IWD  | Greater Malison                                   | Bomb        | Lower Defenses       |
| OlvynSpells    | Expose to the Elements                            | Bomb        | Lower Defenses       |
| BG1, BG2, IWD  | Entangle                                          | Bomb        | Restrictive          |
| BG1, BG2, IWD  | Grease                                            | Bomb        | Restrictive          |
| BG1, BG2, IWD  | Sleep                                             | Bomb        | Restrictive          |
| BG1, BG2, IWD  | Web                                               | Bomb        | Restrictive          |
| BG1, BG2, IWD  | Stinking Cloud                                    | Bomb        | Restrictive          |
| BG1, BG2, IWD  | Otiluke's Resilient Sphere                        | Bomb        | Restrictive          |
| OlvynSpells    | Colossal Growth                                   | Bomb        | Restrictive          |
| IWD(ification) | Mist of Eldath                                    | Bomb        | Restorative          |
| IWD(ification) | Cloud of Pestilence                               | Bomb        | Status Attack        |
| BG1, BG2, IWD  | Knock                                             | Bomb        | Utility              |
| BG1, BG2, IWD  | Dispel Magic                                      | Bomb        | Utility              |
|                |                                                   |             |                      |
| IWD(ification) | Cure Moderate Wounds                              | Cure        | Healing              |
| BG1, BG2, IWD  | Cure Medium Wounds                                | Cure        | Healing              |
| BG1, BG2, IWD  | Cure Serious Wounds                               | Cure        | Healing              |
| BG1, BG2, IWD  | Heal                                              | Cure        | Healing              |
| IWD(ification) | Trollish Fortitude                                | Cure        | Regeneration         |
| BG1, BG2, IWD  | Remove Curse                                      | Cure        | Restorative          |
| BG1, BG2, IWD  | Cure Disease                                      | Cure        | Restorative          |
| BG1, BG2, IWD  | Zone of Sweet Air                                 | Cure        | Restorative          |
| BG1, BG2, IWD  | Lesser Restoration                                | Cure        | Restorative          |
| IWD(ification) | Unfailing Endurance                               | Cure        | Restorative          |
| BG1, BG2, IWD  | Greater Restoration                               | Cure        | Restorative          |
|                |                                                   |             |                      |
| BG1, BG2, IWD  | Armor                                             | Defense     | Armor                |
| BG1, BG2, IWD  | Barkskin                                          | Defense     | Armor                |
| BG1, BG2, IWD  | Shield                                            | Defense     | Armor                |
| BG1, BG2, IWD  | Ghost Armor                                       | Defense     | Armor                |
| BG1, BG2, IWD  | Spirit Armor                                      | Defense     | Armor                |
| BG1, BG2, IWD  | Entropy Shield                                    | Defense     | Armor                |
| BG1, BG2, IWD  | Sanctuary                                         | Defense     | Avoidance            |
| BG1, BG2, IWD  | Spirit Ward                                       | Defense     | Avoidance            |
| BG1, BG2, IWD  | Protection From Evil                              | Defense     | Avoidance            |
| BG1, BG2, IWD  | Blur                                              | Defense     | Avoidance            |
| OlvynSpells    | Displacement                                      | Defense     | Avoidance            |
| OlvynSpells    | Ghostform                                         | Defense     | Avoidance            |
| BG1, BG2, IWD  | Armor of Faith                                    | Defense     | Damage Resistance    |
| BG1, BG2, IWD  | Fireshield (Blue)                                 | Defense     | Damaging Shield      |
| BG1, BG2, IWD  | Fireshield (Red)                                  | Defense     | Damaging Shield      |
| BG2, IWD       | Aura of Flaming Death                             | Defense     | Damaging Shield      |
| OlvynSpells    | Gedlee's Electric Barrier                         | Defense     | Damaging Shield      |
| BG1, BG2, IWD  | Resist Fire and Cold                              | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From Fire                              | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From Cold                              | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From Electricity                       | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From Acid                              | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From The Elements                      | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From Energy                            | Defense     | Energy Resistance    |
| BG1, BG2, IWD  | Protection From Magic Energy                      | Defense     | Magic Resistance     |
| BG1, BG2, IWD  | Resist Fear                                       | Defense     | Mental Defense       |
| IWD(ification) | Exaltation                                        | Defense     | Mental Defense       |
| BG1, BG2, IWD  | Chaotic Commands                                  | Defense     | Mental Defense       |
| IWD(ification) | Impervious Sanctity of Mind                       | Defense     | Mental Defense       |
| BG1, BG2, IWD  | Protection From Petrification                     | Defense     | Status Immunity      |
| BG1, BG2, IWD  | Mirror Image                                      | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Protection From Normal Missiles                   | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Wraithform                                        | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Stoneskin                                         | Defense     | Physical Immunity    |
| IWD(ification) | Shield of Lathander                               | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Protection From Normal Weapons                    | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Protection From Magical Weapons                   | Defense     | Physical Immunity    |
| IWD(ification) | Greater Shield of Lathander                       | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Mantle                                            | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Improved Mantle                                   | Defense     | Physical Immunity    |
| BG1, BG2, IWD  | Absolute Immunity                                 | Defense     | Physical Immunity    |
| OlvynSpells    | Protection From Non-Silver Weapons                | Defense     | Physical Immunity    |
| OlvynSpells    | Antiharm Shell                                    | Defense     | Physical Immunity    |
| OlvynSpells    | Reflect Attack                                    | Defense     | Physical Immunity    |
| OlvynSpells    | Sphere of Security: Protection from Acid          | Defense     | Protection           |
| OlvynSpells    | Sphere of Security: Protection from Cold          | Defense     | Protection           |
| OlvynSpells    | Sphere of Security: Protection from Electricity   | Defense     | Protection           |
| OlvynSpells    | Sphere of Security: Protection from Fire          | Defense     | Protection           |
| OlvynSpells    | Sphere of Security: Protection from Petrification | Defense     | Protection           |
| OlvynSpells    | Sphere of Security: Protection from Poison        | Defense     | Protection           |
| BG1, BG2, IWD  | Minor Spell Turning                               | Defense     | Spell Defense        |
| BG1, BG2, IWD  | Spell Deflection                                  | Defense     | Spell Defense        |
| IWD(ification) | Antimagic Shell                                   | Defense     | Spell Defense        |
| BG1, BG2, IWD  | Spell Turning                                     | Defense     | Spell Defense        |
| BG1, BG2, IWD  | Spell Trap                                        | Defense     | Spell Defense        |
| BG1, BG2, IWD  | Death Ward                                        | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Minor Globe of Invulnerability                    | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Abjuration                        | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Alteration                        | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Conjuration                       | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Divination                        | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Enchantment                       | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Evocation                         | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Illusion                          | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Spell Immunity: Necromancy                        | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Globe of Invulnerability                          | Defense     | Spell Immunity       |
| BG1, BG2, IWD  | Free Action                                       | Defense     | Status Immunity      |
| BG1, BG2, IWD  | Negative Plane Protection                         | Defense     | Status Immunity      |
|                |                                                   |             |                      |
| BG1, BG2, IWD  | Vocalize                                          | Enhancement | Casting Boost        |
| BG2, IWD       | Improved Alacrity                                 | Enhancement | Casting Boost        |
| OlvynSpells    | Mental Agility                                    | Enhancement | Casting Boost        |
| BG1, BG2, IWD  | Find Traps                                        | Enhancement | Detection            |
| BG1, BG2, IWD  | Detect Invisibility                               | Enhancement | Detection            |
| BG1, BG2, IWD  | True Sight                                        | Enhancement | Detection            |
| OlvynSpells    | Extend Vision                                     | Enhancement | Detection            |
| BG1, BG2, IWD  | Non-Detection                                     | Enhancement | Invisibility         |
| BG1, BG2, IWD  | Improved Invisibility                             | Enhancement | Invisibility         |
| BG1, BG2, IWD  | Shadow Door                                       | Enhancement | Invisibility         |
| OlvynSpells    | Camoflauge                                        | Enhancement | Invisibility         |
| OlvynSpells    | Perfect Invisibility                              | Enhancement | Invisibility         |
| IWD(ification) | Expeditious Retreat                               | Enhancement | Movement             |
| OlvynSpells    | Ghostwalk                                         | Enhancement | Movement             |
| OlvynSpells    | Fly                                               | Enhancement | Movement             |
| BG1, BG2, IWD  | Wondrous Recall                                   | Enhancement | Recall               |
| BG1, BG2, IWD  | Wondrous Recall                                   | Enhancement | Recall               |
| OlvynSpells    | Eclectic Recall                                   | Enhancement | Recall               |
| BG1, BG2, IWD  | Luck                                              | Enhancement | Skill Boost          |
| OlvynSpells    | Legend Lore                                       | Enhancement | Skill Boost          |
| BG1, BG2, IWD  | Friends                                           | Enhancement | Stat Boost           |
| BG1, BG2, IWD  | Draw Upon Holy Might                              | Enhancement | Stat Boost           |
| IWD(ification) | Cat's Grace                                       | Enhancement | Stat Boost           |
| OlvynSpells    | Attain Perfection                                 | Enhancement | Stat Boost           |
| BG1, BG2, IWD  | Strength                                          | Enhancement | Stat Boost: Strength |
| BG1, BG2, IWD  | Strength of One                                   | Enhancement | Stat Boost: Strength |
|                |                                                   |             |                      |
| BG1, BG2, IWD  | Holy Power                                        | Offense     | Attack Bonus         |
| BG1, BG2, IWD  | Recitation                                        | Offense     | Attack Bonus         |
| BG1, BG2, IWD  | Champion's Strength                               | Offense     | Attack Bonus         |
| BG1, BG2, IWD  | Righteous Wrath of the Faithful                   | Offense     | Attack Bonus         |
| OlvynSpells    | True Strike                                       | Offense     | Attack Bonus         |
| BG1, BG2, IWD  | Bless                                             | Offense     | Damage Boost         |
| BG1, BG2, IWD  | Aid                                               | Offense     | Damage Boost         |
| BG1, BG2, IWD  | Chant                                             | Offense     | Damage Boost         |
| IWD(ification) | Blood Rage                                        | Offense     | Damage Boost         |
| IWD(ification) | Emotion: Courage                                  | Offense     | Damage Boost         |
| IWD(ification) | Emotion: Hope                                     | Offense     | Damage Boost         |
| BG1, BG2, IWD  | Righteous Magic                                   | Offense     | Damage Boost         |
| BG1, BG2, IWD  | Tenser's Transformation                           | Offense     | Damage Boost         |
| IWD(ification) | Animal Rage                                       | Offense     | Extra Effects        |
| OlvynSpells    | Searing Smite                                     | Offense     | Extra Effects        |
| OlvynSpells    | Turning Weapon                                    | Offense     | Extra Effects        |
| OlvynSpells    | Wind Shots                                        | Offense     | Extra Effects        |
| OlvynSpells    | Piercing Shots                                    | Offense     | Extra Effects        |
| BG1, BG2, IWD  | Improved Haste                                    | Offense     | Haste                |
| OlvynSpells    | Snake's Swiftness                                 | Offense     | Haste                |
| IWD(ification) | Beast Claw                                        | Offense     | Magic Weapon         |
| IWD(ification) | Decastave                                         | Offense     | Magic Weapon         |
| IWD(ification) | Moonblade                                         | Offense     | Magic Weapon         |
| BG1, BG2, IWD  | Enchanted Weapon                                  | Offense     | Magic Weapon         |
| BG1, BG2, IWD  | Phantom Blade                                     | Offense     | Magic Weapon         |
| BG1, BG2, IWD  | Cloak of Fear                                     | Offense     | Mental Attack        |
| BG1, BG2, IWD  | Nature's Beauty                                   | Offense     | Mental Attack        |



### New Potions Recipes
|  Game(s)/Mods  |                     Potion                     |                        Recipe                     | Req. Caster Level | Yield | Hours |
| -------------- |  --------------------------------------------- | ------------------------------------------------- | ----------------- | ----- | ----- |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Bless                                | Bless                                             |               1   |    1  |    4  |
| BG1, BG2, IWD  | Potion of Bless                                | Aid                                               |               1   |    1  |    4  |
| BG1, BG2, IWD  | Potion of Bless                                | Prayer                                            |               1   |    2  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Bomb of Entangle                               | Entangle                                          |               1   |    1  |    6  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Philter of Resist Fear                         | Resist Fear                                       |               3   |    1  |    8  |
| BG1, BG2, IWD  | Philter of Resist Fear                         | Remove Fear                                       |               1   |    1  |    8  |
| BG1, BG2, IWD  | Philter of Resist Fear                         | Remove Fear (SPCL222)                             |               1   |    1  |    8  |
| IWD(ification) | Philter of Resist Fear                         | Impervious Sanctity of Mind                       |               1   |    3  |    8  |
| BG1, BG2, IWD  | Philter of Resist Fear                         | Mind Blank                                        |               3   |    5  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Sanctuary                            | Sanctuary                                         |               1   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Armor of Faith                          | Armor of Faith                                    |               1   |    1  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Spirit Ward                          | Spirit Ward                                       |               1   |    1  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Grease Bomb                                    | Grease                                            |               1   |    1  |    4  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Potion of Armor                                | Spirit Armor (Shaman)                             |               7   |    3  |    4  |
| BG1, BG2, IWD  | Potion of Armor                                | Armor                                             |               1   |    1  |    4  |
| BG1, BG2, IWD  | Potion of Armor                                | Ghost Armor                                       |               5   |    2  |    4  |
| BG1, BG2, IWD  | Potion of Armor                                | Spirit Armor                                      |               7   |    3  |    4  |
| IWD(ification) | Potion of Armor                                | Entropy Shield                                    |              11   |    4  |    4  |
| BG1, BG2, IWD  | Potion of Armor                                | Barkskin                                          |               1   |    1  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Friends                              | Friends                                           |               1   |    1  |    4  |
| OlvynSpells    | Potion of Friends                              | Attain Perfection                                 |              18   |    5  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Petrification        | Protection From Petrification                     |               1   |    1  |    4  |
| BG1, BG2, IWD  | Potion of Protection From Petrification        | Favored of the Spirits                            |              14   |    1  |    4  |
| BG1, BG2, IWD  | Potion of Protection From Petrification        | Mind Blank                                        |              16   |    5  |    4  |
| BG1, BG2, IWD  | Potion of Protection From Petrification        | Iron Body                                         |              16   |    3  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Evil                 | Protection From Evil (Arcane)                     |               1   |    1  |    2  |
| BG1, BG2, IWD  | Potion of Protection From Evil                 | Protection From Evil (Priest)                     |               1   |    1  |    2  |
| BG1, BG2, IWD  | Potion of Protection From Evil                 | Protection From Evil (SPCL213)                    |               1   |    1  |    2  |
| BG1, BG2, IWD  | Potion of Protection From Evil                 | Protection From Evil, 10' Radius (SPCL233)        |               1   |    4  |    2  |
| BG1, BG2, IWD  | Potion of Protection From Evil                 | Protection From Evil, 10' Radius                  |               7   |    4  |    2  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Shield                                  | Shield                                            |               1   |    1  |    4  |
| IWD(ification) | Oil of Shield                                  | Entropy Shield                                    |               1   |    3  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Sleep Bomb                                     | Sleep                                             |               1   |    1  |    4  |
| BG1, BG2, IWD  | Sleep Bomb                                     | Stinking Cloud                                    |               3   |    2  |    4  |
| BG1, BG2, IWD  | Sleep Bomb                                     | Emotion, Hopelessness                             |               7   |    3  |    4  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Aid                                  | Aid                                               |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Barkskin                                | Barkskin                                          |               3   |    1  |    8  |
| IWD(ification) | Oil of Barkskin                                | Entropy Shield                                    |               3   |    2  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Chant                                | Chant                                             |               3   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Philter of Find Traps                          | Find Traps                                        |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Resist Fire and Cold                 | Resist Fire and Cold                              |               3   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Draught of Draw Upon Holy Might                | Draw Upon Holy Might                              |               3   |    1  |   10  |
| BG1, BG2, IWD  | Draught of Draw Upon Holy Might                | Draw Upon Holy Might (SPIN103)                    |               1   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Writhing Fog Bomb                              | Writhing Fog                                      |               3   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Blur                                    | Blur                                              |               3   |    1  |    8  |
| BG1, BG2, IWD  | Oil of Blur                                    | Blur (SPDM103)                                    |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Detect Invisibility                  | Detect Invisibility                               |               3   |    1  |    6  |
| BG1, BG2, IWD  | Potion of Detect Invisibility                  | True Seeing                                       |               3   |    3  |    6  |
| BG1, BG2, IWD  | Potion of Detect Invisibility                  | True Sight                                        |               3   |    3  |    6  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Knock                                   | Knock                                             |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Luck                                 | Luck                                              |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Mirror Image                            | Mirror Image                                      |               3   |    1  |    8  |
| BG1, BG2, IWD  | Oil of Mirror Image                            | Mirror Image (SPDM106)                            |               1   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Bomb of Stinking Cloud                         | Stinking Cloud                                    |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Potion of Strength                             | Attain Perfection                                 |              18   |    3  |    8  |
| BG1, BG2, IWD  | Potion of Strength                             | Strength                                          |               3   |    1  |    8  |
| BG1, BG2, IWD  | Potion of Strength                             | Holy Power                                        |               7   |    1  |    8  |
| BG1, BG2, IWD  | Potion of Strength                             | Champion's Strength                               |               9   |    2  |    8  |
| BG1, BG2, IWD  | Potion of Strength                             | Righteous Magic                                   |               9   |    2  |    8  |
| BG1, BG2, IWD  | Potion of Strength                             | Iron Body                                         |              16   |    3  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Web Bomb                                       | Web                                               |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Draught of Vocalize                            | Vocalize                                          |               3   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Dispelling Grenade                             | True Dispel                                       |              14   |    3  |   24  |
| BG1, BG2, IWD  | Dispelling Grenade                             | Dispel Magic (Priest)                             |               5   |    1  |   24  |
| BG1, BG2, IWD  | Dispelling Grenade                             | Dispel Magic (Arcane)                             |               5   |    1  |   24  |
| BG1, BG2, IWD  | Dispelling Grenade                             | Dispel Magic (SPCL231)                            |               1   |    1  |   24  |
| BG1, BG2, IWD  | Dispelling Grenade                             | Dispel Magic (SPIN112)                            |               1   |    1  |   24  |
| BG1, BG2, IWD  | Dispelling Grenade                             | Remove Magic                                      |               1   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Potion of Protection From Fire                 | Protection From The Elements (Priest)             |               9   |    2  |   24  |
| BG1, BG2, IWD  | Potion of Protection From Fire                 | Protection From Fire (Arcane)                     |               5   |    1  |   10  |
| BG1, BG2, IWD  | Potion of Protection From Fire                 | Protection From Fire (Priest)                     |               5   |    1  |   10  |
| BG1, BG2, IWD  | Potion of Protection From Fire                 | Storm Shield                                      |               1   |    1  |   10  |
| BG1, BG2, IWD  | Potion of Protection From Fire                 | Protection From The Elements                      |              14   |    3  |   10  |
| BG1, BG2, IWD  | Potion of Protection From Fire                 | Protection From Energy                            |              16   |    3  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Draught of Remove Curse                        | Remove Curse (Priest)                             |               5   |    1  |   10  |
| BG1, BG2, IWD  | Draught of Remove Curse                        | Remove Curse (Arcane)                             |               7   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Phial of Strength of One                       | Strength of One                                   |               5   |    1  |   12  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Medium Healing                       | Cure Medium Wounds                                |               5   |    1  |   10  |
| BG1, BG2, IWD  | Potion of Medium Healing                       | Cure Critical Wounds                              |               9   |    2  |   10  |
| BG1, BG2, IWD  | Potion of Medium Healing                       | Heal                                              |              11   |    4  |   10  |
| BG1, BG2, IWD  | Potion of Medium Healing                       | Greater Restoration                               |              14   |    4  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Cure Disease                         | Cure Disease                                      |               5   |    1  |   12  |
| BG1, BG2, IWD  | Potion of Cure Disease                         | Heal                                              |              11   |    2  |   12  |
| BG1, BG2, IWD  | Potion of Cure Disease                         | Greater Restoration                               |              14   |    2  |   12  |
| BG2            | Potion of Cure Disease                         | Mass Healing (BHAAL1A)                            |               1   |    2  |   12  |
| BG1, BG2, IWD  | Potion of Cure Disease                         | Neutralize Poison                                 |               7   |    2  |   12  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Bottled Sweet Air                              | Zone of Sweet Air                                 |               5   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Non-Detection                        | Non-Detection                                     |               5   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Protection From Normal Missiles         | Protection From Normal Missiles                   |               5   |    1  |   10  |
| BG1, BG2, IWD  | Oil of Protection From Normal Missiles         | Protection From Normal Missiles (Ranger)          |               5   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Wraithform                           | Wraithform                                        |               5   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Ghost Armor                             | Ghost Armor                                       |               5   |    1  |   10  |
| BG1, BG2, IWD  | Oil of Ghost Armor                             | Spirit Armor                                      |               7   |    2  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Cold                 | Protection From Cold                              |               5   |    1  |   10  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Modest Healing                       | Cure Serious Wounds                               |               7   |    1  |   24  |
| BG1, BG2, IWD  | Potion of Modest Healing                       | Cure Critical Wounds                              |               9   |    2  |   24  |
| BG1, BG2, IWD  | Potion of Modest Healing                       | Heal                                              |              11   |    3  |   24  |
| BG1, BG2, IWD  | Potion of Modest Healing                       | Greater Restoration                               |              14   |    3  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Philter of Free Action                         | Free Action                                       |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Draught of Death Ward                          | Death Ward                                        |               7   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Holy Power                           | Holy Power                                        |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Philter of Negative Plane Protection           | Negative Plane Protection                         |               7   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Phial of Fear                                  | Cloak of Fear                                     |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Lesser Restoration                   | Lesser Restoration                                |               7   |    1  |   24  |
| BG1, BG2, IWD  | Potion of Lesser Restoration                   | Greater Restoration                               |              14   |    2  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Bomb of Spirit Fire                            | Spirit Fire                                       |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Blue Fireshield                         | Fireshield (Blue)                                 |               7   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Improved Invisibility                | Improved Invisibility                             |               7   |    1  |   48  |
| BG1, BG2, IWD  | Potion of Improved Invisibility                | Shadow Door                                       |               9   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Minor Invulnerability Globe             | Minor Globe of Invulnerability                    |               7   |    1  |   48  |
| BG1, BG2, IWD  | Oil of Minor Invulnerability Globe             | Globe of Invulnerability                          |              12   |    2  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Stoneskin                            | Stoneskin                                         |               7   |    1  |   48  |
| BG1, BG2, IWD  | Potion of Stoneskin                            | Iron Skins                                        |               9   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Bomb of Greater Malison                        | Greater Malison                                   |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Flask of Otiluke's Resilient Sphere            | Otiluke's Resilient Sphere                        |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Oil of Spirit Armor                            | Spirit Armor (Shaman)                             |               7   |    1  |   24  |
| BG1, BG2, IWD  | Oil of Spirit Armor                            | Spirit Armor                                      |               7   |    1  |   24  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Enchanted Weapon                        | Enchanted Weapon                                  |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Red Fireshield                          | Fireshield (Red)                                  |               7   |    1  |   48  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Philter of True Sight                          | True Sight (Priest)                               |               9   |    1  |   96  |
| BG1, BG2, IWD  | Philter of True Sight                          | True Sight (Arcane)                               |              12   |    1  |   96  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Champion's Strength                  | Champion's Strength                               |               9   |    1  |  168  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Concotion of Chaotic Commands                  | Chaotic Commands                                  |               9   |    1  |   72  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Righteous Magic                      | Righteous Magic                                   |               9   |    1  |   96  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Shadow Door                          | Shadow Door                                       |               9   |    1  |   72  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Immunity to Abjuration               | Spell Immunity: Abjuration                        |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Alteration               | Spell Immunity: Alteration                        |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Conjuration              | Spell Immunity: Conjuration                       |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Divination               | Spell Immunity: Divination                        |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Enchantment              | Spell Immunity: Enchantment                       |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Evocation                | Spell Immunity: Evocation                         |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Illusion                 | Spell Immunity: Illusion                          |               9   |    1  |   96  |
| BG1, BG2, IWD  | Potion of Immunity to Necromancy               | Spell Immunity: Necromancy                        |               9   |    1  |   96  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Normal Weapons       | Protection From Normal Weapons                    |               9   |    1  |   96  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Electricity          | Protection From Electricity                       |               9   |    1  |   72  |
| BG1, BG2, IWD  | Potion of Protection From Electricity          | Protection From Lightning                         |               7   |    1  |   72  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Acid                 | Protection From Acid                              |               9   |    1  |   72  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Phantom Blade                           | Phantom Blade                                     |               9   |    1  |   96  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Minor Spell Turning                     | Minor Spell Turning                               |               9   |    1  |   96  |
| BG1, BG2, IWD  | Oil of Minor Spell Turning                     | Spell Turning                                     |              14   |    2  |   96  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Tonic of Heal                                  | Heal                                              |              11   |    1  |  144  |
| BG1, BG2, IWD  | Tonic of Heal                                  | Greater Restoration                               |              14   |    2  |  144  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Wondrous Divine Recall               | Wondrous Recall                                   |              11   |    1  |  144  |
| BG1, BG2, IWD  | Potion of Wondrous Arcane Recall               | Wondrous Recall                                   |              11   |    1  |  144  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Invulnerability Globe                   | Globe of Invulnerability                          |              12   |    1  |  144  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Tincture of Tenser's Transformation            | Tenser's Transformation                           |              12   |    1  |  240  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Philter of Protection From Magic Energy        | Antiharm Shell                                    |              11   |    1  |  156  |
| BG1, BG2, IWD  | Philter of Protection From Magic Energy        | Protection From Magic Energy                      |              12   |    1  |  156  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Potion of Protection From Magical Weapons      | Protection From Magical Weapons                   |              12   |    1  |  144  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Elixir of Improved Haste                       | Improved Haste                                    |              12   |    1  |  144  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Death Fog Bomb                                 | Death Fog                                         |              12   |    1  |  144  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Bottled Lightning                              | Rampant Lightning                                 |              18   |    3  |  144  |
| BG1, BG2, IWD  | Bottled Lightning                              | Chain Lightning                                   |              12   |    1  |  144  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Oil of Spell Deflection                        | Spell Deflection                                  |              12   |    1  |  156  |
| BG1, BG2, IWD  | Oil of Spell Deflection                        | Shield of the Archons                             |              14   |    1  |  156  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Balm of Nature's Beauty                        | Nature's Beauty                                   |              14   |    1  |  168  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Phial of Greater Restoration                   | Greater Restoration                               |              14   |    1  |  168  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Draught of Spell Turning                       | Spell Turning                                     |              14   |    1  |  168  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Philter of Protection From The Elements        | Protection From The Elements (Priest)             |               9   |    1  |  156  |
| BG1, BG2, IWD  | Philter of Protection From The Elements        | Protection From The Elements                      |              14   |    1  |  156  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Mixture of Mantle                              | Mantle                                            |              14   |    1  |  168  |
| BG1, BG2, IWD  | Mixture of Mantle                              | Improved Mantle                                   |              16   |    2  |  168  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Elixir of Protection From Energy               | Protection From Energy                            |              16   |    1  |  180  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Mixture of Improved Mantle                     | Improved Mantle                                   |              16   |    1  |  192  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Draught of Spell Trap                          | Spell Trap                                        |              18   |    1  |  216  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Tincture of Absolute Immunity                  | Absolute Immunity                                 |              18   |    1  |  240  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Philter of Improved Alacrity                   | Improved Alacrity                                 |              18   |    1  |  240  |
|                |                                                |                                                   |                   |       |       |
| BG1, BG2, IWD  | Aura of Flaming Death Mixture                  | Aura of Flaming Death                             |              15   |    1  |  192  |
|                |                                                |                                                   |                   |       |       |
| IWD(ification) | Oil of Expeditious Retreat                     | Expeditious Retreat                               |               1   |    1  |    4  |
|                |                                                |                                                   |                   |       |       |
| IWD(ification) | Potion of Beast Claw                           | Beast Claw                                        |               3   |    1  |   10  |
| IWD(ification) | Potion of Cat's Grace                          | Cat's Grace                                       |               3   |    1  |    8  |
| IWD(ification) | Potion of Moderate Healing                     | Cure Moderate Wounds                              |               3   |    1  |    6  |
| IWD(ification) | Oil of Decastave                               | Decastave                                         |               3   |    1  |    6  |
| IWD(ification) | Bomb of Snilloc's Snowball Swarm               | Snilloc's Snowball Swarm                          |               3   |    1  |    6  |
|                |                                                |                                                   |                   |       |       |
| IWD(ification) | Potion of Exaltation                           | Exaltation                                        |               5   |    1  |   10  |
| IWD(ification) | Potion of Exaltation                           | Impervious Sanctity of Mind                       |               5   |    3  |   10  |
|                |                                                |                                                   |                   |       |       |
| IWD(ification) | Oil of Moonblade                               | Moonblade                                         |               5   |    1  |   24  |
| IWD(ification) | Bomb of Spike Growth                           | Spike Growth                                      |               5   |    1  |   12  |
| IWD(ification) | Potion of Recitation                           | Recitation                                        |               7   |    1  |   48  |
| IWD(ification) | Potion of Blood Rage                           | Blood Rage                                        |               7   |    1  |   48  |
| IWD(ification) | Bomb of Pestilence                             | Cloud of Pestilence                               |               7   |    1  |   48  |
| IWD(ification) | Potion of Courage                              | Emotion: Courage                                  |               7   |    1  |   48  |
| IWD(ification) | Potion of Hope                                 | Emotion: Hope                                     |               7   |    1  |   48  |
| IWD(ification) | Tonic of Unfailing Endurance                   | Unfailing Endurance                               |               7   |    1  |   48  |
| IWD(ification) | Potion of Animal Rage                          | Animal Rage                                       |               9   |    1  |   72  |
| IWD(ification) | Potion of Righteous Wrath of the Faithful      | Righteous Wrath of the Faithful                   |               9   |    1  |   72  |
| IWD(ification) | Potion of Shield of Lathander                  | Shield of Lathander                               |               9   |    1  |   72  |
| IWD(ification) | Bomb of Spike Stones                           | Spike Stones                                      |               9   |    1  |   96  |
| IWD(ification) | Extract of Entropy Shield                      | Entropy Shield                                    |              11   |    1  |  144  |
| IWD(ification) | Potion of Antimagic Shell                      | Antimagic Shell                                   |              12   |    1  |  144  |
| IWD(ification) | Potion of Trollish Fortitude                   | Trollish Fortitude                                |              12   |    1  |   96  |
| IWD(ification) | Potion of Impervious Sanctity of Mind          | Impervious Sanctity of Mind                       |              14   |    1  |   96  |
| IWD(ification) | Potion of Greater Shield of Lathander          | Greater Shield of Lathander                       |              14   |    1  |  168  |
| IWD(ification) | Bottle of Eldath's Mist                        | Mist of Eldath                                    |              14   |    1  |  156  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Oil of Snake's Swiftness                       | Snake's Swiftness                                 |               1   |    1  |    6  |
| OlvynSpells    | Oil of Searing Smite                           | Searing Smite                                     |               1   |    1  |    8  |
| OlvynSpells    | Oil of Turning Weapon                          | Turning Weapon                                    |               1   |    1  |    4  |
| OlvynSpells    | Oil of Camouflage                              | Camoflauge                                        |               1   |    1  |    8  |
| OlvynSpells    | Oil of Reflect Attack                          | Reflect Attack                                    |               1   |    1  |    8  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Potion of Ghostwalk                            | Ghostwalk                                         |               3   |    1  |    6  |
| OlvynSpells    | Potion of Ghostwalk                            | Ghostwalk                                         |               3   |    1  |    6  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Oil of Wind Shots                              | Wind Shots                                        |               3   |    1  |   12  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Potion of Fly                                  | Fly                                               |               5   |    1  |   12  |
| OlvynSpells    | Potion of Fly                                  | Fly                                               |               5   |    1  |   12  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Oil of Displacement                            | Displacement                                      |               5   |    1  |   10  |
| OlvynSpells    | Draught of Lengendary Lore                     | Legend Lore                                       |               5   |    1  |   10  |
| OlvynSpells    | Oil of Piercing Shots                          | Piercing Shots                                    |               7   |    1  |   48  |
| OlvynSpells    | Bomb of Elemental Exposure                     | Expose to the Elements                            |               9   |    1  |   96  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Oil of Security: Protection from Acid          | Sphere of Security: Protection from Acid          |               9   |    1  |   72  |
| OlvynSpells    | Oil of Security: Protection from Cold          | Sphere of Security: Protection from Cold          |               9   |    1  |   72  |
| OlvynSpells    | Oil of Security: Protection from Electricity   | Sphere of Security: Protection from Electricity   |               9   |    1  |   72  |
| OlvynSpells    | Oil of Security: Protection from Fire          | Sphere of Security: Protection from Fire          |               9   |    1  |   72  |
| OlvynSpells    | Oil of Security: Protection from Petrification | Sphere of Security: Protection from Petrification |               9   |    1  |   72  |
| OlvynSpells    | Oil of Security: Protection from Poison        | Sphere of Security: Protection from Poison        |               9   |    1  |   72  |
|                |                                                |                                                   |                   |       |       |
| OlvynSpells    | Potion of Ghostform                            | Ghostform                                         |               9   |    1  |   96  |
| OlvynSpells    | Potion of Electric Barrier                     | Gedlee's Electric Barrier                         |               9   |    1  |   72  |
| OlvynSpells    | Potion of Antiharm                             | Antiharm Shell                                    |              11   |    1  |  144  |
| OlvynSpells    | Oil of Protection From Non-Silver Weapons      | Protection From Non-Silver Weapons                |              11   |    1  |  168  |
| OlvynSpells    | Exilir of Extend Vision                        | Extend Vision                                     |              16   |    1  |  180  |
| OlvynSpells    | Potion of Perfect Invisibility                 | Perfect Invisibility                              |              18   |    1  |  216  |
| OlvynSpells    | Potion of Attained Perfection                  | Attain Perfection                                 |              18   |    1  |  216  |
| OlvynSpells    | Draught of Eclectic Recall                     | Eclectic Recall                                   |              18   |    1  |  240  |
| OlvynSpells    | Potion of Mental Agility                       | Mental Agility                                    |              18   |    1  |  240  |
| OlvynSpells    | Bomb of Colossal Growth                        | Colossal Growth                                   |              15   |    1  |  240  |
| OlvynSpells    | Potion of True Strike                          | True Strike                                       |               1   |    1  |    4  |
