# The Artisan's House Tweaks
This mod contains an assortment of personal tweaks intended to change certain aspects of Baldur's Gate (I-II):EE and Icewind Dale:EE, ranging from gameplay rebalance, quality of life changes, and minor enhancements.
## Expanded Racial Enemies
*Adds new racial enemies.*

This component unifies the racial enemy selection between BG:EE, BG2:EE and IWD:EE and offers an expanded variety of choices. The available racial enemies include:

Ankheg, Basilisk, Bear, Beholder, Carrion Crawler, Doppleganger, Dragon, Drider, Dwarf, Elemental, Elf, Ettercap, Ettin, Fairy, Fiend, Genie, Ghoul, Giant, Gibberling, Githyanki, Goblin, Golem, Gnoll, Gnome, Half-elf, Half-orc, Halfling, Hobgoblin, Human, Imp, Kobold, Kuo-toa, Lich, Lizardfolk, Lycanthrope, Mephit, Mind Flayer, Minotaur, Myconid, Ogre, Orc, Otyugh, Rakshasa, Sahuagin, Salamander, Shadow, Shambling Mound, Skeleton, Slime, Spider, Troll, Umber Hulk, Vampire, Wolf, Wyvern, Yeti, Yuan-ti, Zombie
## Expanded Shapeshifting
*Provides more versatile and powerful shapeshifting for druids.*

This component replaces the mediocre shapeshifting abilities of the vanilla druid with a much more powerful ability. The druid and avenger gain a ‘Wild Shape’ ability which, three times per day, allows them to shapeshift into five different animal forms. Additionally, the Fire and Earth Elemental Transformation HLAs have now been removed. Instead, the druid gains one cast of Elemental Shape at 14th level, allowing them to transform into four different types of elemental, each with unique benefits.

The totemic druid and shapeshifter are not affected by this component.
## Expanded Racial Bonuses
*Modifies racial stat bonuses and proficiencies.*

This component alters the racial bonuses of the playable races as follows:

Humans:

>– Quick To Master: Humans gain a +5% bonus to experience gained from all sources.
>
>– Skilled: Humans receive a +5% bonus to all thieving skills and +2 bonus to minimum rolls to all ability scores.

Elves:

>– Hardiness vs. Enchantments: Elves gain a +2 bonus to Saving Throws vs. Enchantment spells and a 90% resistance against charm and sleep magics.
>
>– Infravision.
>
>– Elven Proficiency: Elves gain a +2 bonus to hit with bows, short swords, and long swords.
>
>– Thieving Skills: Elves gain a +15% bonus to Move Silently, a +10% bonus to Find Traps and Hide in Shadows, and a +5% bonus to Pick Pockets and Detect Illusions.
>
>– +1 Dexterity, -1 Constitution.

Half-elves:

>– Minor Hardiness vs. Enchantments: Half-elves gain a +1 bonus to Saving Throws vs. Enchantment spells and a 30% resistance against charm and sleep magics.
>
>– Infravision.
>
>– Thieving Skills: Half-elves gain a +10% bonus to Pick Pockets and Hide In Shadows and a +5% bonus to Find Traps.

Dwarves:

>– Dwarven Hardiness: Dwarves gain a +1 bonus to Saving Throws vs. Paralysis/Poison/Death, vs. Rod/Staff/Wand, and vs. Spell, with additional bonuses based on Constitution.
>
>– Infravision.
>
>– Dwarven Proficiency: Dwarves gain a +2 bonus to hit with axes and warhammers.
>
>– Small Stature: Dwarves gain a +2 bonus to Armor Class and Saving Throws vs. giant creatures, but a -2 penalty to hit with all two-handed melee weapons.
>
>– Thieving Skills: Dwarves gain a +20% bonus to Find Traps, +10% bonus to Open Locks and Set Traps, and a +5% bonus to Detect Illusions.
>
>– +1 Constitution, -1 Dexterity, -1 Charisma.

Halflings:

>– Halfling Hardiness: Halflings gain a +1 bonus to Saving Throws vs. Paralysis/Poison/Death, vs. Rod/Staff/Wand, and vs. Spell, with additional bonuses based on Constitution.
>
>– Halfling Proficiency: Halflings gain a +2 bonus bonus to hit with with slings, darts and daggers.
>
>– Small Stature: Halflings gain a +2 bonus to Armor Class and Saving Throws vs. giant creatures, but a -2 penalty to hit with all two-handed melee weapons.
>
>– Thieving Skills: Halflings gain a +15% bonus to Pick Pockets, Open Locks and Hide in Shadows, a +10% bonus to Find Traps and Move Silently, and a +5% bonus to Set Traps.
>
>– +1 Dexterity, -1 Strength.

Gnomes:

>– Gnomish Hardiness: Gnomes gain a +1 bonus to Saving Throws vs. Rod/Staff/Wand and vs. Spell, with additional bonuses based on Constitution.
>
>– Infravision.
>
>– Spell Focus (Illusion): Gnome mages will always specialize in the Illusion school, even when multi-classed. They receive an additional +2 bonus to Saving Throws vs. Illusions.
>
>– Small Stature: Gnomes gain a +2 bonus to Armor Class and Saving Throws vs. giant creatures, but a -2 penalty to hit with all two-handed melee weapons.
>
>– Thieving Skills: Gnomes receive a +15% bonus to Detect Illusions, a +10% bonus to Open Locks and Find Traps, and a +5% bonus to Hide in Shadows, Move Silently and Set Traps.
>
>– +1 Intelligence, -1 Wisdom.

Half-orcs:

>– Infravision.
>
>– Great Fortitude: Half-orcs gain a +2 bonus to Saving Throws vs. Paralysis/Poison/Death.
>
>– Orcish Proficiency: Half-orcs gain a +2 bonus to hit with two-handed melee weapons.
>
>– +1 Strength, +1 Constitution, -1 Intelligence, -1 Charisma.
## Rebalanced Proficiencies
*Modifies proficiencies to expand weapon options for certain classes.*

This component a few weapon proficiencies and restrictions, opening up some classes to a greater variety of weapons.

Clerics may use Heavy and Light Crossbows.

Mages may use Clubs and Light Crossbows, and may become Proficient in Two-Handed Weapon Style and Single Weapon Style.
## Rebalanced Weapon Styles
*Modifies the weapon style proficiencies to be more diverse and useful.*

This component rebalances the bonuses granted by the weapon styles, giving each style its own niche. Additionally, it unlocks Grandmastery of Weapon Styles to appropriate classes and kits.
## Racial Weapon Proficiency
*Allows for certain races to proficiently wield certain weapon types regardless of class... with some technical concessions.*

This component attempts to imitate 3e’s racial weapon proficiency system. Certain races receive automatic proficiency with weapon types they favor, even if no points are added to them. These are the following:

>Elf: Long Swords, Short Swords, Longbows, Shortbows
>
>Dwarf: Axes, War Hammers
>
>Halfling: Daggers, Darts, Slings.

The proficiency bonus is based on the weapons themselves, meaning that if you were an elf who equipped a long sword without normally being proficient, for example, you would be proficient in it for as long as it is equipped. This does mean you are disincentivized from investing points in these weapons normally unless intending to specialize or go further.

Additionally, this component removes class restrictions on weapons for the sake of allowing, for example, an elven sorcerer or cleric to wield long swords, or for a dwarf thief to wield axes. However, this does not modify existing proficiency tables. This means that an dwarf fighter/cleric, for example, will only ever benefit from their innate proficiency in axes and never be able to specialize.

To enforce this new system, class restrictions have been unlocked from all weapon types outside of those with specific themes (e.g. Carsomyr or any other special race/class restricted weapons). I count on the innate penalty to non-proficient weapons to deter people from brute forcing weapons on characters that normally can’t wield them, though I cannot account for any potential exploits.
## Rebalanced Attacks Per Round Progression
*Gives all classes attacks per round progression scaling with base THAC0.*

In vanilla, attacks per round, as well as specialization in most cases, are restricted, purely to warrior classes, limiting the viability of other classes in direct combat roles without dipping into a warrior class via multi-class or dual-class. This component aims to somewhat change that. Similar to how base attack bonus in 3e determines number of attacks per round, this component allows all classes to gain bonus attacks per round determined by their base THAC0 stat, which is the same as that of warriors at base THAC0 values 14 and 8.
## Monk Can Use Quarterstaves
*Gives monks the ability to use and be proficient in quarterstaves.*

This component enables quarterstaff and two-handed weapon style proficiency for monks, complete with semi-proper animations.
## Constitution Bonuses for All Classes + Regeneration Changes
*All classes get equal hit point bonuses for constitution. Regeneration rates increased all around.*

This component makes Constitution a much stronger stat for non-warrior classes by granting full hit point bonuses to all classes.

Additionally, this component also greatly increases high-constitution regeneration rates as well as giving slow regeneration to lower constitution values. CON-based Regeneration has always felt a little too slow to be useful and this was my attempt to make the effect much more noticeable. Also, as a player who tries to rest sparingly, slow regeneration makes resting between area transitions less necessary while not affecting combat. This will also hopefully also reduce cases of ‘resting for 3 days and 16 hours’ for those who play with ‘rest until fully healed’ enabled.

As an addendum: Dragon Disciples will absolutely LOVE this change.
## INT/WIS/CHA-based Bonus Spell Slots
*Grants bonus spell slots based on stats for the Mage, Sorcerer, Ranger, Paladin, Bard and Shaman.*

This component makes the mental ability scores of Intelligence, Wisdom and Charisma more persistently valuable to spellcasters, giving them extra spell slots per ability point.
## Warrior HLAs
*Modifies the HLAs Resist Magic, Critical Strike, War Cry*

These three High Level Abilities are, in my opinion, poorly implemented. War Cry has a pathetic effect, Resist Magic has anti-synergy with spells and equipment, and Critical Strike is abused with high APR which overshadows Whirlwind Attack. As such, I’ve changed all three abilities significantly:

**Resist Magic**

This ability allows the warrior to temporarily tap a great inner strength and fight off the effects of malevolent magic. For 5 rounds, the warrior gains a +10 bonus to all saves. In addition, the warrior absorbs the next 20 spell level’s worth of spells cast upon them. The saving throw bonus always persists for the full duration.

**Critical Strike**

A high-level warrior’s intimate knowledge of vital spots on opponents allows them to, once per day, concentrate their next attack to strike a vital area. With this ability, the warrior’s next attack is a natural 20, a critical hit that deals 4x damage (2x against enemies immune to critical hits).

**War Cry**

With a War Cry, the warrior lets out an invigorating roar, healing their hit points to full in addition to removing fatigue and restoring drained levels.
## Improved Dialogues (BG:EE)
*Makes a couple interactions more convenient for the player.*

Allows the player to get the reputation bonus from Officer Vai without giving up the ability to sell scalps. Talking to Brage no longer forces the party to teleport back to Nashkel.
## Not-So-Indestructible Rats
*Removes the 90% physical resistance from Candlekeep’s rats.*

Makes Candlekeep’s worst sidequest more bearable, especially in Legacy of Bhaal mode.
## Good-Aligned Roleplay Rewards (BG2:EE)
*Allows the player to acquire items that previous required evil actions.*

Soul Reaver and Girdle of Frost Giant Strength: The morally upright players may attempt to desecrate the shrine to Demogorgon to draw the attention of the Demon Knights instead of offering up a living sacrifice. Beware though, a transgression against the Prince of Demons will not go unpunished. Non-evil clerics and paladins get a safer alternative.

Silver Pantaloons: After freeing Lady Elgea, the party will receive the Silver Pantaloons from a messenger after three days.

Deck of Many Things: After playing the game with Aesgareth the cambion, assuming a peaceful resolution, he may be persuaded to trade the deck… for a rather steep price, naturally.
## Cloak of Dragomir only decreases stats in daylight
*Removes annoying micromanagement.*

Not much explanation required I hope. The Cloak of Dragomir only decreases its wearer’s stats while standing in daylight. Hexxat will also auto-equip the cloak when necessary if it is in her inventory.
## Give Stat Bonuses to EENPCs in BG2 (except Hexxat)
*Gives the returning EENPCs in BG2 a stat boost as per the other BG1 NPCs.*
This component gives a boost to the stats of the EENPCs, in line with the returning BG1 party members.

Rasaad: +1 Strength, Dexterity, Constitution

Neera: +2 Constitution, +1 Intelligence

Dorn: +1 Dexterity, +2 Constitution
## Useful Plot Items
*Gives abilities to the plot items that stay in the inventory.*

This component (originally its own mod) gives special abilities to the Mask of King Strohm III, Shadow Dragon Wardstone and Symbol of Amaunator.
## Faster Troll Unconsciousness
*Makes killing trolls less annoying.*

This component modifies the troll’s near death mechanic to make them fall over a lot faster than usual.
## Restore Reputation Increase Sound Effect for BG2
*Restores the reputation increase sound for BG2.*

This component brings the reputation increase jingle from BG:EE into BG2:EE.
## Race Text Patch
*Adds character record text for all races.*

This component adds text to the character record screen for all races in the game. This does not enable any new races for character creation, but should you use an editor or mod to add a non-playable race to your party, it will be named in the records screen and any race references in dialogue.
## Hoodless Thief Avatars
*Changes the unarmored thief avatar.*

This component restores the hoodless avatars for unarmored thieves from vanilla BG2. Options for each race can be chosen individually.
## NPC Soundsets for Icewind Dale
*Adds a bit more life into IWD.*

One of the biggest flaws of IWD in my opinion, as inconsequential as it is to gameplay, is the complete silence of the majority of NPCs in the game due to their lack of soundsets, which in my opinion hurts the atmosphere of the game. This component injects some of the BG soundsets to most of the appropriate NPCs in the game, save for a few already-voiced characters (e.g. Hrothgar, Arundel). I’ve tried to use as wide a range of voices as possible so nothing sounds too repetitive.
## Soundset Tweaks for Anomen and Sarevok (BG2:EE)
*Applies Anomen’s existing soundset changes to more broad conditions. Restores some unused Sarevok soundset lines.*

In BG2, Anomen has a few different soundset lines that he is intended to swap to depending on the outcome of his trial, as well as whether he is in a committed romance, reflecting his personality change. However, these lines have oddly specific conditions that mean they are not used when you would expect them to. For example, a Chaotic Neutral Anomen does not use his appropriate lines until Throne of Bhaal. This component pushes his soundset change to immediately after his alignment change in Shadows of Amn. Additionally, Anomen also has a few calmer, gentler lines in place of his more arrogant ones when in a committed romance. This component also applies these lines to a Lawful Good Anomen, irrespective of romance, to make his character more palatable in accordance to his character development.

Additionally, this component also restores four of Sarevok's unused action lines for his soundset.
## Experience Books
*Adds experience books to help weaker or late-recruited party members keep up.*

Many players like to switch party members in and out for more interactions or to change their playstyle. However, as experience is not shared to out-of-party members, this often leads to companions falling behind and large imbalances in strength. This component adds ‘experience books’ to various temples. These books allow a character at a certain experience threshold to set an underleveled ally to that level. For example, a companion with over 50,000 experience may set an ally with lower experience to 50,000. However, these books are limited in supply and highly expensive to try and prevent abuse, so use them wisely!
## Restored Blade of Aihonen/Sword of Myrloch Vale Tweak
*Change the Blade of Aihonen or Sword of Myrloch Vale's weapon types.*

The Blade of Aihonen is an iconic weapon in the game with a tie to the plot. However, not all protagonists or parties may choose to be proficient in longswords. This component can change the blade into either a bastard sword or two-handed sword.

This same tweak can be applied to the Sword of Myrloch Vale, another interesting weapon with a backstory. Additionally, it has been given a few buffs to make it more appealing to bards, granting a +1 bonus to Charisma and a bard-exclusive buff, Blessing of Myrloch, which grants the wielder a +2 bonus to Armor Class and Saving Throws, and one additional attack per round.
## Passive Trap Detection
*Search for traps passively at a percentage chance while the detection mode is off.*

This component adds a passive effect to all thieves, monks and (with the Artisan’s Kitpack’s overhaul and EEex) rangers, which allows them to passively detect traps using a percentage of their Find Traps skill even when the mode is not selected.
## Remove all 'Hide in Shadows' Voice Cues
*Disable voice lines for hiding.*

Some people find the constant repetition of stealth characters' lines when hiding rather annoying. This component disables them.
## Remove all 'Set Traps' Voice Cues
*Disables voice lines for successful trap setting.*

Same as above, but for setting traps instead.
## Make Helmets Invisible on Mage Avatars
*Removes the helmet model on all mage avatars.*

Some mods add helmets that are usable by mages. These can clip with the hoods on the highest tier robes and look rather weird, and some simply dislike the look of metallic helmets on their unarmored spellcasters in general. This component makes helmets invisible when worn with a mage avatar.
