// The basic idea is to offer 3 paths with 3 distinct consequences:
// 1. Tell Imoen to embrace the taint, which leads to her losing all bhaal abilities but letting her become an uncontrollable Ravager avatar, very powerful but that will attack indiscriminately. It will also count as "corrupting" Imoen.
// 2. Tell Imoen to control the taint, letting her keep all bhaal abilities as well as become another Slayer that works just like the PC.
// 3. Tell Imoen to shut out the taint, giving her +1 constitution and the ability to look at herself in a mirror without seeing a monster.

/*
Contents:
First Conversation: nightmares and first powers
Second Conversation: more powers
Third Conversation: faster, stronger, more violent
*/

//change the weights so the vanilla taint talks have highest priority
SET_WEIGHT BIMOEN25 81 #-3
SET_WEIGHT BIMOEN25 91 #-2
SET_WEIGHT BIMOEN25 100 #-1

//force set 15 minute timer after gromnir, yaga is dead
//we want the talks to happen sequentially after these bosses are dead

// ~Gromnir knows a stranger came to Saradush, pretty Melissan. Another Bhaalspawn. You must think Gromnir too stupid not to remember there is no way in or out of this city, mmm?~
ADD_TRANS_ACTION GROMNIR
BEGIN 0 END
BEGIN 0 END
~RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",900)~

// ~What a disappointment you created for me, worm! I redoubled our efforts to crush this worthless town when I heard you were within, the Terror of the Sword Coast... only to find you gone!~ 
ADD_TRANS_ACTION YAGA01
BEGIN 1 END
BEGIN 0 END
~RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",900)~




// First Conversation: nightmares and first powers

// Imoen says:
// I... I've been having some nightmares. Really strange ones, like sailing on rivers of blood. So *real*. You... you used to dream a lot. Right before Gorion died. Was it... was it like that?

ADD_STATE_TRIGGER BIMOEN25 81 ~!ActuallyInCombat() RealGlobalTimerExpired("IRTBhaalTalkTimer","GLOBAL") InParty("Imoen2") !StateCheck(Player1,CD_STATE_NOTVALID) !StateCheck(Myself,CD_STATE_NOTVALID)~

ADD_TRANS_TRIGGER BIMOEN25 81 ~!Global("ImoenRomanceActive","GLOBAL",2) !Global("ImoenRomanceActive","GLOBAL",3)~ DO 0 1 2


ADD_TRANS_ACTION BIMOEN25
BEGIN 81 END
BEGIN 0 1 2 3 4 END
~SetGlobal("IRTTortureTalk","GLOBAL",1) RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700)~

EXTEND_TOP BIMOEN25 81
+ ~Global("ImoenRomanceActive","GLOBAL",2)~ + ~You've been restless in your sleep. I was wondering if that was the issue.~ DO ~SetGlobal("IRTTortureTalk","GLOBAL",1) SetGlobal("ExpBImoen10","LOCALS",1)  RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700)~ + 81Restless
	+ ~Global("ImoenRomanceActive","GLOBAL",3)~ + ~Did we suddenly become friends? I've ordered you not to talk to me.~ DO ~SetGlobal("IRTShutUp","GLOBAL",1) SetGlobal("ExpBImoen10","LOCALS",1)  RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700)~ + 81mean
END

APPEND BIMOEN25
	IF ~~ THEN 81Restless
		SAY ~Yeah. I think I've kicked you a few times, hah. Sorry about that.~
		IF ~~ THEN GOTO 84
	END

	IF ~~ THEN 81mean
		SAY ~(Imoen looks at you for a while.)~
		= ~I was just hoping...~
		= ~Never mind. Don't be surprised if I do some... weird things I couldn't do before.~
	   IF ~~ THEN DO ~RunAwayFrom(Player1,20) ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END
END

EXTEND_BOTTOM BIMOEN25 85
	++ ~Let me guess. Minor healing spells, life draining abilities...~ + 85guess
	++ ~I know what this is about, and I can't help you. You need to work it out for yourself, as I did.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-2)~ + 85yourself
	++ ~I honestly don't give a damn.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-10)~ + 81mean
END

APPEND BIMOEN25
	IF ~~ THEN 85guess
		SAY ~Yeah! Yeah, of course you'd know. It's just like what you went through, isn't it? That means...~
		IF ~~ THEN GOTO 87
	END

	IF ~~ THEN 85yourself
		SAY ~(Imoen gives you a helpless look, but soon it turns to resignation.)~
		= ~I guess it's only fair. Everyone's different... and you've got enough already, dealing with your own whispers. Though I guess by now it's turned into conversations for ya.~
		= ~Well, alright then. Don't be surprised if I do some... weird things I couldn't do before. I only hope I don't suddenly turn into a monster and kill everyone.~
	   IF ~~ THEN DO ~RunAwayFrom(Player1,20) ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END
END

EXTEND_TOP BIMOEN25 87
	++ ~Regardless of what happens, I will always be here for you.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + 87new
END

//go to state 88
//transition 0 (the first one)
//change the transition only when no romance imoen (not even possible really unless you didn't install the mod for SOA
//i guess it makes it never appear

ADD_TRANS_TRIGGER BIMOEN25 88 ~Global("ImoenRomanceActive","GLOBAL",0)~ DO 0

 //put in new states as below
EXTEND_BOTTOM BIMOEN25 88
COPY_TRANS BIMOEN25 87new
END

APPEND_EARLY BIMOEN25
IF ~~ THEN 87new
	SAY ~(Imoen gives you a faint smile.) That's always comforting. Though now it means you'll be right there to be clawed to death when I become a giant monster...~
	= ~I don't know how you ever dealt with it. The more I discover about this taint, the more I don't want it.~
	++ ~It's hard at the start, but you get used to it. It's just another tool. You must learn to tame the power and bend it to your will, like I do.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1) IncrementGlobal("IRTControlTaint","GLOBAL",1)~ + 87new1
	++ ~Your only recourse is to embrace it. Anything else is doomed to fail.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1) IncrementGlobal("IRTEmbraceTaint","GLOBAL",1)~ + 87new2
	++ ~Fight against it with everything you have. We'll get through it together, Imoen.~ DO ~IncrementGlobal("IRTFightTaint","GLOBAL",1)~ + 87new4
		++ ~I didn't deal with it. I still feel like a pawn to its whim sometimes. You simply live on.~ + 87new3
	++ ~Just keep yourself in check. I don't want it interfering with my plans.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + 87new5
END
END

ADD_TRANS_TRIGGER BIMOEN25 90 ~Global("ImoenRomanceActive","GLOBAL",0)~ DO 0

EXTEND_BOTTOM BIMOEN25 90
+ ~GlobalGT("ImoenRomanceActive","GLOBAL",0)~ + ~We kill people all the time, Imoen. You shouldn't worry so much, I'll handle you if it comes to that. Take it from me, there is truly no sense fighting this.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1) IncrementGlobal("IRTEmbraceTaint","GLOBAL",1)~ + 90new1
+ ~GlobalGT("ImoenRomanceActive","GLOBAL",0)~ + ~That is exactly why you must explore it on your own terms. Don't let the Taint be something that happens to you; call upon it so that you may bend it to your will.~ DO ~IncrementGlobal("IRTControlTaint","GLOBAL",1) IncrementGlobal("IRTCorruptImoen","GLOBAL",1)~ + 90new2
+ ~GlobalGT("ImoenRomanceActive","GLOBAL",0)~ + ~You're right, I was just trying to make you feel better. Take your time.~ + 90new3
+ ~GlobalGT("ImoenRomanceActive","GLOBAL",0)~ + ~As you wish, as long as you don't fail me when I need you.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-3)~ + 87new5
END


APPEND BIMOEN25
	IF ~~ THEN 87new1
		SAY ~That's just scary. I don't wanna touch this thing at all. It's like this gross pool of black rage in the back of my head, just waiting to spill out and get on everything. And I get a feeling that the more I dip into it, the more I'll *want* to dip into it. I don't know if that's the best idea.~
		= ~But you'd know, of course. If I have no choice... then I need to learn to live with it.~
		= ~Thanks for listening. Hopefully I'll wake up one day and it'll be all gone, just like that. Wouldn't it be nice...~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 87new2
		SAY ~Jeez, you don't have to be so bleak about it! Maybe it'll be different for me, because I don't have so much of the stuff inside me. Who knows? I'm not gonna just lie down and take it, no way.~
		= ~I'll keep you updated. Hopefully I'll wake up one day and it'll be all gone, just like that. Wouldn't it be nice...~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 87new3
		SAY ~Boy, that's just depressing. Is that really how it is? Maybe it'll be different for me, because I don't have so much of the stuff inside me. Who knows? I'm not gonna just lie down and take it, no way.~
		= ~There's gotta be a way to fight it. I'll keep you updated. Thanks for listening, anyway.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 87new4
		SAY ~Yeah, I'm trying. I'm so glad you're here, it would be terrifying to deal with this without you around. Now that I'm seeing how it was like for you... well, let's say I'm impressed with how you've dealt with everything without going crazy.~
		= ~Without going even crazier, I mean. Hah.~
		= ~Thanks for listening, <CHARNAME>.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 87new5	
		SAY ~Jeez. Yes <PRO_SIRMAAM>. Yer just overflowing with sympathy there.~
		= ~I'll keep you updated, I guess. Ya know, so you can plan around it.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 90new1
		SAY ~Yeah, we kill people *on purpose*, because they had it coming! I don't wanna go on an indiscriminate rampage like it happened to you in Spellhold. You almost tore my head off, remember that?~
		= ~But I guess you're right on the "being able to handle me" part. I doubt I could land a claw on ya even with Bhaal superpowers. Yer all kinds of mighty.~
		= ~Well, then, if it happens... you know what to do. Try not to hurt me too much, though, huh? Drooling monstrosity or not, I'll still have feelings.~
		= ~Not that it'll ever happen. You'll see. I'll beat this thing into the ground.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 90new2
		SAY ~But that's like inviting madness! I don't want to touch it, no way. It's like this gross pool of black rage in the back of my head, just waiting to spill out and get on everything. And I get a feeling that the more I dip into it, the more I'll *want* to dip into it. I don't know if that's the best idea.~
		= ~I know you've got the experience and I should take your advice, but... I can't. I have to try and fight it. I have to.~
		= ~Thanks for listening anyway, even if I'm being stubborn. Hopefully I'll wake up one day and it'll be all gone, just like that. Wouldn't it be nice...~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END

	IF ~~ THEN 90new3
		SAY ~Thank you. I'll keep you updated. Hopefully I'll wake up one day and it'll be all gone, just like that. Wouldn't it be nice...~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL1)~ EXIT
	END
END

// Second Conversation: more powers, faster and stronger
// Imoen says: I've, um... been developing some more abilities. Bhaal abilities, like your own. I don't mean to; they just come... although I don't think they're very strong.
ADD_STATE_TRIGGER BIMOEN25 91 ~!ActuallyInCombat() Dead("Gromnir") RealGlobalTimerExpired("IRTBhaalTalkTimer","GLOBAL") InParty("Imoen2") !StateCheck(Player1,CD_STATE_NOTVALID) !StateCheck(Myself,CD_STATE_NOTVALID)~

//limit some options out
ADD_TRANS_TRIGGER BIMOEN25 91 ~Global("ImoenRomanceActive","GLOBAL",0)~ DO 1 3


ADD_TRANS_ACTION BIMOEN25
BEGIN 91 END
BEGIN 0 1 2 3 END
~RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700)~

EXTEND_TOP BIMOEN25 91
 	  ++ ~That must be unnerving. I didn't expect you to be so calm about it.~ DO ~SetGlobal("ExpBImoen10","LOCALS",2) RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700) ~ + 91new
	  ++ ~Excellent. Tell me more.~ DO ~SetGlobal("ExpBImoen10","LOCALS",2) RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700) ~ + 92
END

APPEND BIMOEN25
	IF ~~ THEN 91new
		SAY ~I freaked out the first time they happened. Healed a scratch on my hand right there on the spot. You didn't get to see it because I happened to be in the middle of peeing, if you must know.~
		= ~It has nothing to do with my magic, either. Pretty sure only priests can do stuff like that. Sure enough, just like what you started doing - I must be a late bloomer or something.~
		IF ~~ THEN GOTO 93
	END
END

//vanilla choices appear if you didn't even do anything with imoen lol

ADD_TRANS_TRIGGER BIMOEN25 93 ~Global("ImoenRomanceActive","GLOBAL",0)~ DO 0 1 2

EXTEND_BOTTOM BIMOEN25 93 #1
++ ~But they *are* natural. Your true nature is manifesting. As you can see, not all of it is unpleasant.~ DO ~IncrementGlobal("IRTEmbraceTaint","GLOBAL",1) IncrementGlobal("IRTCorruptImoen","GLOBAL",1)~ + 93new1
++ ~You are the master, Imoen, not the Taint. Push your limits, test these powers you are developing and work to have absolute control over them.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1) IncrementGlobal("IRTControlTaint","GLOBAL",1)~ + 93new2
++ ~The less you use those accursed abilities, the better. Take it from me, it's much easier to deal with the Taint if you shut it out as much as you can.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",-1) IncrementGlobal("IRTFightTaint","GLOBAL",1)~ + 93new3
+ ~Global("ImoenRomanceActive","GLOBAL",2)~ + ~(Give her a roguish smile.) Sounds like we'll have even more fun in the bedroll from now on.~ + 93new4
END

APPEND BIMOEN25
	IF ~~ THEN 93new1
		SAY ~My true nature? It doesn't feel like me at all. I have these thoughts all the time... they cloud my mind and make me angry. I don't like it.~
		= ~You put it like I have no choice. Maybe... maybe I don't. You would know, of all people.~
		= ~(Imoen sighs, her shoulders hunched over.) It's getting really old to fight inside my head every waking moment...~
		= ~Thanks again for listening to my whining.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL2)~ EXIT
	END

	IF ~~ THEN 93new2
		SAY ~That sounds so scary, though. And way easier said than done. It's hard to keep control with all these dreams and thoughts all the time... they cloud my mind and make me angry. I don't like it. It's not me.~
		= ~But... I'll try. If you think I can do it, I'll try. I don't have much of a choice, do I? The alternative is getting swallowed whole by the monster.~
		= ~Maybe I should stop whining and start working on it.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL2)~ EXIT
	END

	IF ~~ THEN 93new3
		SAY ~Sometimes I don't get a choice, though; it just happens. And I can't make myself weaker on purpose... though I understand what yer trying to say. Shutting it all out sounds like the greatest idea anyone ever had.~
		= ~Thank you so much, <CHARNAME>. You always know how to give me hope.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL2)~ EXIT
	END

	IF ~~ THEN 93new4
		SAY ~(Imoen smacks your shoulder.) One track mind, you! It's serious stuff, ya horndog. I'm... changing. I'm pretty sure it's not for the better.~
		++ ~Better or worse, it's who you truly are. You might as well enjoy the good parts.~ DO ~IncrementGlobal("IRTEmbraceTaint","GLOBAL",1) IncrementGlobal("IRTCorruptImoen","GLOBAL",1)~ + 93new1
		++ ~It might not seem like it, but you are in control of those changes. Explore your new powers and gain mastery over them.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1) IncrementGlobal("IRTControlTaint","GLOBAL",1)~ + 93new2
		++ ~The less you use those accursed abilities, the better. Take it from me, it's much easier to deal with the Taint if you shut it out as much as you can.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",-1) IncrementGlobal("IRTFightTaint","GLOBAL",1)~ + 93new3
		++ ~Everything will be alright, Imoen. It will be over soon.~ + 97new
	END	

	IF ~~ THEN 97new
		SAY ~I hope so. Feels like there's a spell trigger counting down inside my head. We better hurry to get this Bhaal stuff resolved before it goes off.~
		= ~Thanks for listening to my whining again.~
		IF ~~ THEN DO ~ReallyForceSpell(Myself,IMOEN_BHAAL2)~ EXIT
	END
END

// Third Conversation: craving violence

// Imoen Says: I felt something come over me, <CHARNAME>. A... viciousness I've never felt before. I just wanted to tear someone's throat out with my bare hands.

ADD_STATE_TRIGGER BIMOEN25 100 ~!ActuallyInCombat() RealGlobalTimerExpired("IRTBhaalTalkTimer","GLOBAL") Dead("Yaga01") InParty("Imoen2") !StateCheck(Player1,CD_STATE_NOTVALID) !StateCheck(Myself,CD_STATE_NOTVALID)~

ADD_TRANS_ACTION BIMOEN25
BEGIN 100 END
BEGIN 0 END
~RealSetGlobalTimer("IRTBhaalTalkTimer","GLOBAL",2700)~

EXTEND_BOTTOM BIMOEN25 102
++ ~I wish you had. It's been a good while since we got into some rough-housing. I'd probably have won through crippling tickles.~ + 102new1
++ ~You would have regretted that dearly. I hope you know that.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-2)~ + 102new2
END

EXTEND_BOTTOM BIMOEN25 101
IF ~GlobalGT("IRTEmbraceTaint","GLOBAL",0) OR(2) GlobalGT("IRTControlTaint","GLOBAL",0) GlobalGT("IRTFightTaint","GLOBAL",0)~ THEN GOTO 101Disamb
IF ~GlobalGT("IRTFightTaint","GLOBAL",0)  OR(2) GlobalGT("IRTControlTaint","GLOBAL",0) GlobalGT("IRTEmbraceTaint","GLOBAL",0)~ THEN GOTO 101Disamb
IF ~GlobalGT("IRTControlTaint","GLOBAL",0) OR(2) GlobalGT("IRTEmbraceTaint","GLOBAL",0) GlobalGT("IRTFightTaint","GLOBAL",0)~ THEN GOTO 101Disamb

IF ~GlobalGT("IRTEmbraceTaint","GLOBAL",0) Global("IRTControlTaint","GLOBAL",0) Global("IRTFightTaint","GLOBAL",0) ~ THEN GOTO 101E
IF ~GlobalGT("IRTControlTaint","GLOBAL",0) Global("IRTEmbraceTaint","GLOBAL",0) Global("IRTFightTaint","GLOBAL",0)~ THEN GOTO 101C
IF ~GlobalGT("IRTFightTaint","GLOBAL",0) Global("IRTControlTaint","GLOBAL",0) Global("IRTEmbraceTaint","GLOBAL",0)~ THEN GOTO 101F
END

APPEND BIMOEN25
	IF ~~ THEN 102new1
		SAY ~Hah! Now I'm a bit sorry I didn't. Coulda used the mindless laughter.~
		= ~(Imoen sighs.) I don't know... I'm starting to forget what I used to be like. I think that's the worst part.~
		IF ~~ THEN GOTO 104
	END

	IF ~~ THEN 102new2
		SAY ~Yeesh, of course I do, you don't have to threaten me like that. You'd have put me in my place real quick.~
		= ~Probably not before I'd bitten you a bunch of times, though.~
		IF ~~ THEN GOTO 104
	END

		// You've adviced Imoen contradictory things
	IF ~~ THEN 101Disamb
		SAY ~And when the fight was over, I was disappointed. I didn't really know what to do, I found myself *this* close to snarling and jumping on your back. It was scary.~
		= ~I mean, you yourself don't seem to know how to deal with it. You tell me to do one thing first, then the other. Embracing the Taint is so very tempting, and it feels good in a way, but it also feels... wrong. Like I'd lose myself completely to the rage. And controlling the Taint seems outright impossible - how do you reel it back? How do you bottle it back up without letting it take over? I don't know if I can use this thing without it swallowing me.~
		= ~I'd rather fight it with everything I've got but... I'm so confused. Even now I want to keep attacking somebody, doesn't matter who it is.~
		+ ~GlobalGT("IRTEmbraceTaint","GLOBAL",0)~ + ~Embracing the Taint is the first step. After you let go, things will become clear. You will be one with the power.~ + 101E3
		+ ~GlobalGT("IRTControlTaint","GLOBAL",0)~ + ~To control it you need to be aware at all times of where you end and where the Taint begins. It isn't easy, but you can do it.~ + 101C1
		+ ~GlobalGT("IRTFightTaint","GLOBAL",0)~ + ~I know it seems hopeless, but that's what this evil thing wants you to think. You are far stronger than the Taint, always remember that.~ + 101F2
		+ ~GlobalGT("IRTFightTaint","GLOBAL",0)~ + ~You only have to hold on until we finish this. I'll be by your side every step of the way.~ + 101F4
		++ ~I don't care one way or another. Figure it out on your own.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + 101FuckOff
	END
	
	// You've adviced Imoen to embrace the Taint

	IF ~~ THEN 101E
		SAY ~And when the fight was over, I was disappointed. No - I was angry, SO angry. For a moment, I found myself *this* close to snarling and jumping on your back, just to give the anger release.~
		= ~I don't know if this whole "embrace the taint" thing is working for me. It's so very tempting, and it feels good in a way, but it also feels... wrong. Like I'd lose myself completely to the rage. And not just that - I can sense something deeper lurking beneath. Like... a very real, very spiky monster waiting to get out.~
		= ~Are you... are you sure I should let go like that? Every part of me that's still *me* says I shouldn't.~
		++ ~I'm saving you all the grief of the struggle. You'll end up where I am anyway, so might as well take a shortcut there.~ + 101E1
        ++ ~It doesn't have to stop. (You shove her shoulder, hard.) Come on, show me what you can do.~ + 101E2
		++ ~Embracing it is the first step. After you let go, things will become clear. You will be one with the power.~ + 101E3
		++ ~If you feel that way, maybe you should fight it for as long as you can. You are no use to anyone as a mindless beast.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",-1) IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + 101E4
		++ ~I don't care one way or another. Figure it out on your own.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + 101FuckOff
	END

	IF ~~ THEN 101E1
		SAY ~(Imoen bites her lip.) Remember what Mr. G used to say? A fool's map is full of shortcuts. He'd say it about me wanting to skip lessons, but still...~
	    IF ~GlobalGT("IRTLoveMeter","GLOBAL",4)~ THEN DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1)~ GOTO EmbraceYes  // It is only a measure of Imoen's trust, so it doesn't have to be very high.
		IF ~!GlobalGT("IRTLoveMeter","GLOBAL",4)~ THEN DO ~SetGlobal("IRTCorruptImoen","GLOBAL",0)~ GOTO EmbraceNo
	END

	IF ~~ THEN 101E2
		SAY ~(She staggers a step back and looks at you behind a frown.) Whoa, hey, what's your problem?~
		++ ~(Shove her again.) Come on! You said you were disappointed, but it doesn't have to end! Do what you crave. Let it all out.~ + 101E2next
		++ ~Never mind. You are not ready.~ + 101E2notReady
		++ ~Alright, sorry about that. It was a misguided attempt at pushing you over the edge.~ + 101E2sorry
	END

	IF ~~ THEN 101E2sorry
		SAY ~(Imoen's frown lingers.) Yeah. Yeah, no kiddin'. Misguided is right.~
		IF ~~ THEN GOTO 101E2end
	END

	IF ~~ THEN 101E2end	
		SAY ~If this is your way of helping me, I think I'll be fine on my own, thanks. I just need to hold on until it's all over.~
		= ~... Jerk.~
		IF ~~ THEN DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5) SetGlobal("IRTCorruptImoen","GLOBAL",0) ~ EXIT
	END

	IF ~~ THEN 101E2notReady
		SAY ~(Imoen's frown deepens.) Not ready? Ready for what, you nutjob?~
		IF ~~ THEN GOTO 101E2end
	END

	IF ~~ THEN 101E2next
		SAY ~Hey, watch it! (She speaks through bared teeth. There's a wild spark in her eye.) Are you nuts? I don't want to fight *you*!~
		++ ~(Keep harassing her, throwing calculated jabs that you know she'll dodge.) Do you think the Taint is some kind of parasite? A Bhaalspawn is who you *are*, the anger you feel is all yours. Come on, let loose already!~ + 101E2next2
		++ ~Never mind. You are clearly not ready.~ + 101E2notReady
		++ ~Alright, fine. Sorry about that. It was a misguided attempt at pushing you over the edge.~ + 101E2sorry
	END

	IF ~~ THEN 101E2next2
		SAY ~(Imoen dodges and deflects by instinct, your attacks providing hardly a challenge. She locks arms with you and stares. Her eyes are wide and her breath is ragged, far more than the exertion would warrant.)~
		= ~Stop it. Stop it, <CHARNAME>.~
		= ~It's not true. This isn't me. It can't be me.~
		++ ~Stop lying to yourself. You keep worrying about losing who you are, but *this* is your true self. Accept it. Embrace it.~ + 101E2next3
		++ ~I also struggled, but it's pointless. Sooner or later you give in, because that's our nature. There is no other choice.~ + 101E2next3
		++ ~See past your denial for a moment. Focus on what lies beneath, that spark urging you to let go. It feels good, doesn't it? It feels... *right*.~ + 101E2next3
	END

	IF ~~ THEN 101E2next3
		SAY ~Don't you think I *know* that? (She lets go of your arms, shaking her head.) Deep inside, I know it. I already know it.~
		= ~There's no fighting this thing. It's... what I am. There's a part of me that's been dormant until now, but it's waking up. And that part of me is a bloodthirsty monster. I can't deny it any more than I could deny my spleen.~
		= ~Alright... (Imoen closes her eyes and nods to herself.) Alright. You made your point. If you think it's for the best, I'll try. Next time I feel it there, egging me on, I'll just... give in.~
		= ~Whatever happens, I'm sure you'll know how to deal with it.~
		IF ~~ THEN DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1) SetGlobal("IRTRavagerTurnCounter","GLOBAL",1)~ EXIT
	END

	/*
	IRTRavagerTurnCounter needs to go up by 1 every time Imoen gets in combat. When it reaches 5, she will heal all hitpoints and become the Ravager.
	The Ravager is a powerful avatar of Bhaal and is uncontrollable. It has boosted resistances, double Imoen's normal HP and packs a fat melee punch - but it's not nearly as tough as the Ravager monster you fight at the end of ToB, for reference. Its script will attack nearest enemies first, then it will turn on party members. The only way for Imoen to turn back is to get her to one half of her total health. Once Imoen turns back, she will fall unconscious until end of combat. When combat is over, she will start the conversation labeled "After Ravager Turn", below. 
	*/

	IF ~~ THEN 101E3
		SAY ~(Imoen bites her lip.) Ya know, that doesn't put me at ease. I don't give a damn about the power. I just want the nasty dreams and whispers to stop already. Is it really that much to ask?~
		IF ~GlobalGT("IRTLoveMeter","GLOBAL",4)~ THEN DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1)~ GOTO EmbraceYes
		IF ~!GlobalGT("IRTLoveMeter","GLOBAL",4)~ THEN DO ~SetGlobal("IRTCorruptImoen","GLOBAL",0)~ GOTO EmbraceNo
	END

	IF ~~ THEN 101E4
		SAY ~(Imoen blows out a nervous breath.) Oh, thank the Gods. I was hoping you'd say something like that. As tempting as it is, this whole idea was just terrifying. It's dark down there with the Taint. I didn't want to sink into that pit, who knows what would come out of it.~
		= ~Alright, then... I'm going to try and not touch this awful thing. I just want it gone. Maybe if I hold out long enough, it will all get resolved in the end. We can hope, right?~
		= ~Just gotta hang on a bit longer.~
		IF ~~ THEN DO ~SetGlobal("IRTCorruptImoen","GLOBAL",0) SetGlobal("IRTFightTaintCount","GLOBAL",1) ~ EXIT
	END

	IF ~~ THEN EmbraceYes
		SAY ~Alright... (She closes her eyes and nods to herself.) Alright. I trust you, <CHARNAME>, you've dealt with this for so long. If you think it's for the best, I'll try. I keep making light of things, but honestly I'm willing to try anything if it'll help me deal with this nightmare.~
		= ~Next time I feel it there, egging me on, I'll just... give in. I don't know what will happen, but I'll trust you to help me through it. Okay?~
		++ ~As always, Imoen.~ + EY1
		++ ~On second thought, it might not be the best idea.~ + EY2
	END

	IF ~~ THEN EmbraceNo
		SAY ~I think... I think I need to hold it back as much as I can. I know it's not what you're tellin' me I should do, but I just... I can't give up like that. The Taint is a terrible thing and I just can't do it.~
		= ~Maybe nothing will happen before we resolve this whole mess. We can hope, right? Thanks for listening to me anyway, just that is enough to make me feel better.~
		IF ~~ THEN DO ~SetGlobal("IRTFightTaintCount","GLOBAL",1)~ EXIT
	END

	IF ~~ THEN EY1
		SAY ~(Imoen blows out a nervous breath.) Okay. When the time comes... you'll know.~
		IF ~~ THEN DO ~SetGlobal("IRTRavagerTurnCounter","GLOBAL",1)~ EXIT
	END

	IF ~~ THEN EY2
		SAY ~(Imoen's pent up tension falls through her breath.) Oh, thank the Gods. I was hoping you'd say that. The more I talked about it, the more scared I felt.~
		= ~I mean, sure, maybe it'll work out alright. But... it's dark down there with the Taint. You know it, and I know it. Who knows what might be unleashed if I just let go? I'll try to hold it in check until we get to the end of this mess, how about that? Maybe it'll all work out nicely in the end. We can hope, right?~
		= ~It's so nice of you to help me through this. What would I do without ya?~
		= ~Get bored out of my mind, that's what...~
		IF ~~ THEN DO ~SetGlobal("IRTCorruptImoen","GLOBAL",0)~ EXIT
	END

	// You've adviced Imoen to control the Taint
			
	IF ~~ THEN 101C
		SAY ~I tried to use it like you said to do, control it and direct it toward the enemy. I think it worked, somewhat. For a little while, I felt like the reins were in my hands.~
		= ~But when the fight was over, I was disappointed. Angry, even. For a moment, I found myself *this* close to snarling and jumping on your back, just to give the anger release. It was scary.~
		= ~How do you reel it back? How do you bottle it back up without letting it take over? I don't know if I can use this thing without it swallowing me...~
		++ ~You need to be aware at all times of where you end and where the Taint begins. It isn't easy. You are doing well, keep practicing.~ + 101C1
        	++ ~Let's find out. (You shove her shoulder.) The fight doesn't have to stop. Come on, show me what you can do.~ + 101C2
		
		++ ~If you feel that way, maybe you should fight the Taint for as long as you can, instead.~ + 101E4
		++ ~I don't care one way or another. Figure it out on your own.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + 101FuckOff
	END
		
	IF ~~ THEN 101C1
		SAY ~No easy answers, huh? I shoulda known.~
		= ~Does it at least get better, though? As in, does it ever become second nature to use the power without letting the Taint take over? 'Cuz if it doesn't... I don't even see the point in trying. I might as well fight it with everything I can.~
		++ ~It does. It only takes practice and a strong will. You've seen me become the Slayer and go back to normal as I please, haven't you?~ + 101C1a
		++ ~I'm afraid it doesn't. You will always have to struggle, Imoen. It's the price we have to pay.~ + 101C1a2
		++ ~It depends on how well you assert your dominance. Never let up. You must always remain in control.~ + 101C1c
	END
END

APPEND_EARLY BIMOEN25
	IF ~~ THEN 101C1a
		SAY ~Yeah... yeah, I have. But you couldn't control it for a good while. It's *that* stage that scares me the most. What if I'm not as strong as you? What if it takes over for good?~
		++ ~I didn't know what was happening at the time. You'll be different. If you do as I say, you'll be able to control it from the start.~ + 101C1a1
		++ ~That is a risk you need to take.~ + 101C1a2
		++ ~If you don't feel confident, maybe you should focus on fighting the Taint instead.~ + 101E4
	END
END

APPEND BIMOEN25
	IF ~~ THEN 101C1a1
		SAY ~You... you really think so? It's just so... terrifying. This whole thing. I'm scared out of my mind, <CHARNAME>.~
		= ~But that doesn't help anyone, does it. I need to suck it up and deal with it. Let me think for a while, okay? I need to sort it all out in my head. I'll get back to ya.~
		= ~Thank you so much for helping me deal with this.~
		IF ~~ THEN DO ~SetGlobal("IRTSlayerTurnLesson","GLOBAL",1)~ EXIT
	END

	/* IRTSlayerTurnLesson
	Imoen starts a conversation as soon as the party rests in the pocket plane. She will initiate the conversation further below, labeled "Teach me to control the Slayer"
	*/

	IF ~~ THEN 101C1a2
		SAY ~Really? I don't know... if it's like that, I think I'd much rather throw everything I've got into fighting this awful curse. If I hang on for long enough, maybe it will all work out by the time your all-important prophecy gets fulfilled.~
		= ~I mean... we can hope, right? Beats the good ol' "lie down and die" that so many other Bhaalspawn went for, at any rate.~
		= ~Thanks for helping me out with this, <CHARNAME>. I don't think I could deal with this nightmare without you.~
		IF ~~ THEN DO ~ SetGlobal("IRTCorruptImoen","GLOBAL",0)~ EXIT
	END

	IF ~~ THEN 101C1c
		SAY ~Yeah... like when you slipped in Spellhold. It wasn't pretty.~
		= ~You're much stronger than me, and still you couldn't control it for a good while. That's the scariest part; what if I try to control this thing, and it just beats me? What if it takes over for good?~	
		COPY_TRANS BIMOEN25 101C1a
	END

	IF ~~ THEN 101C2
		SAY ~(She staggers a step back and looks at you behind a frown.) Whoa, hey, what's your problem?~
		++ ~(Shove her again.) Come on! You said you were disappointed, but it doesn't have to end! Isn't this what you want? Go for it!~ + 101C2next
		++ ~Never mind. You are not ready.~ + 101E2notReady
		++ ~Alright, sorry about that. It was a misguided attempt at showing you the difference between your anger and Bhaal's.~ + 101E2sorry
	END

	IF ~~ THEN 101C2next
		SAY ~Hey, watch it! (She speaks through bared teeth. There's a wild spark in her eye.) Are you nuts? I don't really want to fight you!~
		++ ~(Keep harassing her, throwing calculated jabs that you know she'll dodge.) Whose anger is this, Imoen? Can you even tell? Do you want to go through your life without a grasp of your own emotions? Focus!~ + 101C2next2
		++ ~Never mind. You are clearly not ready for this.~ + 101E2notReady
		++ ~Alright, fine. Sorry about that. It was a misguided attempt at teaching you the difference between you and the Taint.~ + 101E2sorry
	END

	IF ~~ THEN 101C2next2
		SAY ~(Imoen dodges and deflects by instinct, your attacks providing hardly a challenge. She locks arms with you and stares. Her eyes are wide and her breath is ragged, far more than the exertion would warrant.)~
		= ~Stop it. Stop it, <CHARNAME>.~
		= ~You're right. You're right... I can't tell. I'm upset, like I should be upset, but also... there's so much *rage* right now. I can barely speak.~
		++ ~Look within yourself. Take *your* anger and embrace it as yours. Take the Taint's rage, and direct it elsewhere. You can't contain it, but you can *use* it.~ + 101C2next3
		++ ~The Taint is a parasite vying for dominance. It will only spread deeper if you try to suppress it, but it will consume you if you give it free rein. You must let it come out only on your own terms. The power is all in your hands.~ + 101C2next3
		++ ~Turn Bhaal's rage against him. Feed your own frustration into it. You exert control by making the Taint into a tool against evil.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",-1)~ + 101C2next3
	END

	IF ~~ THEN 101C2next3
		SAY ~(She breaks away and shuts her eyes, hands clenched into fists. Her features are contorted in a struggle against an unseen foe. A furious groan starts at the bottom of her throat, its deep undertones not entirely human.)~
		= ~(Suddenly Imoen raises her fist and smashes it into the ground. The force of the impact sends a cloud of debris drifting around her, pulverized material spreading out to leave a small crater around her hand.)~
		= ~(A dark, clawed hand.)~
		= ~(Imoen stares at it. Before her eyes it reverts to normal, tough hide and sharp edges morphing back to regular skin. Her face is a mixture of horror and awe.)~
		= ~Gods have mercy...~
		= ~(She looks at you and shakes her head.) This is too darn creepy.~
		++ ~It's the only way.~ + 101C2next4
		++ ~That was badass.~ + 101C2next4
		++ ~That was... concerning.~ + 101C2next4
	END
		
	IF ~~ THEN 101C2next4
		SAY ~(Imoen continues shaking her head as she walks past you.) I'd rather not think about this mess for a while. Let's just keep going, please.~
		IF ~~ THEN DO ~SetGlobal("IRTSlayerTurnLesson","GLOBAL",1)~ EXIT
	END

	// You've adviced Imoen to fight the taint	

	IF ~~ THEN 101F
		SAY ~And when the fight was over, I was disappointed. Angry, even. I tried to fight it, like you said - I asked myself, "whose anger is this?" and it clearly wasn't mine. I want to think that it helped, but... but I still was *this* close to snarling and jumping on your back, just to give the anger release. It was all very disturbing.~
		= ~Does it really matter, <CHARNAME>? Can I really do a damn thing? It feels like a disease. No matter how much I want it gone, this gross infection keeps eating at me from the inside.~
		++ ~The point isn't whether it works, Imoen. The important part is not giving up. Keeping true to yourself, no matter what. It's the only way the *real* you will survive.~ + 101F1
		++ ~I know it seems hopeless, but that's what this evil thing wants you to think. You are far stronger than the Taint, always remember that.~ + 101F2
		++ ~It's true, there isn't much you can do in the end. The best you can hope for is controlling it. Making use of it like any other tool.~ + 101F3
		++ ~You only have to hold on until we finish this. I'll be by your side every step of the way.~ + 101F4
		++ ~I don't care one way or another. Figure it out on your own.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + 101FuckOff
	END

	IF ~~ THEN 101F1
		SAY ~Oh. (Imoen blinks a few times.) Wow.~
		= ~I know that's meant to be inspiring, but honestly it's the most depressing thing you coulda said.~
		IF ~~ THEN GOTO 101F1next
	END

	IF ~~ THEN 101F1next
		SAY ~Actually, y'know what? I survived all the way to Baldur's Gate, and then I was imprisoned and tortured and driven mad by a psychopath for longer than I can even recall. I went to freakin' Hell and back, dammit, and I'm still here, stronger than I ever was.~
		= ~If this gross thing inside me thinks I'll just roll over and take it, well, it's sorely mistaken.~
		= ~Thanks for helping me deal with this, <CHARNAME>. I don't think I could get through it without you.~
		IF ~~ THEN DO ~SetGlobal("IRTFightTaintCount","GLOBAL",1)~ EXIT
	END

	/*
	IRTFightTaintCount: 
	This global goes up by 1 every time Imoen is in combat. When it reaches 5, the conversation below labeled "Imoen Resists the Slayer" happens right as combat ends.
	*/

	IF ~~ THEN 101F2
		SAY ~(She gives you a heartened smile.) Wow. Thanks a lot for that. I mean, I dunno if it's true, but, well, feels good all the same to hear it.~
		IF ~~ THEN GOTO 101F1next
	END

	IF ~~ THEN 101F3
		SAY ~What? No no no no no, I'm not in a thousand years touching it on purpose. It's like inviting madness into your house for a night. It's not gonna want to leave by morning.~
		= ~I mean, that might be what worked for you or whatnot but... no, there's no way. I'm fighting it until I drop.~
		IF ~~ THEN GOTO 101F1next
	END

	IF ~~ THEN 101F4
		SAY ~(She gives you a heartened smile.) I don't know what I'd do without your help, <CHARNAME>. I really don't. I wonder sometimes, ya know? How bad I'd have it if we'd parted ways for good. It's never a fun story to imagine.~
		= ~I'd probably have ended up just another poor sod in Saradush, trapped and hopeless. Even after everything I had to go through, I would never trade places with any of them.~
		IF ~~ THEN GOTO 101F1next
	END	

	IF ~~ THEN 101FuckOff
		SAY ~Yeesh, I just wanted a bit of advice! Ya know, from literally the *only* person that truly knows what's happening to me?~
		= ~But fine, whatever, fair enough. I'll just try to hold on 'til we get to the end of this. Maybe it will all magically go away then.~
		= ~Grumps...~
		IF ~~ THEN EXIT
	END
END



//  If you convince Imoen to give in, she will eventually turn into the Ravager during combat. After combat is over, depending on how hard you've tried to corrupt her, she will have one of two different attitudes about it.
// IRTCorruptImoen is 3 or lower: she is scared witless and will lose all Bhaal abilities to show her renewed efforts to never touch the Taint again
// IRTCorruptImoen is higher than 3: she will admit to have enjoyed it and will be able to become the uncontrollable Ravager at will once a day.

// About-to-turn dialogue:
APPEND IMOEN25J
 IF ~Global("IRTImoenRavagerTransformation","GLOBAL",1)~ THEN BEGIN AssTrans
	SAY ~I can't take this anymore! Everything wants to kill us wherever we go!~ [IRQUIET]
	= ~(There's a feverish look to Imoen's eyes.) You want to fight? I'll give you all a damn fight!~
	= ~(With a savage roar, Imoen charges forward with no regard for safety or tactics.)~ 
	IF ~~ THEN DO ~SetGlobal("IRTImoenRavagerTransformation","GLOBAL",2)~ EXIT
END
// Imoen fights until she's at half health. She will fight enemies first, then turn on the nearest party member. Once her health is at half or lower, she will fall unconscious until combat ends. When combat ends, she will initiate the following dialogue:

// After Ravager Turn


	IF  ~Global("IRTImoenRavagerTransformation","GLOBAL",5)~ THEN BEGIN Ass1
		SAY ~(Back in her human form, Imoen stirs and sits up, holding her head in her hands.)~ [IRQUIET]
		IF ~GlobalGT("IRTCorruptImoen","GLOBAL",3)~ THEN DO ~SetGlobal("IRTImoenRavagerTransformation","GLOBAL",6) SetGlobal("IRTImoenIsRavager","GLOBAL",1)~ GOTO AssYes
		IF ~!GlobalGT("IRTCorruptImoen","GLOBAL",3)~ THEN DO ~SetGlobal("IRTImoenRavagerTransformation","GLOBAL",6) SetGlobal("IRTCorruptImoen","GLOBAL",0)~ GOTO AssNo
	END
END 

CHAIN IMOEN25J AssYes
	~Unngh. I didn't expect... *that*.~
	== AERIE25J IF ~IsValidForPartyDialog("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~I knew it was a terrible idea. I should have been more forceful about it. Please don't give in to the monster again, Imoen.~
	== AERIE25J IF ~IsValidForPartyDialog("Aerie") !GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~That was terrifying. Are you alright, Imoen?~
	== JAHEI25J IF ~IsValidForPartyDialog("Jaheira")~ THEN ~Are you well, my friend? I feared we had lost you for good.~
	== VICON25J IF ~IsValidForPartyDialog("Viconia")~ THEN ~Become a monster to fight the monsters. It is only natural.~
	== MINSC25J IF ~IsValidForPartyDialog("Minsc")~ THEN ~This is, uh... confusing. Is our friend evil now? No, it couldn't be!~
	== SAREV25J IF ~IsValidForPartyDialog("Sarevok")~ THEN ~What a disgrace. What good is raw strength without the will to control it? This is what happens when you tread lightly with Bhaal's power.~
	== KELDO25J IF ~IsValidForPartyDialog("Keldorn")~ THEN ~Don't succumb to your curse, Imoen. It will be a dark day indeed if there comes a time when I am forced to raise my sword against you.~
	== EDWIN25J IF ~IsValidForPartyDialog("Edwin")~ THEN ~A warning would have been welcome, foolish girl. Your inability to control your power is an embarrassment to us all.~
	== ANOME25J IF ~IsValidForPartyDialog("Anomen")~ THEN ~That foul Taint will corrupt even the most innocent. I shall not hesitate to fight you if you turn against us, child.~
	==IMOEN25J  IF ~IsValidForPartyDialog("Imoen2")~ THEN ~That was...~
	==IMOEN25J  IF ~IsValidForPartyDialog("Imoen2")~ THEN ~That felt good. It felt... REALLY good.~
END IMOEN25J AssYesR

APPEND IMOEN25J
	IF ~~ THEN AssYesR
		SAY ~Which is probably bad. But I can't say I care about that at this very moment.~
		++ ~About time you came into your own. Don't be ashamed of our nature.~ + AssYes1
		++ ~What was that? That was *not* the Slayer.~ + AssYes2
		++ ~Well done, Imoen. You are fulfilling your true potential.~ + AssYes1
		++ ~Are you even aware of what just happened? This was all a terrible idea and I wish I hadn't set you on this path.~ + AssYes3
	END
		
	IF ~~ THEN AssYes1
		SAY ~Pfah. I can't buy into that, are you kidding? What just happened is horrible, I know that, but I just couldn't take it anymore. And now all that pent up anger and hatred and bloodlust, it's gone. It's all gone. I haven't felt this good since... since before Athkatla.~
		= ~Not like it matters, how I feel about it. Like you said, I can't escape any of it. Resisting is pointless, so if the price of release is turning into a death-machine for five minutes now and then... so be it. I'm sick of fighting inside my head.~
		IF ~~ THEN GOTO AssYesEnd
	END

	IF ~~ THEN AssYes2
		SAY ~Bhaal has more than one avatar. That was... whatever is inside me.~
		= ~Don't ask me how I know. I just *know*.~
		++ ~Interesting. About time you came into your own. Don't be ashamed of our nature.~ + AssYes1
		++ ~I see. At last you are fulfilling your true potential.~ + AssYes1
		++ ~That was awful. I did this to you. I wish I hadn't set you on this path.~ + AssYes3
	END

	IF ~~ THEN AssYes3
		SAY ~Are you kidding? I haven't felt this good in ages. All that pent up anger and hatred and bloodlust... it's gone. It's all gone.~
		= ~Yeah, okay, the gruesome violence is really gross and scary, but honestly I can't muster the will to care anymore. I can't escape any of it. Like you said, resisting is pointless, so if the price of release is turning into a death-machine for five minutes now and then... so be it. I'm sick of fighting inside my head.~
		IF ~~ THEN GOTO AssYesEnd
	END

	IF ~~ THEN AssYesEnd
		SAY ~I know the relief is only temporary. It's all gonna come back to haunt me again. When that happens... just point me in their general direction and I'll let loose.~
		IF ~~ THEN EXIT
	END 	
END
/*

From here on out, Imoen can turn into the Ravager once a day. It's an uncontrollable instant polymorph as described above
*/

CHAIN IMOEN25J AssNo
	~No... no no no no... (She looks up at you. Horror is clear in her features.) <CHARNAME>... what have I done?~
	= ~I'm a monster. Is that really what's inside me? Is that what happens when I give up control?~
	== AERIE25J IF ~IsValidForPartyDialog("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~I knew it was a terrible idea. I should have been more forceful about it.~
	== AERIE25J IF ~IsValidForPartyDialog("Aerie") !GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~That was terrifying. Are you alright, Imoen?~
	== JAHEI25J IF ~IsValidForPartyDialog("Jaheira")~ THEN ~Are you well, my friend? I feared we had lost you for good.~
	== VICON25J IF ~IsValidForPartyDialog("Viconia")~ THEN ~Become a monster to fight the monsters. It is only natural.~
	== MINSC25J IF ~IsValidForPartyDialog("Minsc")~ THEN ~This is, uh... confusing. Is our friend evil now? No, it couldn't be!~
	== SAREV25J IF ~IsValidForPartyDialog("Sarevok")~ THEN ~What a disgrace. What good is raw strength without the will to control it?~
	== KELDO25J IF ~IsValidForPartyDialog("Keldorn")~ THEN ~Don't succumb to your curse, Imoen. It will be a dark day indeed if there comes a time when I am forced to raise my sword against you.~
	== EDWIN25J IF ~IsValidForPartyDialog("Edwin")~ THEN ~Your inability to control your power is an embarrassment to us all.~
	== ANOME25J IF ~IsValidForPartyDialog("Anomen")~ THEN ~That foul Taint will corrupt even the most innocent. I shall not hesitate to fight you if you turn against us, child.~
END IMOEN25J AssNoR

APPEND IMOEN25J
	IF ~~ THEN AssNoR
		SAY ~I'm a monster...~
		++ ~About time you accepted it. Don't be ashamed of our nature.~ + AssNo1
		++ ~What was that? That was *not* the Slayer.~ + AssNo2
		++ ~Finally. Now you see what happens. *Now* you have the motivation to fight the Taint so this never happens again.~ + AssNo3
		++ ~Excellent. Well done, Imoen. At last you've reached your full potential.~ + AssNo4
	END
		
	IF ~~ THEN AssNo1
		SAY ~Accept it? NO! I don't EVER want to let that happen again! I could've stopped it, I absolutely could have, but you told me to give in, so I did. I can't believe I let you talk me into it. I must've been so desperate...~
		IF ~~ THEN GOTO AssNoBreakup
	END

	IF ~~ THEN AssNoBreakup
		SAY ~Why didn't you tell me it was like that? Locked away, screaming and wailing without a mouth, watching yourself *do* things to people. No, no, no, *never* again.~
		= ~But no, you control it, don't you? I don't know what's worse. You turn into the Slayer on purpose! You need to be messed up in the head to make yourself into that thing. Now that I know what it's *really* like... (She is shaking her head, regarding you with appalled disgust.) I can't get it out of my head.~
		= ~I can't even look at you right now. I don't want to touch anyone, ever again. All this Bhaal stuff is awful and I want it gone and I'd rather kill myself than let it take over.~
		= ~Hopefully this will all be over before I need to resort to that.~
		IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTNeverForgive","GLOBAL",1)~ EXIT
	END
		
	IF ~~ THEN AssNo2
		SAY ~It was the monster inside me. It doesn't like to share.~
		++ ~At least now you've accepted it. Don't be ashamed of our nature.~ + AssNo1
		++ ~I'm sorry, then, that must have been worse than I anticipated. But now you've finally seen what happens. *Now* you have the motivation you need to never let the Taint take over.~ + AssNo3
		++ ~I see. Well, that was incredible. You have reached your full potential.~ + AssNo4
	END

	IF ~~ THEN AssNo3
		SAY ~(Imoen takes a moment to respond, slowly coming out of her horrified haze.)~
		= ~Wait...~
		= ~What?~
		= ~It was... everything you said, it was a ploy to...~
		= ~(She trails off and stays silent for a while. A frown knits her brow, not necessarily hostile.)~
		= ~Well, it worked. That was horrible. Locked away, screaming and wailing without a mouth, watching myself *do* things to people. No, never, *ever* again.~
		= ~All this Bhaal stuff is awful and I want it gone. I'd rather kill myself than let it take over.~
		= ~So... yeah. Thanks, I guess. Hopefully this will all be over before I need to resort to that.~
		IF ~~ THEN EXIT
	END	

	IF ~~ THEN AssNo4
		SAY ~My full potential? Are you insane? That thing wasn't me! It wasn't ANYTHING like me! I can't believe I let you talk me into this. I could've stopped it, I absolutely could have, but you told me to give in, so I did. I was so desperate for relief...~
		IF ~~ THEN GOTO AssNoBreakup
	END
END

/*
Teach me to control the Slayer:
This conversation happens if you've convinced Imoen to control her Bhaal powers. She will approach you the next time you rest in the pocket plane
*/

CHAIN IF WEIGHT #0 ~Global("IRTSlayerTurnLesson","GLOBAL",2)~ THEN IMOEN25J SCon
	~(Imoen approaches you as you set your things down for the day. There is a grim set to her jaw.)~ [IRQUIET] DO ~SetGlobal("IRTSlayerTurnLesson","GLOBAL",3)~
	= ~Hey. I've been thinking of everything you've said about dealing with the Taint. I think you're right. I better get ahead of this thing and learn to work with it before we get a nasty surprise at the worst of times.~
END IMOEN25J SConR

APPEND IMOEN25J
	IF ~~ THEN SConR
		SAY ~I was hoping... maybe you could help me do that? Right now?~
		++ ~Sure. I'm glad you listened.~ + SCon1
		++ ~It's good that you feel this way, but I have no idea how to teach such a thing. You have to sort it out yourself.~ + SCon2
		++ ~I'm exhausted, Imoen. I can't do this right now.~ + SCon3
		++ ~I've actually changed my mind about that. You should fight the Taint as hard as you can.~ + SCon4
		++ ~I've actually changed my mind about that. You should simply give in to the Taint.~ + SCon5
	END

	IF ~~ THEN SCon1
		SAY ~(She smirks mirthlessly.) Not spoiled for choices exactly, am I? I either do this or become Surprise Monster at some point. I'd rather not take that risk. I could get everyone killed if I lose control at the wrong time.~
		= ~I mostly just wanted you to sit with me and make sure I don't do anything stupid or... violent. I'm gonna try and tap into that gross pool of power down there and... I don't know. Do what I can, I guess. (Her mouth purses in a resigned frown.) Ideally, push myself to become the Slayer before it shows up on its own.~
		= ~That sound like a good idea to ya?~
		++ ~It's your best option. I'll help any way I can.~ + SCon2Yes
		++ ~No, in fact. When you put it that way, I don't think you should do it at all.~ + SCon4
		++ ~I'll be honest with you, I'm far too exhausted to do this. I just want to rest.~ + SCon3
		++ ~I feel you have to do this on your own, by yourself. There is no other way.~ + SCon2No
	END

	IF ~~ THEN SCon2
		SAY ~Oh, well, I was hoping... I dunno, maybe you could just sit with me? To make sure I don't do anything stupid or... violent. I'm gonna try and tap into that gross pool of power down there and... I don't know. Do what I can, I guess. Ideally, push myself to become the Slayer before it shows up on its own.~
		= ~(Imoen's mouth is pursed in a resigned frown.)~
		++ ~Alright. I can do that.~ + SCon2Yes
		++ ~I'm exhausted, Imoen. I only want to rest.~ + SCon3
		++ ~You must do it on your own. There is no other way.~ + SCon2No
	END

	IF ~~ THEN SCon2Yes
		SAY ~Alright, then. Let's get it over with.~
		IF ~~ THEN DO ~StartCutSceneMode() StartCutScene("IRBhaal1")~ EXIT
	END

	// Small cutscene: fade to black, moves Imoen and the player to the center of the Pocket Plane while every other party member gets moved out of the frame (by the fate spirit?) fade from black, Imoen starts dialogue, State "SConMain"

	IF ~~ THEN SCon2No
		SAY ~Well, I'm too afraid to do it on my own, so that's not gonna happen. I'll remind ya this was *your* idea, by the way.~
		= ~Y'know what, I'll just keep trying to shove Bhaal out of my thoughts like usual. Maybe if I hang on long enough, everything will magically resolve itself. We can hope, right?~
		= ~Rest easy.~
		IF ~~ THEN DO ~SetGlobal("IRTControlTaint","GLOBAL",0) SetGlobal("IRTCorruptImoen","GLOBAL",0) RestParty()~ EXIT
	END
		
	IF ~~ THEN SCon3
		SAY ~Oh. Well, then... okay. Never mind, I suppose. I wasn't looking forward to this whole mess at all.~
		= ~I'll just keep trying to shove Bhaal out of my thoughts, like usual. Maybe if I hang on long enough, everything will magically resolve itself. We can hope, right?~
		= ~Rest easy.~
		IF ~~ THEN DO ~SetGlobal("IRTControlTaint","GLOBAL",0) SetGlobal("IRTCorruptImoen","GLOBAL",0) RestParty()~ EXIT
	END

	IF ~~ THEN SCon4
		SAY ~(She startles and blinks profusely. A perplexed smile curves her lips.) Really? You think so? I have no problems with that at all!~
		= ~That's such a relief, I'd just figured this was the only way. The prospect of trying to become the frikkin' Slayer on purpose was just *awful*.~
		= ~Well, then... never mind, I suppose. I'll keep trying to shove Bhaal out of my thoughts, like usual. Maybe I just need to hang on long enough. We can hope, right?~
		= ~Phew.~
		IF ~~ THEN DO ~SetGlobal("IRTControlTaint","GLOBAL",0) SetGlobal("IRTCorruptImoen","GLOBAL",0) RestParty()~ EXIT
	END	
		
	IF ~~ THEN SCon5
		SAY ~(She startles and blinks profusely.) Are you serious? Did you lose your mind? There's no way I'm doin' that. The *whole point* of what I'm saying is so I don't do that.~
		= ~Well, then... never mind, I suppose. I'll just keep trying to shove Bhaal out of my thoughts.~
		= ~Jeez.~
		IF ~~ THEN DO ~SetGlobal("IRTControlTaint","GLOBAL",0) SetGlobal("IRTCorruptImoen","GLOBAL",0) RestParty()~ EXIT
	END

	IF WEIGHT #0 ~Global("IRTSlayerTurnLesson","GLOBAL",4)~ THEN SConMain
		SAY ~(After all the routine camp preparations are done, you and Imoen sit on a blanket, facing one another.)~ [IRQUIET]
		IF ~~ THEN DO ~SetGlobal("IRTSlayerTurnLesson","GLOBAL",5)~ GOTO SConMainR
	END

	IF ~~ THEN SConMainR
		SAY ~So... here goes. I'm gonna touch that same spark that lets me heal wounds like magic. And then I'm gonna sink into it, so to speak. Any tips?~
		++ ~Exert an iron will from the start. Nothing but complete dominance will do.~ + SConM1
		++ ~Let yourself drift and become a vessel for the Taint. You must wait until the right moment to strike and take the reins.~ + SConM2
		++ ~Dealing with the Slayer is a bargaining process. You wield its power, but you must give a part of you in exchange. The key is making the right deal.~ + SConM3
		++ ~The Slayer will whisk you away to the astral plane and challenge you to a sweetroll eating contest. You must wolf down those sweetrolls like your life depends on it. Because it does.~ + SConM4
		++ ~You will know best what to do. I'm only here in case something goes wrong.~ + SConM5
	END

	IF ~~ THEN SConM1
		SAY ~Complete dominance. Got it.~
		IF ~~ THEN GOTO SConMainNext
	END

	IF ~~ THEN SConM2
		SAY ~Strike at the right moment. Got it.~
		IF ~~ THEN GOTO SConMainNext
	END
		
	IF ~~ THEN SConM3
		SAY ~(She makes a face of disgust.) Lookin' forward to it already.~
		IF ~~ THEN GOTO SConMainNext
	END

	IF ~~ THEN SConM4
		SAY ~(Imoen laughs and smacks your knee.) You goon, you had me up until "sweetroll eating contest". This is serious business, c'mon! Gimme some good advice or shut yer trap.~
		++ ~Okay, fine. Exert an iron will from the start. Nothing but complete dominance will do.~ + SConM1
		++ ~Let yourself drift and become a vessel for the Taint. You must wait until the right moment to strike and take the reins.~ + SConM2
		++ ~Dealing with the Slayer is a bargaining process. You wield its power, but you must give a part of you in exchange. The key is making the right deal.~ + SConM3
		++ ~It *was* good advice. I know what I'm talking about here.~ + SConM4a
		++ ~I wish I had something for you, but you will know best what to do.~ + SConM5
	END

	IF ~~ THEN SConM4a
		SAY ~Yeah, alright, whatever you say. But I'll be askin' you to make up for it if there are no sweetrolls comin' up.~
		IF ~~ THEN GOTO SConMainNext
	END

	IF ~~ THEN SConM5
		SAY ~Alright. Fair enough.~
		IF ~~ THEN GOTO SConMainNext
	END

	IF ~~ THEN SConMainNext
		SAY ~Wish me luck. (Sitting cross-legged in front of you, Imoen closes her eyes. After a little while her breathing has deepened, her features settling on a serene expression.)~
		= ~(For quite some time nothing happens. She remains nearly motionless, hands on her bare knees, shirt-clad chest slowly rising and falling. The magical transformation never rent your gear after it was done, but apparently she didn't want to take any chances with her expensive equipment.)~
		= ~(Her mouth twitches, then her brow. Gradually her features draw up into mild strain.)~
		= ~I can feel it. It's... unwilling. I think it knows what I'm trying to do.~
		= ~This is so weird, like I'm talking to something inside me.~
		++ ~*Make it* willing. You are the master.~ + SConMainN1
		++ ~Pretend to surrender, then counter when it strikes.~ + SConMainN1
		++ ~It's all part of your own self. It will come forward, for a price.~ + SConMainN1
		++ ~(Remain silent.)~ + SConMainN1
	END

	IF ~~ THEN SConMainN1
		SAY ~(Imoen goes quiet. She seems to be making a conscious effort to remain calm. Her breathing becomes louder, but remains slow and deep; hands that had begun to clench return to a relaxed languor.)~
		= ~(Eddies of mist start peeling off her skin like steam off a tempering blade, curling all around her in a mystical halo. A low hum rumbles in your chest, spreading from her center in a circle around her.)~
		= ~(She opens her eyes and looks straight at you. They've become solid pools of darkness.)~
		= ~Death follows in our wake, <PRO_BROTHERSISTER>. My soul will become as black as yours.~
		= ~(Before you can respond, Imoen's head lulls back, and she collapses to one side.)~
		++ ~Imoen! (Rush to check her vitals.)~ + SConCheck
		++ ~Imoen? Are you alright?~ + SConNext2
		++ ~Well, that was creepy. I'll have nightmares for days now, thanks.~ + SConNext2
		++ ~(Let events unfold as they may.)~ + SConNext2
	END

	IF ~~ THEN SConCheck
		SAY ~(Her pulse rushes under your probing fingers. Imoen is breathing just fine. Upon lifting her eyelids, you verify that her pupils have returned to normal.)~
		IF ~~ THEN GOTO SConNext2
	END

	IF ~~ THEN SConNext2
		SAY ~(Imoen stirs and lets out a groan. With some effort she gets off the floor and back to a sitting position, hands holding her head at the temples.)~
		= ~Unnngh. Gross. (She looks up at you, and her eyes are as blue as they've ever been.) I feel so gross...~
		++ ~What just happened?~ + SCFinal1
		++ ~Are you alright?~ + SCFinal2
		++ ~That was it? How did it go?~ + SCFinal3
		++ ~Are you an avatar of death and destruction now?~ + SCFinal4
		++ ~At least it's over now.~ + SCFinal5
	END

	IF ~~ THEN SCFinal1
		SAY ~The worst time of my life, that's what just happened. Worse than the torture and everything else. I've never felt so... (Imoen shudders in utter repulsion.)~
		IF ~~ THEN GOTO SCFinalN
	END

	IF ~~ THEN SCFinal2
		SAY ~No. No, I'm not alright. That was nasty. I've never felt so... (Imoen shudders in utter repulsion.)~
		IF ~~ THEN GOTO SCFinalN
	END

	IF ~~ THEN SCFinal3
		SAY ~I... it went well, I suppose? Got what I was going for. But I've never felt so... (Imoen shudders in utter repulsion.)~
		IF ~~ THEN GOTO SCFinalN
	END

	IF ~~ THEN SCFinal4
		SAY ~(Imoen shakes her head, apparently not in the mood to be amused by your levity.)~
		= ~I've never felt so... (She shudders in utter repulsion.)~
		IF ~~ THEN GOTO SCFinalN
	END

	IF ~~ THEN SCFinal5
		SAY ~I... don't know about that. Feels like it just now started for real. I've never felt so... (Imoen shudders in utter repulsion.)~
		IF ~~ THEN GOTO SCFinalN
	END

	IF ~~ THEN SCFinalN
		SAY ~I... communed with that thing. That's the best way I got to describe it. I want to think I tricked it. I'm pretty sure it thinks it tricked me.~
		= ~One way or another... I can become the Slayer now. Without losing my marbles, just like you. Don't ask me how I know. I just *know*.~
		= ~(She rubs her brow and eyelids forcefully. Suddenly Imoen looks like a mourner at a vigil.) I feel like I've been awake for the last three days, now. I need to get to sleep.~
		= ~Here's as good as anywhere. (She crawls to a ball on top of the blanket.) Thanks for... being there.~
		= ~(Imoen's features become lax in barely a moment. She is already softly not-quite-snoring. Whatever it was that happened, it appears to have taken a steep toll.)~
		++ ~(Carry her to a proper bed.)~ + SCFinalEnd1
		++ ~(Leave her where she is.)~ + SCFinalEnd2
		++ ~(Curl up next to her and join her slumber.)~ + SCFinalEnd3
	END

	IF ~~ THEN SCFinalEnd1
		SAY ~(She doesn't stir even one bit as you lift her listless body, take her to the spot she'd already prepared and tuck her into her bedroll.)~
		IF ~~ THEN DO ~SetGlobal("IRTImoenControlsSlayer","GLOBAL",1)  RestParty()~ EXIT
	END

	IF ~~ THEN SCFinalEnd2
		SAY ~(With an indifferent shrug, you get up and go get your own rest.)~
		IF ~~ THEN DO ~SetGlobal("IRTImoenControlsSlayer","GLOBAL",1) RestParty()~ EXIT
	END

	IF ~~ THEN SCFinalEnd3
		SAY ~(Just like she said, here's as good as anywhere. She will probably appreciate the familiar presence once she wakes up.)~
		IF ~~ THEN DO ~SetGlobal("IRTImoenControlsSlayer","GLOBAL",1) RestParty()~ EXIT
	END
END
	

/*
Imoen Resists the Slayer
this conversation happens as combat ends if you've encouraged Imoen to fight the taint.
 Give Imoen +1 Constitution just as the dialogue ends
*/

APPEND IMOEN25J
	IF WEIGHT #0 ~Global("IRTResistTheSlayer","GLOBAL",1)~ THEN SRes
		SAY ~(As combat ends Imoen remains in place, eyes squeezed shut. She's hunched over and her fingers are digging into her thighs.)~ [IRQUIET]
		IF ~~ THEN DO ~SetGlobal("IRTResistTheSlayer","GLOBAL",2)~ GOTO SResR
	END

	IF ~~ THEN SResR
		SAY ~No. No, no, no, I will not give in. Leave me alone, you son of a half-brained goat.~
		++ ~Are you alright?~ + SRes1
		++ ~Be strong, Imoen. You can do it.~ + SRes1
		++ ~Who are you talking to?~ + SRes1
		++ ~It wasn't even a real fight. You're having trouble now?~ + SRes2
		++ ~(Remain silent.)~ + SRes3
	END

	IF ~~ THEN SRes1
		SAY ~(Imoen pries one eye open. Her lips are pressed together, her brow is creased with worry and strain.)~
		= ~<CHARNAME>... (She reaches out with one hand, palm down.)~
		++ ~(Approach and hold her hand.)~ + SRes1a
		++ ~You don't need me. You are stronger than anyone I know. Remain in control, Imoen.~ + SRes1b
		++ ~Pull yourself together already. It's embarrassing.~ + SRes1c
	END
END 

CHAIN IMOEN25J SRes1a
	~(Her fingers close on yours fiercely, pulling your closer. Through your bond you feel her muscles trembling, as if spring-loaded with pent-up aggression. It would seem that she remains motionless for fear that she might unwind irreparably.)~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",5)~
	= ~(After several deep breaths her stance begins to uncoil, tension gradually leaving her grip. It takes her a while longer to finally open her eyes.)~
	== IMOEN25J IF ~Global("ImoenRomanceActive","GLOBAL",2)~ THEN ~<CHARNAME>. (Gazing into your eyes, Imoen brings your hand to her lips and lovingly kisses our fingers.) Thank you. That helped.~
	== IMOEN25J IF ~!Global("ImoenRomanceActive","GLOBAL",2)~ THEN ~<CHARNAME>. (Awkwardly glancing at you, she lets go of your hand with a relieved smile.) Thank you. That helped.~
END IMOEN25J SResE

APPEND IMOEN25J
	IF ~~ THEN SResE
		SAY ~Stupid Taint. That felt like... an ambush. Like the damn thing was waiting for the right moment. It's been leaving me alone lately, so I let my guard down. And then, boom, all at once, pushing me to keep fighting, to attack someone, to let it take over and do who-knows-what. I was so close, <CHARNAME>. So close.~
		= ~But I made it through. That felt like the worst it could do, and I made it through. (She smiles.) Gives me hope.~
		++ ~I've always had confidence in your resilience, Imoen.~ + SResE1
		+ ~Global("ImoenRomanceActive","GLOBAL",2)~ + ~(Bring her into a loving hug.) We'll beat this together, like we always have.~ + SResE2
		+ ~!Global("ImoenRomanceActive","GLOBAL",2)~ + ~(Bring her into a comforting hug.) We'll make it to the end together, like we always have.~ + SResE3
		++ ~You made it through this time. Don't let your guard down ever again.~ + SResE4
		++ ~You talk about it like it's a parasite, but it's only another part of us. Maybe understanding that will help you in the future.~ + SResE5
	END

	IF ~~ THEN SResE1
		SAY ~Hah. I can always count on ya to prop up my ego. I'm determined to see this thing through to the end, that's for sure. The filthy stain of some dead god isn't gonna stop me.~
		= ~I'll be okay. Hopefully. Let's just keep going.~
		IF ~~ THEN  EXIT
	END

	IF ~~ THEN SResE2
		SAY ~(Imoen sinks into your embrace, breathing in deep. She squeezes you with comforting familiarity.)~
		= ~Like we always have. (She lifts her head and kisses your lips, smiling.) I love you, <CHARNAME>. No dead god can take that away from me.~
		= ~Now let's get going before more idiots show up trying to kill us.~
		IF ~~ THEN  EXIT
	END

	IF ~~ THEN SResE3
		SAY ~(Imoen chuckles and squeezes you tight, welcoming your gesture with sincere appreciation.)~
		= ~Yep. Like we always have. It's kinda crazy we've made it this far, isn't it?~
		= ~Anyway, let's get going now, before more idiots show up trying to kill us.~
		IF ~~ THEN EXIT
	END

	IF ~~ THEN SResE4
		SAY ~Boy, did I just learn my lesson. But it's hard to be on edge all the time, ya know? Does some bad stuff to yer head, makes ya paranoid. Not that you wouldn't know about that.~
		= ~Anyway, I should be okay. Hopefully. We better get going before more idiots show up trying to kill us.~
		IF ~~ THEN EXIT
	END

	IF ~~ THEN SResE5
		SAY ~Hm. I dunno. I think I'd rather not consider it a part of me at all, regardless of whatever the Hell it actually is.~
		= ~Yer probably right, though, since it was still there even after Irenicus took our souls.~
		= ~(Imoen shrugs.) One way or another, I won't make the same mistake again. We better get going now, before more idiots show up trying to kill us.~
		IF ~~ THEN EXIT
	END
		
	IF ~~ THEN SRes1b
		SAY ~(Both her hands clench into fists. Her muscles tremble, as if spring-loaded with pent-up aggression. It would seem that she remains motionless for fear that she might unwind irreparably.)~
		= ~(After several deep breaths her stance begins to uncoil, tension gradually leaving her body. It takes her a while longer to finally open her eyes.)~
		= ~(She glances at you and blows out an unsteady breath.) That was upsetting.~
		IF ~~ THEN GOTO SResE
	END
		
	IF ~~ THEN SRes1c
		SAY ~(Both her hands clench into fists. Her muscles tremble, as if spring-loaded with pent-up aggression. It would seem that she remains motionless for fear that she might unwind irreparably.)~
		= ~(After several deep breaths her stance begins to uncoil, tension gradually leaving her body. It takes her a while longer to finally open her eyes.)~
		= ~(She glances at you and blows out an unsteady breath.) You jackass...~
		= ~(Imoen shakes her head, rolls her eyes and gets back to usual business.)~
		IF ~~ THEN DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-10) ~ EXIT
	END	

	IF ~~ THEN SRes2
		SAY ~(Imoen pries one eye open. Her lips are pressed together, her brow is creased with worry and strain.)~
		= ~I don't make the damn rules. I don't *know* the damn rules... (Speaking through gritted teeth, Imoen reaches out with one hand, palm down.)~
		++ ~(Approach and hold her hand.)~ + SRes1a
		++ ~You don't need me. You are stronger than anyone I know. Remain in control, Imoen.~ + SRes1b
		++ ~Pull yourself together already. It's embarrassing.~ + SRes1c
	END

	IF ~~ THEN SRes3
		SAY ~I hate you... I hate you, I hate you, I hate you...~
		= ~(Her brow creases with worry and strain, her lips are pressed together. A few beads of sweat run down her temples.)~
		IF ~~ THEN GOTO SRes1b
	END
END


// After these happen, the player gets a new PID option in Imoen's "Can I ask you a question?" menu:
// PID options:
/*
+ ~Global("IRTResistTheSlayer","GLOBAL",2) Global("IRTResistTheSlayerQ","GLOBAL",0)~ + ~You've been dealing with the Taint for quite some time. How are you holding up?~ DO ~SetGlobal("IRTResistTheSlayerQ","GLOBAL",1) IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + HowResist
+ ~Global("IRTImoenControlsSlayer","GLOBAL",1) Global("IRTImoenControlsSlayerQ","GLOBAL",0)~ + ~How is it for you to become the Slayer?~ DO ~SetGlobal("IRTImoenControlSlayerQ","GLOBAL",1) IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + HowSlay 
+ ~Global("IRTImoenIsRavager","GLOBAL",1) Global("IRTImoenIsRavagerQ","GLOBAL",0)~ + ~How is it to become the Ravager?~ DO ~SetGlobal("IRTImoenIsRavagerQ","GLOBAL",1) IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + HowAss 
*/

 