// This is Imoen's Bracelet Mini quest.

BEGIN ~IRTSoren~
BEGIN ~IRTXag~


// Part 1: Imoen inquires about the bracelet in Saradush
//// She initiates conversation with Lazarus after completion of the spellbook quest, right after the player is done talking to him.
// Only happens if Imoen has the bracelet, d'uh


CHAIN IF ~Global("IRTLazarusBracelet","GLOBAL",1)~ THEN IMOEN25J Notice
	~Oh hey, if there's someone that would know, it'd be you. Got a moment, Mr. Librarus?~ [ IRQUIET ]
	== 25SPELL ~But of course, Lady Imoen. How may I assist you?~ DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",2)~
	== IMOEN25J ~Well, I've been tryin' to figure out this bracelet. Maybe you can read this stuff?~
	= ~(Imoen slips the artifact off her wrist and hands it to Lazarus Librarus.)~
	== 25SPELL ~(The wizened man handles the artifact with care, examining its surface with mounting interest.)~
	= ~Hmmm.~
	== IMOEN25J ~Yeah? You got something?~
	== 25SPELL ~Well, I can say that it presents some rather interesting contradictions.~
	== IMOEN25J ~Contradictions? Whaddya mean?~
	== 25SPELL ~Yes, yes indeed. The engravings are ostensibly Tanar'ri, and yet its powerful aura is nothing if not benevolent. Most curious. Where did you acquire it, if I may ask?~
	== IMOEN25J ~Um. Some merchant in Amn. It was very definitely purchased with money, no doubt about that.~
	= ~Tanar'ri, though? That's... evil, isn't it? Literally demonic.~
	== 25SPELL ~Yes, but only the script appears to be so. The rest...~
	= ~May I copy these patterns? It will only take a minute.~
	==IMOEN25J ~S- sure, sure. Go ahead.~ 
	DO ~ StartCutSceneMode() StartCutScene("BracCut1") ~ 
EXIT

////  Cutscene: A standard fast fade to black and back to color.

CHAIN IF ~Global("IRTLazarusBracelet","GLOBAL",2)~ THEN IMOEN25J Notice2
    ~Well?~
	== 25SPELL ~Yes. I am quite certain many of these are actual words. I will have a translation, with enough study.~
	== IMOEN25J ~Hey, that's great! How long 'til, ya think?~ 
	== 25SPELL ~Oh, quite some time, regrettably. This siege isn't particularly conducive to fruitful research. The simple act of finding the proper tome for this might take days.~
	== IMOEN25J ~Aw. Phooey.~
	= ~Well... let us know when yer done, I guess.~
	== 25SPELL ~Absolutely. Safe travels, Lady Imoen, <PRO_LADYLORD> <CHARNAME>.~
	== IMOEN25J ~See ya!~
	DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",3)~
EXIT



// Part 2: Reunion in Amkethran.


CHAIN IF  ~Global("IRTLazarusBracelet","GLOBAL",4)~ THEN IMOEN25J NoDo
	~Oh, hey, Mr. L! Done with that translation we talked about?~ [ IRQUIET ] DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",5) SetGlobalTimer("IRTLazarusBraceletTimer","GLOBAL",TWO_DAYS)~
	== 25SPELL ~Ah, the bracelet, yes! I am not done entirely, but I have gleaned some meaning from the inscription. You might find it of interest.~
	== IMOEN25J ~Well, yeah. D'uh.~
	== 25SPELL ~Yes, good. In short, it appears to be elaborate sigaldry aimed at imprisonment. There is much hatred in these words - much cursing, rather crude insults both against all celestial beings and one specific name.~
	== IMOEN25J ~Huh. A name?~
	== 25SPELL ~I can't translate it easily. The closest phonetic approximation I have is "Sorenthanaris".~
	= ~So, these findings lead me to conclude-~
	== IMOEN25J ~Oh, don't tell me. (Imoen is looking at her wrist, lips drawn down in disillusionment.) There's an angel trapped in here, isn't there.~
	== 25SPELL ~Y- yes, yes. That is my conclusion. Or, rather, this bracelet is both key and lock to an extraplanar pocket dimension. Are you perhaps familiar with the planes beyond the prime material?~
	== IMOEN25J ~Well, we travel through a nifty pocket-plane and have our very own Solar as tourist guide, so... yeah, you could say as much.~
	== 25SPELL ~But of course you would. I forget whom I speak to. In any case, this being is probably a Deva, if I had to venture a guess. Higher beings would require much stronger enchantments.~
	== IMOEN25J ~Ogh, it just figures, wearing an angel's prison on my wrist all this time! The poor thing, I feel terrible now. This is why we can't have nice things.~
	= ~So, um... what now? Please tell me you've a way to free this guy. Or gal. Or... gosh, I don't even know how they work.~
	== 25SPELL ~My research is very much incomplete. I need further study to determine what can be done. Now that I've finally set up the shop, I should have some quiet time to dedicate to this issue. I would urge you to return in a few days.~
	== IMOEN25J ~Aww, but of course you'd say that.~
END IMOEN25J NoDoR

APPEND IMOEN25J
IF ~~ THEN NoDoR
	SAY ~(Imoen holds up her wrist and yells into it.) Don't worry, Bob! We'll getcha out of there!~
	++ ~We'll be back in a few days, then.~ + NoDoYes
	++ ~No, I don't think so. We can't afford to lose this piece of equipment. Maybe once we're no longer in danger.~ + NoDo3
	++ ~I've had my fill of angels. If this Deva was stupid enough to get itself trapped, it probably deserved it.~ + NoDo2
	++ ~You don't know what this creature might do. It could have gone insane. We won't risk it.~ + NoDo1
END

IF ~~ NoDo1
   SAY ~Aw, c'mon! These angel-types are all sorts of resilient. It'll probably be grateful! It'll probably gives us candy!~
   ++ ~No, Imoen. I'm sorry.~ + NoDoNo
   ++ ~Alright, fine. It's not like we couldn't handle it, if it comes down to a fight.~ + NoDoYes
   ++ ~We'll wait and see what Lazarus finds out, I suppose.~ + NoDoYes
   ++ ~It's not happening, and that's it.~ + NoDoNo
END

IF ~~ NoDoNo
   SAY ~But... but...~
   = ~Fine, jeez! But just so you know, I'm *absolutely* gonna go for it as soon as we settle the Bhaal issue. So there.~
   IF ~~ THEN DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",20)~ EXIT //break and stop entire quest
END

IF ~~ NoDoYes
   SAY ~All right! Can't wait to see what happens.~
   IF ~~ THEN EXIT
END

IF ~~ NoDo2
   SAY ~Aw, c'mon. I got trapped myself, remember? Don't think I deserved it, either. It's the nice thing to do, <CHARNAME>. Can we please try? Please?~
   ++ ~No, Imoen. I'm sorry.~ + NoDoNo
   ++ ~Alright, fine. Can't argue with that point.~ + NoDoYes
   ++ ~We'll wait and see what Lazarus finds out, I suppose.~ + NoDoYes
   ++ ~It's not happening, and that's it.~ + NoDoNo
END

IF ~~ NoDo3
   SAY ~Aw, c'mon, we're all kinds of mighty already! And b'sides, it'll probably be grateful and bestow some crazy good reward. It'll probably gives us candy!~
   ++ ~No, Imoen. I'm sorry.~ + NoDoNo
   ++ ~Alright, fine. I'm sure I can find something else for you to wear.~ + NoDoYes
   ++ ~We'll wait and see what Lazarus finds out, I suppose.~ + NoDoYes
   ++ ~It's not happening, and that's it.~ + NoDoNo
END
END



// Part 3: Returing to Lazarus
////  Triggers if you enter Lazarus's shop with Global("IRTLazarusBracelet","GLOBAL",5) and GlobalTimerExpired("IRTLazarusBraceletTimer","GLOBAL")

CHAIN IF  ~Global("IRTLazarusBracelet","GLOBAL",6)~ THEN IMOEN25J Done
	~Mr. L! Been over two days now. Got somethin' for us?~
	== 25SPELL ~Why, yes! Yes indeed. Though maybe not what you expect, it is my hope that it will prove useful.~
	== IMOEN25J ~Aw. Not a way to free Bob, then?~
	== 25SPELL ~I'm afraid not. Judging by the inscriptions, the enchantments upon the prison function more like a curse. Only a particular circumstance or item will break them. What this item or circumstance might be, I do not know. It doesn't say.~
	= ~However... there might be a way to find out. Through the Deva itself.~
	== IMOEN25J ~Oh! You mean... you mean I could maybe talk to Bob? How?~
	== 25SPELL ~Ah, yes, excellent question! My research, you see. (Lazarus gestures at a rolled-up parchment on his desk.)~
	= ~I have modified a Freedom spell to affect certain properties of the artifact. If my theories are correct, the spell will allow the entrapped Deva a modicum of autonomy for the duration.~
	== IMOEN25J ~Really? Wow. You must've been workin' on this non-stop.~
	== 25SPELL ~It's such a fascinating puzzle! And even if it weren't, I owe my livelihood to your efforts. I was lost without my spellbook.~
	= ~The spell is ready right now, if you would like to use it.~
END IMOEN25J DoneR

APPEND IMOEN25J 
IF ~~ THEN DoneR
	SAY ~Oh boy! This is so exciting. We got some time, right <CHARNAME>?~
   ++ ~Yes, of course. I'm quite curious myself.~ + Done3
   ++ ~I suppose. Try to hurry it up.~ + Done3
   ++ ~No, not right now. We will come back later.~ + Done2
   ++ ~I'm fed up of all this nonsense. I don't want to hear about this issue ever again.~ + Done1
END
END

CHAIN IMOEN25J Done1
	~Aw, but... but...~
	= ~Fine, jeez! But I'm *so* coming back by myself as soon as we settle the Bhaal issue.~
	= ~Sourpuss...~ DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",20)~ //some value that wont ever be triggered
EXIT

CHAIN IMOEN25J Done2
~Aww, I suppose that's alright...~
= ~You'll save the spell for us, right Mr. L?~
== 25SPELL ~Of course. I will eagerly await your return.~ DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",7)~
== IMOEN25J ~Hope's not too long 'til then...~
EXIT


//// Add to the bottom of Lazarus's standard Amkethran greeting
EXTEND_BOTTOM 25SPELL 1
+ ~Global("IRTLazarusBracelet","GLOBAL",7)  OR(2)PartyHasItem("MRIMRIN1") HasItemEquiped("MRIMRIN1","Imoen2")~ + ~Let's see to this bracelet business.~ + Bracelet
END

CHAIN 25SPELL Bracelet
~Yes, of course. I have the spell right here.~
END IMOEN25J Done3

CHAIN IMOEN25J Done3
	~(Imoen picks up the scroll and tentatively rolls it open.)~
	= ~Huh. I expected it to be longer.~
	== 25SPELL ~It is just as long as it needs to be, Lady Imoen.~
	== IMOEN25J ~So do I just... y'know, do it?~
	== 25SPELL ~You may want to place the artifact on the desk first. It seems safer that way.~
	== IMOEN25J ~Yeah. Yeah, makes sense.~
	= ~Alrighty then. Here goes nothing.~
DO ~StartCutSceneMode() StartCutScene("BracCut2") ~
EXIT

////   Camera pans to center on Imoen while Imoen displays the casting animation for the same spell school as Freedom (the spell used to cancel Imprisonment). A few seconds after she finishes casting, a blue wisp materializes in front of her.

CHAIN IF  ~Global("IRTLazarusBracelet","GLOBAL",9)~ THEN IRTSoren BobTalk
	~(A faint blue shimmer has come to life atop the bracelet. It glows and quivers with increasing strength.)~
	== IMOEN25J ~B- bob? Is... is that you?~
	== IRTSoren ~(The shimmer seems to react to Imoen's words, as if focusing its attention toward her voice. Slowly its contours and edges drift toward a face-like silhouette.)~
	= ~Can you... hear me?~
	== IMOEN25J ~Yes! Well, just barely, but yeah!~
	== IRTSoren ~It has been so long...~
	= ~(The silhouette resolves into well-defined features. High cheekbones, tilted eyes, windswept hair. All shades of blue.)~
	== IMOEN25J ~Um... hiya. My name's Imoen.~
	== IRTSoren ~Imoen. I know you, Imoen. You may call me Sorenthis.~
	= ~I have sensed your presence often. I have tried to assist you. Even if this is all the freedom I get to experience, I will never forget this kindness.~
	== IMOEN25J ~Freedom's what we're working on. Time's a bit short, though. What happened to you? How'd you get in there?~
	== IRTSoren ~I will be brief, then. It was the demon Xaglaroth, my nemesis. He deceived me, outsmarted me. I pay for my mistakes, my brashness.~
	== IMOEN25J ~Oh. So how do we get ya out? There's gotta be away.~
	== IRTSoren ~His blood upon the inscribed sigils. Only then will Calcen be shattered.~
	== IMOEN25J ~Uh, okay. Calcen is... the bracelet?~
	== IRTSoren ~My prison. My torment.~
	== IMOEN25J ~So... where do we find this guy?~
	== IRTSoren ~Through Calcen my nemesis and I share a soul-bond. At all times I've known his whereabouts, his abhorrent deeds. He now resides in Ghtorax, a sub-realm within the Abyss.~
	== IMOEN25J ~Oh, just another trip into Hell, then. Easy-peasy, been there done that. We've a trans-dimensional pocket-plane, maybe we could travel through it somehow...~
END IRTSoren BobTalkR

APPEND IRTSoren
IF ~~ THEN BobTalkR
	SAY ~This limited freedom you have provided allows me to open a portal there. With your help, the soul-bond he created to taunt me for eternity shall be Xaglaroth's undoing.~
   ++ ~We will help you, Sorenthis. Open the portal. I only wish we had known earlier.~ EXTERN IMOEN25J BobTalk4
   ++ ~How dangerous is this? We can't carelessly march to our deaths, no matter how noble the cause.~ EXTERN IMOEN25J BobTalk3
   ++ ~Not so fast. I won't risk my neck going into a Hellish dimension just to have a valuable magic item destroyed.~ EXTERN IMOEN25J BobTalk1
   ++ ~We don't have time for this. I'm sorry, but we cannot help you.~ EXTERN IMOEN25J BobTalk2
   ++ ~What's in it for us?~ EXTERN IMOEN25J BobTalk1
END
END

APPEND IMOEN25J
IF ~~ THEN BobTalk1
	SAY ~Gee, <CHARNAME>. Way to be classy in front of our new angel friend.~
	IF ~~ THEN EXTERN IRTSoren BobTalk1R
END
END

APPEND IRTSoren
IF ~~ THEN BobTalk1R
	SAY ~Should you do this for me, I would be eternally grateful. I would remain in your service for as long as you live. Imoen would need only call out to me, be it with words or thought.~
   ++ ~That is acceptable. Open that portal. Let's get this done.~ EXTERN IMOEN25J BobTalkHaggle
   ++ ~That doesn't sound worth the trouble. Forget about it.~ EXTERN IMOEN25J BobTalkNo
END
END

CHAIN IMOEN25J BobTalkHaggle
~Always gotta haggle for the best deal...~
END IRTSoren BobTalkYes

CHAIN IMOEN25J BobTalk2
	~What? Oh, c'mon! This is, like, routine stuff! Some random stranger walks up to us with this problem and we'd be all over it.~
	== IRTSoren ~Should you do this for me, I would be eternally grateful. I would remain in your service for as long as you live. Imoen would need only call out to me, be it with words or thought.~
	== IMOEN25J ~See? Rewards! I know we're busy an' all, but... we've done things not nearly as worthy - and while workin' to get our souls back, no less. Besides, I can't be wearing this thing anymore. Now it feels like it's made from the bones of children or something...~
END
   ++ ~There is simply no time. The answer is still no.~ EXTERN IMOEN25J BobTalkNo
   ++ ~It's not worth the trouble. Forget about it.~ EXTERN IMOEN25J BobTalkNo
   ++ ~Fine, we'll get it done, and quickly at that. Open that portal.~ EXTERN IMOEN25J BobTalkQuick

CHAIN IMOEN25J BobTalkQuick
	~Yes! Drop in sword and sorcery blazing, trash the place and drop out. Easy stuff!~
END IRTSoren BobTalkYes

CHAIN IMOEN25J BobTalk3
	~Really? By now this kinda stuff sounds a bit pedestrian, honestly. Doubt we'll even break a sweat.~
	== IRTSoren ~Xaglaroth would destroy most mortals with nary an effort, but you are no ordinary mortal. Just like I would be no match for your skills, neither could he pose a credible threat.~
END
   ++ ~Ah. In that case, we will help you, Sorenthis. Open that portal.~ EXTERN IMOEN25J BobTalk4
   ++ ~No, I don't think so. I won't risk my neck going into a Hellish dimension just to have a valuable magic item destroyed.~ EXTERN IMOEN25J BobTalk1
   ++ ~We don't have time for this. I'm sorry, but we cannot help you.~ EXTERN IMOEN25J BobTalk2
   ++ ~I see. And what's in it for us?~ EXTERN IMOEN25J BobTalk1

CHAIN IMOEN25J BobTalk4
	~Hah! <CHARNAME> delivers the goods again. I knew I could count on ya.~
END IRTSoren BobTalkYes

CHAIN IMOEN25J BobTalkNo
	~But... but...~
	== IRTSoren ~It is your prerogative to refuse, God-child. I suffer the consequences of my mistakes. They are my burden alone.~
	== IMOEN25J ~That's a load of crap. Don't you worry about a thing, I'll help you as soon as <CHARNAME>'s all-important mission is over. By myself, if I have to.~
	== IRTSoren ~I harbor nothing but gratitude toward you both. The memory of this moment of freedom shall be savored for years to come.~
	== IMOEN25J ~Not so long, hopefully...~
	== IRTSoren ~I wish you good fortune, Bhaalspawn. Farewell.~
DO ~StartCutSceneMode() StartCutScene("BracCut3")~ EXIT

//// Cutscene: the apparition vanishes . Dialogue restarts with Imoen

CHAIN IF WEIGHT #200 ~Global("IRTLazarusBracelet","GLOBAL",19)~ THEN IMOEN25J BobTalkBad
	~I get your reasons, but... that was rotten all the same, <CHARNAME>.~ DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",20) IncrementGlobal("IRTLoveMeter","GLOBAL",-7)~
	== 25SPELL ~I must admit, that was... anticlimactic.~
	== IMOEN25J ~Can't get mad, though. I know what's important. C'mon, we're apparently in a big hurry.~
EXIT

CHAIN IRTSoren BobTalkYes
	~Excellent. Thank you, Children of the Gods. I will be overjoyed to follow your command, should you succeed.~
	= ~A word of warning: Xaglaroth is cunning. If he becomes aware of his impending demise, he will no doubt offer you a deal. Beware the folly of a demon's bargain, my friends.~
DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",10) StartCutSceneMode() StartCutScene("BracCut4")~
EXIT

//// Cutscene: After some flashy spell effects, a swirling portal is created right at the wall.
// Sorenthis displays the following string above his head:
// "You need only walk through the wall. Xaglaroth awaits." (all without the quotes)
// Imoen walks over to the desk, displays the following string:
// "Can't forget to take this thing..."
// The Player walks toward the portal, then it cuts to the Demon's lair. A suitable area could be recycled, like a chunk of the hell trials or the planar sphere area where you face the fat winged demon. 
// After a few seconds, the following string displays over the player's head:
// "Suffocating heat engulfs you as soon as you step through the portal. The air here reeks of sulfur and rot, forcing you to take shallow breaths. The sky, drawn in and oppressive, is a solid sheet of black."
// Imoen starts conversation:

CHAIN IF  ~Global("IRTLazarusBracelet","GLOBAL",11)~ THEN IMOEN25J LairIntro
	~Oh Gods. This is awful.~ [ IRQUIET ]
	== NALIA25J IF ~IsValidForPartyDialog("Nalia")~ THEN ~Another day, another trip through a hellish landscape.~
	== JAHEI25J IF ~IsValidForPartyDialog("Jaheira")~ THEN ~Let us be done quickly. I doubt we could survive here for long.~
	== AERIE25J IF ~IsValidForPartyDialog("Aerie")~ THEN ~Yuck. This place is foul through and through.~
	== EDWIN25J IF ~IsValidForPartyDialog("Edwin")~ THEN ~Yes, marvelous. Here we are again, risking our necks in Hell itself on a fool's errand. Bravo, <CHARNAME>, bravo.~
	== SAREV25J IF ~IsValidForPartyDialog("Sarevok")~ THEN ~I had hoped never to return to the wilder Abyss. Let's dispatch this demon and be done with it.~
	== KORGA25J IF ~IsValidForPartyDialog("Korgan")~ THEN ~<CHARNAME>, ye fool <PRO_RACE>! Another daft quest we don't be havin' the time for. Pfeh!~
	== IMOEN25J ~(Imoen is covering her nose and mouth with one hand, features cringed as if she just swallowed a bug.)~
   = ~C'mon, we better hurry before I hark breakfast, lunch and dinner all together. This guy must be somewhere nearby.~
   DO ~SetGlobal("IRTLazarusBracelet","GLOBAL",12) StartCutSceneMode() StartCutScene("BraCut4b")~
EXIT


/*


Xaglaroth uses one of the gross demon models in the game. He starts dialogue as soon as he comes into view of a visible character. He has three different starting dialogues, depending on how the player approached. If the player managed to destroy Xaglaroth before he could initiate dialogue, Imoen begins dialogue as soon as combat is over as if you picked the violent path in conversation.

If Xaglaroth turns enemy at any point, any surviving imps turn hostile. The fight is pretty standard demon stuff, just like any that has been summoned through a Gate. If you feel like it, go ahead and get creative with him casting some spells or having special abilities. It feels right that he should focus on Imoen, too. Don't make it too hard, however; he is pleading for his life because he knows he can't beat you, after all.

*/


APPEND IRTXag
IF ~Global("IRTBraceletXag","GLOBAL",1)~ Xag1
   SAY ~Ah, the intruders. Calcen warned me of your coming. Stay your hand, fleshlings. I would speak to you.~
   IF ~~ THEN DO ~SetGlobal("IRTBraceletXag","GLOBAL",2)~ GOTO XagStay
END


// Convergence

IF ~~ XagStay
   SAY ~You bring violence in your intent. I am no fool, fleshlings. If I were to engage you in battle, I would succumb to your might, as many have before. I wish to resolve this... (The hulking beast seems to shudder) ... peacefully.~
   = ~Thus I propose... a bargain. A price for my life. Power for the bearer of Calcen, and wealth to assist your journey. I would grant both, immediately. In exchange, you leave without bloodshed.~
   ++ ~There is no peace for one such as you! Die, foul demon! (Attack.)~ + XagViolence
   ++ ~Hmm. What kind of power, and how much wealth?~ EXTERN IMOEN25J XagHey
   ++ ~I cannot leave Sorenthis imprisoned, demon.~ + XagHiss
   ++ ~Easiest deal I ever made. I accept.~ EXTERN IMOEN25J XagWhat
   ++ ~You must think me stupid, if you think I'd make a deal with a demon. I refuse. Prepare yourself.~ + XagNo
END

IF ~~ XagViolence
   SAY ~So be it, fool! I will feast on your bones!~
   IF ~~ THEN DO ~Enemy()~ EXIT
END
END

CHAIN IRTXag XagHiss
	~(The demon lets out a crackling hiss at the mention of the Deva.)~
	= ~Yes... Sorenthis. Why should the fool's fate concern you? Consider the wealth I can offer, fleshling. Magic will become effortless to the bearer of Calcen. Thousands of coins would further fatten your purse. Is it not tempting?~
	== IMOEN25J ~What a waste of breath. We want nothing from gross demons like you. Let's get this over with, <CHARNAME>.~
	== IRTXag ~Righteousness will be your undoing. Consider my offer. It could be the difference between victory and defeat.~
END
	++ ~If I were to accept, what would happen to Sorenthis?~ EXTERN IRTXag XagExplain
	++ ~Absolutely not. Prepare yourself, creature.~ EXTERN IRTXag XagNo
	++ ~I see your point. I accept this deal, demon.~ EXTERN IMOEN25J XagWhat

APPEND IRTXag
IF ~~ XagExplain
   SAY ~Ah, a delightful question. Calcen is but a prison. I can empower it to become a conduit that would harvest the Celestial and infuse the wearer with its energy. The drain would eventually exhaust the Foul one, many, many delectable eons from now.~
   = ~The wearer would gain untold prowess at magicking, increased strength and resilience, faster reflexes. Are these boons not worth the price someone *else* must pay?~
   ++ ~Absolutely not. Prepare yourself, creature.~ + XagNo
   ++ ~I see your point. I accept this deal, demon.~ EXTERN IMOEN25J XagWhat
END

IF ~~ XagNo
   SAY ~No, wait! Stay your hand awhile longer. What if I were to... (the demon shudders once more) ... free the Deva, and still grant you wealth?~
   = ~Thirty thousand of your gold pieces to buy my life.~
   ++ ~And what exactly stops me from collecting this wealth from your rotting carcass?~ + XagNo1
   ++ ~That is reasonable. I didn't want to fight, anyway.~ + XagSpared
   ++ ~Make it fifty thousand, and then I'll consider it.~ + XagNo2
   ++ ~I think I would rather destroy you. (Attack.)~ + XagViolence
END

IF ~~ XagNo1
   SAY ~(The demon's growl is like the sound of grinding stones.) You could not. I do not carry Prime Material currency on me, fleshling. My hoard can be accessed by my will alone.~
   ++ ~So be it, then. I will spare you. I didn't want to fight, anyway.~ + XagSpared
   ++ ~A hoard? Then make it fifty thousand, and I'll consider sparing you.~ + XagNo2
   ++ ~It doesn't matter. I'd rather destroy you. (Attack.)~ + XagViolence
END

IF ~~ XagNo2
   SAY ~Thirty thousand is the extent of my hoard in Prime Material coin, <PRO_RACE>. You will have every piece.~
   ++ ~So be it, then. I will spare you. I didn't want to fight, anyway.~ + XagSpared
   ++ ~Not enough. It's time for you to die. (Attack.)~ + XagViolence
END
END

CHAIN IMOEN25J XagHey
	~Whoa, what? You can't be seriously considering this!~
	== IRTXag ~Ahh, yes, is it not tempting? I would empower the prison to become an irreparable vise, a harvesting conduit, transferring the Foul One's power to the bearer. Magic will become effortless, spells will happen faster, and the capacity to memorize them will increase. It would augment strength and resilience both, as well as grant faster reflexes. The effects would last for eons, until the Foul One withers in delectable decay.~
	= ~As for wealth, thirty thousand coins would further fatten your purse. You would need only say the word, and allow the empowerment of Calcen to happen.~
END
	++ ~If I were to accept, what would happen to Sorenthis?~ EXTERN IRTXag XagExplain
	++ ~Absolutely not. Prepare yourself, creature.~ EXTERN IRTXag XagNo
	++ ~I see your point. I accept this deal, demon.~ EXTERN IMOEN25J XagWhat

CHAIN IMOEN25J XagWhat
	~What? No! What are you doing? The whole point of coming here was to free our new angel friend!~
	== IRTXag ~Do you not crave power, human? Do you not wish to assist your leader? With this boon you will become <PRO_HISHER> greatest asset. The price is not yours to pay.~
	== IMOEN25J ~Don't talk to me, you filthy thing! The price is my conscience! <CHARNAME>, *please*, you can't be serious!~
END
	++ ~We all make sacrifices, Imoen. We need every advantage. This is my decision.~ + XagWhat2
	++ ~Be quiet. You do not tell me what I can and cannot do. Give him the bracelet, now.~ + XagCommand
	++ ~Imoen, you must understand. I am as disgusted as you are, but we *need* this.~ + XagWhat2
	++ ~You owe nothing to this Deva, and neither do I. Why not benefit from the situation as much as we can?~ + XagWhat1
	++ ~Alright, fine. No deal, Demon. Prepare yourself.~ EXTERN IRTXag XagNo

APPEND IMOEN25J
IF ~~ XagWhat1
   SAY ~W... why? You're really asking me why? I'm not going to torture an angel for eternity just so I can have more power, and much less make a deal with a demon to make it happen! Who knows how this thing is going to trick us, if you let it? It's nuts to even-~
   IF ~~ THEN EXTERN IRTXag XagWhatLast
END

IF ~~ XagWhat2
   SAY ~What are you saying? We don't need it, we really don't! We'd have never known about this deal if we hadn't set out to free Sorenthis in the first place. This is crazy, there's no way I'm going to torture an angel for eternity just so I can have more power, and much less make a deal with a demon to make it happen. Who knows how this thing is going to trick us, if you let it? It's nuts to even-~
   IF ~~ THEN EXTERN IRTXag XagWhatLast
END

IF ~~ XagWhatHypocrite
   SAY ~Well... yes, exactly that. I don't agree with some of the things you do, but they've always been your call. This was *my* call, we're here because of me, and it's a *good* thing. If you turn around and ruin it like this... you're betraying me.~
   = ~I trusted you, and you're betraying me.~
   ++ ~So be it. My decision is final. Give him the bracelet, now.~ + XagCommand
   ++ ~(Shake your head.) Some day you will understand why this is happening. For now, do as I say and give him the bracelet.~ + XagCommand
   ++ ~That's too bad. I'm taking this deal. I must have *all* the power.~ + XagCommand
   ++ ~Oh. I hadn't thought of it that way. I'd never betray you, Imoen. No deal, demon. Prepare yourself.~ EXTERN IRTXag XagNo
END
END

CHAIN IRTXag XagWhatLast
	~There is no trickery, I assure you. I know when I have been bested. Your power already surpasses mine; let me empower you further.~
	== IMOEN25J ~I *swear*, if you interrupt me again, I'll make your head explode.~
	== IMOEN25J IF ~Global("ImoenRomanceActive","GLOBAL",2)~ THEN ~Please, <CHARNAME>. Think about what you're doing. We don't need any of this guy's crap. And I... I can't love someone that would do this...~
	== IMOEN25J IF ~Global("ImoenRomanceActive","GLOBAL",4)~ THEN ~Please, <CHARNAME>. Think about what you're doing. We don't need any of this guy's crap. And I... I can't be friends with someone that would do this...~
	== IMOEN25J ~Let's do what we set out to do, please.~
END
	++ ~No. My decision is final and the deal is happening. Give him the bracelet, now.~ EXTERN IMOEN25J XagCommand
	++ ~(Shake your head.) Some day you will understand. For now, do as I say and give him the bracelet.~ EXTERN IMOEN25J XagCommand
	++ ~That sounded like a threat. I don't respond well to ultimatums. I'm taking this deal.~ EXTERN IMOEN25J XagCommand
	++ ~You've seen me do much worse and said nothing, but now that it affects *you* suddenly you're too good for me?~ EXTERN IMOEN25J XagWhatHypocrite
	++ ~Fine, you've convinced me. No deal, Demon. Prepare yourself.~ EXTERN IRTXag XagNo


CHAIN IMOEN25J XagCommand
	~(For a moment Imoen simply stares. Her eyes transition from disbelief, to disappointment, to anger.)~
	= ~I can't believe this.~
	= ~(She bows her head, disgust and frustration clear in her features. She tosses the bracelet at Xaglaroth's misshapen feet. The trinket clangs against the rocky floor and slides to a stop before the demon.)~
	= ~You and I are done, <CHARNAME>.~ DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) SetGlobal("IRTNeverForgive","GLOBAL",1)~
	== IRTXag ~(Xaglaroth lashes out and picks up the bracelet, lightning-quick. Intense satisfaction radiates from the monster.)~
	= ~You will not regret your choice, mighty <CHARNAME>.~
	DO ~SetGlobal("IRTBraceletCorrupted","GLOBAL",1) StartCutSceneMode() StartCutScene("BracCut5")~
EXIT

//// cutscene empower bracelet
CHAIN IF ~Global("IRTBraceletCorrupted","GLOBAL",1)~ THEN IRTXag XagCorruptedEnd
	~It is done. Upon you I bestow my dark favor. Let us now part... (Xaglaroth hisses and growls) ... without violence.~
	= ~(You feel the demon's foul influence on the bracelet as soon as it touches your hand. What was once a benevolent aura is now a tyrannous choke, like a slaver's sense of dark satisfaction as he cracks his whip. Calcen feels heavy in your hand, much heavier than it looks.)~
	== IMOEN25J ~I can't believe this happened. I'm not ever touching that thing.~
	= ~You're disgusting, <CHARNAME>.~
	== IRTXag ~Farewell, primals.~
	DO ~ SetGlobal("IRTBraceletCorrupted","GLOBAL",2)~
END
    ++ ~Good. Nothing stops me from killing you now, fool.~ + XagWTF
	++ ~A pleasure doing business with you.~ DO ~StartCutSceneMode() StartCutScene("BraCut10") ~ EXIT
	++ ~This better be worth the trouble, demon.~ DO ~StartCutSceneMode() StartCutScene("BraCut10") ~ EXIT
	++ ~(Leave without a word.)~ DO ~StartCutSceneMode() StartCutScene("BraCut10")~ EXIT

APPEND IRTXag
IF ~~ XagWTF
   SAY ~Filthy <PRO_RACE>! You have locked Sorenthis away, the way out is gone! You can't go back without my help!~
   ++ ~Hm. Fine, then. Farewell, demon.~ DO ~StartCutSceneMode() StartCutScene("BraCut10")~ EXIT
   ++ ~I'm just messing with you, Xag. Stay classy.~ DO ~StartCutSceneMode() StartCutScene("BraCut10") ~ EXIT
END
END

CHAIN IRTXag XagSpared
	~(Xaglaroth's mouth clicks and crackles unpleasantly.) It is agreed. Bring Calcen to me.~
	== IMOEN25J ~Yeugh. Are you *sure* you wanna let this thing live? It's a demon! It does evil, terrible things. Is the money really worth it?~
END
	++ ~No, it really isn't. Prepare yourself, demon. It's time to destroy you.~ EXTERN IRTXag XagViolence
	++ ~It's the non-violent solution, Imoen. I thought you'd appreciate that.~ EXTERN IMOEN25J XagSpared1
	++ ~You're so bloodthirsty. I like it. You heard the lady, filthy creature.~ DO ~IncrementGlobal("IRTCorruptImoen","GLOBAL",1)~ EXTERN IRTXag XagViolence
	++ ~I'm just being pragmatic. This is the best deal available.~ EXTERN IMOEN25J XagSpared2
	++ ~(Shrug.) I don't care one way or another. Up to you, Imoen.~ EXTERN IMOEN25J XagSpared3

CHAIN IMOEN25J XagSpared1
	~Huh. Well, y-yeah, I... I guess? Can't feel too good about it when we're sparing this gross, evil... thing.~
END IMOEN25J XagGiveCalcen

CHAIN IMOEN25J XagSpared2
	~Yeah, except for all the people's lives he'll ruin, or whatever creatures this guy goes after...~
END IMOEN25J XagGiveCalcen

CHAIN IMOEN25J XagSpared3
	~Oh yeah? Then I say we do what we came here to do. It's a demon, the world will be better off.~
END IRTXag XagViolence

CHAIN IMOEN25J XagGiveCalcen
	~Fine, whatever, at least we got what we came for. Let's do this thing, you ugly mutton-lover. Come over here. (Imoen steps forth.)~
	== IRTXag ~You need only give me the artifact, mighty sorceress. I shall spill my blood upon it.~
	== IMOEN25J ~Haha, ya think I'm stupid? I'm not letting go of this thing. (Imoen unsheathes a small dagger from her sleeve.) I don't mind getting my hands dirty.~
	= ~Now, stand still and let me do the work. One suspicious move and you *will* blow up. My contingency spells are pretty sensitive, y'see.~ DO ~SetGlobal("IRTXagSparedCutscene","GLOBAL",1)
	StartCutSceneMode() StartCutScene("BracCut7") ~ 
EXIT


CHAIN IF ~Global("IRTXagSparedCutscene","GLOBAL",1)~ THEN IRTSoren BobFreeXag1
	~Freedom! Freedom at last!~ DO ~SetGlobal("IRTXagSparedCutscene","GLOBAL",2)~
	== IMOEN25J ~Ha! I know the feeling, bud.~
	== IRTSoren ~Yet... Xaglaroth still lives.~
	== IRTXag ~(The demon hisses with hatred, coiling as if ready to attack. Then he visibly restrains himself.)~
	= ~Foul One. I bested you once. I shall do it again, in time.~
	== IMOEN25J ~Shut up and give us our money, Cuddles.~
END IRTXag XagCont


/*
Cutscene: The way out opens and the party walks toward it.
Fade to black.
Fade from black back in Lazarus's shop.
Sorenthis starts the end-of-event dialogue with Imoen, below.
*/

APPEND IRTXag

IF ~~ XagCont
 SAY  ~Yes, the bargain.~
	=~ (Xaglaroth throws a small bag at your feet. Its glossy surface glows with runed enchantments.)~ 
	= ~The deed is done. Leave now and never come back.~
	++ ~A pleasure doing business with you.~ DO ~StartCutSceneMode() StartCutScene("BracCut6")~ EXIT
	++ ~Stay out of mortal affairs, or I will be back for you, demon.~ DO ~StartCutSceneMode() StartCutScene("BracCut6")~ EXIT
	++ ~(Leave without a word.)~ DO ~StartCutSceneMode() StartCutScene("BracCut6")~ EXIT
END

IF ~~ XagWTF2
   SAY ~Filthy <PRO_RACE>! I shall feast on your bones!~
   IF ~~ THEN DO ~Enemy()~ EXIT
END
END

/***************************************************/


/*
This next cutscene happens as soon as the Demon Xaglaroth is dead, Sorenthis is still trapped, Imoen is still alive and combat has ended.
*/

CHAIN IF ~Global("IRTXagKilled","GLOBAL",1) Global("IRTXagImoenDead","GLOBAL",0)~ THEN IRTSoren BobFreeNoXag1
	~Freedom! Freedom at last!~ DO ~ SetGlobal("IRTXagKilled","GLOBAL",2) SetGlobal("IRTSorenReturnPrompt","GLOBAL",1)~
	== IMOEN25J ~Ha! I know the feeling, bud.~
	== IRTSoren ~And there lies Xaglaroth. A pity I could not deal the final blow myself. You have amended my mistakes, good friends. I shall repay this debt until the day you die your final death.~
	== IMOEN25J ~Aw, jeez, that sounds kinda depressing, actually. But how about we get outta here? The smell's gonna cling to my clothes for years to come...~
	  == IRTSoren ~Of course. The Prime Material plane awaits. Talk to me when you are ready~
EXIT

//DOES NOT EXECUTE
//current problem where we cant get rid of the bracelet because when imoen dies its left on the ground
//if we ever figure out a good way to get rid of it then we can get this to run
CHAIN IF ~Global("IRTXagKilled","GLOBAL",1) Global("IRTXagImoenDead","GLOBAL",1)~ THEN IMOEN25J BobImDead
   ~(Imoen takes in a sudden gasp, eyes flying open as her wounds close and heal in barely a moment. After a series of deep breaths, she focuses on the angel.)~  DO ~ SetGlobal("IRTSorenReturnPrompt","GLOBAL",1)  SetGlobal("IRTXagKilled","GLOBAL",2)~
   = ~Hah... totally worth it...~
   == IRTSoren ~Rest easy, my friend. It will take you a moment to recover.~
   == IMOEN25J ~Aw, I'll... I'll be alright... in no time.~
   == IRTSoren ~You gave your life for me, Imoen of Candlekeep. I am yours to command until the day you die your final death.~
   == IMOEN25J ~Yeah... so you said already. Help me up?~
   == IRTSoren ~Of course. The Prime Material plane awaits. Talk to me when you are ready~
EXIT

//DOES NOT EXECUTE
//current problem where we cant get rid of the bracelet because when imoen dies its left on the ground
//if we ever figure out a good way to get rid of it then we can get this to run
APPEND IRTSoren
	IF ~Global("IRTSorenReturnPrompt","GLOBAL",1)~ BobFinalExit
	SAY ~Are you ready to depart?~
	++ ~Let's go.~ DO ~ SetGlobal("IRTSorenReturnPrompt","GLOBAL",2) StartCutSceneMode() StartCutScene("BracCut6")~ EXIT
	++ ~Wait, I forgot something.~ EXIT
	END
END 


/*
Cutscene: The way out opens as described before and the party walks toward it.
Fade to black.
Fade from black back in Lazarus's shop.
Sorenthis starts the end-of-event dialogue with Imoen, below.
*/


/*
 The End of Event talk with Sorenthis happens as soon as the cutscene to get back to Lazarus's Shop is over.
In case Sorenthis wasn't freed, Lazarus starts a conversation instead as soon as you show up in his shop.
*/

CHAIN IF ~Global("IRTBobEndOfEvent","GLOBAL",1)~ THEN IRTSoren End1
	~You have my deepest gratitude for what you have done, my friends. Your foes will be my foes from this point forward.~ DO ~SetGlobal("IRTBobEndOfEvent","GLOBAL",2)~
	== 25SPELL ~Ah! Everything transpired as planned, it seems.~
	== IMOEN25J ~This is so cool. Hopefully I won't bother you too much. Which reminds me, uh... how do I call on you, anyway?~
	== IRTSoren ~It is as simple as speaking my name or calling out with your thoughts. You bore Calcen as it shattered, and so we are now connected. Do not ever hesitate to request my assistance.~
	== IMOEN25J ~But what if yer in the middle of something really important? I don't wanna interrupt all the time...~
	== IRTSoren ~For a cruel eternity I've languished in my prison. All that I might have cared for once has moved beyond my existence. I have no pressing matters to attend to, my friend.~
	== IMOEN25J ~Yikes. Depressing.~
	= ~Well, okay then. I guess we'll see each other soon. Have fun, uh... doin' whatever you wanna do.~
	== IRTSoren ~Thank you. I will.~ DO ~SetGlobal("IRTBobEndOfEvent","GLOBAL",2) StartCutSceneMode() StartCutScene("BracCut8")~ 
EXIT

/*
Cutscene:
Sorenthis teleports out with a swirly effect while displaying this string over his head:
~'til next we meet.~
End cutscene. Imoen gains the special ability to call Sorenthis three times a day, going in the same menu as all the bhaalspawn abilities. He functions like a regular Deva summon, except he displays one of these random strings whenever he gets summoned:
~Your foes shall perish.~
~Ready to heed your call.~
~I am here, Imoen.~

And displays these dialogues if talked to:
*/

APPEND IRTSoren
IF ~Global("IRTBobEndOfEvent","GLOBAL",2) !IsGabber("Imoen2")~ BobTalkNoIm
   SAY ~I intend no disrespect, <GABBER>, but I would rather talk to Imoen.~
   IF ~~ THEN EXIT
END
END

CHAIN IF ~Global("IRTBobEndOfEvent","GLOBAL",2) IsGabber("Imoen2") RandomNum(5,1)~ THEN IRTSoren BobTalkIm1
	~Yes?~
	== IMOEN25J ~Heya Bob! How's it going?~
	== IRTSoren ~It is going quite nicely, Imoen.~
	== IMOEN25J ~Glad to hear it.~
EXIT

CHAIN IF ~Global("IRTBobEndOfEvent","GLOBAL",2) IsGabber("Imoen2") RandomNum(5,2)~ THEN IRTSoren BobTalkIm2
	~How can I serve you?~
	== IMOEN25J ~So whatcha do whenever yer not stabbing my enemies?~
	== IRTSoren ~I lie in wait beyond your perception, watching your every move, listening to every word you say and considering every thought you do not dare speak.~
	== IMOEN25J ~What? R- really?~
	== IRTSoren ~No, Imoen. I go about my business until I sense your calling. I am often in the midst of meditation.~
	== IMOEN25J ~Pfah. Of all the Devas I could've rescued, I had to get the wisecracking one.~
EXIT

CHAIN IF ~Global("IRTBobEndOfEvent","GLOBAL",2) IsGabber("Imoen2") RandomNum(5,3)~ THEN IRTSoren BobTalkIm3
	~I have answered your call.~
	== IMOEN25J ~As always. Yer a nice fellow, Bob.~
	== IRTSoren ~I try.~
EXIT

CHAIN IF ~Global("IRTBobEndOfEvent","GLOBAL",2) IsGabber("Imoen2") RandomNum(5,4)~ THEN IRTSoren BobTalkIm4
	~What is it you need?~
	== IMOEN25J ~So if I called you just to refresh my drink some time, wouldja do it?~
	== IRTSoren ~Of course.~
	== IMOEN25J ~Really?~
	== IRTSoren ~I owe you my freedom. My stay within Calcen was one of inescapable constraint. I would relish the fact that I could pour something unpleasant in your beverage and you would be none the wiser.~
	== IMOEN25J ~But... but you'd never do something like that, would you?~
	== IRTSoren ~No. I wouldn't.~
	== IMOEN25J ~That... didn't sound convincing at all.~
EXIT

CHAIN IF ~Global("IRTBobEndOfEvent","GLOBAL",2) IsGabber("Imoen2") RandomNum(5,5)~ THEN IRTSoren BobTalkIm5
~Yes?~
	== IMOEN25J ~Hey, Bob! What's up?~
	== IRTSoren ~You called me. I answered.~
	== IMOEN25J ~Well, yeah. But what've you been up to?~
	== IRTSoren ~Fighting your enemies, Imoen.~
	== IMOEN25J ~Well, yeah! But... ogh, never mind.~
EXIT


////If the bracelet was corrupted, Lazarus starts a conversation with you as soon as you return

CHAIN IF ~Global("IRTBraceletCorrupted","GLOBAL",2)~ THEN IMOEN25J IRTBobCorrupted
	~...~
	== 25SPELL~Ah! You were not gone long. Did everything go as planned?~
	== IMOEN25J ~No, it didn't. Forget the whole thing, Lazarus. I don't ever want to hear a word about this again.~
	== 25SPELL ~Oh. I... very well, then. I wish you good fortune in your ventures.~ DO ~SetGlobal("IRTBraceletCorrupted","GLOBAL",3)~ 
EXIT


