// Final Conversation with the Solar


/*

Maximum value possible of IRTCorruptImoen = 11
Maximum value possible of IRTLoveMeter = 40 (technically infinite, but this assumes the player only looped once through the PDAs.)

Thresholds for ascension: 
	IRTLoveMeter = 31+   			:  Imoen is madly in love and will do anything to stay with the player
	IRTLoveMeter = 6 < X < 31    :  Imoen is in love with the player but requires to be corrupted to ascend together, and only as a handmaiden
	IRTLoveMeter = 6 or less     :  Imoen somewhat loves the player, but doesn't want to factor into his/her decision and breaks up with them.
	IRTLoveMeter > 12            :  When Imoen is Romanced and considers whether to ascend as a divine handmaiden, she will decide to do it if value > 12
	IRTLoveMeter > 2             :  Not romanced, corrupted Imoen ascends as divine handmaiden
	
	
Depending on IRTCorruptImoen 's value, she will have a different attitude toward both ascension and giving up her taint.	
	
*/

// Extend the exchange between Imoen and Solar:

/*
Original line:
If I could have gotten rid of it voluntarily, I would have done it a long time ago. *shudder* Take it... I don't want it. I never wanted it.
*/

EXTEND_BOTTOM FINSOL01 7
	IF ~Global("ImoenRomanceActive","GLOBAL",2) GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN EXTERN IMOEN25J FinMad // If Imoen is madly in love
	IF ~OR(2)  Global("IRTImoenIsRavager","GLOBAL",1) Global("IRTImoenControlsSlayer","GLOBAL",2) GlobalGT("IRTCorruptImoen","GLOBAL",6)~ THEN DO ~SetGlobal("IRTBhaalImoen","GLOBAL",1)~ EXTERN IMOEN25J FinCC // If Imoen is fully corrupted
	IF ~Global("ImoenRomanceActive","GLOBAL",2) !GlobalGT("IRTLoveMeter","GLOBAL",30) !Global("IRTImoenIsRavager","GLOBAL",1) !Global("IRTImoenControlsSlayer","GLOBAL",2) GlobalGT("IRTCorruptImoen","GLOBAL",6)~ THEN EXTERN IMOEN25J FinC // If Imoen has been sort of corrupted but never embraced the taint in any way
END

CHAIN IMOEN25J FinC
	~You mean I could get rid of it voluntarily? Let it go, just like that?~
	== FINSOL01 ~Yes, you may do so in this place. The Throne of Blood is at a finger's reach. Bhaal's essence is fluid and malleable here.~
	== IMOEN25J ~It goes against everything <CHARNAME>'s been telling me, but... take it. Please take it, I don't want it, I never did.~
END FINSOL01 8
	
CHAIN IMOEN25J FinCC
	~You mean I could get rid of it now, after everything I've dealt with? This sounds like a very bad joke.~
	== FINSOL01 ~You may let it go in this place. The Throne of Blood is at a finger's reach. Bhaal's essence is fluid and malleable here.~
	== IMOEN25J IF ~Global("IRTImoenControlsSlayer","GLOBAL",1)~ THEN ~Are you nuts? It's as much mine as it is <CHARNAME>'s, I fought to control this damn thing! <CHARNAME>'s taught me not to run away from power. What happens if I keep it?~
	== IMOEN25J IF ~Global("IRTImoenIsRavager","GLOBAL",1)~ THEN ~Are you nuts? It's as much mine as it is <CHARNAME>'s. <PRO_HESHE>'s taught me not to run away from power, and Bhaal's power has shown me what I truly am. What happens if I keep it?~
	== FINSOL01 ~That is for <CHARNAME> to decide. Your portion of Bhaal's essence is small enough not to affect <PRO_HISHER> options. <PRO_HESHE> may allow you to keep it, or may want to slay you for it.~
	= ~But know this. As long as you keep Bhaal's essence within you, you shan't know rest. You will be forever tethered to its divine power, with all the dangers such a thing entails. Should <CHARNAME> refuse his birthright, you will walk Toril as the last true Bhaalspawn.~ 
	== IMOEN25J ~We'll see, then. I'd never go against your wishes, <CHARNAME>... but if this is going where I think it's going, we might have a pretty interesting arrangement in our hands.~
	== FINSOL01 ~As you wish. The final decision approaches.~
END FINSOL01 5

CHAIN IMOEN25J FinMad
	~You mean I could get rid of it voluntarily? Let it go, just like that?~
	== FINSOL01 ~Yes, you may do so in this place. The Throne of Blood is at a finger's reach. Bhaal's essence is fluid and malleable here.~
	== IMOEN25J ~But that would mean... (Imoen throws a fretful glance at you.)~
	= ~I think I know where all this is going. Maybe I could hold on to it awhile longer? What happens if I keep it?~
	== FINSOL01 ~Your portion of Bhaal's essence is small enough not to affect <CHARNAME>'s options - yet beware, should you keep the Taint within you, your soul will be forever tethered to its divine power.~
	== IMOEN25J ~That's... what I thought. We'll see, then.~
	== FINSOL01 ~As you wish. The final decision approaches.~
END FINSOL01 5


////////////////////////////////////

EXTEND_BOTTOM IMOEN25J 15 // Introduce a different sentence if Imoen isn't considered a friend
	IF ~Global("ImoenRomanceActive","GLOBAL",3) !Global("IRTNeverForgive","GLOBAL",1)~ THEN GOTO 15IRA3
	IF ~Global("ImoenRomanceActive","GLOBAL",3) Global("IRTNeverForgive","GLOBAL",1)~ THEN GOTO 15IRA3F
END	

APPEND IMOEN25J
IF ~~ THEN 15IRA3
	SAY ~We might have fallen out, but I'll still miss you if you go. I was there to see this whole story start. It's strange to see it end, now...~
	= ~Good luck, whatever you do.~
	COPY_TRANS IMOEN25J 16
END

IF ~~ THEN 15IRA3F
	SAY ~I wish I could say I'll miss you, but... I don't think I will. Now that this is finally over, I won't ever have to deal with you again. At last I feel like my life is finally my own.~
	COPY_TRANS IMOEN25J 16
END

//Solar tells you about your choices
IF ~~ THEN FD
	SAY ~<CHARNAME>...~ [IRDusk]
	IF ~!Global("ImoenRomanceActive","GLOBAL",2) OR(2) Global("ImoenRomanceActive","GLOBAL",3) !Global("IRTBhaalImoen","GLOBAL",1)~ THEN GOTO 15
	IF ~Global("ImoenRomanceActive","GLOBAL",2) Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) !GlobalLT("IRTLoveMeter","GLOBAL",7)~ THEN GOTO FDWarned // Imoen was warned about the player probably leaving
	IF ~Global("ImoenRomanceActive","GLOBAL",2) !Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) !GlobalLT("IRTLoveMeter","GLOBAL",7)~ THEN GOTO FDUnwarned // Imoen wasn't warned
	IF ~Global("ImoenRomanceActive","GLOBAL",2) !Global("IRTBhaalImoen","GLOBAL",1) GlobalLT("IRTLoveMeter","GLOBAL",7)~ THEN DO ~SetGlobal("IRTEpBreakup","GLOBAL",1) SetGlobal("ImoenRomanceActive","GLOBAL",5)~ GOTO FDBreakup // Love meter is too low, Imoen breaks up with the player
	IF ~!Global("ImoenRomanceActive","GLOBAL",2) !Global("ImoenRomanceActive","GLOBAL",3) Global("IRTBhaalImoen","GLOBAL",1)~ THEN DO ~SetGlobal("IRTCorruptProposal","GLOBAL",1)~ GOTO FDCorrupt // Imoen isn't romanced but the player corrupted her
END

IF ~~ THEN FDWarned
	SAY ~You were clear that this is what you wanted. I've been trying to get used to the idea ever since you told me... just live each day, enjoy what we have while it lasts. But now that we're here... it's much harder than I thought.~
	IF ~Global("ImoenRomanceActive","GLOBAL",2) !Global("IRTBhaalImoen","GLOBAL",1) Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) !GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN DO ~SetGlobal("IRTNotMadNotCorrupt","GLOBAL",1)~ GOTO FDW1 // Imoen was warned and she's not MADLY in love with the player and she's not corrupted
	IF ~Global("ImoenRomanceActive","GLOBAL",2) Global("IRTBhaalImoen","GLOBAL",1) Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) !GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN DO ~SetGlobal("IRTNotMadCorrupt","GLOBAL",1)~ GOTO FDW2 // Imoen was warned and she's not MADLY in love with the player and she IS corrupted
	IF ~Global("ImoenRomanceActive","GLOBAL",2) Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN DO ~SetGlobal("IRTMad","GLOBAL",1)~ GOTO FDW3 // Imoen was warned and she is MADLY in love with the player
END

IF ~~ THEN FDW1
	SAY ~I won't lie, I'd love it if you stayed - but I know this is your choice alone. Who wouldn't want to see the planes and play with the gods? After all that you've done to get here... I'd understand. I really would.~
	= ~If you go... I'll miss you forever. But I'll remember you fondly, and I'll even pray to you now and then. (Imoen's voice quavers slightly. She sniffles.) It'll be so weird.~
	IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7
END

IF ~~ THEN FDW2
	SAY ~This is why I wanted to keep Bhaal's essence. You've taught me to live up to my potential. What if... what if we could stay together, somehow? You don't need to leave me behind. I dunno if I could be a Goddess with you, but... y'know, some kind of divine handmaiden? Maybe it could work. (She turns to the Solar.) Could it work?~
	IF ~~ THEN EXTERN FINSOL01 FinChain2
END
END
	
CHAIN FINSOL01 FinChain2
	~(The Solar regards Imoen in inscrutable silence, as if weighing possibilities and their consequences. Though only a moment passes, when the celestial being finally speaks you get the sense that it has put careful consideration in its next words.)~
   = ~There is a long, colorful history of consorts to deities, divine and mortal alike. The Taint you harbor could make such an arrangement possible in the astral planes. You would not have to remain confined to the mortal realms.~
	= ~Know that you would be forever bound to <CHARNAME>'s will and power. I advise you consider this carefully, Child of Bhaal.~
	== IMOEN25J IF ~!GlobalGT("IRTLoveMeter","GLOBAL",12)~ THEN ~(Imoen looks back at you. There is a doubtful mien on her face.) That sounds... complicated.~
	== IMOEN25J IF ~!GlobalGT("IRTLoveMeter","GLOBAL",12)~ THEN ~Well, if there's a time to be honest, it's right now. I love you, <CHARNAME>, but... I dunno if I'd trust you with my whole eternity. No offense.~
	== IMOEN25J IF ~!GlobalGT("IRTLoveMeter","GLOBAL",12)~ THEN ~Forget about it, then. Take the Taint away, take it and do with it whatever you like. In the end it's still a hateful thing that I shouldn't have anything to do with.~ DO ~SetGlobal("IRTNotMadCorrupt","GLOBAL",0) SetGlobal("IRTNotMadNotCorrupt","GLOBAL",1)~
	== IMOEN25J IF ~GlobalGT("IRTLoveMeter","GLOBAL",12)~ THEN ~(Imoen looks back at you. There is a small grin on her lips, full of trepidation.) I'm willing to pay the price.~
	== FINSOL01 ~So be it.~
END 
	IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7
	
CHAIN IMOEN25J FDW3
	~This is why I wanted to keep Bhaal's essence. I never thought I would feel this way about anyone. The thought of losing you has been tearing me apart... so, maybe - maybe there's a way we could... go together? Somehow? I dunno if I could be a goddess, but... y'know, some kind of divine handmaiden? (She turns to the Solar.) Is that possible?~
	== FINSOL01 ~(The Solar regards Imoen in inscrutable silence, as if weighing possibilities and their consequences. Though only a moment passes, when the celestial being finally speaks you get the sense that it has put careful consideration in its next words.)~
   = ~There is a long, colorful history of consorts to deities, divine and mortal alike. The Taint you harbor could make such an arrangement possible in the astral planes; the bond you share might even enable you to ascend to godhood alongside <CHARNAME>. Either way, you do not need to remain confined to the mortal realms.~
	= ~Know that regardless of the choice, you would be forever bound to <CHARNAME>'s power. Should you attempt to attain godhood together, <PRO_HESHE> will be irrevocably bound to yours. You will be linked, in body, mind and spirit. I advise you consider this carefully, Children of Bhaal.~
	== IMOEN25J ~(Imoen looks back at you. There is a nervous grin on her lips.) What do you say, <CHARNAME>? I'll do my best no matter what. We've gone through too much, I love you *too much* to lose you now. Tell me you feel the same way.~
END
	IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7


APPEND IMOEN25J
IF ~~ THEN FDUnwarned
	SAY ~In the back of my head, I've kept wondering what you'd do once we got here. I know you haven't said you'd go, but I worried all the same. I mean, who wouldn't want to see the planes? After all the work you've done... who wouldn't be tempted to see things through to their proper end? I've been trying not to think about it, just live each day and enjoy what we have while it lasts. But now that we're here... it's much harder than I thought.~
	IF ~Global("ImoenRomanceActive","GLOBAL",2) !Global("IRTBhaalImoen","GLOBAL",1) !Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) !GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN DO ~SetGlobal("IRTNotMadNotCorrupt","GLOBAL",1)~ GOTO FDUnW1 // Imoen wasn't warned and she's not MADLY in love with the player and she's not corrupted
	IF ~Global("ImoenRomanceActive","GLOBAL",2) Global("IRTBhaalImoen","GLOBAL",1) !Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) !GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN DO ~SetGlobal("IRTNotMadCorrupt","GLOBAL",1)~ GOTO FDUnW2 // Imoen wasn't warned and she's not MADLY in love with the player and she IS corrupted
	IF ~Global("ImoenRomanceActive","GLOBAL",2) !Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) GlobalGT("IRTLoveMeter","GLOBAL",30)~ THEN DO ~SetGlobal("IRTMad","GLOBAL",1)~ GOTO FDUnW3 // Imoen wasn't warned and she is MADLY in love with the player
END

IF ~~ THEN FDUnW1
	SAY ~I won't lie, I'd love it if you stayed - but I know this is your choice alone. How would I feel, knowing that you gave up godhood for me? Would you resent me, eventually? Would you even grow to hate me? I couldn't live with that.~
	= ~I want you to choose what you want, what you feel is *right*. And if you go... I'll miss you forever. But I'll remember you fondly, and I'll even pray to you now and then. (Imoen's voice quavers slightly. She sniffles.) It'll be so weird.~
			 IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7

END

IF ~~ THEN FDUnW2
	SAY ~This is why I wanted to keep Bhaal's essence, just in case. You've taught me to live up to my potential. What if... what if we could stay together, somehow? If you choose to claim Bhaal's power, you don't have to leave me behind. I dunno if I could be a goddess with you, but... y'know, some kind of divine handmaiden? Maybe it could work. (She turns to the Solar.) Could it work?~
	IF ~~ THEN EXTERN FINSOL01 FinChain2
END
END

CHAIN IMOEN25J FDUnW3
	~This is why I wanted to keep Bhaal's essence. I never thought I would feel this way about anyone. I hear the choice that's before you, and the thought of losing you is just too much. If you really want to claim Bhaal's power, maybe - maybe there's a way we could... go together? Somehow? I dunno if I could be a goddess, but... y'know, some kind of divine handmaiden? (She turns to the Solar.) Is that possible?~
	== FINSOL01 ~(The Solar regards Imoen in inscrutable silence, as if weighing possibilities and their consequences. Though only a moment passes, when the celestial being finally speaks you get the sense that it has put careful consideration in its next words.)~
   = ~There is a long, colorful history of consorts to deities, divine and mortal alike. The Taint you harbor could make such an arrangement possible in the astral planes; the bond you share might even enable you to ascend to godhood alongside <CHARNAME>. Either way, you do not need to remain confined to the mortal realms.~
	= ~Know that regardless of the choice, you would be forever bound to <CHARNAME>'s power. Should you attempt to attain godhood together, <PRO_HESHE> will be irrevocably bound to yours. You will be linked, in body, mind and spirit. I advise you consider this carefully, Children of Bhaal.~
	== IMOEN25J ~(Imoen looks back at you. There is a nervous grin on her lips.) How about that? No matter what you choose, we don't have to go separate ways. Together since the beginning, and together to the end of time, if that's what you want. (Imoen's voice quavers. Tears have welled in her eyes.) We've gone through too much... I love you *too much* to lose you now. Tell me you feel the same way.~
END
	IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7


APPEND IMOEN25J
IF ~~ THEN FDBreakup
	SAY ~(Imoen is looking at you with worry. She doesn't seem capable of maintaining eye contact for long.)~
	= ~If there's a time to be truthful and honest... well, that's now, isn't it. (She takes a deep breath and lets it go slowly.)~
	= ~I love you, <CHARNAME>. I think I always will. But... I see you standing here, destiny itself unfolding before you, and I find myself outside of it. It's... revelatory. The truth is that I don't want to be part of this decision.~
	= ~We've been together from the start, and now... I think I'm done. We got here. It's over. I don't wanna do it anymore.~
	= ~You're free, now. Go where you will and... I'll do the same.~
	++ ~Wait... are you breaking up with me? Now?~ + FDBr1
	++ ~I couldn't have said it better. I understand what you're saying, Imoen. Thank you for everything.~ + FDBr2
	++ ~But I was planning to stay with you! I'll be the <PRO_MANWOMAN> you deserve, now that it's all over!~ + FDBr3
	++ ~Things haven't worked between us for a while. I'm glad you see it as I do.~ + FDBr4
END

IF ~~ THEN FDBr1
	SAY ~Yeah... I guess I am.~
	++ ~How DARE you, after everything I've done for you!~ + FDBr1a
	++ ~Just making sure I understood you correctly. I agree, then. Things haven't worked between us for a while.~ + FDBr4
	++ ~Is it because I haven't treated you well enough? I've been so stressed! Now I can finally be the person you want me to be!~ + FDBr3
END

IF ~~ THEN FDBr1a
	SAY ~I know. I'm sorry.~
	= ~Do you want me to explain, or shut up?~
	++ ~Explain yourself, it's the least that you owe me.~ + FDBr1a1
	++ ~Just be quiet, I can't believe you're doing this right now.~ + FDBr1a2
END

IF ~~ THEN FDBr1a1
	SAY ~I owe you much more than that... I owe you everything. But romantically, I can't do this anymore. It's taken me this long to realize... we're not meant for one another.~
	= ~So I imagine what will happen with each of your options - if you go, we had a clean break. Nothing left unsaid, no regrets. If you stay... I can't bear the thought of sticking together, an ex-girlfriend hanging around like she's got nothing better. Sure, I don't *have* anything better. You are my whole life. And when I think about that... I want to change it.~
	= ~So that's where we're at right now. I hope it makes sense.~
	= ~I'll miss you, <CHARNAME>. Who knows, maybe if you stay I'll show up to save yer bacon again one day.~
			 IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7

END

IF ~~ THEN FDBr1a2
	SAY ~Yeah. I'm sorry, for what it's worth.~
			 IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7

END

IF ~~ THEN FDBr2
	SAY ~(Though she smiles, tears have welled in her eyes.) Yeah. I'll miss you a lot anyway, you know? I owe you so much, and we've come so far...~
	= ~But it's the right decision. Whatever you choose, we need to part ways. At least for a while.~
	= ~Who knows, maybe if you stay I'll show up to save yer bacon again one day.~
			 IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7

END

IF ~~ THEN FDBr3
	SAY ~No, <CHARNAME>. It's not about that. We're not meant for each other, I see it now. You'll understand where I'm coming from, with time.~
	IF ~~ THEN GOTO FDBr4
END

IF ~~ THEN FDBr4
	SAY ~Yeah. I'll miss you a lot anyway, you know? (Tears have welled in Imoen's eyes.) I owe you so much, and we've come so far, but... it's the right decision. Whatever you choose, we need to part ways. At least for a while.~
	= ~Who knows, maybe if you stay I'll show up to save yer bacon again one day.~
		 IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7
END
END

CHAIN IMOEN25J FDCorrupt
	~If there's something I've learned with you is to stop trying to hold back my potential. You taught me to use the Taint, and accept myself for who I am and what I really want... and I'm standing here, looking at you and the decision you're about to make - and it's just amazing. That's why I wanted to keep Bhaal's essence. I want to see the planes too. I want to bicker with the gods. If you're doing this, I want to go with you, <CHARNAME>.~
	== AERIE25J IF ~InParty("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~I so wish you'd reconsider...~
	== IMOEN25J IF ~InParty("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~I'm sorry, Aerie. I need to take this chance. It probably won't work, but I gotta try. (She addresses you once more.)~
	= ~Don't get me wrong, I don't want *your* place, I'm not jealous or anything like that... I just want to continue helping you. Like, y'know, some kind of divine handmaiden? (She turns to the Solar.) Is that possible?~
	== FINSOL01 ~(The Solar regards Imoen in inscrutable silence, as if weighing possibilities and their consequences. Though only a moment passes, when the celestial being finally speaks you get the sense that it has put careful consideration in its next words.)~
   = ~Yours is the same divine spark that fuels <CHARNAME>'s claim to <PRO_HISHER> birthright. The Taint you harbor could make such an arrangement possible in the astral planes. You need not remain in the mortal realms.~
	= ~Know that, if you do this, you would be forever bound to <CHARNAME>'s will and power. I advise you consider this carefully, Child of Bhaal.~
	== IMOEN25J IF ~!GlobalGT("IRTLoveMeter","GLOBAL",2)~ THEN ~(Imoen looks back at you. There is a doubtful mien on her face.) That sounds... complicated.~
	== IMOEN25J IF ~!GlobalGT("IRTLoveMeter","GLOBAL",2)~ THEN ~Well, if there's a time to be honest, it's right now. I love you plenty, <PRO_BROTHERSISTER>, but... I dunno if I'd trust you with my whole eternity. No offense.~
	== IMOEN25J IF ~!GlobalGT("IRTLoveMeter","GLOBAL",2)~ THEN ~Forget about it, then. Take the Taint away, take it and do with it whatever you like. In the end it's still a hateful thing that I shouldn't have anything to do with. I'll find things to do with myself in the mortal world, I'm sure.~ DO ~SetGlobal("IRTCorruptProposal","GLOBAL",0)~
	== IMOEN25J IF ~GlobalGT("IRTLoveMeter","GLOBAL",2)~ THEN ~(Imoen looks back at you. There is a small grin on her lips, full of trepidation.) And what's new? Been at <PRO_HISHER> beck and call for years, it's all I've ever done. Might as well make it official.~
	== FINSOL01 ~So be it.~
END
	IF ~  True()
	~ THEN EXTERN ~FINSOL01~ 28
	  IF ~  IfValidForPartyDialogue("Valygar")
	Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 3
	  IF ~  IfValidForPartyDialogue("Anomen")
	Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 11
	  IF ~  IfValidForPartyDialogue("Viconia")
	Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 8
	  IF ~  IfValidForPartyDialogue("Aerie")
	Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 9
	  IF ~  IfValidForPartyDialogue("Jaheira")
	Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 9
	  IF ~  IfValidForPartyDialogue("Valygar")
	!Global("ValygarRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VALYG25J~ 2
	  IF ~  IfValidForPartyDialogue("Anomen")
	!Global("AnomenRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~ANOME25J~ 10
	  IF ~  IfValidForPartyDialogue("Viconia")
	!Global("ViconiaRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~VICON25J~ 6
	  IF ~  IfValidForPartyDialogue("Aerie")
	!Global("AerieRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~AERIE25J~ 7
	  IF ~  IfValidForPartyDialogue("Jaheira")
	!Global("JaheiraRomanceActive","GLOBAL",2)
	~ THEN EXTERN ~JAHEI25J~ 7



// Main decision super branch



/*
Default choices:
IF ~GlobalLT("PPEvilChoices","GLOBAL",2)~ THEN REPLY ~I will retain the essence of Bhaal that is my right and become a power of the planes.~ DO ~SetGlobal("PlayerChoseEssence","GLOBAL",1)~ GOTO 31
IF ~GlobalGT("PPEvilChoices","GLOBAL",1) GlobalLT("PPEvilChoices","GLOBAL",4)~ THEN REPLY ~I will retain the essence of Bhaal that is my right and become a power of the planes.~ DO ~SetGlobal("PlayerChoseEssence","GLOBAL",1)~ GOTO 30
IF ~GlobalGT("PPEvilChoices","GLOBAL",3) GlobalLT("PPEvilChoices","GLOBAL",6)~ THEN REPLY ~I will retain the essence of Bhaal that is my right and become a power of the planes.~ DO ~SetGlobal("PlayerChoseEssence","GLOBAL",1)~ GOTO 29
IF ~~ THEN REPLY ~I do not want the essence of Bhaal. Do what you will with it... I want to remain mortal.~ GOTO 32
*/


APPEND IMOEN25J
	IF ~~ THEN finalbreak
	   SAY ~Wow.~
	// Imoen not romanced, not corrupt (Vanilla responses - since priority is given from bottom to top, these will only be followed if none of the stuff below is met)
		IF ~Global("PlayerChoseEssence","GLOBAL",1) Global("ImoenRomanceActive","GLOBAL",0)~ GOTO 18
		IF ~Global("PlayerChoseEssence","GLOBAL",0) Global("ImoenRomanceActive","GLOBAL",0)~ GOTO 19
		

	// Imoen romanced but not madly in love, not corrupt
		IF ~Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) Global("IRTNotMadNotCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN DO ~SetGlobal("IRTEpSoloStandard","GLOBAL",1)~ GOTO AA1 //resolved
		IF ~!Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) Global("IRTNotMadNotCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN DO ~SetGlobal("IRTEpSoloStandard","GLOBAL",1)~ GOTO AA2  //resolved
		IF ~Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) Global("IRTNotMadNotCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN DO ~SetGlobal("IRTEpJointStandard","GLOBAL",1)~ GOTO AA3 //resolved
		IF ~!Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) Global("IRTNotMadNotCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN DO ~SetGlobal("IRTEpJointStandard","GLOBAL",1)~ GOTO AA4 //resolved





		
	// Imoen madly in love | Let's just make something new
		IF ~Global("IRTMad","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) ~ THEN REPLY ~I'm sorry, Imoen. You must stay behind.~ DO ~SetGlobal("IRTEpSoloMad","GLOBAL",1)~ GOTO BB1
		IF ~Global("IRTMad","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN REPLY ~I want you to come with me, Imoen. We belong together, for all eternity.~ DO ~SetGlobal("IRTEpAscendedFull","GLOBAL",1)~ GOTO BB2
		+ ~Global("IRTMad","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,LAWFUL_EVIL)~ + ~I'll be ruthless, Imoen. I will turn the celestial rules on their head and run all my opponents into the ground. Are you sure you want to join me?~ GOTO BBEvil 
	   + ~Global("IRTMad","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,NEUTRAL_EVIL)~ + ~I'll be ruthless, Imoen. Assassinations, betrayals, torture, whatever it takes to get me ahead. Are you sure you want to join me?~ GOTO BBEvil 
	   + ~Global("IRTMad","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,CHAOTIC_EVIL)~ + ~I'll be ruthless, Imoen. I will spread ruin and misery, and mortals will cower at the mention of my name. Are you sure you want to join me?~ GOTO BBEvil
		IF ~Global("IRTMad","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN REPLY ~Did I make the right choice? I'll reconsider if you believe I should.~ + BB5
		IF ~Global("IRTMad","GLOBAL",1) Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN DO ~SetGlobal("IRTEpJointMad","GLOBAL",1)~ GOTO BB3 //resolved
		IF ~Global("IRTMad","GLOBAL",1) !Global("IRTImoenWarnedAboutLeaving","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~  THEN DO ~SetGlobal("IRTEpJointMad","GLOBAL",1)~ GOTO BB4 //resolved

		
	// Imoen not mad in love, corrupt
		IF ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~  THEN REPLY ~I'm sorry, Imoen. You must stay behind.~ DO ~SetGlobal("IRTEpSoloStandard","GLOBAL",1)~ GOTO CC1 //resolved
		IF ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~  THEN  REPLY ~I want you to come with me, Imoen. We belong together, after all.~ DO ~SetGlobal("IRTEpAscendedMaiden","GLOBAL",1)~ GOTO CC2 //resolved


		+ ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,LAWFUL_EVIL)~ + ~I'll be ruthless, Imoen. I will turn the celestial rules on their head and run all my opponents into the ground. Are you sure you want to join me?~ GOTO CCEvil
		+ ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,NEUTRAL_EVIL)~ + ~I'll be ruthless, Imoen. Assassinations, betrayals, torture, whatever it takes to get me ahead. Are you sure you want to join me?~ GOTO CCEvil
		+ ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,CHAOTIC_EVIL)~ + ~I'll be ruthless, Imoen. I will spread ruin and misery, and mortals will cower at the mention of my name. Are you sure you want to join me?~ GOTO CCEvil
	
		IF ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN REPLY ~Godhood isn't for me, after all. I would much rather spend the rest of my mortal life with you.~ DO ~SetGlobal("IRTEpJointStandard","GLOBAL",1)~  GOTO CC5 //resolved
		
		IF ~Global("IRTNotMadCorrupt","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~  THEN REPLY ~Godhood isn't for me, but how about you, Last Living Bhaalspawn? I don't want Bhaal's essence. You can do with it what you will.~ DO ~SetGlobal("IRTEpJointStandard","GLOBAL",1)~  GOTO CC4 //resolved

	// Imoen not romanced, corrupt

		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN REPLY ~I'm sorry, Imoen. You must stay behind.~ GOTO DD1 // Non-mod epilogue displays (or Aerie friendship if applicable)
		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN REPLY ~Come with me, Imoen. Together we will be unstoppable.~ DO ~SetGlobal("IRTEpAscendedMaiden2","GLOBAL",1)~ GOTO DD2
		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,LAWFUL_EVIL)~ THEN REPLY ~I'll be ruthless, Imoen. I will turn the celestial rules on their head and run all my opponents into the ground. Are you sure you want to join me?~ GOTO DDEvil
		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,NEUTRAL_EVIL)~ THEN REPLY ~I'll be ruthless, Imoen. Assassinations, betrayals, torture, whatever it takes to get me ahead. Are you sure you want to join me?~ GOTO DDEvil
		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1) Alignment(Player1,CHAOTIC_EVIL)~ THEN REPLY ~I'll be ruthless, Imoen. I will spread ruin and misery, and mortals will cower at the mention of my name. Are you sure you want to join me?~ GOTO DDEvil

		
		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN REPLY ~Godhood isn't for me, after all. Time to go live our lives at last, Imoen.~ GOTO DD3 // Non-mod epilogue displays (or Aerie friendship if applicable)
		IF ~Global("IRTCorruptProposal","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN REPLY ~Godhood isn't for me, but how about you, Last Living Bhaalspawn? I don't want Bhaal's essence. You can do with it what you will.~ GOTO CC4 // Non-mod epilogue displays (or Aerie friendship if applicable)


		

















		//vanilla choices
		    //ascended
		IF ~Global("ImoenRomanceActive","GLOBAL",3) Global("PlayerChoseEssence","GLOBAL",1)~ THEN GOTO Sol29a
		IF ~Global("ImoenRomanceActive","GLOBAL",5) Global("PlayerChoseEssence","GLOBAL",1)~ THEN GOTO Sol29b
		IF ~Global("IRTEpBreakup","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",1)~ THEN GOTO Sol29c
		//mortal
		IF ~Global("ImoenRomanceActive","GLOBAL",3) Global("PlayerChoseEssence","GLOBAL",0)~ THEN GOTO Sol32a
		IF ~Global("ImoenRomanceActive","GLOBAL",5) Global("PlayerChoseEssence","GLOBAL",0)~ THEN GOTO Sol32b
		IF ~Global("IRTEpBreakup","GLOBAL",1) Global("PlayerChoseEssence","GLOBAL",0)~ THEN GOTO Sol29d
		
	END
END
APPEND IMOEN25J
IF ~~ THEN AA1
	SAY ~I can't blame you, it's what you always wanted... (Despite her efforts, tears escape her eyelids and stream down her cheeks. She wipes at them in frustration, trying to smile.)~
	IF ~~ THEN GOTO AAGod
END

IF ~~ THEN AA2
	SAY ~I can't blame you, I really can't... (Despite her efforts, tears escape her eyelids and stream down her cheeks. She wipes at them in frustration, trying to smile.)~
	IF ~~ THEN GOTO AAGod
	IF ~Global("IRTWantsMarriage","GLOBAL",1)~ THEN GOTO AAMarry	
END

IF ~~ THEN AAMarry
	SAY ~I'm sorry. I'd even started daydreaming about my wedding dress. I knew it was a silly thing to think about.~
	IF ~~ THEN GOTO AAGod
END

IF ~~ THEN AAGod
	SAY ~I'll miss you so much. Make me proud up there, <CHARNAME>. Don't do anything I wouldn't do.~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN AA3
	SAY ~You changed your mind! (Imoen throws herself into your arms, squeezing you tightly.)~
	IF ~~ THEN GOTO AAMortal
END

IF ~~ THEN AA4
	SAY ~(Imoen throws herself into your arms, squeezing you tightly.)~
	IF ~~ THEN GOTO AAMortal
END

IF ~~ THEN AAMortal
	SAY ~You're staying, I'm so happy, SO happy! After all this, we're going to end up on the road again.~
	IF ~!Global("IRTWantsMarriage","GLOBAL",1)~ THEN GOTO AAMarryStay1
	IF ~Global("IRTWantsMarriage","GLOBAL",1)~ THEN GOTO AAMarryStay2
END

IF ~~ THEN AAMarryStay1
	SAY ~It'll be the first time we'll be able to pick our path since we left Candlekeep! I can't wait!~
	COPY_TRANS IMOEN25J 20
END

IF ~~ THEN AAMarryStay2
	SAY ~It'll be the first time we'll be able to pick our path since we left Candlekeep! I can't wait!~
	=~I'm so glad all the silly daydreaming I've been doing about my wedding dress didn't go to waste...~
	COPY_TRANS IMOEN25J 20
END

IF ~~ THEN BB1
	SAY ~What? But... we could...~
	= ~Why? I thought we were just perfect together. You don't feel that way? Help me understand...~
	++ ~I don't wish this fate for you, Imoen. You belong in the mortal realm. Trust me in this.~ + BB1a
	++ ~I love you so very dearly, but... eternity together? That is more of a commitment than anyone should make.~ + BB1a
	++ ~I hate to break it to you, but I don't feel nearly as strongly about you as you feel about me.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-10)~ + BB1b
	++ ~This is *my* birthright, and I will share it with no-one, not even you.~ + BB1c
	++ ~My reasons are my own. This is my will, and you must accept it.~ + BB1b
END

IF ~~ THEN BB1a
	SAY ~I... see. I guess... I guess I could... understand. With time.~
	= ~I was a fool to hope for this. It was such a long shot... (Despite her best efforts, tears escape her eyelids and stream down her cheeks. She wipes at them in frustration.)~
	= ~There's no point to any of this then, if you don't want to. Take my Bhaal essence, do what you were destined to do. I'll just... let you go...~
	IF ~~ THEN GOTO BB1End
END

IF ~~ THEN BB1End
	SAY ~(Imoen gives in to the tears. She faces away from you, hugging herself, waiting for the inevitable.)~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN BB1b
	SAY ~Wow. I... wow.~
	= ~That's... alright, then. (Imoen is blinking profusely, her eyes not quite knowing where to focus.) I don't... I don't know how to deal with this.~
	= ~What am I even doing, then? There's no point to any of it. I was such a fool to hope for this... (Despite her best efforts, tears escape her eyelids and stream down her cheeks. She wipes at them in frustration.)~
	= ~Take my Bhaal essence, do whatever you want. I'll just... I need a moment.~
	IF ~~ THEN GOTO BB1End
END

IF ~~ THEN BB1c
	SAY ~I... see. I thought... maybe you wouldn't care. But I should've known. I should've known...~
	= ~I was a fool to hope for this. I know you better than that. (Despite her best efforts, tears escape her eyelids and stream down her cheeks. She wipes at them in frustration.)~
	= ~There's no point to any of this then, if you don't want to. Take my Bhaal essence, do what you were destined to do. I'll just... let you go...~
	IF ~~ THEN GOTO BB1End
END

IF ~~ THEN BB2
	SAY ~Oh, gods. This is real. It's really going to happen. (Imoen throws herself into your arms, squeezing you tightly.)~
	= ~This is... *so* terrifying. But I'm ready. If there's anything I've learned through all this, it's that we can face anything as long as we're together.~
	COPY_TRANS IMOEN25J 18
END
END

APPEND FINSOL01
IF ~~ THEN 29R
	SAY ~As you wish, though it brings me no pleasure to unleash such an evil onto the cosmos. You are wicked, Bhaalspawn, and your time as a power will be a difficult one, I swear. Perhaps Imoen's influence will temper your ruthlessness, yet I very much doubt it. She will very likely mold to your ways.~ [SOLAR103]
	IF ~~ THEN GOTO 33
END
	
IF ~~ THEN 30R
	SAY ~As you wish... though the thought of you succumbing to the temptations of Bhaal's foul taint brings me no pleasure. We shall see what manner of power you become... in time. Perhaps Imoen's influence shall tip the scales in favor of righteousness, mischief-riddled as it may be.~ [SOLAR104]
	IF ~~ THEN GOTO 33
END

IF ~~ THEN 31R
	SAY ~As you wish. You have proven to us all that the power in your blood is yours to command... it does not command you. I shall be proud to stand by you in a place of power among the heavens. Imoen's influence should only reinforce your righteousness, mischief-riddled as it may become.~ [SOLAR105]
	IF ~~ THEN GOTO 33
END
END

APPEND IMOEN25J
IF ~~ THEN BB3
	SAY ~You changed your mind! (Imoen throws herself into your arms, squeezing you tightly.)~
	IF ~~ THEN GOTO BBMortal
END

IF ~~ THEN BB4
	SAY ~YES! (Imoen throws herself into your arms, squeezing you tight.)~
	IF ~~ THEN GOTO BBMortal
END
END

CHAIN IMOEN25J BBMortal
	~I'll admit, the thought of going with you was *terrifying*. But I was ready. If there's anything I've learned through all this, it's that we can face anything as long as we're together.~
	== IMOEN25J IF ~Global("IRTWantsMarriage","GLOBAL",1)~ THEN ~I'm SO happy to stay, though. Oh, this is so great, I can hardly believe it's happening... it's over, <CHARNAME>, it's all over at last, and we're gonna be on the road again. It'll be the first time we'll be able to pick our path since we left Candlekeep, I can't wait! I even have a wedding to plan, oh boy...~
	== IMOEN25J IF ~!Global("IRTWantsMarriage","GLOBAL",1)~ THEN ~I'm SO happy to stay, though. Oh, this is so great, I can hardly believe it's happening... it's over, <CHARNAME>, it's all over at last, and we're gonna be on the road again. It'll be the first time we'll be able to pick our path since we left Candlekeep, I can't wait!~
	== IMOEN25J ~Solar, please, take this gross Bhaal essence away. We don't want it. I can't wait to forget all about it.~
END
  COPY_TRANS IMOEN25J 20

APPEND IMOEN25J
IF ~~ THEN BB5
	SAY ~What? No... this is about what *you* think is right. You can't make this decision based on what I want. When it comes to this, that shouldn't matter.~
	++ ~How can you say that? You are part of me. I will always have your wishes in mind.~ + BB5a
	++ ~What's right? I want to be happy by your side. You know what makes me happy? Making *you* happy. So, yes, I need to know which life you'd rather have.~ + BB5a
	++ ~And have you resent me a couple centuries down the line? No, I need you to be just as certain as I am about this.~ + BB5b
	++ ~I see. Then I'm sorry, Imoen. You must stay behind.~ DO ~SetGlobal("IRTEpSoloMad","GLOBAL",1)~ + BB1
	++ ~Come with me, then. We belong together, for all eternity.~ DO ~SetGlobal("IRTEpAscendedFull","GLOBAL",1)~ + BB2
	+ ~Global("IRTImoenWarnedAboutLeaving","GLOBAL",1)~ + ~Fine, then. I do not want the essence of Bhaal. Let us remain mortal.~ DO ~SetGlobal("IRTEpJointMad","GLOBAL",1)~ + BB3
	+ ~!Global("IRTImoenWarnedAboutLeaving","GLOBAL",1)~ + ~Fine, then. I do not want the essence of Bhaal. Let us remain mortal.~ DO ~SetGlobal("IRTEpJointMad","GLOBAL",1)~ + BB4
END

IF ~~ THEN BB5a
	SAY ~(Imoen chuckles lightly.) Even at a time like this, you still find the exact right thing to say.~
	= ~Alright, then, how about this: I won't tell you what you should choose, but I'll tell you what *I'd* choose if I were in your shoes and had no-one else to think about.~
	= ~The truth is that I'd let go of Bhaal's essence and stay mortal. Becoming a new god sounds like the beginning of another huge struggle. At this point, I feel like we've struggled long enough.~
	= ~But like I said... I want to be with you. Go or stay, this is what I want. Don't you get it, <CHARNAME>? That's what I've always wanted, to help you, to support you in every way. The way I feel when I'm with you, I can't feel it anywhere else.~
	IF ~~ THEN GOTO BB5End
END

IF ~~ THEN BB5b
	SAY ~I *am* certain. I want to be with you. Go or stay, this is what I want. Don't you get it, <CHARNAME>? That's what I've always wanted, to help you, to support you in every way. The way I feel when I'm with you, I can't feel it anywhere else.~
	IF ~~ THEN GOTO BB5End
END

IF ~~ THEN BB5End
	SAY ~I love you more than I can say. Mortal or God, it doesn't matter to me.~
	++ ~I see. Then I'm sorry, Imoen. You must stay behind.~ DO ~SetGlobal("IRTEpSoloMad","GLOBAL",1)~ + BB1
	++ ~Come with me, then. We belong together, for all eternity.~ DO ~SetGlobal("IRTEpAscendedFull","GLOBAL",1)~ + BB2
	+ ~Global("IRTImoenWarnedAboutLeaving","GLOBAL",1)~ + ~Fine, then. I do not want the essence of Bhaal. Let us remain mortal.~ DO ~SetGlobal("IRTEpJointMad","GLOBAL",1)~ + BB3
	+ ~!Global("IRTImoenWarnedAboutLeaving","GLOBAL",1)~ + ~Fine, then. I do not want the essence of Bhaal. Let us remain mortal.~ DO ~SetGlobal("IRTEpJointMad","GLOBAL",1)~ + BB4
END	

IF ~~ THEN BBEvil
	SAY ~I...~
	= ~I've been watching you do these things all this time. I've helped you, feeling bad all the while, but I helped anyway. I stuck around and followed your steps, whatever terrible places you went. I made love to you knowing the kind of person you are. You do what you do and still... I love you more than I can say.~
	= ~What does that say about me? I like to be nice to people, but maybe, deep down... I don't care. As long as I'm happy, as long as you treat me the way you do, I don't care.~
	= ~And now we stand in this place, and I look at the two paths before me. Go separate ways and find a life of my own. Stay with you and keep doing terrible things. One is the right thing to do, while the other makes me happy.~
	= ~I want to be with you. I'll do what it takes. Mortal or god, it makes no difference.~
	++ ~I see. (Shake your head.) I'm sorry, Imoen. You must stay behind.~ DO ~SetGlobal("IRTEpSoloMad","GLOBAL",1)~ GOTO BB1
	++ ~I'm glad you feel this way. Come with me, then. We belong together, for all eternity.~ DO ~SetGlobal("IRTEpAscendedFull","GLOBAL",1)~ GOTO BB2



END

IF ~~ THEN CC1
	SAY ~Wow, really? But... we could've made it work...~
	= ~Why? I thought this is what you wanted. We have something beautiful together. You don't feel that way? Help me understand...~
	++ ~I don't wish this fate for you, Imoen. You belong in the mortal realm. Trust me in this.~ + BB1a
	++ ~I love you so very dearly, but... eternity together? That is more of a commitment than anyone should make.~ + BB1a
	++ ~I hate to break it to you, but I don't feel nearly as strongly about you as you feel about me.~ + CC1b
	++ ~This is *my* birthright, and I will share it with no-one, not even you.~ + BB1c
	++ ~My reasons are my own. This is my will, and you must accept it.~ + CC1b
END

IF ~~ THEN CC1b
	SAY ~Wow. I... wow.~
	= ~That's... alright, then. I didn't see that coming.~
	= ~(Imoen is blinking profusely, her eyes not quite knowing where to focus.) I don't... I don't know how to deal with this.~
	= ~What am I even doing, then? There's no point to any of it. I was such a fool to hope for this... (Despite her best efforts, tears escape her eyelids and stream down her cheeks. She wipes at them in frustration.)~
	= ~Take my Bhaal essence, do whatever you want. I'll just... I need a moment.~
	IF ~~ THEN GOTO BB1End
END

IF ~~ THEN CC2
	SAY ~Oh, gods. This is real. This is really happening. (Imoen throws herself into your arms, squeezing you tight.)~
	= ~This is... *so* terrifying. But I'm ready. If there's anything I've learned through all this, it's that we can face anything as long as we're together. I won't hold back. I'm going to become the absolute very best I can become. I'll be your right hand and do you proud.~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN CC3
	SAY ~You changed your mind?~
	IF ~~ THEN GOTO CCNuts
END

IF ~~ THEN CC4
	SAY ~This is so weird, I'd have thought...~
	IF ~~ THEN GOTO CCNuts
END 

IF ~~ THEN CCNuts
	SAY ~Wait, wait - and you are leaving this in *my* hands? Are you nuts?~
	++ ~What do you say, Imoen? Fancy being a goddess? Once in a lifetime opportunity. Go for it, I won't resent you at all.~ + CCN1
	++ ~Somebody needs to fill this void, and it will not be me. Fulfil this duty, Imoen. Perhaps you were fated to inherit Bhaal's throne after all.~ + CCN1
	++ ~I'm staying. Now the choice is up to you.~ + CCN2
END

IF ~~ THEN CCN1
	SAY ~Me? A goddess...~
	= ~(Imoen grows quiet, her lips parted slightly. You can watch the possibility slowly becoming real on her features.)~ 
	= ~No... no, there's no way. We'd have to go separate ways, for one. And it sounds like such a huge hassle. I'm done struggling, I think. I don't wanna be ripped apart by a pissed off pantheon.~
	= ~Only a mad<PRO_MANWOMAN> would go for it - and since not even you are willing to do it, well, that tells me something right there, hah!~
	= ~I'm happy to stay with you. Actually... I'm REALLY happy to stay. It's hard to believe... it's over, <CHARNAME>, it's all over at last, and we're gonna be on the road again. It'll be the first time we'll be able to pick our path since we left Candlekeep, isn't that crazy?~
	= ~Solar, please, take this gross Bhaal essence away. I wish I'd never touched it. I can't wait to forget all about it.~
	COPY_TRANS IMOEN25J 20
END
	
IF ~~ THEN CCN2
	SAY ~You *are* nuts!~
	IF ~~ THEN GOTO CCN1
END
	
IF ~~ THEN CC5
	SAY ~It's so weird that you changed your mind in the end, after everything you said. I thought for sure you'd go for it...~

	IF ~~ THEN GOTO CCMortal
END

IF ~~ THEN CC6
	SAY ~Oh, wow, really? I thought for sure you'd go for it...~
	IF ~~ THEN GOTO CCMortal
END
END

CHAIN IMOEN25J CCMortal
	~I'll admit, the thought of going through with the whole ascension thing was *terrifying*. But I was ready. If there's anything I've learned through all this, it's that we can face anything as long as we're together.~
	== IMOEN25J IF ~Global("IRTWantsMarriage","GLOBAL",1)~ THEN ~I'm happy to stay, though. Actually... I'm REALLY happy to stay. It's hard to believe... it's over, <CHARNAME>, it's all over at last, and we're gonna be on the road again. It'll be the first time we'll be able to pick our path since we left Candlekeep. I even have a wedding to plan, oh boy...~
	== IMOEN25J IF ~!Global("IRTWantsMarriage","GLOBAL",1)~ THEN ~I'm happy to stay, though. Actually... I'm REALLY happy to stay. It's hard to believe... it's over, <CHARNAME>, it's all over at last, and we're gonna be on the road again. It'll be the first time we'll be able to pick our path since we left Candlekeep, isn't that crazy?~
	== IMOEN25J ~Solar, please, take this gross Bhaal essence away. I wish I'd never touched it. I can't wait to forget all about it.~
COPY_TRANS IMOEN25J 20

APPEND IMOEN25J
IF ~~ THEN CCEvil
	SAY ~I...~
	= ~I've been watching you do these things all this time. I've helped you, feeling bad all the while, but I helped anyway. I stuck around and followed your steps, whatever terrible places you went, and listened to your advice knowing full well where it would lead me.~
	= ~I made love to you knowing the kind of person you are. You do what you do and still... I love you more than I can say. What does that say about me? I like to be nice to people, but maybe, deep down... I don't care. As long as I'm happy, as long as you treat me the way you do, I don't care.~
	= ~And now we stand in this place, and I look at the two paths before me. Go separate ways and find a life of my own. Stay with you and keep gaining power doing terrible things. One is the right thing to do, while the other makes me happy.~
	= ~I want to see how far I can go, and I want to be with you. I'll do what it takes.~
	++ ~I see. (Shake your head.) I'm sorry, Imoen. You must stay behind.~ DO ~SetGlobal("IRTEpSoloStandard","GLOBAL",1)~ GOTO CC1
	++ ~I'm glad you feel this way. Come with me, then. We belong together, after all.~ DO ~SetGlobal("IRTEpAscendedMaiden","GLOBAL",1)~ GOTO CC2
END

IF ~~ THEN DD1
	SAY ~Psh, figures. All of it for yourself, what a shocker. I don't get it, you could have an excellent right hand by your side. I mean... I dunno about everything else, but I think I've got trustworthy and loyal down pat.~
	= ~But hey, it's always been up to you. Take this gross Bhaal essence then, I sure don't wanna keep it. If I'd had a choice, it would've been gone a long time ago.~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN DD2
	SAY ~Hah! I thought for a moment you were leaving me behind. Wow, we're really doing this. It's terrifying!~
	= ~I'm ready, though. If there's something I've learned through all this, it's that we can face anything as long as we're together. I won't hold back. I'm going to become the absolute very best I can become. I'll be your right hand and do you proud.~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN DD3
	SAY ~This is so weird, I thought for sure you'd go for it. I'll admit, the thought of ascending with ya was *terrifying*... but I was ready. If there's anything I've learned through all this, it's that we can face anything as long as we're together.~
	= ~I'm happy to stay, to be honest. It's hard to believe... it's all over at last, and we're gonna be on the road again. It'll be the first time we'll be able to pick our path since we left Candlekeep, isn't that crazy?~
	= ~Solar, please, take this gross Bhaal essence away. I wish I'd never touched it. I can't wait to forget all about it.~
	COPY_TRANS IMOEN25J 20
END

IF ~~ THEN DDEvil
	SAY ~I...~
	= ~I've been watching you do these things all this time. I've helped you, feeling bad all the while, but I helped anyway. I stuck around and followed your steps, whatever terrible places you went, and listened to your advice knowing full well where it would lead me. Everything you've done, everything *we've* done... I'm just as much to blame.~
	= ~What does that say about me? I like to be nice to people, but maybe, deep down... I don't care. I stand in this place, looking at the two paths before me. Go separate ways and find a life of my own. Stay with you and keep gaining power doing terrible things. One is the right thing to do, while the other... the other is what I actually want.~
	= ~I want to see how far I can go. I'll do what it takes. I can do it, as long as I'm with you.~
	++ ~I see. Even so, I'm sorry, Imoen. You must stay behind.~ GOTO DD1 // Non-mod epilogue displays (or Aerie friendship if applicable)
	++ ~Excellent, I'm glad you feel this way. Come with me, then. Together we will be unstoppable.~ DO ~SetGlobal("IRTEpAscendedMaiden2","GLOBAL",1)~ GOTO DD2

END
END

//dialogue path if not romanced and you make vanilla solar choices

APPEND IMOEN25J
   
IF ~~ THEN Sol32a
	SAY ~I didn't expect you to stay. I suppose we'll be saying our goodbyes soon enough, then...~
	COPY_TRANS IMOEN25J 20
END

IF ~~ THEN Sol32b
	SAY ~So you're going to stay a mortal? Wow, after all that, we're going to end up on the road again! Must feel good, though, to have your own future ahead of you again, though. No?~ [IMOE2525]
	= ~I mean, if you don't mind me sticking around, still. With... our history an' all. It'll be fun to set our path, for once.~
	COPY_TRANS IMOEN25J 20
END

IF ~~ THEN Sol29a
	SAY ~It'll be strange not traveling with you anymore. Good luck, for what it's worth.~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN Sol29b
	SAY ~Well, Good luck, <CHARNAME>. I'll miss ya... although somehow I just know we'll see each other again. Maybe I'll getcha out of trouble again... ya never know!~ [IMOE2526]
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN Sol29c
	SAY ~Well, I guess it's what I thought you'd do. I'm glad we sorted things out before you left. Good luck, <CHARNAME>. I mean it.~
	COPY_TRANS IMOEN25J 18
END

IF ~~ THEN Sol29d
	SAY ~Well, I guess it's what I thought you'd do. I'm glad we sorted things out before you left. Good luck, <CHARNAME>. I mean it.~
	COPY_TRANS IMOEN25J 20
END
END