/*
Table of contents:
Quarrels
 // First
 // Second
 // Third
Cool down period
 // First
 // Second
 // Third
*/



// There are two types of angry Imoen conversations: full arguments (Quarrels), and small spats where you snapped out of the blue (Cooldowns)
// Every instance where Imoen starts talking to you in a friendly way needs to make sure that
// !Global("IRTQuarrelDue","GLOBAL",1) !Global("IRTCooldownDue","GLOBAL",1) . Interjections to NPCs don't need to do this check.

// Quarrels:
// These happen when the outcome of a previous conversation was as follows:
// IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) SetGlobal("IRTQuarrelDue","GLOBAL",1)
// They are generic arguments kept very vague on purpose so they can be reused whenever you piss her off.


// First (QuarrelCounter = 1)

APPEND IMOEN25J
IF WEIGHT #990 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTQuarrelDue","GLOBAL",1) Global("IRTQuarrelCounter","GLOBAL",1) Global("ImoenRomanceActive","GLOBAL",2)~ THEN Q1
 SAY ~(Imoen barely looks in your direction as you approach her.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",0)~ GOTO Q1N
END

IF ~~ Q1N
 SAY ~I'm still angry with you.~
 ++ ~I don't have a reason to apologize. You are overreacting and I don't deserve to be treated this way.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-2)~ GOTO Quarrel1g
 ++ ~Things got out of control and we said things we didn't really mean. Now is when we forgive each other so we can be happy again. It's just the way it works.~ GOTO Quarrel1f
 ++ ~Please forgive me, my love. I simply don't know what got in my head. It won't happen again.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ GOTO Quarrel1e
 ++ ~I'd rather not argue right now, alright? Let's pretend nothing ever happened.~ GOTO Quarrel1d
 ++ ~That is what I wanted to talk to you about. This just doesn't work. We can't be together, it is only making us unhappy.~ GOTO Quarrel1b
 ++ ~The feeling is mutual. Get out of my sight.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ GOTO Quarrel1a
END

IF ~~ THEN Quarrel1a
 SAY ~(Imoen's eyes widen with ire. She says nothing and steps away from you, huffing as she turns around.)~
 IF ~~ THEN DO ~IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) SetGlobal("IRTQuarrelDue","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b
 SAY ~Well, it's YOU who can't make it work! I've never said anything just to hurt you, never!~
 = ~But hey, fine, if you want to break things off, that's fine by me. I should've known you'd be like this.~
 ++ ~Can't you see, Imoen? It is our personalities. We simply are not compatible.~ GOTO Quarrel1b7
 ++ ~Always so self-centered. You are never to blame for anything, right Imoen? You never see past your own point of view.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-1)~ GOTO Quarrel1b6
 ++ ~I don't want to argue about who did what. I want us to remain friends. We should have never taken our relationship to this point.~ GOTO Quarrel1b5
 ++ ~Maybe you are right. Maybe I haven't tried hard enough.~ GOTO Quarrel1b4
 ++ ~Yes, it's over. Deal with it.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ GOTO Quarrel1b1
END

IF ~~ THEN Quarrel1b1
 SAY ~(Imoen clenches her jaw and appears to be about to start yelling. Then her mouth quirks down at the corner. Her eyes glimmer with held-back tears.)~
 = ~Go screw yourself, <CHARNAME>.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b4
 SAY ~Yeah, maybe that's a remote possibility, how about that.~
 IF ~~ THEN GOTO Quarrel1Fix
END

IF ~~ THEN Quarrel1Fix
 SAY ~(For a moment, she looks at you as if she was thoughtfully evaluating the worth of a piece of new equipment.) I suppose I can maybe forgive you. We... are bound to argue now and then. Though I don't think it should be as one-sided. Sometimes you're *really* mean, <CHARNAME>. It hurts.~
 ++ ~I know. I'm sorry.~ + Q1Fix5
 ++ ~Sometimes everything that's happening gets to me and I lose control. I'll try harder.~ + Q1Fix4
 ++ ~You have to understand, Imoen. In our circumstances, it's hard for me to always treat you with the love you deserve.~ + Q1Fix3
 ++ ~Yes, well, maybe you deserve it sometimes.~ + Q1Fix1
END

IF ~~ THEN Q1Fix1
 SAY ~What? No. Not like that. It's *never* okay to do what you did. I thought you were apologizing to me.~
 ++ ~And I am. I'm sorry.~ + Q1Fix5
 ++ ~I changed my mind. You seem to think you are never at fault.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-1)~ GOTO Quarrel1b6
 ++ ~Forget it! I can't deal with this relationship anymore. Get lost!~ + Quarrel1b1
END

IF ~~ THEN Q1Fix3
 SAY ~I do understand, but what you did to me was too much, regardless of circumstance. But I *do* understand what you say, and that's why I'm being so nice here.~
 IF ~~ THEN GOTO Q1Fix3Next
END

IF ~~ THEN Q1Fix3Next
 SAY ~(Her lips betray the hint of a smile.) I mean, usually you'd have the shape of my boot printed on your arse already. So, all you gotta do is say you're sorry and that it won't happen again. How about that?~
 ++ ~I'm lucky to have someone like you, Imoen. I'm sorry.~ + Q1Fix5
 ++ ~I don't have to take this kind of talk from you. Get lost.~ + Q1Fix3a
 ++ ~You know I'm regretful, and I'll try my best not to treat you like that again. Is that enough?~ + Q1Fix3b
 ++ ~You are being condescending now. You know I hate that.~ + Q1Fix3a
END

IF ~~ THEN Q1Fix3a
 SAY ~UGH. (Imoen throws her hands up in the air.) I give up! Apparently you wanna just treat me like crap and be proud of it! I made it really easy for ya, y'know? I was ready to forgive you, just like that. But no, you have to be an IDIOT. So fine! Have it your way. I'm done with this, and I'm done with you!~
 = ~(With her final word, she spins on her heel and stalks off away from you.)~
 IF ~~ THEN DO ~IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) SetGlobal("IRTQuarrelDue","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Q1Fix3b
 SAY ~Eh. It'll have to do I guess.~
 IF ~~ THEN GOTO Q1Fix5
END

IF ~~ THEN Q1Fix4
 SAY ~I know that, <CHARNAME>. It's the only reason why I'm being so patient about this whole thing.~
 IF ~~ THEN GOTO Q1Fix3Next
END

IF ~~ THEN Q1Fix5
 SAY ~There. (A teasing smirk curves her lips.) It wasn't that much of a sacrifice, was it? Come here... (Imoen hugs you close, her body still a bit tense.)~
 = ~Let's not have this sort of conversation ever again, okay? We'll be one of those couples that never argue and are sugary-sweet all the time from now on. (She kisses your cheek and leaves your side with a relieved smile.)~
 IF ~~ THEN DO ~SetGlobal("ToBMRQuarrel","GLOBAL",0) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b5
 SAY ~(Imoen stares at you with wide eyes.) And that's *it*? That's all you've got, after all the bullshit we went through in Amn? "Oops, it was a mistake, let's be friends!" You *have* to be joking! What, you think I've some kind of switch to flip on or off whenever you decide to just be friends?~
 ++ ~You don't? And here I was thinking you were an automaton, what with you being so terrible in bed and all.~ + Quarrel1b5a
 ++ ~No, I don't think that. I was just hoping to resolve this like adults.~ + Quarrel1b5a
 ++ ~You are being so dramatic. Relationships end all the time. It's not such a big deal.~ + Quarrel1b5a
 ++ ~I won't tolerate you talking to me like this.~ + Quarrel1b5a
 ++ ~Whoa, calm down. I don't give a damn, be upset forever for all I care.~ + Quarrel1b5a
END

IF ~~ THEN Quarrel1b5a
 SAY ~(She shakes her head, disgust and sheer exhaustion on her face.) Y'know what? I'm sick of you. At this point I just wanna throw it all into a pit and pretend it was never there.~
 = ~So come on, march on so we can see this damn thing through. The sooner it's all over, the earlier I can get away from your stupid crap. (Imoen spins around and angrily stalks off.)~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) SetGlobal("IRTImoenDumped","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b6
 SAY ~(She looks at you as if you just said the most ridiculous thing she has ever heard.) What... what are you talking about! Do you even *know* what yer talkin' about? You're just blindly trying to throw the blame on me, hoping to make me doubt myself. Is that it?~
 ++ ~That's exactly it. You have seen right through me.~ + Quarrel1b6a
 ++ ~No, of course not! I'm trying to make you SEE that there's two people in this relationship. It's not always about how wrong I am and how right you are.~ + Quarrel1b6a
 ++ ~Think whatever you want, Imoen. I'm done with this.~ + Quarrel1b1
 ++ ~Truth be told, yes, that's what I was aiming for. It's sort of embarrassing that you called me out like that.~ + Quarrel1b6a
 ++ ~Alright, I'm sorry. You're right, I was too upset and said it just to get back at you.~ + Quarrel1b6a
 ++ ~(Remain silent.)~ + Quarrel1b6a
END

IF ~~ THEN Quarrel1b6a
 SAY ~There are times when I've deserved a snappy comeback, even a mean comment. I'm aware of how annoying I can get, believe it or not. But I'm *absolutely* sure, no doubt at all, that right now all I deserve is a damn apology.~
 = ~So get off your high, condescending, judgmental horse and realize that- that... (Her voice breaks slightly, and she needs a moment to continue.) That you hurt me. That... you're losing me. That we worked real hard to be together like this, and it's all about to come crashing down.~
 ++ ~(Her words strike home, and a sudden rush of emotion tells you how much you don't want this to end. You take Imoen in your arms, squeezing her against your chest.) I'm sorry, Imoen. I'm so sorry. I love you.~ + Quarrel1b6a3
 ++ ~(You know it to be over. It pains you that she must get hurt, but that is simply how break-ups go.) I'm sorry it has come to this, Imoen. I wish things had gone differently. We are simply not made for each other.~ + Quarrel1b6a2
 ++ ~(It gives you pleasure to watch her suffer. You pause to think for a moment, trying to find the words that will hurt her the most.) That is exactly what I want. You are an unbearable burden and I want you gone. I am done using you.~ + Quarrel1b6a1
END

IF ~~ THEN Quarrel1b6a1
 SAY ~(Your sentence takes a moment to sink in. Gradually, her eyes narrow in disgust, her face twisting in a grimace of sheer revulsion. She appears to be more appalled by the unwarranted cruelty than the actual rejection.)~
 IF ~~ THEN GOTO Quarrel1Hatred1
END

IF ~~ THEN Quarrel1Hatred1
 SAY ~I can't believe you'd say something like that just to spite me. (Her voice seethes with anger.) You're pathetic, <CHARNAME>. I feel sorry for you.~
 IF ~~ THEN GOTO Q2Leaving
END

IF ~~ THEN Quarrel1b6a2
 SAY ~(Your sentence takes a moment to sink in. Slowly, she closes her eyes and exhales a soft, trembling sigh. Runaway tears lightly streak down her cheeks. Her voice barely gets past her lips, as if only a frail thread is weaving the words together.)~
 = ~Alright...~
 = ~I... I need to be alone for a while. Excuse me.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",5) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) SetGlobal("IRTBrokeUpTalk","GLOBAL",1) RealSetGlobalTimer("IRTBrokeUpTalkTimer","GLOBAL",900) RunAwayFrom(Player1,30)~ EXIT
END

/* These globals are for a small talk that happens if you approach Imoen 2 minutes after you break up gently. If it's before the time, Imoen just blows you off. They can be found at the bottom of this file. */

IF ~~ THEN Quarrel1b6a3
  SAY ~(She squeezes you tightly, relieved beyond measure. You feel her breathe deeply, allowing release to all her pent up emotions.)~
 = ~I hate all this drama. I really do. (She stays in your embrace for a while before gently pushing away to look at you.)~
 = ~Let's not have any more drama, okay? I'm allergic to it.~
 ++ ~Agreed.~ + Quarrel1b6a3e
 ++ ~No promises here.~ + Quarrel1b6a3d
 ++ ~Only if you agree to the same!~ + Quarrel1b6a3c
 ++ ~I actually like it. It keeps the spark going to shake things up once in a while.~ + Quarrel1b6a3b
 ++ ~You say it as if it's all my fault!~ + Quarrel1b6a3a
END

IF ~~ THEN Quarrel1b6a3a
 SAY ~Of course, it's always your fault. I am completely innocent all the time. Jeez, one would think you'd have learned by now.~
 = ~Ah well, I'm sure you'll get it eventually. One can only hope. (She leans forward to kiss your cheek, and leaves your side with a smile.)~
 IF ~~ THEN DO ~RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b6a3b
 SAY ~Psh. Next time you wanna shake things up, go get manhandled by an ogre and leave me out of it.~
 = ~"I like it," <PRO_HESHE> says. The things you come up with... (She leaves your side while shaking her head.)~
 IF ~~ THEN DO ~RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b6a3c
 SAY ~Easiest deal I ever made. (She leans forward to kiss your cheek and leaves your side with a smile.)~
 IF ~~ THEN DO ~RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b6a3d
 SAY ~Well, ya better try your best, 'cause I won't let you off so easy next time. (She leans forward to kiss your cheek and leaves your side with a smile.)~
 IF ~~ THEN DO ~RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b6a3e
 SAY ~Excellent. Glad to know that we have a deal. (She leans forward to kiss your cheek and leaves your side with a smile.)~
 IF ~~ THEN DO ~RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Quarrel1b7
 SAY ~Hah! And that's it, right? That's all you've got, after all we've been through. "Oh, sorry about all the crazy crap I put you through, it turns out we're not compatible after all!" Well, what a big fat fucking surprise! Why'd'ya think I was so reluctant in the first place?~
 = ~Gosh! How'd you think I'd take this? Please tell me, I'm dying to know - because apparently you think I have a switch I can flip on and off whenever you decide to be just friends!~
 ++ ~You don't? And here I was thinking you were an automaton, what with you being so terrible in bed and all.~ + Quarrel1b5a
 ++ ~I was just hoping we would resolve this like adults.~ + Quarrel1b5a
 ++ ~You are so dramatic. It's not such a big deal.~ + Quarrel1b5a
 ++ ~I won't tolerate your insults.~ + Quarrel1b5a
 ++ ~Whoa, calm down. I don't really give a damn, be upset forever for all I care.~ + Quarrel1b5a
END

IF ~~ THEN Quarrel1d
 SAY ~Oh, that's rich. So I guess now you can say and do anything you please, no matter how obnoxious or insulting, and then pretend it didn't happen.~
 IF ~~ THEN GOTO Quarrel1dNext
END

IF ~~ THEN Quarrel1dNext
 SAY ~Do I get this kind of privilege too? Can I shove a finger in your eye and then expect you to smile about it?~
 ++ ~I'm not asking you to forget about the issue. I'm just asking you to put it aside for a moment because I need your abilities right now.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-3)~ + Quarrel1d6
 ++ ~Look, I'm sorry, alright? Can we get this out of the way already?~ + Quarrel1d5
 ++ ~Whatever, Imoen. If all you want to do is argue, I'll talk to you later.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-3)~ + Quarrel1d4
 ++ ~Alright, alright. I see what you mean. Please accept my apology.~ + Quarrel1d3
 ++ ~You always have to make a huge deal out of things, don't you? I'm tired of your attitude.~ + Quarrel1d2
 ++ ~(You simply frown and walk away.)~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + Quarrel1d1
END

IF ~~ THEN Quarrel1d1
 SAY ~(Her lips curve in a humorless smile.) Yeah, I didn't think so.~
 IF ~~ THEN DO ~IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) SetGlobal("IRTQuarrelDue","GLOBAL",1)~ EXIT
END

IF ~~ THEN Quarrel1d2
 SAY ~Wow, you gotta be kiddin' me. MY attitude? I've always been nice to you; I've never, EVER been harsh for no reason or insulted you just to be hurtful!~
 ++ ~Look, I'm sorry, alright? Can we get this out of the way already?~ + Quarrel1d5
 ++ ~Whatever, Imoen. If all you want to do is argue, I'll talk to you later.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-3)~ + Quarrel1d4
 ++ ~Alright, alright. I see what you mean. Please accept my apology.~ + Quarrel1d3
 ++ ~(You simply frown and walk away.)~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + Quarrel1d1
END

IF ~~ THEN Quarrel1d3
 SAY ~Well, I'm glad you understand what I'm talking about.~
 IF ~~ THEN GOTO Quarrel1Fix
END

IF ~~ THEN Quarrel1d4
 SAY ~Yeah, whatever to you too, <CHARNAME>.~
 IF ~~ THEN DO ~IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) SetGlobal("IRTQuarrelDue","GLOBAL",1)~ EXIT
END

IF ~~ THEN Quarrel1d5
 SAY ~Oh, such a sincere apology! You truly know how to sweet-talk your way out of trouble, dontcha.~
 IF ~~ THEN GOTO Quarrel1Fix
END

IF ~~ THEN Quarrel1d6
 SAY ~(Although quite visibly displeased, Imoen complies.) Sure, <CHARNAME>, use me for whatever you want.~
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",1)~ EXIT
END

IF ~~ THEN Quarrel1e
 SAY ~(Imoen appears genuinely surprised by your approach.)~
 = ~I... um. Well. That's... nice of you to say. Thank you.~
 IF ~~ THEN GOTO Quarrel1Fix
END

IF ~~ THEN Quarrel1f
 SAY ~Wow, thank you *so much* for patronizing me, it really makes me want to forgive everything. You obviously know all about "how things work," how silly of me. I guess I should expect you to say obnoxious and insulting things regularly, so I can forgive you later. Since, you know, that's the way things work.~
 IF ~~ THEN GOTO Quarrel1dNext
END

IF ~~ Quarrel1g
 SAY ~You... are kidding me, right? Please tell me you're kidding me, because apparently you can say and do anything you want, no matter how obnoxious or insulting, and then pretend it didn't happen.~
 IF ~~ THEN GOTO Quarrel1dNext
END


// Second (QuarrelCounter = 2)

IF WEIGHT #990 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTQuarrelDue","GLOBAL",1) Global("IRTQuarrelCounter","GLOBAL",2) Global("ImoenRomanceActive","GLOBAL",2)~ THEN Q2
 SAY ~(Imoen stares straight ahead as you approach her.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",0)~ GOTO Q2N
END

IF ~~ Q2N
 SAY ~I can't even look at you right now.~
 ++ ~Never mind that, I had some questions for you.~ + Q2ShoveIt
 ++ ~I am so sorry, Imoen. I don't know what got into me. Please forgive me.~ + Q2Beg
 ++ ~I did nothing wrong. You are overreacting, as usual.~ + Q2g
 ++ ~The feeling is mutual. I wanted to make sure you understood that it's over between us.~ + Q2Over
 ++ ~Whatever. (Walk away.)~ + Q2Loop
END

IF ~~ Q2Loop
 SAY ~Right back at you.~
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",1)~ EXIT
END

IF ~~ Q2Over
 SAY ~Oh, I understand. I understand everything now. Crystal-fucking-clear.~
 = ~I don't want to ever talk to you again.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300)~ EXIT
END

IF ~~ Q2ShoveIt
 SAY ~Take your damn questions and shove them up your backside, okay?~
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ Q2Beg
 SAY ~(She glances at you, resentment in her eyes.) We've been here before. You say that, and I want to listen to you, and that makes me feel like a chump.~
 = ~I get that couples argue from time to time, but this isn't like that. It's like... like you *wanted* to hurt me. And I can't help thinking, if I forgive you, will I get burned the same way again? I don't even know if I can go back to the way things were.~
 = ~What do you say to that? And don't you feed me more crap, <CHARNAME>. Just say what you feel. I need the damn truth.~
 ++ ~I feel horrible. I lost control. All I can do is ask for your forgiveness.~ + Q2B4
 ++ ~I feel I will probably hurt you again, even if I don't mean to. You should stay away from me.~ + Q2B3
 ++ ~I said I was sorry! What more do you want from me?~ + Q2B2
 ++ ~The truth? I'm honestly tired of this. This relationship doesn't work.~ + Q2B1
END

IF ~~ Q2B1
 SAY ~It very well *could*, if you'd just- (Imoen makes an effort to restrain her sudden bout of anger. She speaks after a few deep, controlled breaths.)~
 = ~I am very, very frustrated right now. I agree with what you just said, and it's over between us. Okay?~
 IF ~~ THEN GOTO Q2BreakUpEnd
END

IF ~~ Q2BreakUpEnd
 SAY ~Please leave me alone for a while.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",5) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) SetGlobal("IRTBrokeUpTalk","GLOBAL",1) RealSetGlobalTimer("IRTBrokeUpTalkTimer","GLOBAL",900) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ Q2B2
 SAY ~Oh, really? You're gonna go with that? Fine, here's a list of what I want - it's a short one! How about some respect? How about knowing you're not going to suddenly stab me in the chest for no reason? I think that's pretty basic, don't you? Feeling *safe* with the person you love?~
 = ~Gosh! (She brings her hands to her face, first pressing fingers to her forehead, then forcefully pushing her hair back.) I- I can't believe I'm even having this conversation. Where'd we go wrong? This was supposed to be...~
 = ~(Her brow knits. Her eyes water.) This isn't what I wanted. I... don't want to do this anymore.~
 ++ ~Whoa, whoa, let's back up. I'm sorry for what I did, Imoen.~ + Q2B2Answer
 ++ ~About time one of us said it out loud.~ + Q2B2Answer
 ++ ~If that's what you want, there is nothing I can say.~ + Q2B2Answer
 ++ ~You're just a weak coward.~ + Q2B2Answer
END

IF ~~ Q2B2Answer
 SAY ~(Imoen is shaking her head.) It's over, <CHARNAME>. It's over.~
 IF ~~ THEN GOTO Q2BreakUpEnd
END

IF ~~ Q2B3
 SAY ~(Imoen closes her eyes and remains still for a while. Finally, she nods in acceptance.)~
 = ~I should've seen it. We should've known.~
 = ~It's... over, then. It's over.~
 IF ~~ THEN GOTO Q2BreakUpEnd
END

IF ~~ Q2B4
 SAY ~(Imoen closes her eyes and remains still for a while. Finally, she nods in acceptance.)~
 = ~I can't just... flip a switch and stop loving you. Promise me we won't have this conversation again, <CHARNAME>.~
 ++ ~I promise.~ + Q2B4b
 ++ ~You know I can't make that promise. I'll do my best - that, I promise.~ + Q2B4a
 ++ ~I will not be humiliated like this.~ + Q1Fix3a
END

IF ~~ Q2B4a
 SAY ~(She eyes you evenly, lips pursed. A moment later she rolls her eyes.)~
 = ~Well then, one way or another, next time will be the last. Understand? I won't be abused. I've had enough of that in my life already.~
 IF ~~ THEN GOTO Q2B4Exit
END

IF ~~ Q2B4Exit
 SAY ~C'mon, let's take care of whatever we're trying to accomplish now.~
 IF ~~ THEN EXIT
END

IF ~~ Q2B4b
 SAY ~(She eyes you evenly, lips pursed. A moment later she exhales her held breath.)~
 = ~Then I forgive you. But if you abuse me again...~
 = ~I won't be abused, do you understand? I've had enough of that in my life already.~
 IF ~~ THEN GOTO Q2B4Exit
END

IF ~~ Q2g
 SAY ~(Imoen blinks in disbelief.)~
 = ~How... how *dare* you?~
 = ~I can't even explain how hurtful you were to me. How hard is this to understand? Do I need to spell it out for you? Maybe I should make you a diagram, or compose a song with a catchy tune and very simple lyrics clearly explaining just how much of a jerk you were.~
 = ~Y'know what? I'm tired. This isn't the first time, and I'm just tired of this nonsense. How am I supposed to take this? Please tell me - go ahead and tell me, why the Hell should I even *try* after hearing what you just said?~
 ++ ~Maybe you shouldn't. I really don't care.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-10)~ + Q2gN5
 ++ ~How about, just this once, you admit you are at fault here?~ + Q2gN4
 ++ ~There you go again, blowing things way out of proportion. Am I expected to grovel at your feet for forgiveness after every single mistake I make?~ + Q2gN3
 ++ ~Hold on, hold on. I spoke too soon and let my pride get the best of me. Let's start over. I didn't mean what I just said.~ + Q2gN2
 ++ ~Oh, give me a break. Poor Imoen, always having to put up with mean, mean <CHARNAME>. I'm so sorry I didn't treat you like a princess while fighting for my life every damn minute!~ + Q2gN1
END

IF ~~ THEN Q2gN1
 SAY ~Oh no, <PRO_SIRMAAM>! You don't get to play the "I'm too stressed" card on me. Dammit, <CHARNAME>, I'm not asking for a freakin' palace and manservant here! All I want is to hear you say that you're sorry.~
 = ~I get it, okay? I get that you're dealing with all sorts of crap all the damn time, but that doesn't mean you get to treat me like dirt while I sing your praises and rub your grubby feet!~
 = ~I'm sick of these up and downs, honestly. Look at us. Look at what we've become. We made a mistake along the way. We were better off before, without this... thing between us. I can't take it anymore.~
 IF ~~ THEN GOTO Q2FrN
END

IF ~~ THEN Q2gN2
 SAY ~(She purses her lips for a moment.) Fine, alright. I'll take your word on that. Go ahead, start over.~
 ++ ~I am so sorry, Imoen. I don't know what got into me. Please forgive me.~ + Q2Beg
 ++ ~What I meant to say is that you and I should break up. It's clearly not working.~ + Q2B1
 ++ ~What I meant is that you are an obnoxious little harlot and I hate everything about you.~ + Q2Lolz
 END

 IF ~~ Q2Lolz
 SAY ~(Imoen's eyes widen as you speak. Her cheeks turn an angry shade of crimson.)~
 = ~Go fuck yourself, <CHARNAME>.~
 IF ~~ THEN GOTO Q2Leaving
 END

IF ~~ THEN Q2gN3
 SAY ~No, dammit! I'm not asking for a freakin' oath of fealty here! All I want is to hear you say that you're sorry! Is that really too much to ask, a half-assed apology?~
 = ~I get it, okay? I get that you're a proud <PRO_MANWOMAN> and that you don't wanna show weakness and all that dumb nonsense. But that doesn't mean you get to treat me like dirt while I sing your praises and rub your grubby feet!~
 = ~I'm sick of all of it, honestly. Look at us. Look at what we've become. We weren't like this before. We were better off before we got involved. I can't take it anymore.~
 IF ~~ THEN GOTO Q2FrN
END

IF ~~ THEN Q2gN4
 SAY ~*I'm* at fault? (She looks about to start yelling, but at the last moment she presses her lips together and exhales a deep breath.)~
 = ~I'm done, <CHARNAME>. I'm done trying to get through to you. I'm done fighting that brick wall inside your head, and I'm done being treated like dirt, putting up with this nonsense and getting nothing out of it.~
 = ~Look at us, look at what we've become. We made a mistake along the way. We were better off before we got involved like this. This is not what I want in a relationship, and I'd wager you're not terribly happy either.~
 IF ~~ THEN GOTO Q2FrN
END

IF ~~ THEN Q2gN5
 SAY ~(She stares for a moment before looking away in disgust.) That's... great. That's just great.~
 = ~(Shaking her head in utter disbelief, Imoen walks away from you.)~
 IF ~~ THEN DO ~IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) SetGlobal("IRTQuarrelDue","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ THEN Q2FrN
 SAY ~Look, I'm all for sticking around and seeing this mess to the end, but I'm done here, with our... "thing". It's only making us unhappy now. We can be adults about it and just accept things like they are.~
 = ~I'm ready to pretend it never happened. I'll just stay to help out if you'll have me.~
 ++ ~Whoa, hold on! We can make it work, we just need to try harder!~ + Q2Friends4
 ++ ~It's painful, but true. I'm glad we can be civil about this.~ + Q2Friends3
 ++ ~You can stay if you keep quiet, and I'll use you for as long as I need your abilities.~ + Q2Friends2
 ++ ~I can't have you around me anymore then. Leave, and I hope we never meet again.~ + Q2Friends1
END

IF ~~ THEN Q2Friends1
 SAY ~(Even in her anger, Imoen seems to deflate at your words. Hopelessness and acceptance shroud her voice.)~
 = ~Then... good bye, and good luck. You'll probably need it.~
 IF ~~ THEN GOTO Q2Leaving
END
END

CHAIN IMOEN25J Q2Leaving
~(She looks around with determination, as if looking for something that isn't there.)~
== IMOEN25J IF ~!AreaCheck("AR4500") InParty("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~(With a meaningful last glance at Aerie, she simply turns around, leaving your company. Soon she makes use of her magic to disappear from your life forever.)~ DO ~LeaveParty() EscapeArea() SetGlobal("IRTAerieImoenLeft","GLOBAL",1)~
== IMOEN25J IF ~!AreaCheck("AR4500") !InParty("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~(She turns around and walks away, leaving your company. Soon she makes use of her magic to disappear from your life forever.)~ DO ~LeaveParty() EscapeArea() SetGlobal("IRTAerieImoenLeft","GLOBAL",1)~
== IMOEN25J IF ~!AreaCheck("AR4500") !GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~(She turns around and walks away, leaving your company. Soon she makes use of her magic to disappear from your life forever.)~ DO ~LeaveParty() EscapeArea()~

== IMOEN25J IF ~AreaCheck("AR4500") InParty("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~(With a meaningful last glance at Aerie, she simply turns around, leaving your company. Soon she makes use of her magic to disappear from your life forever.)~ DO ~SetGlobal("IRTAerieImoenLeft","GLOBAL",1) StartCutSceneMode() LeaveParty() GivePartyAllEquipment() RunAwayFrom(Player1,30) FaceObject(Player1) CreateVisualEffectObject("SPGRWHRL","Imoen2") PlaySound("EFF_M28") Wait(1) DestroySelf() EndCutSceneMode()~
== IMOEN25J IF ~AreaCheck("AR4500") !InParty("Aerie") GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~(She turns around and walks away, leaving your company. Soon she makes use of her magic to disappear from your life forever.)~ DO ~SetGlobal("IRTAerieImoenLeft","GLOBAL",1) StartCutSceneMode() LeaveParty() GivePartyAllEquipment() RunAwayFrom(Player1,30) FaceObject(Player1) CreateVisualEffectObject("SPGRWHRL","Imoen2") PlaySound("EFF_M28") Wait(1) DestroySelf() EndCutSceneMode()~
== IMOEN25J IF ~AreaCheck("AR4500") !GlobalGT("IRTAerImFriend","GLOBAL",0)~ THEN ~(She turns around and walks away, leaving your company. Soon she makes use of her magic to disappear from your life forever.)~ DO ~StartCutSceneMode() LeaveParty() GivePartyAllEquipment() RunAwayFrom(Player1,30) FaceObject(Player1) CreateVisualEffectObject("SPGRWHRL","Imoen2") PlaySound("EFF_M28") Wait(1) DestroySelf() EndCutSceneMode()~
EXIT

APPEND IMOEN25J
IF ~~ THEN Q2Friends2
 SAY ~(Hopelessness and acceptance shroud her voice.) As you wish. I'll be damned if I don't see this Bhaalspawn issue through. March on then, leader.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1)RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300)~ EXIT
END

IF ~~ THEN Q2Friends3
 SAY ~(She sighs heavily.) Me too, I guess. Gotta admit, I was afraid this would blow up in our faces. Well, it kinda did, but I mean, REALLY blow up, with us ending up hating each other. I really didn't want that, y'know, despite it all. It'll be weird for a while, but hopefully we'll be back to normal in no time.~
 = ~And hey, I'll be damned if I don't see this Bhaalspawn issue through. March on forward, oh leader.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",5) SetGlobal("IRTImoenDumped","GLOBAL",1)RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300)~ EXIT
END

IF ~~ THEN Q2Friends4
 SAY ~(Imoen shakes her head, saddened but resolute.) No, <CHARNAME>. Can't you see it? I've been having these thoughts about us for a while now. We just don't work. There's nothing else to it.~
 = ~Let's just go back to the old days, have fond memories of the good times, and keep going. Let's not make a huge thing of it and move on, please.~
 ++ ~I'm appalled you're even suggesting this! It's just an argument. We can work through it.~ + Q2Friends4a
 ++ ~Alright. It's painful but true. I'm glad we can be civil about this.~ + Q2Friends3
 ++ ~Fine! You can stay if you wish, but only if you keep quiet. I'll use you for as long as I need your abilities.~ + Q2Friends2
 ++ ~This is an outrage. I can't have you around me like this. Leave, and I hope we never meet again.~ + Q2Friends1
END

IF ~~ THEN Q2Friends4a
 SAY ~It isn't just an argument! I just don't *feel it* anymore, okay? I'm exhausted, and I've made up my mind. I was happier before, when we weren't involved like this. I'm sorry, I really am, for everything... but it's over.~
 = ~I'll understand if you don't want me around anymore. I do hope we can eventually go back to bein' the friends we used to be, though.~
 ++ ~I refuse to let you go. I love you, Imoen.~ + Q2Friends4a1
 ++ ~I'll respect your wishes, then. I'm glad we can be civil about this.~ + Q2Friends3
 ++ ~Fine! You can stay if you wish, but only if you keep quiet. I'll use you for as long as I need your abilities.~ + Q2Friends2
 ++ ~I can't believe you are telling me this. I won't have you around me anymore, not like this! Leave, and I hope we never meet again.~ + Q2Friends1
END

IF ~~ THEN Q2Friends4a1
 SAY ~(Frustration and worry furrow her brow.) Well, then... I guess I should leave. It'll be the best thing for everyone.~
 ++ ~No! I won't let you!~ + Q2Friends1
 ++ ~No, please, don't. I need you by my side. I'll respect your wishes; I'd rather have you as a friend, if nothing else.~ + Q2Friends3
 ++ ~Fine! You can stay if you wish, but only if you keep quiet. I'll use you for as long as I need your abilities.~ + Q2Friends2
 ++ ~I can't believe you are telling me this. I won't have you around me anymore, not like this! Leave, and I hope we never meet again.~ + Q2Friends1
END


// Third (QuarrelCounter = 3)


IF WEIGHT #990 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTQuarrelDue","GLOBAL",1) Global("IRTQuarrelCounter","GLOBAL",3) Global("ImoenRomanceActive","GLOBAL",2)~ THEN Q2
 SAY ~(Imoen stares daggers at you as you approach.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",0)~ GOTO Q3N
END

IF ~~ Q3N
 SAY ~Don't say a damn word. I knew this would happen, I *knew* it.~
 ++ ~(Remain quiet, contrite.)~ + Q3Quiet
 ++ ~(Remain quiet, defiant.)~ + Q3Quiet
 ++ ~I am so sorry, Imoen...~ + Q3Sorry
 ++ ~And yet you stuck around anyway. You can't get enough of this, can you. You *like it* when I abuse you.~ + Q3Abuse
 ++ ~Just get over it, I have questions for you.~ + Q3Qs
END

IF ~~ Q3Quiet
 SAY ~I was stupid enough to stick around, but I was just an idiot trying to make things work. Well, not anymore. I'm *done*, okay? It's over. So you can take your abuse and shove it.~
 ++ ~Do you really think I *want* to hurt you? Sometimes the beast escapes my control, and I say something I regret. I thought you of all people would understand.~ + Q3Understand
 ++ ~I understand. I hope we can still be friends.~ + Q3Friends
 ++ ~Get out of my sight, then. I am done with you.~ + Q3Leave
 ++ ~As long as I can still use you, I don't give a damn.~ + Q3Use
END

IF ~~ Q3Understand
 SAY ~(Her features darken beneath a bleak frown.) You're so full of shit. Do you *really* think I can't tell the difference? It's all *you*, <CHARNAME>. I'm done listening to your crap.~
 = ~Now please just leave me alone. I'll stick around, see this mess through, and then I'm gone.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300)~ EXIT
END

IF ~~ Q3Friends
 SAY ~I can't even think about that right now. Just... just leave me alone for a while.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",5) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) SetGlobal("IRTBrokeUpTalk","GLOBAL",1)RealSetGlobalTimer("IRTBrokeUpTalkTimer","GLOBAL",900)  RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ Q3Leave
 SAY ~(Imoen visibly holds back the tears.) That suits me just fine.~
 IF ~~ THEN GOTO Q2Leaving
END

IF ~~ Q3Use
 SAY ~(Imoen's teary eyes sink beneath a dark frown.)~
 = ~Go fuck yourself, <CHARNAME>.~
 IF ~~ THEN GOTO Q2Leaving
END

IF ~~ Q3Sorry
 SAY ~No, I don't wanna hear it! You're so full of shit, I'm just *done*, okay? I can't do this anymore. You hurt me for the last time.~
 = ~Please just leave me alone. I'll stick around, see this mess through, and then I'm gone.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300)~ EXIT
END

IF ~~ Q3Abuse
 SAY ~Are you *insane*? I stuck around because at some point I was dumb enough to fall in love with you! I'm done getting hurt, you hear me? Get away from me.~
 = ~It's over. Leave me alone.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) SetGlobal("IRTImoenDumped","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ Q3Qs
 SAY ~I'm not answering any of your stupid questions - I'm not ever talking to you, ever again! I'm done with you, it's over, OVER!~
 = ~(Imoen turns on her heel and stalks off.)~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) RunAwayFrom(Player1,30)~ EXIT
END
END








// Cool Down period

// Sometimes if you snap at Imoen, she will give you some time to cool off. These are the short conversations that happen afterwards, when you initiate dialogue with her.

// First (IRTCooldownCounter = 1)

APPEND IMOEN25J
IF WEIGHT #-500 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTCooldownDue","GLOBAL",1) Global("IRTCooldownCounter","GLOBAL",1)~ THEN CD1
 SAY ~(Imoen eyes you warily.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTCooldownDue","GLOBAL",0)~ GOTO CD1N
END

IF ~~ CD1N
 SAY ~Are you done yellin' at me?~
 ++ ~I'm sorry, Imoen. I didn't mean to snap at you.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + CD1Sorry
 ++ ~No, I'm not done! You keep getting on my nerves, and I'm sick of it!~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-5)~ + CD1Sick
 ++ ~(Gentle and contrite, you pull her into a hug, letting your actions speak for themselves.)~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + CD1Hug
 ++ ~I was too stressed at the time. I'm glad you didn't overreact.~ DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",1)~ + CD1Stressed
 ++ ~I don't know what you're talking about. I just wanted to ask some questions.~ + CD1Qs
END

IF ~~ CD1Sick
 SAY ~B- but I didn't *do* anything! What the Hell got into you?~
 = ~Are you... are you breaking up with me?~
 ++ ~Yes. I can't do this anymore. It's over, Imoen.~ + CD1BreakUp
 ++ ~No. I simply need some time alone. Don't bother me for a while.~ + CD1Sick2
 ++ ~No... no, I'm just frustrated with everything. I might have unfairly taken it out on you.~ + CD1Sick1
END

IF ~~ CD1Sick1
 SAY ~Yeah. I'd say.~
 = ~At least you caught yourself. I know yer going through a lot right now, but I'd rather not become your punching bag.~
 = ~So... glad that's settled, I guess.~
 IF ~~ THEN EXIT
END

IF ~~ CD1Sick2
 SAY ~I... I guess I can do that. I don't really get it, but... okay.~
 = ~Hope you figure it out, whatever it is.~
 IF ~~ THEN EXIT
END

IF ~~ CD1BreakUp
 SAY ~Wow. I... wow.~
 = ~You're dumping me. Really? This isn't some sort of elaborate, twisted prank, is it?~
 ++ ~I'm afraid not.~ + CD1BreakUpEnd
 ++ ~Hahaha, you're such a gullible fool! Of course it's a prank. I'd sooner cut off my own arm than do without you.~ + CD1Prank
END

IF ~~ CD1Prank
 SAY ~(Imoen's mouth falls open as you speak. Her distraught expression becomes a strange mix of outrage and wonder.)~
 = ~You are *the worst*! (She batters your shoulder with tiny punches.) I was about to start crying! This is the meanest thing you've *ever* done, you jerk!~
 = ~Oh Gods. I'm *so* getting you back for this. You will regret this day, <PRO_SIRMAAM>. Mark my words, you *will* regret this!~
 = ~(She looks about to stalk off, but then abruptly leans in and plants a forceful kiss on your mouth.)~
 = ~(Imoen looks into your eyes, brow raised and lips squirming with restrained laughter.) You *will* regret it.~
 IF ~~ THEN EXIT
END

IF ~~ CD1BreakUpEnd
 SAY ~Wow. That's... great. That's just great.~
 = ~(Imoen takes a moment to let your words sink in. Slowly, she closes her eyes and exhales a soft, trembling sigh. Her voice barely gets past her lips, as if only a frail thread is weaving the words together.)~
 = ~Alright...~
 = ~I won't even ask why. I'm just going to...~
 = ~I... I need to be alone for a while. Excuse me.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",5) SetGlobal("IRTImoenDumped","GLOBAL",1) SetGlobal("IRTBrokeUpTalk","GLOBAL",1)RealSetGlobalTimer("IRTBrokeUpTalkTimer","GLOBAL",900)  RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ CD1Qs
 SAY ~Really? You don't know? 'Cause you were pretty mean to me.~
 = ~At least you seem to have calmed down. Go ahead and ask your questions, I guess.~
 IF ~~ THEN EXIT
END

IF ~~ CD1Stressed
 SAY ~N- no, I try not to take it personal. I know you're going through a lot. Don't make a habit out of it, though!~
 = ~Glad yer feeling better. (Imoen squeezes your hand and parts with a friendly smile.)~
 IF ~~ THEN EXIT
END

IF ~~ CD1Hug
 SAY ~(She is tense at first, but soon she relaxes into the familiarity of your embrace.)~
 = ~Hey, it's alright. I get it. Everyone loses it now and then, and yer going through a lot.~
 = ~Just don't make a habit out of it, huh? Glad you came to yer senses. (Imoen squeezes your hand and parts with a friendly smile.)~
 IF ~~ THEN EXIT
END

IF ~~ CD1Sorry
 SAY ~Hey, it's alright, no big deal. Everyone loses it now and then. Just don't make a habit out of it, huh?~
 = ~Glad you came to yer senses. (Imoen squeezes your hand and parts with a friendly smile.)~
 IF ~~ THEN EXIT
END
END




// Second (IRTCooldownCounter = 2)

APPEND IMOEN25J
IF WEIGHT #-500 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTCooldownDue","GLOBAL",1) Global("IRTCooldownCounter","GLOBAL",2)~ THEN CD2
 SAY ~(Imoen eyes you with pursed lips.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTCooldownDue","GLOBAL",0)~ GOTO CD2N
END

IF ~~ CD2N
 SAY ~Better if you stay away if you're going to yell at me again...~
 ++ ~I'm very sorry, Imoen. I don't know what got into me.~ + CD2Sorry
 ++ ~Sometimes I let the pressure get to me. So much rides on my shoulders. You understand, don't you?~ + CD2Silent
 ++ ~(You gently take her hand and kiss it, silently letting her know that you're not proud of your actions.)~ + CD2Silent
 ++ ~Never mind that. I need some questions answered.~ + CD2Qs
 ++ ~I do and say as I please. (Put on your tinted spectacles.) Deal with it.~ + CD2Abuse
END

IF ~~ CD2Abuse
 SAY ~Um. No, that's... not how it works. You can't just abuse me for no reason whenever you like. I won't put up with that.~
 = ~It's fine to lose your temper sometimes, everyone gets a pass now and then - especially you, with all the crap yer dealing with. But you better damn well apologize after.~
 = ~And will you take those things off? You look ridiculous.~
 ++ ~(Shove your hand in front of her face.) Talk to the hand, bitch.~ + CD2Abuse3
 ++ ~Alright, fine. I'm sorry.~ + CD2Abuse2
 ++ ~I don't have to listen to this. Get moving already.~ + CD2Abuse1
END

IF ~~ CD2Abuse1
 SAY ~(Imoen stares at you for a moment.)~
 = ~You know, you can be a real jerk sometimes.~
 IF ~~ THEN DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-3)~ EXIT
END

IF ~~ CD2Abuse2
 SAY ~Ah, see? A half-assed apology is all I was asking for. Now we can keep going as if nothing ever happened, isn't that great?~
 IF ~~ THEN EXIT
END

IF ~~ CD2Abuse3
 SAY ~Uuuuurgh! You're impossible sometimes! I'm trying to be serious here!~
 = ~Well, you know the deal, either way. Acting like a jackass won't save you next time, <PRO_SIRMAAM>.~
 IF ~~ THEN EXIT
END

IF ~~ CD2Qs
 SAY ~Wow. You're not even gonna say you're sorry for being a jerk?~
 ++ ~No, didn't plan to. We have far more important problems right now. About those questions...~ + CD2Abuse1
 ++ ~Alright, fine. I'm sorry for being a jerk, Imoen.~ + CD2Abuse2
 ++ ~What are you even talking about? I have nothing to apologize for.~ + CD2Qs1
END

IF ~~ CD2Qs1
 SAY ~What? You snapped at me! You were nasty.~
 ++ ~Oh, that. Alright, fine. I'm sorry.~ + CD2Abuse2
 ++ ~Do I need to treat you with kid gloves now? I thought you were tough enough to take it.~ + CD2Abuse1
 ++ ~Yeah, whatever, I don't care. Drop the issue already, there is something I want to know.~ + CD2Abuse1
END

IF ~~ CD2Silent
 SAY ~(She looks skeptical to begin with, but soon she's rolling her eyes.) I forgive you, doofus. You get angry sometimes. I probably would too if I were in your shoes. I get it.~
 = ~Though, y'know... next time, just say you're not in the mood to talk. I'll leave you alone, no questions asked, no hard feelings.~
 IF ~~ THEN GOTO CD2SorryN
END

IF ~~ CD2Sorry
 SAY ~(She gives you a half-smile.) It's all the stuff happening around us, dummy. I try not to take it personally. I'd probably blow up all the time if I were in your shoes.~
 = ~Though, y'know... I really don't want this to become a thing. I'd love it if you just let me know. Tell me yer not in the mood and I'll leave you alone, no questions asked, no hard feelings.~
 IF ~~ THEN GOTO CD2SorryN
END

IF ~~ CD2SorryN
 SAY ~I mean... you can't expect me to just take the abuse indefinitely, right?~
 ++ ~Right. I knew you'd understand. You're wonderful, Imoen.~ + CD2Won
 ++ ~Sometimes I won't be able to hold back. Just remember it's not really about you.~ + CD2NotYou
 ++ ~You're patronizing me now. I hate that.~ + CD2Pat
 ++ ~Fine, whatever.~ + CD2Abuse1
END

IF ~~ CD2Pat
 SAY ~Patronizing? I'm just letting you know where I stand with this stuff! I thought I was being real sweet about it, what with you yelling at me for no reason at all.~
 = ~But hey, fine, whatever. You know the deal now. Let's keep going, I guess.~
 IF ~~ THEN DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-1)~ EXIT
END

IF ~~ CD2NotYou
 SAY ~Eugh... that's easier said than done, y'know. You can't just take out your frustrations on me whenever you like. I think I'm being real sweet about this, all things considered.~
 = ~So... yeah. Try harder, maybe. It's not that hard not to be nasty to the person you love, I think.~
 IF ~~ THEN EXIT
END

IF ~~ CD2Won
 SAY ~Why, thank you! About time someone noticed. (She lands a sweet peck on your cheek.)~
 = ~Now, we better not have this conversation again. I'll be very upset and frown a lot.~
 IF ~~ THEN EXIT
END
END

// Third (IRTCooldownCounter = 3)

APPEND IMOEN25J
IF WEIGHT #-500 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTCooldownDue","GLOBAL",1) Global("IRTCooldownCounter","GLOBAL",3)~ THEN CD3
 SAY ~(Imoen glowers at you as you approach.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTCooldownDue","GLOBAL",0)~ GOTO CD3N
END

IF ~~ CD3N
 SAY ~You did it again. I thought you were done being nasty to me.~
 ++ ~Imoen, please forgive me. I wish I hadn't talked to you like that.~ + CD3Sorry
 ++ ~(Reach for her hand and bring her into a contrite embrace.)~ + CD3Silent
 ++ ~Things haven't changed. I'm still incredibly stressed and sometimes I lose my temper.~ + CD3Temper
 ++ ~Yeah. You'd think you'd have taken the hint by now.~ + CD3Hint
 ++ ~You're such a crybaby. Get over it already.~ + CD3Cry
END

IF ~~ CD3Cry
 SAY ~Whoa. Whoa, no, I don't think so. I'm not putting up with this crap.~
 = ~I'm done talking to you.~
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",1) IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ CD3Hint
 SAY ~Taken the hint? What the Hell do you mean by that?~
 = ~Are you... are you breaking up with me?~
 ++ ~Ding ding ding! The moron finally got it!~ + CD3Hint3
 ++ ~Yes. I can't do this anymore. It's over, Imoen.~ + CD1BreakUp
 ++ ~No. I simply need some time alone. Don't bother me for a while.~ + CD3Hint2
 ++ ~No... no, I'm just frustrated with everything. I think I've been unfairly taking it out on you.~ + CD3Hint1
END

IF ~~ CD3Hint1
 SAY ~(Imoen looks relieved.) Well, about time you realized that. I was pretty clear about it before, I thought.~
 = ~(Lips pressed together, she draws close and puts her arms around your waist.) I love you, <CHARNAME>. We've been happy before. I'd like to get back to that.~
 = ~It should be easier once all this Bhaal crap is over with. Can't wait 'til we take care of it...~
 IF ~~ THEN EXIT
END

IF ~~ CD3Hint2
 SAY ~Oh. So... you're only kind of fed up with me. That's... encouraging.~
 = ~Fine, I'll leave you alone, I guess. I better... I better take some time to think, too.~
 IF ~~ THEN DO ~IncrementGlobal("IRTLoveMeter","GLOBAL",-3) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ CD3Hint3
 SAY ~(Imoen looks at you as if she just watched you punch a baby.)~
 = ~Wow. Just... wow. I don't even... I can't believe this. You're breaking up with me like *this*?~
 = ~You're the biggest jerk to ever walk Faerun, <CHARNAME>. Go fuck yourself.~
 IF ~~ THEN DO ~SetGlobal("ImoenRomanceActive","GLOBAL",3) SetGlobal("IRTImoenDumped","GLOBAL",1) RealSetGlobalTimer("IRTAerieComfortTimer","GLOBAL",300) RunAwayFrom(Player1,30)~ EXIT
END

IF ~~ CD3Temper
 SAY ~Yeah, well, maybe not lose it at *me*, though? I'm supposed to be the person you love and trust, not another enemy to berate. I can't let you just keep yelling at me...~
 ++ ~It's all I can do sometimes not to go on a murderous rampage. You've no idea what it's like to walk in my shoes.~ + CD3Temper2
 ++ ~I'm sorry. I can do better. Give me another chance.~ + CD3Sorry
 ++ ~It's the way it is. Toughen up and deal with it.~ + CD3Cry
 ++ ~I can't help it. Just try to hold on until all of this is over. Can you do that for me?~ + CD3Temper1
END

IF ~~ CD3Temper1
 SAY ~(Imoen looks into your eyes. Tears glint on hers.) I... I guess. I can try.~
 = ~Yeah. I can try.~
 IF ~~ THEN GOTO CD3Go
END

IF ~~ CD3Go
 SAY ~We better get going...~
 IF ~~ THEN EXIT
END

IF ~~ CD3Temper2
 SAY ~Yeah, okay. The more you say that, the more it sounds like an excuse to get away with whatever the Hell you want.~
 = ~I don't know if you're even trying anymore. But if you are, I think it's time to try *harder*.~
 IF ~~ THEN GOTO CD3Go
END

IF ~~ CD3Silent
 SAY ~(She withdraws her hand and stays put.) No. No, I can't just let it go like that.~
 IF ~~ THEN GOTO CD3Sorry
END

IF ~~ CD3Sorry
 SAY ~It's getting silly now. How many times do we have to go back and forth like this? Are you even trying to be civil anymore?~
 ++ ~It's all I can do sometimes not to go on a murderous rampage. You've no idea what it's like to walk in my shoes.~ + CD3Temper2
 ++ ~Of course I'm trying, my love. It's just difficult. Please try to understand.~ + CD3Sorry1
 ++ ~You know what? I'm done apologizing. This is the way it is. Toughen up and deal with it.~ + CD3Cry
 ++ ~I can't control the anger sometimes. Just try to hold on until all of this is over. Can you do that for me?~ + CD3Temper1
END

IF ~~ CD3Sorry1
 SAY ~I try, I *do* try, but I can take only so much. Would you stick around to be abused, if you were in my place? I don't think so...~
 = ~(She shakes her head.) I love you, <CHARNAME>... but if you keep doing this to me, not even that will matter.~
 IF ~~ THEN GOTO CD3Go
END
END

// Fourth ( IRTCooldownCounter = 4 )
// Imoen just acts super hurt and it just leads to a full Quarrel

APPEND IMOEN25J
IF WEIGHT #-500 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTCooldownDue","GLOBAL",1) Global("IRTCooldownCounter","GLOBAL",4)~ THEN CD4
 SAY ~(Imoen doesn't look up from the ground when you try to get her attention.)~ [ IRQUIET ]
 IF ~~ THEN DO ~SetGlobal("IRTCooldownDue","GLOBAL",0)~ GOTO CD4N
END

IF ~~ CD4N
 SAY ~I can't do this anymore...~
 IF ~~ THEN DO ~SetGlobal("IRTQuarrelDue","GLOBAL",1) IncrementGlobal("IRTQuarrelCounter","GLOBAL",1) RunAwayFrom(Player1,30)~ EXIT
END



// ~~ Talking after you break up with her during a quarrel ~~

IF WEIGHT #999 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTBrokeUpTalk","GLOBAL",1) !RealGlobalTimerExpired("IRTBrokeUpTalkTimer","GLOBAL")~ THEN QBrokeUpEarly
 SAY ~(Imoen shakes her head and gets away from you.)~
 IF ~~ THEN DO ~RunAwayFrom(Player1,30)~ EXIT
END 

IF WEIGHT #999 ~IsGabber(Player1) !AreaCheck("AR5203") Global("IRTBrokeUpTalk","GLOBAL",1) RealGlobalTimerExpired("IRTBrokeUpTalkTimer","GLOBAL")~ THEN QBrokeUp
SAY ~(Imoen looks up and offers a mirthless yet welcoming smile. Her eyes appear sunken and weary.) Hey.~
 ++ ~Hey.~ + QBrokeUp5
 ++ ~I'm just coming to check up on you. Are you going to be alright?~ + QBrokeUp4
 ++ ~Listen, Imoen, I know we just went through a lot, but I need you to stay focused on what we are doing here. Do you think you can do that?~ + QBrokeUp3
 ++ ~Are you going to mope around all the time now? Because if that's the case, I'll have to replace you.~ + QBrokeUp2
 ++ ~(You think better of it and leave her alone.)~ + QBrokeUp1
END

IF ~~ THEN QBrokeUp1
 SAY ~(She notices you are turning to step away.) Wait, <CHARNAME>.~
 IF ~~ THEN GOTO QBrokeUpEnd
END

IF ~~ THEN QBrokeUpEnd
 SAY ~Look, I'm not gonna say I'm alright, 'cause I'm not. But we've been through too much together already for me to just walk away now. There's gonna be a lot of awkward moments, I'm sure, but I just wanna let you know that I'll be damned before I let this whole Bhaalspawn thing unravel without me.~
 = ~I'm in for the long haul, alright? In a way I'm glad I don't have our relationship to worry about anymore. It was killin' me lately and now it's like a huge weight off my shoulders.~
 = ~So... there. Maybe, with time, it'll all be just like old times. (A genuine smile curves her lips.) Except... for the torture an' all.~
 = ~(She gives a gentle pat to your arm and walks past you.)~
 IF ~~ THEN DO ~SetGlobal("IRTBrokeUpTalk","GLOBAL",2) RunAwayFrom(Player1,20)~ EXIT
END

IF ~~ THEN QBrokeUp2
 SAY ~As subtle as a boot to the face, <CHARNAME>. So charming.~
 IF ~~ THEN GOTO QBrokeUpEnd
END

IF ~~ THEN QBrokeUp3
 SAY ~(She sighs, her features sporting visible signs of exhaustion.)~
 IF ~~ THEN GOTO QBrokeUpEnd
END

IF ~~ THEN QBrokeUp4
 SAY ~(She utters a bitter chuckle.) I basically just got dumped, <CHARNAME>. I'm doing great, other than that.~
 IF ~~ THEN GOTO QBrokeUpEnd
END

IF ~~ THEN QBrokeUp5
 SAY ~So... yeah. Feelin' pretty crappy. I'm gonna go ahead and assume yer not feelin' too good either.~
 = ~I guess you're wondering whether I'm gonna stick around or not. I've been wonderin' myself, really.~
 IF ~~ THEN GOTO QBrokeUpEnd
END
END