# IEEE-Dwarven-Voice-Classic-

This is a custom voice mod for a custom character that is generated during character creation. The voice is that of a classic dwarf (Fan-Fiction).

If you click on the image below you will be taken to a sort of teaser video on YouTube.

[![YouTube](https://github.com/Incrementis/Infinity-Engine-Modding-Wiki-Content-/blob/main/Dwarven%20Voice%20Classic/Images/CaveAndDwarf.png)](https://www.youtube.com/watch?v=t1pVB-WKLhI)

This mod was created using the [IEEE PCVI Pack](https://github.com/Incrementis/IEEE-Player-Character-Voice-Installer-Pack-) tool/template set.

## Supported Games

* BG:EE (Baldur's Gate:Enhanced Edition) tested version is 2.6.6.0
* SoD (Siege of Dragonspear) tested version is 2.6.6.0
* BG2:EE (Baldur's Gate 2:Enhanced Edition) tested version is 2.6.6.0
* IWD:EE (Icewind Dale:Enhanced Edition) tested version is 2.6.6.0

The SoD and BG2:EE versions can be installed in BG:EE and IWD:EE if desired, but I do not recommend it, as SoD and BG2:EE have lines that could affect consistency with other custom character voice sets.

BG:EE and IWD:EE versions cannot be installed in SoD and BG2:EE.
BG:EE can be installed in IWD:EE.
IWD:EE cannot be installed in BG:EE.


## Operating Systems

* Implemented and tested on Micrososft Windows 11
* It is highly possible that the mod will NOT work on other OS like Linux or MAC


## Compatibility

* It uses the unofficial [soundset convention](https://www.gibberlings3.net/forums/topic/34560-adding-soundsets-to-the-ees-using-the-ee-soundset-tool/) for advanced sound slots, ensuring compatibility with sound files developed under this standard.


## Languages

* English
* Deutsch

There are a maximum of 42 voice lines for each language, so there are 84 voice lines in total.

## Installation Guide

1. Download the latest version, which you can find [here](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/releases)
2. Unzip the file e.g. "*IEEE-Dwarven-Voice-Classic--0.3.1-beta.zip*"
3. Navigate into the unzipped folder until you see the "*IWDEE*,*BGEE*,*BG2EE & SoD*" folders.
4. Navigate into one of the "*IWDEE*,*BGEE*,*BG2EE & SoD*" folders until you see the "*IEE_Dwarven_Voice_Classic*" folder.
5. Copy the folder "*IEE_Dwarven_Voice_Classic*" and the file "*Setup-IEE_Dwarven_Voice_Classic.exe*" and paste them into your game folder.
6. Start "*Setup-IEE_Dwarven_Voice_Classic.exe*"(the one you copied into your game folder) and select the installation language.


## Context

Self-written biographies were the inspiration for the creation of the “*Dwarven Voice Classic*”.
You can find these in the “IEEE_Dwarven_Voice_Classic/*guides*/” folder.
It is up to the player how he uses them.

The following links lead to an English and German version.
They serve as inspiration only. They can be used for character biography.

* [IWDEE](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/blob/main/IWDEE/IEEE_Dwarven_Voice_Classic/guides/bio_suggestionDE.txt) German
* [IWDEE](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/blob/main/IWDEE/IEEE_Dwarven_Voice_Classic/guides/bio_suggestionEN.txt) English
* [BG:EE](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/blob/main/BG2EE%20%26%20SoD/IEEE_Dwarven_Voice_Classic/guides/bio_suggestionDE.txt) German
* [BG:EE](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/blob/main/BG2EE%20%26%20SoD/IEEE_Dwarven_Voice_Classic/guides/bio_suggestionEN.txt) English


## More Information

The WAV audio files are stored in the "*/IEEE_Dwarven_Voice_Classic/vox/en_US*" folder for English voice lines and in the "*/IEEE_Dwarven_Voice_Classic/vox/de_DE*" folder for German voice lines.

[VoiceLinesDE.txt](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/blob/main/VoiceLinesDE.txt) and [VoiceLinesEN.txt](https://github.com/Incrementis/IEEE-Dwarven-Voice-Classic-/blob/main/VoiceLinesEN.txt) contain the recorded lines in text form.



## Troubleshooting
### There are known issues when installing SOD as DLC for BG:EE
* [DLCmerger](https://github.com/Argent77/A7-DlcMerger/releases) is recommended for installation


## Copyright

The "*IEEE Dwarven Voice Classic*" Project is not developed, supported, or endorsed by BioWare™, Interplay/BlackIsle, Beamdog, or Wizards of the Coast.

"*IEEE Dwarven Voice Classic*" is licensed under a [Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)](https://creativecommons.org/licenses/by-nc/4.0/).