#include "options.h"

#include "utils.h"

static LPCTSTR s_szDefault = "0";
static const DWORD s_nBufSize = 8;
static char s_szBuf[s_nBufSize] = { 0 };
static LPCTSTR s_szFileCore = "./TobEx_ini/TobExCore.ini";
static LPCTSTR s_szFileTweak = "./TobEx_ini/TobExTweak.ini";

CGameOptionsEx* pGameOptionsEx = NULL;

CGameOptionsEx::CGameOptionsEx() {
    bActionAddKitFix = FALSE;
    bActionAttackOnceFix = FALSE;
    bActionAttacksGenuine = FALSE;
    bActionChangeAnimFix = FALSE;
    bActionEquipRangedFix = FALSE;
    bActionExpandedActions = FALSE;
    bActionJoinPartyFix = FALSE;
    bActionPickpocketRemainHidden = FALSE;
    bActionTakePartyItemFix = FALSE;

    bArenasEnable = FALSE;

    bDebugCriticalMsgBoxFix = FALSE;
    bDebugExpandedLUAConsole = FALSE;
    bDebugExternalLogging = FALSE;
    bDebugLogDialogueBar = FALSE;
    bDebugLogFailures = FALSE;
    bDebugLogWarnings = FALSE;
    bDebugLogMissingRes = FALSE;
    bDebugLogMore = FALSE;
    bDebugLogNetworkErrors = FALSE;
    bDebugRestoreCombatInfoText = FALSE;
    bDebugVerbose = FALSE;

    bEffApplyConcCheckDamage = FALSE;
    bEffApplyEffItemFix = FALSE;
    bEffApplyEffItemtypeFix = FALSE;
    bEffAttacksPerRoundFix = FALSE;
    bEffAwakenFix = FALSE;
    bEffDamageAwaken = FALSE;
    bEffBlindnessAsSpellDesc = FALSE;
    bEffBlindnessFix = FALSE;
    bEffButtonFXMod = FALSE;
    bEffCastSpellConditionMod = FALSE;
    bEffCastingLevelModFix = FALSE;
    bEffCharismaModFix = FALSE;
    bEffBackstabEveryHitConfig = FALSE;
    bEffDamageBypassMirrorImageConfig = FALSE;
    bEffStackingConfig = FALSE;
    bEffDispelMagicalItemConfig = FALSE;
    bEffConstitutionModFix = FALSE;
    bEffContainerUseEffFileFix = FALSE;
    bEffCureDrunkFix = FALSE;
    bEffCutScene2Mod = FALSE;
    bEffDamageFix = FALSE;
    bEffDexterityMod = FALSE;
    bEffStoneskinDisableColour = FALSE;
    bEffDiseaseFix = FALSE;
    bEffDisintegrateFix = FALSE;
    bEffDispelFix = FALSE;
    bEffDropInvDisintegrate = FALSE;
    bEffDropInvFrozenDeath = FALSE;
    bEffDropInvStoneDeath = FALSE;
    bEffFatigueModFix = FALSE;
    bEffFindTrapsModFix = FALSE;
    bEffForbidItemTypeFix = FALSE;
    bEffIntelligenceModFix = FALSE;
    bEffIntoxicationModFix = FALSE;
    bEffInvisibleFix = FALSE;
    bEffLearnSpellMod = FALSE;
    bEffLevelModFix = FALSE;
    bEffLoreModFix = FALSE;
    bEffLuckMod = FALSE;
    bEffMageMemSpellMod = FALSE;
    bEffMagicResistModFix = FALSE;
    bEffMoraleBreakModFix = FALSE;
    bEffNoDamageNoSpellInterrupt = FALSE;
    bEffOpenLocksModFix = FALSE;
    bEffPickPocketsModFix = FALSE;
    bEffPoisonFix = FALSE;
    bEffPoisonResistMod = FALSE;
    bEffPolymorphFix = FALSE;
    bEffPriestMemSpellMod = FALSE;
    bEffProficiencyModMod = FALSE;
    bEffRegenerationFix = FALSE;
    bEffRemoveProjectileMod = FALSE;
    bEffRepeatingEffFix = FALSE;
    bEffReputationModFix = FALSE;
    bEffSaveVsBreathMod = FALSE;
    bEffSaveVsDeathMod = FALSE;
    bEffSaveVsPolyMod = FALSE;
    bEffSaveVsSpellMod = FALSE;
    bEffSaveVsWandsMod = FALSE;
    bEffSavingThrowFix = FALSE;
    bEffStealthModFix = FALSE;
    bEffStrengthExModFix = FALSE;
    bEffStrengthMod = FALSE;
    bEffTrackingModFix = FALSE;
    bEffMirrorImageUseCastLevel = FALSE;
    bEffUseEFFFileFix = FALSE;
    bEffWisdomModFix = FALSE;

    bEnginePriestKnownSpellsExtend = FALSE;
    bEngineAllowDualClassAll = FALSE;
    bEngineAllowEquipArmorCombat = FALSE;
    bEngineAllowZeroStartXP = FALSE;
    bEngineAssBHPenaltyKit = FALSE;
    bEngineClericRangerHLAFix = FALSE;
    bEngineCloneCreatureFix = FALSE;
    nEngineCustomSoAStartXP = -1;
    nEngineCustomToBStartXP = -1;
    bEngineDisableEndPlayer1Dead = FALSE;
    bEngineDisableInvPauseSP = FALSE;
    bEngineDisableXPBoost = FALSE;
    bEngineCharmSilenceRemoval = FALSE;
    bEngineAutoPauseAllSP = FALSE;
    bEngineExpandedStats = FALSE;
    bEngineExternHPTables = FALSE;
    bEngineExternClassRaceRestrictions = FALSE;
    bEngineExternDifficulty = FALSE;
    bEngineExternEncumbrance = FALSE;
    bEngineExternMageSpellsCap = FALSE;
    bEngineExternStealSlots = FALSE;
    bEngineFakeTalkFix = FALSE;
    bEngineLauncherProficiencyFix = FALSE;
    bEngineProficiencyRestrictions = FALSE;
    bEngineMoveAreasFix = FALSE;
    bEngineOptimiseVarCode = FALSE;
    bEngineRestSpawnsAdvanceTime = FALSE;
    bEngineSpellTurningFix = FALSE;
    bEngineSummonLimitFix = FALSE;
    bEngineTargetDeadFix = FALSE;
    bEngineWeapSpecNumAttacksMod = FALSE;

    bItemsAbilityItemAnim = FALSE;
    bItemsBackstabRestrictionsConfig = FALSE;
    bItemsCriticalHitAversionConfig = FALSE;
    bItemsTargetInvisConfig = FALSE;
    bItemsRandomTreasureExtend = FALSE;
    bItemsNonAmmoLauncherDamageFix = FALSE;
    bItemsUseAnimPercentThrowingWeapons = FALSE;

    bMusicSonglistExtend = FALSE;

    bSoundAnimSoundFix = FALSE;
    bSoundAnimAttackSounds = FALSE;
    bSoundDlgGreetingSubtitles = FALSE;
    bSoundExistenceFix = FALSE;
    bSoundExternWalkSounds = FALSE;
    bSoundSoundsetSubtitles = FALSE;

    bSpellsCastingFix = FALSE;
    bSpellsUnvoicedConfig = FALSE;
    bSpellsTargetInvisConfig = FALSE;
    bSpellsExternBardSong = FALSE;

    bStoreItemRechargeMod = FALSE;
        
    bTriggerPickpocketFailed = FALSE;
    bTriggerExpandedTriggers = FALSE;
    bTriggerKitFix = FALSE;
    bTriggerOptimiseBagSearch = FALSE;
    bTriggerPickpocketFailedOnly = FALSE;

    bUserKitsExtend = FALSE;
    bUserContingencySelectSpell = FALSE;
    nUserCustomDlgBarSize = 0;
    bUserLargerTooltipScroll = FALSE;
    bUserExternMageSpellHiding = FALSE;
    bUserExternRaceSelectionText = FALSE;
    bUserChargenMageSpellScroll = FALSE;
    bUserChargenKitSelectScroll = FALSE;
    bUserRecordMageSpellScroll = FALSE;
    bUserMageBookScroll = FALSE;
    bUserPriestBookScroll = FALSE;
    bUserFourInventorySlots = FALSE;

    bVideoEnableMorePaperdolls = FALSE;
    bVideoIWDAnimAttack3Fix = FALSE;
    bVideoSpellTurningAnimFix = FALSE;
    bVideoVvcAlphaCrashFix = FALSE;
    bVideoVvcShadowAnimFix = FALSE;

    bUI_LootPanel                       = FALSE;
    bUI_LootPanelGUI_720Hack            = FALSE;
    bUI_ColorizeLearnableScrolls        = FALSE;
    bUI_HideWriteScrollButton           = FALSE;
    bUI_WeaponInfoOnInventoryScreen     = FALSE;
    bUI_WeaponInfoOnRecordScreen        = FALSE;
    bUI_DarkPortraitsIfItemNotAllowed   = FALSE;
    bUI_TotalRollInfo                   = FALSE;
    bUI_FoldJournal                     = FALSE;
    bUI_GreyBackgroundOnPause           = FALSE;
    //bUI_GreyBackgroundEnabled           = FALSE;
    bUI_UnlimitedHandOffSlot            = FALSE;
    bUI_LogActiveBuffs                  = FALSE;
    bUI_LogActiveBuffsWithTime          = FALSE;
    bUI_LogActiveBuffsWithItems         = FALSE;
    bUI_LogActiveBuffsWithTime_Party    = FALSE;
    bUI_ExtendedEventText               = FALSE;
    bUI_CombatExtendedTextType          = FALSE;
    bUI_CombatExtendedTextFull          = FALSE;
    bUI_KeepDrainedSpellSlots           = FALSE;
    bUI_ShowHitPointsOnPortrait         = FALSE;
    bUI_ShowActionOnPortrait            = FALSE;
    bUI_ShowHitPointsOnPortrait_Always  = FALSE;
    bUI_ShowActionOnPortrait_Always     = FALSE;
    bUI_YellowBorderOnPortraitIfTooFar  = FALSE;

    bUI_NightmareMode                   = FALSE;
    bNightmareBonusXP                   = FALSE;
    bNightmareBonusGold                 = FALSE;
    bNightmarePartySummon               = FALSE;

    bDisableHiddenPatches               = FALSE;
    bDisarmTrapDistanceFix              = FALSE;
    bEngineCharacterBehindPolygonFix    = FALSE;
    bContinuousBattleMusic              = FALSE;
    bEngineShamanClass                  = FALSE;
    bUI_StartNewGameWithBG1Animation    = FALSE;
    bUI_GreetingBeforeDialog            = FALSE;
    bUI_GreetingBeforeDialog_BG2Chapters    = FALSE;
    bUI_HighlightActiveZones                = FALSE;
    bUI_HighlightActiveZones_InfoQuestion   = FALSE;
    bUI_HighlightActiveZones_InfoAction = FALSE;
    bUI_HighlightActiveZones_EnterSteps = FALSE;
    bUI_HighlightActiveZones_EnterDoor  = FALSE;
    bEngine_CpuIdle                     = FALSE;
    bUI_DoubleRenderRate                = FALSE;
    bUI_DoubleRenderRate_MouseOnlyMode  = FALSE;
    bUI_FastProgressBarScreen           = FALSE;
    bVideo_FlickeringCursorFix          = FALSE;
    bEff_OverTargetVisualEffectFixes    = FALSE;
    bVideo_SkipFixedInterpolationModes  = 0;
    bVideo_OpenGL_VSync                 = FALSE;
    bVideo_StretchGUI                   = FALSE;
    bVideo_StretchCursor                = FALSE;
    bVideo_StretchGUI_WidescreenMode    = FALSE;
    bVideo_StretchAll                   = FALSE;
    bVideo_ShiftSubtitlesDown           = FALSE;
    bUI_ImprovedStoreInterface          = FALSE;
    bUI_PickPocketsButtonForClericThief = FALSE;
    bUI_DisableInnateToolBar            = FALSE;
    bUI_SequenceWindowButton            = FALSE;
    bUI_SpellIconRightClick             = FALSE;
    bEffProtectionFromSpellContingencyFix = FALSE;
    bEngine_RunInBackground             = FALSE;
    bUI_HideStaticPortraitIcons         = FALSE;
    bUI_ShortCuts                       = FALSE;
    bUI_PartyColorCircles                 = FALSE;
    bUI_PartyColorCirclesExcludeNPCColors = FALSE;
    bEff_StopInterruptedCastingAnimation  = FALSE;
    bUI_SpellSelectMenu                 = FALSE;
    bUI_FullScreenWorldMap              = FALSE;
    bUI_ShowNPCFloatHP                  = FALSE;
    bUI_ShowNPCFloatHP_Enemy            = FALSE;
    bUI_ShowNPCFloatHP_Party            = FALSE;
    bUI_ShowNPCFloatHP_Ally             = FALSE;
    bUI_ShowNPCFloatHP_Neutral          = FALSE;
    bUI_ShowNPCFloatName                = FALSE;
    bUI_AutoSwitchBookScreen            = FALSE;
    bUI_ExtendedRecordScreenText           = FALSE;
    bUI_ExtendedRecordScreenText_Threshold = FALSE;
    bSound_Normalize                     = FALSE;
    bSound_NormalizeCreOnly              = FALSE;
    bSound_NormalizePrintResname         = FALSE;
    bSound_BGTSelectionSoundSet          = FALSE;
    //bSound_BGTSelectionSoundSet_MODsAreBG2 = FALSE;
    bUI_DisableOffHandWeaponBG1part     = FALSE;
    bSound_ANISNDEX                     = FALSE;
    bAnimation_EXTANIM                  = FALSE;
    bSound_DisableGenericAttackSound    = FALSE;
    bSound_RestoreCreatureAttackSounds  = FALSE;
    bSound_DisableHardcodedBG1ItemSounds= FALSE;
    bEff_SelfPatchedEffectRemovingFix =   FALSE;
    bEngine_AddPauseToSaveGame          = FALSE;
    bSound_SequenceOverrideFix          = FALSE;
    bVideo_AnkhegRangeWeaponAnimFix     = FALSE;
    bSound_PriorityCREOver2DA           = FALSE;
    bSound_DisableWeaponSwingSoundExclusive = FALSE;
    bDebug_CrashdumpLibrary             = FALSE;
    bEff_ImprovedInvisibilityIcon       = FALSE;
    bBG1AnimationOffhandWeapon          = FALSE;
    bUI_BlockAreaTransitionCombat       = FALSE;
    bSound_RobeArmor                    = FALSE;
    bAnimation_SEQ_READY_AfterWeaponChange  = FALSE;
    bEngine_WSPECIAl_SPEED              = FALSE;
    bEngine_PartyBumpableInMoving       = FALSE;
    bEngine_EnemyCanBumpParty           = FALSE;
    bEngine_EnemyCanBumpPartyUnmoveable = FALSE;
    bEffSavingThrowImprovedInvisibleBonus   = FALSE;
    bSound_BG1CastingSound              = FALSE;
    bSound_BG1CastingSound_Level        = FALSE;
    bSound_BG2ClearCastingSound         = FALSE;
    bSound_NWNCastingSound              = FALSE;
    bEngine_FakeDiskFreeSpace           = FALSE;
    bVideo_7313_PaletteFix              = FALSE;
    bEngine_LimitXP                     = FALSE;
    bSound_DSOAL                        = FALSE;
    bSound_44KhzMixer                   = FALSE;
    bSound_FreezeOnPause                = FALSE;

    Init();
}

void CGameOptionsEx::Init() {
    bActionAddKitFix = GetCoreIniValue("Action", "AddKit Actions Fix");
    bActionAttackOnceFix = GetCoreIniValue("Action", "AttackOnce Action Fix");
    bActionAttacksGenuine = GetTweakIniValue("Tweak", "Action:Attacks Are All Genuine");
    bActionChangeAnimFix = GetCoreIniValue("Action", "ChangeAnimation Action Fix");
    bActionEquipRangedFix = GetCoreIniValue("Action", "EquipRanged Action Fix");
    bActionExpandedActions = GetCoreIniValue("Action", "Expanded Actions");
    bActionJoinPartyFix = GetCoreIniValue("Action", "JoinParty Action Class Ability Refresh Fix");
    bActionPickpocketRemainHidden = GetTweakIniValue("Tweak", "Action:Remain Hidden On Pickpocket Success");
    bActionTakePartyItemFix = GetCoreIniValue("Action", "TakePartyItem Fix");

    bArenasEnable = GetCoreIniValue("Arenas", "Enable Arenas Game Type");

    bDebugCriticalMsgBoxFix = GetCoreIniValue("Debug", "Critical Error Message Box Fix");
    bDebugExpandedLUAConsole = GetCoreIniValue("Debug", "Expanded LUA Console");
    bDebugExternalLogging = GetCoreIniValue("Debug", "Externalise Logging");
    bDebugLogDialogueBar = GetCoreIniValue("Debug", "Log Dialogue Bar");
    bDebugLogFailures = GetCoreIniValue("Debug", "Log Assertion Failures");
    bDebugLogWarnings = GetCoreIniValue("Debug", "Log Assertion Warnings");
    bDebugLogMissingRes = GetCoreIniValue("Debug", "Log Missing Resources");
    bDebugLogMore = GetCoreIniValue("Debug", "Log More Messages");
    bDebugLogNetworkErrors = GetCoreIniValue("Debug", "Log Network Errors");
    bDebugRestoreCombatInfoText = GetCoreIniValue("Debug", "Restore Extra Combat Info Text");
    bDebugVerbose = GetCoreIniValue("Debug", "Verbose Logging");

    bEffApplyConcCheckDamage = GetTweakIniValue("Tweak", "Effect Opcodes:Apply Concentration Check On Damage");
    bEffApplyEffItemFix = GetCoreIniValue("Effect Opcodes", "Apply Effect Item Fix");
    bEffApplyEffItemtypeFix = GetCoreIniValue("Effect Opcodes", "Apply Effect Itemtype Fix");
    bEffAttacksPerRoundFix = GetCoreIniValue("Effect Opcodes", "Attacks Per Round Mod Fix");
    bEffAwakenFix = GetCoreIniValue("Effect Opcodes", "Awaken Fix");
    bEffDamageAwaken = GetTweakIniValue("Tweak", "Effect Opcodes:Awaken On Damage");
    bEffBlindnessAsSpellDesc = GetTweakIniValue("Tweak", "Effect Opcodes:Blindness As Spell Description");
    bEffBlindnessFix = GetCoreIniValue("Effect Opcodes", "Blindness Fix");
    bEffButtonFXMod = GetCoreIniValue("Effect Opcodes", "Button Effects Mod");
    bEffCastSpellConditionMod = GetCoreIniValue("Effect Opcodes", "Cast Spell On Condition Mod");
    bEffCastingLevelModFix = GetCoreIniValue("Effect Opcodes", "Casting Level Mod Fix");
    bEffCharismaModFix = GetCoreIniValue("Effect Opcodes", "Charisma Mod Fix");
    bEffBackstabEveryHitConfig = GetCoreIniValue("Effect Opcodes", "Configurable Backstab Every Hit");
    bEffDamageBypassMirrorImageConfig = GetCoreIniValue("Effect Opcodes", "Configurable Damage Effect Bypasses Mirror Images");
    bEffStackingConfig = GetCoreIniValue("Effect Opcodes", "Configurable Effect Stacking");
    bEffDispelMagicalItemConfig = GetCoreIniValue("Effect Opcodes", "Configurable Magical Item Dispel Behaviour");
    bEffConstitutionModFix = GetCoreIniValue("Effect Opcodes", "Constitution Mod Fix");
    bEffContainerUseEffFileFix = GetCoreIniValue("Effect Opcodes", "Container Use EFF File Fix");
    bEffCureDrunkFix = GetCoreIniValue("Effect Opcodes", "Cure Drunk Fix");
    bEffCutScene2Mod = GetCoreIniValue("Effect Opcodes", "Cut Scene 2 Mod");
    bEffDamageFix = GetCoreIniValue("Effect Opcodes", "Damage Fix");
    bEffDexterityMod =  GetCoreIniValue("Effect Opcodes", "Dexterity Mod");
    bEffStoneskinDisableColour = GetTweakIniValue("Tweak", "Effect Opcodes:Disable Stoneskin Grey Colour");
    bEffDiseaseFix = GetCoreIniValue("Effect Opcodes", "Disease Fix");
    bEffDisintegrateFix = GetCoreIniValue("Effect Opcodes", "Disintegrate Fix");
    bEffDispelFix = GetCoreIniValue("Effect Opcodes", "Dispel Formula Fix");
    bEffDropInvDisintegrate = GetTweakIniValue("Tweak", "Effect Opcodes:Drop Inventory on Disintegrate");
    bEffDropInvFrozenDeath = GetTweakIniValue("Tweak", "Effect Opcodes:Drop Inventory on Frozen Death");
    bEffDropInvStoneDeath = GetTweakIniValue("Tweak", "Effect Opcodes:Drop Inventory on Stone Death");
    bEffFatigueModFix =  GetCoreIniValue("Effect Opcodes", "Fatigue Mod Fix");
    bEffFindTrapsModFix =  GetCoreIniValue("Effect Opcodes", "Find Traps Mod Fix");
    bEffForbidItemTypeFix = GetCoreIniValue("Effect Opcodes", "Forbid Item Type Fix");
    bEffIntelligenceModFix = GetCoreIniValue("Effect Opcodes", "Intelligence Mod Fix");
    bEffIntoxicationModFix = GetCoreIniValue("Effect Opcodes", "Intoxication Mod Fix");
    bEffInvisibleFix = GetCoreIniValue("Effect Opcodes", "Invisible Fix");
    bEffLearnSpellMod = GetCoreIniValue("Effect Opcodes", "Learn Spell Mod");
    bEffLevelModFix = GetCoreIniValue("Effect Opcodes", "Level Mod Fix");
    bEffLoreModFix = GetCoreIniValue("Effect Opcodes", "Lore Mod Fix");
    bEffLuckMod = GetCoreIniValue("Effect Opcodes", "Luck Mod");
    bEffMageMemSpellMod = GetCoreIniValue("Effect Opcodes", "Mage Spell Slots Mod");
    bEffMagicResistModFix = GetCoreIniValue("Effect Opcodes", "Magic Resistance Mod Fix");
    bEffMoraleBreakModFix = GetCoreIniValue("Effect Opcodes", "Morale Break Mod Fix");
    bEffNoDamageNoSpellInterrupt = GetTweakIniValue("Tweak", "Effect Opcodes:No Spell Interruption On Zero Damage");
    bEffOpenLocksModFix = GetCoreIniValue("Effect Opcodes", "Open Locks Mod Fix");
    bEffPickPocketsModFix = GetCoreIniValue("Effect Opcodes", "Pick Pockets Mod Fix");
    bEffPoisonFix = GetCoreIniValue("Effect Opcodes", "Poison Fix");
    bEffPoisonResistMod = GetCoreIniValue("Effect Opcodes", "Poison Resistance Mod");
    bEffPolymorphFix = GetCoreIniValue("Effect Opcodes", "Polymorph Fix");
    bEffPriestMemSpellMod = GetCoreIniValue("Effect Opcodes", "Priest Spell Slots Mod");
    bEffProficiencyModMod = GetCoreIniValue("Effect Opcodes", "Proficiency Modifier Mod");
    bEffRegenerationFix = GetCoreIniValue("Effect Opcodes", "Regeneration Fix");
    bEffRemoveProjectileMod = GetCoreIniValue("Effect Opcodes", "Remove Projectile Mod");
    bEffRepeatingEffFix = GetCoreIniValue("Effect Opcodes", "Repeating Effect Fix");
    bEffReputationModFix = GetCoreIniValue("Effect Opcodes", "Reputation Mod Fix");
    bEffSaveVsBreathMod = GetCoreIniValue("Effect Opcodes", "Save Vs Breath Mod");
    bEffSaveVsDeathMod = GetCoreIniValue("Effect Opcodes", "Save Vs Death Mod");
    bEffSaveVsPolyMod = GetCoreIniValue("Effect Opcodes", "Save Vs Poly Mod");
    bEffSaveVsSpellMod = GetCoreIniValue("Effect Opcodes", "Save Vs Spell Mod");
    bEffSaveVsWandsMod = GetCoreIniValue("Effect Opcodes", "Save Vs Wands Mod");
    bEffSavingThrowFix = GetCoreIniValue("Effect Opcodes", "Saving Throw Fix");
    bEffStealthModFix = GetCoreIniValue("Effect Opcodes", "Stealth Mod Fix");
    bEffStrengthExModFix = GetCoreIniValue("Effect Opcodes", "Strength Extra Mod Fix");
    bEffStrengthMod = GetCoreIniValue("Effect Opcodes", "Strength Mod");
    bEffTrackingModFix = GetCoreIniValue("Effect Opcodes", "Tracking Mod Fix");
    bEffMirrorImageUseCastLevel = GetTweakIniValue("Tweak", "Effect Opcodes:Use Caster Level On Mirror Image");
    bEffUseEFFFileFix = GetCoreIniValue("Effect Opcodes", "Use EFF File Fix");
    bEffWisdomModFix = GetCoreIniValue("Effect Opcodes", "Wisdom Mod Fix");

    bEnginePriestKnownSpellsExtend = GetCoreIniValue("Engine", "Allow 99 Priest Known Spells Per Level");
    bEngineAllowDualClassAll = GetTweakIniValue("Tweak", "Engine:Allow All Races to Dual Class");
    bEngineAllowEquipArmorCombat = GetTweakIniValue("Tweak", "Engine:Allow Equipping Armor in Combat");
    bEngineAllowZeroStartXP = GetCoreIniValue("Engine", "Allow Zero Starting Experience");
    bEngineAssBHPenaltyKit = GetCoreIniValue("Engine", "Assassin and Bounty Hunter Penalty to Similar Kits");
    bEngineClericRangerHLAFix = GetCoreIniValue("Engine", "Cleric-Ranger HLA Fix");
    bEngineCloneCreatureFix = GetCoreIniValue("Engine", "Clone Creature Fix");
    nEngineCustomSoAStartXP = GetTweakIniValue("Tweak", "Engine:Custom Shadows of Amn Starting Experience", "-1");
    nEngineCustomToBStartXP = GetTweakIniValue("Tweak", "Engine:Custom Throne of Bhaal Starting Experience", "-1");
    bEngineDisableEndPlayer1Dead = GetTweakIniValue("Tweak", "Engine:Disable End On Player1 Dead");
    bEngineDisableInvPauseSP = GetTweakIniValue("Tweak", "Engine:Disable Force Inventory Pause");
    bEngineDisableXPBoost = GetTweakIniValue("Tweak", "Engine:Disable Experience Boost");
    bEngineCharmSilenceRemoval = GetTweakIniValue("Tweak", "Engine:Disable Silence On Charm");
    bEngineAutoPauseAllSP = GetTweakIniValue("Tweak","Engine:Enable Auto-Pause On All Screens");
    bEngineExpandedStats = GetCoreIniValue("Engine", "Expanded Stats");
    bEngineExternHPTables = GetCoreIniValue("Engine", "Externalise HP Tables");
    bEngineExternClassRaceRestrictions = GetCoreIniValue("Engine", "Externalise Class-Race Restrictions");
    bEngineExternDifficulty = GetCoreIniValue("Engine", "Externalise Difficulty Settings");
    bEngineExternEncumbrance = GetCoreIniValue("Engine", "Externalise Encumbrance Restrictions");
    bEngineExternMageSpellsCap = GetCoreIniValue("Engine", "Externalise Mage Spells Cap");
    bEngineExternStealSlots = GetCoreIniValue("Engine", "Externalise Stealable Item Slots");
    bEngineFakeTalkFix = GetCoreIniValue("Engine", "Fake Talk Exploit Fix");
    bEngineLauncherProficiencyFix = GetCoreIniValue("Engine", "Launcher Proficiency Fix");
    bEngineProficiencyRestrictions = GetTweakIniValue("Tweak", "Engine:Level One Proficiency Restrictions");
    bEngineMoveAreasFix = GetCoreIniValue("Engine", "Move Areas Fix");
    bEngineOptimiseVarCode = GetCoreIniValue("Engine", "Optimise Variables Code");
    bEngineRestSpawnsAdvanceTime = GetTweakIniValue("Tweak", "Engine:Rest Spawns Advance Time");
    bEngineSpellTurningFix = GetCoreIniValue("Engine", "Spell Turning Fix");
    bEngineSummonLimitFix = GetCoreIniValue("Engine", "Summon Limit Fix");
    bEngineTargetDeadFix = GetCoreIniValue("Engine", "Targetting Dead Animations Fix");
    bEngineWeapSpecNumAttacksMod = GetTweakIniValue("Tweak", "Engine:Weapon Specialisation Number of Attacks Mod");

    bItemsAbilityItemAnim = GetCoreIniValue("Items", "Ability-specific Use Item Animations");
    bItemsBackstabRestrictionsConfig = GetCoreIniValue("Items", "Configurable Backstab Restrictions");
    bItemsCriticalHitAversionConfig = GetCoreIniValue("Items", "Configurable Critical Hit Aversion");
    bItemsTargetInvisConfig = GetCoreIniValue("Items", "Configurable Items Cannot Target Invisible");
    bItemsRandomTreasureExtend = GetCoreIniValue("Items", "Enable 99 Random Treasure Rows");
    bItemsExternCreExcl = GetCoreIniValue("Items", "Externalise Item-Creature Exclusions");
    bItemsNonAmmoLauncherDamageFix = GetCoreIniValue("Items", "Non-Ammo Launcher Damage Fix");
    bItemsUseAnimPercentThrowingWeapons = GetTweakIniValue("Tweak", "Items:Use Animation Percentages for Throwing Weapons");

    bMusicSonglistExtend   = GetCoreIniValue("Music", "Extended Songlist");

    bSoundAnimSoundFix = GetCoreIniValue("Sound", "Animation Sound Fix");
    bSoundDlgGreetingSubtitles = GetTweakIniValue("Tweak", "Sound:Dialogue Greeting Subtitles");
    bSoundAnimAttackSounds = GetTweakIniValue("Tweak", "Sound:Enable Animation Attack Sounds");
    bSoundExistenceFix = GetCoreIniValue("Sound", "Existence Sound Fix");
    bSoundExternWalkSounds = GetCoreIniValue("Sound", "Externalise Animation Walking Sounds");
    bSoundSoundsetSubtitles = GetCoreIniValue("Sound", "Soundset Subtitles");

    bSpellsCastingFix = GetCoreIniValue("Spells", "Casting Fixes");
    bSpellsUnvoicedConfig = GetCoreIniValue("Spells", "Configurable Spells Can Be Unvoiced");
    bSpellsTargetInvisConfig = GetCoreIniValue("Spells", "Configurable Spells Can Target Invisible");
    bSpellsExternBardSong = GetCoreIniValue("Spells", "Externalise Bard Song Effects");

    bStoreItemRechargeMod = GetCoreIniValue("Store", "Item Recharge Mod");

    bTriggerPickpocketFailed = GetCoreIniValue("Trigger", "Enable PickpocketFailed Trigger");
    bTriggerExpandedTriggers = GetCoreIniValue("Trigger", "Expanded Triggers");
    bTriggerKitFix = GetCoreIniValue("Trigger", "Kit Trigger Fix");
    bTriggerOptimiseBagSearch = GetCoreIniValue("Trigger", "Optimise Bag Search Code");
    bTriggerPickpocketFailedOnly = GetTweakIniValue("Tweak", "Trigger:PickpocketFailed Trigger Only");

    bUserKitsExtend = GetCoreIniValue("UI", "Allow 1280 Total Kits");
    bUserContingencySelectSpell = GetCoreIniValue("UI", "Contingency Detects Select Spell");
    nUserCustomDlgBarSize = GetCoreIniValue("UI", "Custom Dialogue Bar Buffer Size");
    nUserCustomDlgBarSize = max(nUserCustomDlgBarSize, 0);
    bUserLargerTooltipScroll = GetCoreIniValue("UI", "Enlarge Tooltip Scroll");
    bUserExternMageSpellHiding = GetCoreIniValue("UI", "Externalise Mage Spell Hiding");
    bUserExternRaceSelectionText = GetCoreIniValue("UI", "Externalise Race Selection StrRef");
    bUserChargenMageSpellScroll = GetCoreIniValue("UI", "Scrollable Chargen Mage Spell Selection");
    bUserChargenKitSelectScroll = GetCoreIniValue("UI", "Scrollable Kit Selection");
    bUserRecordMageSpellScroll = GetCoreIniValue("UI", "Scrollable Level Up Mage Spell Selection");
    bUserMageBookScroll = GetCoreIniValue("UI", "Scrollable Mage Spellbook");
    bUserPriestBookScroll = GetCoreIniValue("UI", "Scrollable Priest Spellbook");
    bUserFourInventorySlots = GetTweakIniValue("Tweak", "UI:Universal Four Inventory Weapon Slots");

    bVideoEnableMorePaperdolls = GetCoreIniValue("Video", "Enable More Paperdolls");
    bVideoIWDAnimAttack3Fix = GetCoreIniValue("Video", "IWD Animation Attack 3 Fix");
    bVideoSpellTurningAnimFix = GetCoreIniValue("Video", "Spell Turning Animation Fix");
    bVideoVvcAlphaCrashFix = GetCoreIniValue("Video", "VVC Alpha Rendering Crash Fix");
    bVideoVvcShadowAnimFix = GetCoreIniValue("Video", "VVC Shadow Animation Fix");

    //Improved GUI / AfterLife
    bUI_LootPanel =                     GetTweakIniValue("Tweak", "UI:Loot Panel");
    bUI_LootPanelGUI_720Hack =          GetTweakIniValue("Tweak", "UI:Loot Panel GUI_720 Hack");
    bUI_ColorizeLearnableScrolls =      GetTweakIniValue("Tweak", "UI:Colorize Learnable Scrolls");
    bUI_HideWriteScrollButton =         GetTweakIniValue("Tweak", "UI:Hide Write Magic Button");
    bUI_WeaponInfoOnInventoryScreen =   GetTweakIniValue("Tweak", "UI:THAC0 Info On Inventory Screen");
    bUI_WeaponInfoOnRecordScreen =      GetTweakIniValue("Tweak", "UI:Damage Info On Record Screen");
    bUI_DarkPortraitsIfItemNotAllowed=  GetTweakIniValue("Tweak", "UI:Dark Portraits If Item Not Allowed");
    bUI_TotalRollInfo =                 GetTweakIniValue("Tweak", "UI:Show Total Roll");
    bUI_FoldJournal =                   GetTweakIniValue("Tweak", "UI:Fold Journal");
    bUI_GreyBackgroundOnPause =         GetTweakIniValue("Tweak", "UI:Grey Background On Pause");
    //bUI_GreyBackgroundEnabled =         GetTweakIniValue("Tweak", "UI:Grey Background Auto Enabled");
    bUI_UnlimitedHandOffSlot  =         GetTweakIniValue("Tweak", "UI:Unlimited Hand Off Slot");
    bUI_LogActiveBuffs  =               GetTweakIniValue("Tweak", "UI:Log Active Buffs");
    bUI_LogActiveBuffsWithTime =        GetTweakIniValue("Tweak", "UI:Log Active Buffs with time");
    bUI_LogActiveBuffsWithItems =       GetTweakIniValue("Tweak", "UI:Log Active Buffs with items");
    bUI_LogActiveBuffsWithTime_Party =  GetTweakIniValue("Tweak", "UI:Log Active Buffs with time casted by Party");
    bUI_ExtendedEventText =             GetTweakIniValue("Tweak", "UI:Extended Event Text");
    bUI_CombatExtendedTextType =        GetTweakIniValue("Tweak", "UI:Extended Combat Text Type");
    bUI_CombatExtendedTextFull =        GetTweakIniValue("Tweak", "UI:Extended Combat Text Full");
    bUI_KeepDrainedSpellSlots =         GetTweakIniValue("Tweak", "UI:Keep Drained Spell Slots");
    bUI_ShowHitPointsOnPortrait =       GetTweakIniValue("Tweak", "UI:Show Hit-Points On Portrait");
    bUI_ShowHitPointsOnPortrait_Always= GetTweakIniValue("Tweak", "UI:Show Hit-Points On Portrait Always");
    bUI_ShowActionOnPortrait =          GetTweakIniValue("Tweak", "UI:Show Action On Portrait");
    bUI_ShowActionOnPortrait_Always =   GetTweakIniValue("Tweak", "UI:Show Action On Portrait Always");
    bUI_YellowBorderOnPortraitIfTooFar= GetTweakIniValue("Tweak", "UI:Yellow Border On Portrait If Too Far");
    bDisableHiddenPatches =         GetCoreIniValue("Debug",  "Disable Hidden TobEx Patches");
    bDisarmTrapDistanceFix =        GetCoreIniValue("Action", "Disarm Trap Distance Fix");
    bUI_NightmareMode =             GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty");
    bNightmarePartySummon =         GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Party Summons");
    bNightmareBonusXP =             GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus XP");
    bNightmareBonusGold =           GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.Gold");
    bNightmareBonusXP_Multiplier =  GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.XP Multiplier");
    bNightmareBonusXP_Bonus =       GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.XP Addon");
    bNightmareBonusTHAC0 =          GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.THAC0");
    bNightmareBonusArmorClass =     GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.Armor Class");
    bNightmareBonusAPR =            GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.APR");
    bNightmareBonusSavingThrows =   GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.Saving Throws");
    bNightmareBonusLevels =         GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.LevelsUp");
    bNightmareBonusHP_Multiplier =  GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.HP Multiplier");
    bNightmareBonusHP_Bonus =       GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.HP Addon");
    bNightmareBonusHPSummon_Multiplier =  GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.HP Party Summons Multiplier");
    bNightmareBonusHPSummon_Bonus =       GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.HP Party Summons Addon");
    bNightmareBonusSpawns =         GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.Rest Encounter Spawn Addon");
    bNightmareBonusNoMoraleBreak =  GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.No Morale Break");
    bNightmareBonusMovementRate =   GetTweakIniValue("Tweak", "UI:Legacy of Bhaal Difficulty Bonus.Movement Rate");
    bContinuousBattleMusic =            GetCoreIniValue("Music", "Continuous Battle Music Fix");
    bEngineShamanClass  =               GetCoreIniValue("Engine", "Shaman Class");
    bUI_StartNewGameWithBG1Animation =  GetTweakIniValue("Tweak", "UI:Set BG1 Animation during Character Generation");
    bUI_GreetingBeforeDialog =          GetTweakIniValue("Tweak", "UI:Greeting Before Dialog");
    bUI_GreetingBeforeDialog_BG2Chapters =  GetTweakIniValue("Tweak", "UI:Greeting Before Dialog BG2 Chapters");
    bUI_HighlightActiveZones =              GetTweakIniValue("Tweak", "UI:Highlight Active Zones");
    bUI_HighlightActiveZones_InfoQuestion = GetTweakIniValue("Tweak", "UI:Highlight Active Zones Info Question");
    bUI_HighlightActiveZones_InfoAction =   GetTweakIniValue("Tweak", "UI:Highlight Active Zones Info Action");
    bUI_HighlightActiveZones_EnterSteps =   GetTweakIniValue("Tweak", "UI:Highlight Active Zones Steps Enter");
    bUI_HighlightActiveZones_EnterDoor =    GetTweakIniValue("Tweak", "UI:Highlight Active Zones Door Enter");
    bEngine_CpuIdle  =                      GetCoreIniValue("Engine", "Cpu Idle");
    bUI_DoubleRenderRate =                  GetTweakIniValue("Tweak", "Video:Double Mouse Render Rate");
    bUI_DoubleRenderRate_MouseOnlyMode =    GetTweakIniValue("Tweak", "Video:Double Mouse Render Rate Lite");
    bUI_FastProgressBarScreen =             GetTweakIniValue("Tweak", "UI:Fast ProgressBar Screen");
    bVideo_FlickeringCursorFix =            GetCoreIniValue( "Video", "Flickering Cursor Fix");
    bEff_OverTargetVisualEffectFixes =      GetTweakIniValue("Tweak", "Effect Opcodes:Over Target Visual Effect Fixes");
    bVideo_SkipFixedInterpolationModes =    GetCoreIniValue( "Video", "Skip OpenGL Fullscreen Display Modes with Fixed Interpolation");
    bVideo_OpenGL_VSync =                   GetCoreIniValue( "Video", "OpenGL VSync On");
    bVideo_StretchGUI =                     GetTweakIniValue("Tweak", "UI:Stretch GUI");
    bVideo_StretchCursor =                  GetTweakIniValue("Tweak", "UI:Stretch Cursor");
    bVideo_StretchGUI_WidescreenMode =      GetTweakIniValue("Tweak", "UI:Stretch GUI WidescreenMode");
    bVideo_StretchAll =                     GetTweakIniValue("Tweak", "UI:Stretch Anything");
    bVideo_ShiftSubtitlesDown =             GetTweakIniValue("Tweak", "UI:Show Subtitles Below Movie Frame");
    bUI_ImprovedStoreInterface =            GetTweakIniValue("Tweak", "UI:Improved Store&Bag Interface");
    bUI_PickPocketsButtonForClericThief =   GetTweakIniValue("Tweak", "UI:Turn Undead Button Cleric/Thief");
    bUI_DisableInnateToolBar =              GetTweakIniValue("Tweak", "UI:Disable Empty Innate ToolBar");
    bUI_SequenceWindowButton =              GetTweakIniValue("Tweak", "UI:Spell Sequencer Panel");
    bEffProtectionFromSpellContingencyFix = GetCoreIniValue("Effect Opcodes", "Protection From Spell for Contingency Fix");
    bEngine_RunInBackground  =              GetTweakIniValue("Tweak", "Engine:Run In Background");
    bUI_SpellIconRightClick =               GetTweakIniValue("Tweak", "UI:Spell Icon Right Click");
    bUI_HideStaticPortraitIcons =           GetTweakIniValue("Tweak", "UI:Hide Static Portrait Icons");
    bUI_ShortCuts =                         GetTweakIniValue("Tweak", "UI:Additional Keyboard ShortCuts");
    bUI_PartyColorCircles =                 GetTweakIniValue("Tweak", "UI:Party Color Circles");
    bUI_PartyColorCirclesExcludeNPCColors = GetTweakIniValue("Tweak", "UI:Party Color Circles Exclude NPC Colors");
    bEff_StopInterruptedCastingAnimation =  GetCoreIniValue("Effect Opcodes", "Stop Animation/Sound of Interrupted Casting");
    bUI_SpellSelectMenu =                   GetTweakIniValue("Tweak", "UI:Spell Selection Menu");
    bEngineCharacterBehindPolygonFix =      GetCoreIniValue("Engine", "Character Behind Polygon Fix");
    bUI_FullScreenWorldMap =                GetTweakIniValue("Tweak", "UI:FullScreen World Map");
    bUI_ShowNPCFloatHP =                    GetTweakIniValue("Tweak", "UI:Show NPC Float HP");
    bUI_ShowNPCFloatHP_Enemy =              GetTweakIniValue("Tweak", "UI:Show NPC Float HP Enemy");
    bUI_ShowNPCFloatHP_Party =              GetTweakIniValue("Tweak", "UI:Show NPC Float HP Party");
    bUI_ShowNPCFloatHP_Ally =               GetTweakIniValue("Tweak", "UI:Show NPC Float HP Ally");
    bUI_ShowNPCFloatHP_Neutral =            GetTweakIniValue("Tweak", "UI:Show NPC Float HP Neutral");
    bUI_ShowNPCFloatName =                  GetTweakIniValue("Tweak", "UI:Show NPC Float Name");
    bUI_AutoSwitchBookScreen =              GetTweakIniValue("Tweak", "UI:Auto Switch Book Screen");
    bUI_ExtendedRecordScreenText =          GetTweakIniValue("Tweak", "UI:Extended Text Info at Record Screen");
    bUI_ExtendedRecordScreenText_Threshold= GetTweakIniValue("Tweak", "UI:Extended Text Info at Record Screen Only If Threshold");
    bSound_Normalize             = GetTweakIniValue("Tweak", "Sound:Normalize Volume");
    bSound_NormalizeCreOnly      = GetTweakIniValue("Tweak", "Sound:Normalize Volume Creatures Only");
    bSound_NormalizePrintResname = GetTweakIniValue("Tweak", "Sound:Normalize Volume Debug Print");
    bSound_BGTSelectionSoundSet  =           GetCoreIniValue("Sound", "Mixed Soundset for BGT");
    //bSound_BGTSelectionSoundSet_MODsAreBG2 = GetCoreIniValue("Sound", "Mixed Soundset for BGT Unknown BG1 NPC Have BG2 Soundset");
    bUI_DisableOffHandWeaponBG1part =  GetTweakIniValue("Tweak", "UI:Disable Off Hand Weapon for BG1");
    bSound_ANISNDEX =                  GetCoreIniValue("Sound",  "Externalise Animation Sound Reference Override");
    bAnimation_EXTANIM =               GetCoreIniValue("Engine", "Externalise Animation Config Override");
    bSound_DisableGenericAttackSound =     GetTweakIniValue("Tweak", "Sound:Mute Generic Animation Attack Sound");
    bSound_RestoreCreatureAttackSounds =   GetTweakIniValue("Tweak", "Sound:Restore Creature Attack Sounds #1");
    bSound_DisableHardcodedBG1ItemSounds = GetTweakIniValue("Tweak", "Sound:Disable Hardcoded BG1 Item Sounds");
    bEff_SelfPatchedEffectRemovingFix =    GetCoreIniValue("Effect Opcodes", "Self-Patched Effect Removing Fix");
    bEngine_AddPauseToSaveGame = GetTweakIniValue("Tweak", "Engine:Add Pause To Save Game");
    bSound_SequenceOverrideFix = GetCoreIniValue("Sound", "Sequence Sound Override Fix");
    bVideo_AnkhegRangeWeaponAnimFix = GetCoreIniValue("Video", "Ankheg Range Weapon Animation Fix");
    bSound_PriorityCREOver2DA  = GetTweakIniValue("Tweak", "Sound:Creature Embedded Sound overrides 2DA Entry");
    bSound_DisableWeaponSwingSoundExclusive = GetTweakIniValue("Tweak", "Sound:Restore Creature Attack Sounds #2");
    bDebug_CrashdumpLibrary =    GetCoreIniValue("Debug", "External Crashdump Saving Utility");
    bEff_ImprovedInvisibilityIcon = GetTweakIniValue("Tweak", "UI:Improved Invisibility Icon");
    bEff_BlurAndMirrorImage_Icon  = GetTweakIniValue("Tweak", "UI:Blur/Mirror Image Icon");
    bBG1AnimationOffhandWeapon    = GetTweakIniValue("Tweak", "UI:Enable Off Hand Weapon BG1 Animation");
    bUI_MoraleBreakIcon           = GetTweakIniValue("Tweak", "UI:Morale Break Icon");
    bSound_RobeArmor              = GetTweakIniValue("Tweak", "Sound:Enable Robe Armor Sound");
    bAnimation_SEQ_READY_AfterWeaponChange = GetTweakIniValue("Tweak", "Animation:Reset Idle Timer After Weapon Equipped");
    bEngine_WSPECIAl_SPEED        = GetCoreIniValue("Engine", "Weapon Speed Fix");
    //bEngine_InvisibilityRenderFix = GetTweakIniValue("Tweak", "Engine:Keep Invisibility In Attack");
    bEngine_PartyBumpableInMoving   = GetTweakIniValue("Tweak", "Engine:Path Search Party Bumpable When Moving");
    bUI_BlockAreaTransitionCombat = GetTweakIniValue("Tweak", "Engine:Block Area Transition in Combat");
    bEngine_EnemyCanBumpParty           = GetTweakIniValue("Tweak", "Engine:Enemy Can Bump Party");
    bEngine_EnemyCanBumpPartyUnmoveable = GetTweakIniValue("Tweak", "Engine:Enemy Can Bump Party Unmoveable");
    bEffSavingThrowImprovedInvisibleBonus = GetCoreIniValue("Effect Opcodes", "Saving Throw Improved Invisible Bonus");
    bSound_BG1CastingSound        = GetTweakIniValue("Tweak", "UI:BG1 Casting Voice");
    bSound_BG1CastingSound_Level  = GetTweakIniValue("Tweak", "UI:BG1 Casting Voice Level Depend");
    bSound_BG2ClearCastingSound   = GetTweakIniValue("Tweak", "UI:BG2 Clear Casting Voice");
    bSound_NWNCastingSound        = GetTweakIniValue("Tweak", "UI:NWN Casting Voice");
    bEngine_FakeDiskFreeSpace     = GetCoreIniValue("Engine", "2TB+ Disk Free Space Fix");
    bVideo_7313_PaletteFix        = GetCoreIniValue("Video", "Small Purple Elemental Palette Fix");
    bEngine_LimitXP               = GetTweakIniValue("Tweak", "Engine:Limit XP");
    bSound_DSOAL                  = GetTweakIniValue("Tweak", "Sound:EAX Emulation");
    bSound_44KhzMixer             = GetCoreIniValue("Sound", "44Khz Mixer");
    bSound_FreezeOnPause          = GetTweakIniValue("Tweak", "Sound:Freeze On Pause");

}

int GetCoreIniValue(LPCTSTR szSection, LPCTSTR szKey) {
    int n = 0;
    GetPrivateProfileString(szSection, szKey, s_szDefault, s_szBuf, s_nBufSize, s_szFileCore);
    sscanf_s(s_szBuf, "%d", &n);
    return n;
}

int GetCoreIniValue(LPCTSTR szSection, LPCTSTR szKey, LPCTSTR szDefault) {
    int n = 0;
    GetPrivateProfileString(szSection, szKey, szDefault, s_szBuf, s_nBufSize, s_szFileCore);
    sscanf_s(s_szBuf, "%d", &n);
    return n;
}

int GetTweakIniValue(LPCTSTR szSection, LPCTSTR szKey) {
    int n = 0;
    GetPrivateProfileString(szSection, szKey, s_szDefault, s_szBuf, s_nBufSize, s_szFileTweak);
    sscanf_s(s_szBuf, "%d", &n);
    return n;
}

int GetTweakIniValue(LPCTSTR szSection, LPCTSTR szKey, LPCTSTR szDefault) {
    int n = 0;
    GetPrivateProfileString(szSection, szKey, szDefault, s_szBuf, s_nBufSize, s_szFileTweak);
    sscanf_s(s_szBuf, "%d", &n);
    return n;
}

void InitOptions() {
    pGameOptionsEx = new CGameOptionsEx();
    return;
}