#ifndef OPTIONS_H
#define OPTIONS_H

#include "win32def.h"

struct CGameOptionsEx {
    CGameOptionsEx();

    BOOL bActionAddKitFix;
    BOOL bActionAttackOnceFix;
    BOOL bActionAttacksGenuine;
    BOOL bActionChangeAnimFix;
    BOOL bActionEquipRangedFix;
    BOOL bActionExpandedActions;
    BOOL bActionJoinPartyFix;
    BOOL bActionPickpocketRemainHidden;
    BOOL bActionTakePartyItemFix;

    BOOL bArenasEnable;
    
    BOOL bDebugCriticalMsgBoxFix;
    BOOL bDebugExpandedLUAConsole;
    BOOL bDebugExternalLogging;
    BOOL bDebugLogDialogueBar;
    BOOL bDebugLogFailures;
    BOOL bDebugLogWarnings;
    BOOL bDebugLogMissingRes;
    BOOL bDebugLogMore;
    BOOL bDebugLogNetworkErrors;
    BOOL bDebugRestoreCombatInfoText;
    BOOL bDebugVerbose;
    BOOL bDisableHiddenPatches;
    BOOL bDisarmTrapDistanceFix;

    BOOL bEffApplyConcCheckDamage;
    BOOL bEffApplyEffItemFix;
    BOOL bEffApplyEffItemtypeFix;
    BOOL bEffAttacksPerRoundFix;
    BOOL bEffAwakenFix;
    BOOL bEffDamageAwaken;
    BOOL bEffBlindnessAsSpellDesc;
    BOOL bEffBlindnessFix;
    BOOL bEffButtonFXMod;
    BOOL bEffCastSpellConditionMod;
    BOOL bEffCastingLevelModFix;
    BOOL bEffCharismaModFix;
    BOOL bEffBackstabEveryHitConfig;
    BOOL bEffDamageBypassMirrorImageConfig;
    BOOL bEffStackingConfig;
    BOOL bEffDispelMagicalItemConfig;
    BOOL bEffConstitutionModFix;
    BOOL bEffContainerUseEffFileFix;
    BOOL bEffCureDrunkFix;
    BOOL bEffCutScene2Mod;
    BOOL bEffDamageFix;
    BOOL bEffDexterityMod;
    BOOL bEffStoneskinDisableColour;
    BOOL bEffDiseaseFix;
    BOOL bEffDisintegrateFix;
    BOOL bEffDispelFix;
    BOOL bEffDropInvDisintegrate;
    BOOL bEffDropInvFrozenDeath;
    BOOL bEffDropInvStoneDeath;
    BOOL bEffFatigueModFix;
    BOOL bEffFindTrapsModFix;
    BOOL bEffForbidItemTypeFix;
    BOOL bEffIntelligenceModFix;
    BOOL bEffIntoxicationModFix;
    BOOL bEffInvisibleFix;
    BOOL bEffLearnSpellMod;
    BOOL bEffLevelModFix;
    BOOL bEffLoreModFix;
    BOOL bEffLuckMod;
    BOOL bEffMageMemSpellMod;
    BOOL bEffMagicResistModFix;
    BOOL bEffMoraleBreakModFix;
    BOOL bEffNoDamageNoSpellInterrupt;
    BOOL bEffOpenLocksModFix;
    BOOL bEffPickPocketsModFix;
    BOOL bEffPoisonFix;
    BOOL bEffPoisonResistMod;
    BOOL bEffPolymorphFix;
    BOOL bEffPriestMemSpellMod;
    BOOL bEffProficiencyModMod;
    BOOL bEffRegenerationFix;
    BOOL bEffRemoveProjectileMod;
    BOOL bEffRepeatingEffFix;
    BOOL bEffReputationModFix;
    BOOL bEffSaveVsBreathMod;
    BOOL bEffSaveVsDeathMod;
    BOOL bEffSaveVsPolyMod;
    BOOL bEffSaveVsSpellMod;
    BOOL bEffSaveVsWandsMod;
    BOOL bEffSavingThrowFix;
    BOOL bEffStealthModFix;
    BOOL bEffStrengthExModFix;
    BOOL bEffStrengthMod;
    BOOL bEffTrackingModFix;
    BOOL bEffMirrorImageUseCastLevel;
    BOOL bEffUseEFFFileFix;
    BOOL bEffWisdomModFix;

    BOOL bEnginePriestKnownSpellsExtend;
    BOOL bEngineAllowDualClassAll;
    BOOL bEngineAllowEquipArmorCombat;
    BOOL bEngineAllowZeroStartXP;
    BOOL bEngineAssBHPenaltyKit;
    BOOL bEngineClericRangerHLAFix;
    BOOL bEngineCloneCreatureFix;
    //BOOL bEngineXPReportFix;
    int  nEngineCustomSoAStartXP;
    int  nEngineCustomToBStartXP;
    BOOL bEngineDisableEndPlayer1Dead;
    BOOL bEngineDisableInvPauseSP;
    BOOL bEngineDisableXPBoost;
    BOOL bEngineCharmSilenceRemoval;
    BOOL bEngineAutoPauseAllSP;
    BOOL bEngineExpandedStats;
    BOOL bEngineExternHPTables;
    BOOL bEngineExternClassRaceRestrictions;
    BOOL bEngineExternDifficulty;
    BOOL bEngineExternEncumbrance;
    BOOL bEngineExternMageSpellsCap;
    BOOL bEngineExternStealSlots;
    BOOL bEngineFakeTalkFix;
    BOOL bEngineLauncherProficiencyFix;
    BOOL bEngineProficiencyRestrictions;
    BOOL bEngineOptimiseVarCode;
    BOOL bEngineMoveAreasFix;
    BOOL bEngineRestSpawnsAdvanceTime;
    BOOL bEngineSpellTurningFix;
    BOOL bEngineSummonLimitFix;
    BOOL bEngineTargetDeadFix;
    BOOL bEngineWeapSpecNumAttacksMod;
    BOOL bEngineCharacterBehindPolygonFix;

    BOOL bItemsAbilityItemAnim;
    BOOL bItemsBackstabRestrictionsConfig;
    BOOL bItemsCriticalHitAversionConfig;
    BOOL bItemsTargetInvisConfig;
    BOOL bItemsRandomTreasureExtend;
    BOOL bItemsExternCreExcl;
    BOOL bItemsNonAmmoLauncherDamageFix;
    BOOL bItemsUseAnimPercentThrowingWeapons;

    BOOL bMusicSonglistExtend;
    BOOL bContinuousBattleMusic;

    BOOL bSoundAnimSoundFix;
    BOOL bSoundAnimAttackSounds;
    BOOL bSoundDlgGreetingSubtitles;
    BOOL bSoundExistenceFix;
    BOOL bSoundExternWalkSounds;
    BOOL bSoundSoundsetSubtitles;

    BOOL bSpellsCastingFix;
    BOOL bSpellsUnvoicedConfig;
    BOOL bSpellsTargetInvisConfig;
    BOOL bSpellsExternBardSong;

    BOOL bStoreItemRechargeMod;

    BOOL bTriggerPickpocketFailed;
    BOOL bTriggerExpandedTriggers;
    BOOL bTriggerKitFix;
    BOOL bTriggerOptimiseBagSearch;
    BOOL bTriggerPickpocketFailedOnly;

    BOOL bUserKitsExtend;
    BOOL bUserContingencySelectSpell;
    int  nUserCustomDlgBarSize;
    BOOL bUserLargerTooltipScroll;
    BOOL bUserExternMageSpellHiding;
    BOOL bUserExternRaceSelectionText;
    BOOL bUserChargenMageSpellScroll;
    BOOL bUserChargenKitSelectScroll;
    BOOL bUserRecordMageSpellScroll;
    BOOL bUserMageBookScroll;
    BOOL bUserPriestBookScroll;
    BOOL bUserFourInventorySlots;

    BOOL bVideoEnableMorePaperdolls;
    BOOL bVideoIWDAnimAttack3Fix;
    BOOL bVideoSpellTurningAnimFix;
    BOOL bVideoVvcAlphaCrashFix;
    BOOL bVideoVvcShadowAnimFix;

    BOOL bUI_LootPanel;
    BOOL bUI_LootPanelGUI_720Hack;
    BOOL bUI_ColorizeLearnableScrolls;
    BOOL bUI_HideWriteScrollButton;
    BOOL bUI_WeaponInfoOnInventoryScreen;
    BOOL bUI_WeaponInfoOnRecordScreen;
    BOOL bUI_DarkPortraitsIfItemNotAllowed;
    BOOL bUI_TotalRollInfo;
    BOOL bUI_FoldJournal;
    BOOL bUI_GreyBackgroundOnPause;
    //BOOL bUI_GreyBackgroundEnabled;
    BOOL bUI_UnlimitedHandOffSlot;
    BOOL bUI_LogActiveBuffs;
    BOOL bUI_LogActiveBuffsWithTime;
    BOOL bUI_LogActiveBuffsWithItems;
    BOOL bUI_LogActiveBuffsWithTime_Party;
    BOOL bUI_ExtendedEventText;
    BOOL bUI_CombatExtendedTextType;
    BOOL bUI_CombatExtendedTextFull;
    BOOL bUI_KeepDrainedSpellSlots;
    BOOL bUI_ShowHitPointsOnPortrait;
    BOOL bUI_ShowHitPointsOnPortrait_Always;
    BOOL bUI_ShowActionOnPortrait;
    BOOL bUI_ShowActionOnPortrait_Always;
    BOOL bUI_YellowBorderOnPortraitIfTooFar;

    BOOL bUI_NightmareMode;
    BOOL bNightmarePartySummon;
    BOOL bNightmareBonusXP;
    int  bNightmareBonusGold;
    int  bNightmareBonusXP_Multiplier;
    int  bNightmareBonusXP_Bonus;
    int  bNightmareBonusTHAC0;
    int  bNightmareBonusArmorClass;
    int  bNightmareBonusLevels;
    int  bNightmareBonusSpawns;
    int  bNightmareBonusAPR;
    BOOL bNightmareBonusNoMoraleBreak;
    int  bNightmareBonusSavingThrows;
    int  bNightmareBonusHP_Multiplier;
    int  bNightmareBonusHP_Bonus;
    int  bNightmareBonusHPSummon_Multiplier;
    int  bNightmareBonusHPSummon_Bonus;
    int  bNightmareBonusMovementRate;

    BOOL bEngineShamanClass;
    BOOL bUI_StartNewGameWithBG1Animation;
    BOOL bUI_GreetingBeforeDialog;
    BOOL bUI_GreetingBeforeDialog_BG2Chapters;
    BOOL bUI_HighlightActiveZones;
    BOOL bUI_HighlightActiveZones_InfoQuestion;
    BOOL bUI_HighlightActiveZones_InfoAction;
    BOOL bUI_HighlightActiveZones_EnterSteps;
    BOOL bUI_HighlightActiveZones_EnterDoor;
    BOOL bEngine_CpuIdle;
    BOOL bUI_DoubleRenderRate;
    BOOL bUI_DoubleRenderRate_MouseOnlyMode;
    BOOL bUI_FastProgressBarScreen;
    BOOL bVideo_FlickeringCursorFix;
    BOOL bEff_OverTargetVisualEffectFixes;
    int  bVideo_SkipFixedInterpolationModes;
    BOOL bVideo_OpenGL_VSync;
    BOOL bVideo_StretchGUI;
    BOOL bVideo_StretchCursor;
    BOOL bVideo_StretchGUI_WidescreenMode;
    BOOL bVideo_StretchAll;
    BOOL bVideo_ShiftSubtitlesDown;
    BOOL bUI_ImprovedStoreInterface;
    BOOL bUI_PickPocketsButtonForClericThief;
    BOOL bUI_DisableInnateToolBar;
    BOOL bUI_SequenceWindowButton;
    BOOL bUI_SpellIconRightClick;
    BOOL bEffProtectionFromSpellContingencyFix;
    BOOL bEngine_RunInBackground;
    BOOL bUI_HideStaticPortraitIcons;
    BOOL bUI_ShortCuts;
    BOOL bUI_PartyColorCircles;
    BOOL bUI_PartyColorCirclesExcludeNPCColors;
    BOOL bEff_StopInterruptedCastingAnimation;
    BOOL bUI_SpellSelectMenu;
    BOOL bUI_FullScreenWorldMap;
    BOOL bUI_ShowNPCFloatHP;
    BOOL bUI_ShowNPCFloatHP_Enemy;
    BOOL bUI_ShowNPCFloatHP_Party;
    BOOL bUI_ShowNPCFloatHP_Ally;
    BOOL bUI_ShowNPCFloatHP_Neutral;
    BOOL bUI_ShowNPCFloatName;
    BOOL bUI_AutoSwitchBookScreen;
    BOOL bUI_ExtendedRecordScreenText;
    BOOL bUI_ExtendedRecordScreenText_Threshold;
    BOOL bSound_Normalize;
    BOOL bSound_NormalizeCreOnly;
    BOOL bSound_NormalizePrintResname;
    BOOL bSound_BGTSelectionSoundSet;
    //BOOL bSound_BGTSelectionSoundSet_MODsAreBG2;
    BOOL bUI_DisableOffHandWeaponBG1part;
    BOOL bSound_ANISNDEX;
    BOOL bSound_DisableGenericAttackSound;
    BOOL bSound_RestoreCreatureAttackSounds;
    BOOL bAnimation_EXTANIM;
    BOOL bSound_DisableHardcodedBG1ItemSounds;
    BOOL bEff_SelfPatchedEffectRemovingFix;
    BOOL bEngine_AddPauseToSaveGame;
    BOOL bSound_SequenceOverrideFix;
    BOOL bVideo_AnkhegRangeWeaponAnimFix;
    BOOL bSound_PriorityCREOver2DA;
    BOOL bSound_DisableWeaponSwingSoundExclusive;
    BOOL bDebug_CrashdumpLibrary;
    BOOL bEff_ImprovedInvisibilityIcon;
    BOOL bEff_BlurAndMirrorImage_Icon;
    BOOL bBG1AnimationOffhandWeapon;
    BOOL bUI_BlockAreaTransitionCombat;
    BOOL bUI_MoraleBreakIcon;
    BOOL bSound_RobeArmor;
    BOOL bAnimation_SEQ_READY_AfterWeaponChange;
    BOOL bEngine_WSPECIAl_SPEED;
    //BOOL bEngine_InvisibilityRenderFix;
    BOOL bEngine_PartyBumpableInMoving;
    BOOL bEngine_EnemyCanBumpParty;
    BOOL bEngine_EnemyCanBumpPartyUnmoveable;
    BOOL bEffSavingThrowImprovedInvisibleBonus;
    BOOL bSound_BG1CastingSound;
    BOOL bSound_BG1CastingSound_Level;
    BOOL bSound_BG2ClearCastingSound;
    BOOL bSound_NWNCastingSound;
    BOOL bEngine_FakeDiskFreeSpace;
    BOOL bVideo_7313_PaletteFix;
    BOOL bEngine_LimitXP;
    BOOL bSound_DSOAL;
    BOOL bSound_44KhzMixer;
    BOOL bSound_FreezeOnPause;

protected:
    void Init();
};

extern CGameOptionsEx* pGameOptionsEx;

int GetCoreIniValue(LPCTSTR szSection, LPCTSTR szKey);
int GetCoreIniValue(LPCTSTR szSection, LPCTSTR szKey, LPCTSTR szDefault);
int GetTweakIniValue(LPCTSTR szSection, LPCTSTR szKey);
int GetTweakIniValue(LPCTSTR szSection, LPCTSTR szKey, LPCTSTR szDefault);
void InitOptions();

#endif //OPTIONS_H