# Jarl's Adventure Pack

#### Content List:

1. [Introduction](#introduction)
2. [Installation & Compatibility](#installation--compatibility)
3. [Components](#components)
4. [Hints & Notes](#hints--notes)
5. [Version History](#version-history)
6. [Legal Notes](#legal-notes)

<br>

## Introduction

This mod expands upon the content of the Baldur's Gate game.
There is a lot of content in BG1 that did not make it into the final game. The mod "BG1 Unfinished Business" restores some of them, but there are a lot more still. In addition, there are many instances in the game where the impression arises that something is missing or that it was not implemented completely.

This Adventure Pack adds to such points in the game. A lot of missing content not included in "BG1 UB" is restored by this mod, and situations that seemed meager are expanded upon. Still, there would be a lot more unused content to be found in the game. The more I worked with the BG1 files, the more instances I encountered.

Additionally to restorations and expansions this mod introduces some of my own ideas. For a detailed list of the content please refer to the section [Components](#components) below.


[Mod Page at Kerzenburgforum](https://baldurs-gate.de/index.php?resources/jarls-bgt-adventure-pack.8/)

[Mod Thread at Kerzenburgforum](https://baldurs-gate.de/index.php?threads/jarls-bgt-adventure-pack.42222/)

<br>

## Installation & Compatibility

Unpack the content of the zip-folder into your main game folder and start the _Setup-JA#BGT\_AdvPack.exe_ bei double-clicking. You have to start a new game after the installation!

This mod compatibile with BG:EE, EET and BGT.\
It is aviable in German and English.

Suggested [install order](JA%23BGT_AdvPack/JA%23BGT_AdvPack.ini#L29-L31) when installing with other mods:

- BG1 Unfinished Business
- Endless BG1
- Northern Tales of the Sword Coast
- Loretakers
- BG1 Mini Quests And Encounters
- ___Jarl's Adventure Pack___
- Baldur's Gate Romantic Encounters
- The BG1NPC Project
- Garrick Tales of a Troubadour
- Grey the Dog NPC
- Sword Coast Stratagems

<br>

## Components

1. Extended Law System
2. Ramazith
3. Jopi and his uncle Ragefast
4. Yuxi - Ragefast's imp
5. Husam's story line finished
6. IMPROVED/RESTORED: Ducal Palace
7. Gervisse & Voltine
8. Seven Suns
9. Arkhstuff
10. Iron Throne Guard
11. RESTORED: Palin - Aldeth's hunter comrade [^1]
12. RESTORED: Svlast - the fallen Paladin [^2] [^3]
13. RESTORED: Nashkel Garrison soldier
14. RESTORED: Velvet - Cockfight [^4]
15. RESTORED: Nim Furlwing [^2] [^3]
16. RESTORED: Caravan merchant
17. RESTORED: Galtoth - the fence
18. Phandalyn waits in Elfsong Tavern
19. RESTORED: Suthie & Sthief at Silence's Store [^1]
20. RESTORED: Warehouse Workers
21. RESTORED: Nobles
22. RESTORED: Yago's guard in Low Lantern
23. RESTORED: Ignatio Phleed - the invitation seller
24. RESTORED: Shalasin
25. RESTORED: Sir Artolas
26. RESTORED: Pilar & Gheldehar [^3]
27. RESTORED: Llindellyn - the archer [^3]
28. RESTORED: Mal-Kalen - Ulcaster's Adept [^2]
29. RESTORED: Keelor & Nasha [^3]
30. RESTORED: Marl - Tavern brawl at Feldepost's Inn
31. RESTORED: Beregost guards
32. RESTORED ITEM: Rythe's Last Arrow
33. RESTORED ITEM: The Protector of the Unworthy
34. IMPROVED/FIXED: Counting House
35. Merchants' League investigations
36. Aldeth & Seniyad
37. Aldeth's betrayal and remorse
38. Tenya and the fishermen
39. Tenya's quest in Temple of Umberlee
40. Nashkel changes
41. Stationary soldiers in Nashkel
42. Imoen at Winthrop's inn
43. Priest of Oghma, Gond and Ilmater in Baldur's Gate
44. Extended/Improved dialogues
45. Caldo can be charmed
46. Hulrik and his cows
47. Improved Shop of Silence
48. Ender Sai in Baldur's Gate
49. Sorcerous Sundries
50. RESTORED: Elfsong Tavern Movie [^2] [^5] [^6]
51. Mini-Quest: "The mystery of the silent ghostly voice"
52. Special keg in Elfsong Tavern [^4]
53. Black Alaric's Cave
54. RESTORED: Cloakwood druid
55. Extended meeting between Xzar and Niemain

<ol start="101">
  <li>Backdoor to Gellana's temple</li>
  <li>Backdoor to Waterqueen's House</li>
</ol>

<br>

## Hints & Notes

Note the following to see as much mod content as possible:

- Spare / defend Aldeth's life in the Cloakwood to see all the extended restored material for the Mearchants' League.
- Talk to Husam whenever you might see him.
- For pacifying Caldo and Krumm it needs a bit of imagination. ;)
- The plot inside the Ducal Palace is different now and more extended!

### Spoiler:

<details>
  <summary><b>If fighting Marl inside Feldepost's Inn the guards appear. How can I prevent this?</b></summary>
    Keep to the unwritten laws for tavern brawls, meaning: no weapons and only one opponent against one! Best to turn off group-AI during this fight.
</details>
<details>
  <summary><b>The Iron Throne Building is locked. How do I get inside?</b></summary>
    Ask the drunk Husam for advice. Also, search inside the houses nearby.
</details>

<details>
  <summary><b>How can the desk inside the Mearchants' League be opened?</b></summary>
    You need to pick-pocket the key from Zorl. Zorl can be sent away after talking to Irlentree on the first level, then the desk can be opened without consequences.
</details>

<details>
  <summary><b>Sarevok's Journal no longer is with Cythandria in the Iron Throne Building?</b></summary>
    No, Sarevok's journal will be inside the Ducal Palace.
</details>

<details>
  <summary><b>Why is the scene inside the Ducal Palace not starting?</b></summary>
    To start the scene, you need to go and pick Sarevok's journal from the second level. Nila will help you with this. Also, if expecting help from Husam, you need to grant him and his Shadow Thieves access to the palace, first (via the cellars).
</details>

<details>
  <summary><b>How can I spare Caldo and Krumm?</b></summary>
    Try the spell "Charm Person".
</details>

<br>

## Version History

#### v1.0: 06.04.2025 (by Ychap)

- lot of bug fixes
- complete revision of each component
- some components have been split into several ones
- deprecated Graphical improvements: Animated torches and candles ([Baldur's Gate Graphical Overhaul](https://github.com/Spellhold-Studios/Baldurs-Gate-Graphical-Overhaul) is far more extensive)
- removed most tweaks (they are still present in [Jarl's BGT Tweak Pack](https://www.baldurs-gate.de/index.php?resources/jarls-bgt-tweak-pack.7/))

#### v0.9: 27.02.2020 (by Weigo)

- many of bug fixes
- main component split into 37 separate components
- add Graphical improvements: Animated torches and candles

#### v0.8: 10.01.2020 (by Jastey)

- compatibility with bg1npc project v24: changed component numbers of bg1npc v24.x are considered
- Bently gets override script bently.bcs (same as in bg1ub): correction for "Extended Tavern Guard System"
- component "Useful Fixes & Repairs" no longer available (deprecated): all content available via the Jarl BGT Tweakpack
- compatibility with Tenya NPC mod: custom Tenya in Temple will not spawn if she is recruited as a party member.
- Vaalahor, mage in Sorcerous Sundries, second floor from quest "The mystery of the silent ghostly voice" should not turn hostile if Niemain and his comrades attack
- Phandalyn: should attack evil party member, not other characters in area
- Phandalyn: other characters in inn should not turn hostile (removed SHOUT script)
- hurt merchant on coast way road should not heal by himself and should detect help with a healing potion accordingly

#### v0.7: 21.02.2018 (packed by Jastey)

- (addition) Krammoch can also be asked for the key without threatening or stealing it from him. He now gives the cutsom amululett "Basiliskenzähmer" as a quest reward
- (install change) additional component: "Zweites Treffen und Dialogverbesserungen für Niemain und die Zentarim" (content taken from main component)
- (language versions) English version integrated: corrected and proofread translation from the BWPFixpack.
- (fix) all fixes from BWFixpack integrated
- (fix) all known bugs fixed (see below for details)
- (fix) fixed transitions of added reply options to Noralee's dialogue
- (fix) Aldeth and the Mearchant's League: changed reward for helping Aldeth against Seniyad to unique mod quest item always
- (fix) gave Jopi a dialogue state if talked to again before chapter 5 (added trigger to an existing one)
- (fix) closed holes and fixed bugs in the additions to the Merchants' League doppelganger quest
- (fix) Nelfas Vroc in the Palast's prison shouldn't be inside another prisoner any more
- (fix) Husam won't attack his own people in the palast's cellar any more
- (fix) husam will not remain standing in front of the Palace after Sarevok was revealed if the PC didn't want his help
- (fix) Naiduja in the Sorcerous Sundries will no longer become hostile if the Zentarim in the Sorcerous Sundries are hostile
- (fix) entrance guard of Low Lantern shouldn't loop his dialogue any more if the PC killed Yago
- (fix) hurt merchant at Coast Way should only react if player healed him with a spell or gave him a healing item. If the merchant dies, a rep decrease by 1 was added.
- (fix) Extended Mearchants' League quest: the merchant on the 2nd floor shouldn't talk about their suspicions after the quest is solved.
- (fix) Elfsong Tavern quest: talking to Commoner (MTOB5.cre) after hearing the rumor won't reset the quest variable
- (change) Restored belt "The Protector of the Unworthy" no longer replaces BELT03.itm ("Destroyer of the Hills").
- (change) AMUL14.itm ("The Protector +1") is no longer removed from area NWBaldursGate\_House4\_L1 (AR7269.ARE in BGT).
- (compatibility) added compatibility to bg1npc projects on all occations that I noticed (install order bg1npc - JAP)
- (compatibility) tweaked Hulrik's dialogue a little so it's compatible with Xvart Caverns
- (compatibility) following content will be skipped if already installed by NTotSC or UB:
  - Keelor & Nasha
  - Sylast, the Fallen Paladin
  - Pilar and Gheldehar
  - Llyndellyn the Archer
  - Nim Furlwing and her Hounds
  - Mal-Kalen, the Ghost from Ulcaster
  - Elfsong Tavern Movie
- (compatibility) Gervisse & Voltine: if JAP is installed after bg1npc, the quest will be compatible with bg1npc and Faldorn will have her interjection.
- (compatibility) with Garrick - Tales of a Troubadour: Tenya will only talk about the JAP quest if she didn't flirt with Garrick before. This solves some dialogue hickups if both mods are installed. Garrick will get the dryad's hair from the dryad if the conflict with the woodcutters was solved peacefully.
- (compatibility) with Fields of the Dead: install no longer fails if FotD BGT-version is installed
- (improved code) Phandalyn: remove from original game area is more compatible in case other mods made changes to the area. JAP no longer patches custom script name to Phanda.cre
- (improved code) changed script name patching of FLAMVAI.cre to "FLAMVAI" to make it consistent with possible other mods
- (improved code) changed patched script name of ENDER.CRE to "ENDER" (same as bg1npc)
- component "NPC-Portraits for the main component" was removed due to unclear copyright status
- update to WeiDU v244

#### v0.6 Beta: 06.07.2012 (by Jarl)

- Complete restructuring of the components
- Massive increase in content
- (Mod no longer comparable with v0.5)

#### v0.5 Beta: 01.03.2011 (by Jarl)

<br>

## Legal Notes

Legal Information: BALDUR'S GATE II: SHADOWS OF AMN Developed and © 2000 BioWare Corp. All Rights Reserved. BALDUR'S GATE II: THRONE OF BHAAL Developed and © 2001 BioWare Corp. All Rights Reserved. Baldur's Gate, Shadows of Amn, Tales of the Sword Coast, Forgotten Realms, the Forgotten Realms logo, Advanced Dungeons & Dragons, the AD&D logo, TSR and the TSR logo, and the Wizards of the Coast logo, are trademarks of the Wizards of the Coast, Inc., a subsidiary of Hasbro, Inc., and are used by Interplay Entertainment Corp. under license. All Rights Reserved. BioWare, the BioWare Infinity Engine and the BioWare logo are the trademarks of BioWare Corp. All Rights Reserved. Black Isle Studios and the Black Isle Studios logo are trademarks of Interplay Entertainment Corp. All Rights Reserved. Exclusively licensed and distributed by Interplay Entertainment Corp. All other trademarks and copyrights are property of their respective owners.

This mod is not developed, supported, or endorsed by BioWare, Black Isle Studios, Interplay Entertainment Corp., or the Wizards of the Coast. All other trademarks and copyrights are property of their respective owners.


[^1]: Already restored in BG:EE
[^2]: Also included in BG1 Unfinished Business
[^3]: Also included in Northern Tales of the Sword Coast
[^4]: Requires BG:EE, EET or Infinity Animations
[^5]: Already restored by BG:EE Classic Movies
[^6]: Already restored by Baldur's Gate: Enhanced Edition Trilogy (EET)
