/*
 * Copyright (C) 2010-2011 FlameWing
 * Copyright (C) 2015-2019 CrevsDaak
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

/* Time-stamp: </Users/nico/BG_modding/m7multikit/m7multikit/lib/multikit.tpp, 2024-01-24 Wednesday 19:16:50 nico> */

/******************************************************************************
 *      
 *      This is in the form of a library file for easier use in other mods.
 *      
 *      You must copy several entries from the tra file for this library to work
 *      correctly. The entries to copy are: @1300000 to @1300045
 *      
 *      You are free to use this file as long as due credit is given.
 *      
 ******************************************************************************
 *                                                                                *
 *           DO NOT EDIT THIS FILE UNLESS YOU KNOW WHAT YOU ARE DOING!!!!!        *
 *                                                                                *
 ******************************************************************************/

// Converts an integer to an hex string, padded, with zeroes, to eight digits:
DEFINE_ACTION_FUNCTION ~m7#int_to_hex_str~
        INT_VAR
                "number" = 0
        RET
                "hexstr"
BEGIN
        ACTION_DEFINE_ARRAY "hexdigits" BEGIN
                ~0~ ~1~ ~2~ ~3~ ~4~ ~5~ ~6~ ~7~ ~8~ ~9~
                ~a~ ~b~ ~c~ ~d~ ~e~ ~f~
        END
        ACTION_MATCH number
        WITH
                0
                BEGIN
                        OUTER_SPRINT "hexstr" "0x00000000"
                END
                0xFFFFFFFF BEGIN
                        OUTER_SPRINT "hexstr" "0xFFFFFFFF"
                END
                DEFAULT
                        OUTER_SET "num" = "%number%"
                        ACTION_IF ("%num%" < 0) BEGIN
                                OUTER_SET "absolute" = 0 - num
                                OUTER_SET "one_complement" = BNOT absolute
                                OUTER_SET "two_complement" = one_complement + 1
                                OUTER_SET "num" = two_complement
                        END
                        OUTER_SPRINT "hexstr" ""
                        OUTER_WHILE ("%num%" != 0) BEGIN
                                OUTER_SET "digit" = ("%num%" & 15)
                                OUTER_SET "%num%" >>= 4
                                OUTER_SPRINT "hexdigit" $hexdigits("%digit%")
                                OUTER_SPRINT "hexstr" "%hexdigit%%hexstr%"
                        END
                        OUTER_WHILE ((STRING_LENGTH "%hexstr%") < 8) BEGIN
                                OUTER_SPRINT "hexstr" "0%hexstr%"
                        END
                        OUTER_SPRINT "hexstr" "0x%hexstr%"
        END
END 

// Returns largest of 3 numbers.
DEFINE_PATCH_FUNCTION ~m7#max3~
        INT_VAR
                "n1" = 0
                "n2" = 0
                "n3" = 0
        RET
                "maxval"
BEGIN
        PATCH_IF ("%n1%" > "%n2%" AND "%n1%" > "%n3%") BEGIN
                SET "maxval" = "%n1%"
        END ELSE PATCH_IF ("%n2%" > "%n1%" AND "%n2%" > "%n3%") BEGIN
                SET "maxval" = "%n2%"
        END ELSE BEGIN
                SET "maxval" = "%n3%"
        END
END 

// Returns smallest of 3 numbers.
DEFINE_PATCH_FUNCTION ~m7#min3~
        INT_VAR
                "n1" = 0
                "n2" = 0
                "n3" = 0
        RET
                "minval"
BEGIN
        PATCH_IF ("%n1%" < "%n2%" AND "%n1%" < "%n3%") BEGIN
                SET "minval" = "%n1%"
        END ELSE PATCH_IF ("%n2%" < "%n1%" AND "%n2%" < "%n3%") BEGIN
                SET "minval" = "%n2%"
        END ELSE BEGIN
                SET "minval" = "%n3%"
        END
END 

// Conversion to base 36; returns 1 to 3 digits.
DEFINE_PATCH_FUNCTION ~m7#get_suffix~
        INT_VAR
                "number" = 0
        RET
                "suffixstr"
BEGIN
        DEFINE_ARRAY "tokens" BEGIN
                ~0~ ~1~ ~2~ ~3~ ~4~ ~5~ ~6~ ~7~ ~8~ ~9~
                ~a~ ~b~ ~c~ ~d~ ~e~ ~f~ ~g~ ~h~ ~i~ ~j~
                ~k~ ~l~ ~m~ ~n~ ~o~ ~p~ ~q~ ~r~ ~s~ ~t~
                ~u~ ~v~ ~w~ ~x~ ~y~ ~z~
        END
        // Clamp to range.
        PATCH_IF ("%number%" >= 46656) BEGIN
                SET "n1" = "%number%" / 46656
                SET "n1" *= 46656
                SET "number" -= "%n1%"
        END
        PATCH_IF ("%number%" >= 1296) BEGIN
                SET "n1" = "%number%" / 1296
                SPRINT "tok0" $tokens("%n1%")
                SET "n1" *= 1296
                SET "number" -= "%n1%"
        END ELSE BEGIN
                SPRINT "tok0" ""
        END

        PATCH_IF ("%number%" >= 36) BEGIN
                SET "n1" = "%number%" / 36
                SPRINT "tok1" $tokens("%n1%")
                SET "n1" *= 36
                SET "number" -= "%n1%"
        END ELSE BEGIN
                SPRINT "tok1" ""
        END

        SPRINT "tok2" $tokens("%number%")
        SPRINT "suffixstr" "%tok0%%tok1%%tok2%"
END 

// Conversion to base 36; returns a 1-digit number.
DEFINE_PATCH_FUNCTION ~m7#get_suffix1~
        INT_VAR
                "number" = 0
        RET
                "suffixstr"
BEGIN
        DEFINE_ARRAY "tokens" BEGIN
                ~0~ ~1~ ~2~ ~3~ ~4~ ~5~ ~6~ ~7~ ~8~ ~9~
                ~a~ ~b~ ~c~ ~d~ ~e~ ~f~ ~g~ ~h~ ~i~ ~j~
                ~k~ ~l~ ~m~ ~n~ ~o~ ~p~ ~q~ ~r~ ~s~ ~t~
                ~u~ ~v~ ~w~ ~x~ ~y~ ~z~
        END
        // Clamp to range.
        PATCH_IF ("%number%" >= 36) BEGIN
                SET "n1" = "%number%" / 36
                SET "n1" *= 36
                SET "number" -= "%n1%"
        END
        SPRINT "tok2" $tokens("%number%")
        SPRINT "suffixstr" "%tok2%"
END 

// Conversion to base 36; returns a 2-digit number, padded with 0's on left.
DEFINE_PATCH_FUNCTION ~m7#get_suffix2~
        INT_VAR
                "number" = 0
        RET
                "suffixstr"
BEGIN
        DEFINE_ARRAY "tokens" BEGIN
                ~0~ ~1~ ~2~ ~3~ ~4~ ~5~ ~6~ ~7~ ~8~ ~9~
                ~a~ ~b~ ~c~ ~d~ ~e~ ~f~ ~g~ ~h~ ~i~ ~j~
                ~k~ ~l~ ~m~ ~n~ ~o~ ~p~ ~q~ ~r~ ~s~ ~t~
                ~u~ ~v~ ~w~ ~x~ ~y~ ~z~
        END
        // Clamp to range.
        PATCH_IF ("%number%" >= 1296) BEGIN
                SET "n1" = "%number%" / 1296
                SET "n1" *= 1296
                SET "number" -= "%n1%"
        END
        SET "n1" = "%number%" / 36
        SPRINT "tok1" $tokens("%n1%")
        SET "n1" *= 36
        SET "number" -= "%n1%"

        SPRINT "tok2" $tokens("%number%")
        SPRINT "suffixstr" "%tok1%%tok2%"
END 

// Conversion to base 36; returns a 3-digit number, padded with 0's on left.
DEFINE_PATCH_FUNCTION ~m7#get_suffix3~
        INT_VAR
                "number" = 0
        RET
                "suffixstr"
BEGIN
        DEFINE_ARRAY "tokens" BEGIN
                ~0~ ~1~ ~2~ ~3~ ~4~ ~5~ ~6~ ~7~ ~8~ ~9~
                ~a~ ~b~ ~c~ ~d~ ~e~ ~f~ ~g~ ~h~ ~i~ ~j~
                ~k~ ~l~ ~m~ ~n~ ~o~ ~p~ ~q~ ~r~ ~s~ ~t~
                ~u~ ~v~ ~w~ ~x~ ~y~ ~z~
        END
        // Clamp to range.
        PATCH_IF ("%number%" >= 46656) BEGIN
                SET "n1" = "%number%" / 46656
                SET "n1" *= 46656
                SET "number" -= "%n1%"
        END
        SET "n1" = "%number%" / 1296
        SPRINT "tok0" $tokens("%n1%")
        SET "n1" *= 1296
        SET "number" -= "%n1%"

        SET "n1" = "%number%" / 36
        SPRINT "tok1" $tokens("%n1%")
        SET "n1" *= 36
        SET "number" -= "%n1%"

        SPRINT "tok2" $tokens("%number%")
        SPRINT "suffixstr" "%tok0%%tok1%%tok2%"
END 

// Conversion to base 36; returns 1 to 3 digits.
DEFINE_PATCH_FUNCTION ~m7#patch_get_suffix_padded~
        INT_VAR
                "number" = 0
        RET
                "suffixstr"
BEGIN
        SPRINT "ret" ""
        PATCH_IF ("%number%" < 36) BEGIN
                SET "n1" = "%number%"
                LAUNCH_PATCH_FUNCTION ~m7#get_suffix1~
                        INT_VAR
                                "number" = "%n1%"
                        RET
                                "ret" = "suffixstr" END
        END ELSE PATCH_IF ("%number%" >= 36 AND "%number%" < 1332) BEGIN
                SET "n1" = "%number%" - 36
                LAUNCH_PATCH_FUNCTION ~m7#get_suffix2~
                        INT_VAR
                                "number" = "%n1%"
                        RET
                                "ret" = "suffixstr" END
        END ELSE PATCH_IF ("%number%" >= 1332 AND "%number%" < 47988) BEGIN
                SET "n1" = "%number%" - 1332
                LAUNCH_PATCH_FUNCTION ~m7#get_suffix3~
                        INT_VAR
                                "number" = "%n1%"
                        RET
                                "ret" = "suffixstr" END
        END ELSE BEGIN
                // This is a just-in-case scenario only. Any class needing this will
                // probably cause BG2 to grind to a halt, then crash and burn.
                SET "n1" = "%number%"
                LAUNCH_PATCH_FUNCTION ~m7#get_suffix~
                        INT_VAR
                                "number" = "%n1%"
                        RET
                                "ret" = "suffixstr" END
        END
        SPRINT "suffixstr" "%ret%"
END 

// Conversion to base 36; returns 1 to 3 digits.
DEFINE_ACTION_FUNCTION ~m7#get_suffix_padded~
        INT_VAR
                "number" = 0
        RET
                "suffixstr"
BEGIN
        OUTER_SPRINT "ret" ""
        OUTER_PATCH "dummy" BEGIN
                SET "n1" = "%number%"
                LAUNCH_PATCH_FUNCTION ~m7#patch_get_suffix_padded~
                        INT_VAR
                                "number" = "%n1%"
                        RET
                                "ret" = "suffixstr" END
        END
        OUTER_SPRINT "suffixstr" "%ret%"
END 

// Convert effects with index in ["fxstart", "fxstart" + "fxcount") to use
// opcode 177 to conditionally call an effect.
DEFINE_PATCH_FUNCTION ~m7#convert_effects_to_indirect~
        INT_VAR
                "fxstart" = 0
                "fxcount" = 0
                "suffixid" = 0
                "specval" = 0
                "base_fx_offset" = 0
        STR_VAR
                "fxprefix" = ""
        RET
                "lastsuffix"
BEGIN
        // Initialize the return value:
        SET "lastsuffix" = "%suffixid%"
        // Size of an effect header:
        SET "fx_size" = 0x30
        SET "first_fx_offset" = "%base_fx_offset%"  + ("%fxstart%" * "%fx_size%")
        SET "final_fx_offset" = "%first_fx_offset%" + ("%fxcount%" * "%fx_size%")
        FOR ("%fx%" = "%first_fx_offset%"; "%fx%" < "%final_fx_offset%"; "%fx%" += "%fx_size%") BEGIN
                LAUNCH_PATCH_FUNCTION ~m7#patch_get_suffix_padded~
                        INT_VAR
                                "number" = "%lastsuffix%"
                        RET
                                "suffix" = "suffixstr" END
                SPRINT "effname" "%fxprefix%%suffix%"
                SET "lastsuffix" += 1
                // Write the effect:
                WRITE_SHORT  ("%fx%" + 0x00) 177
                WRITE_BYTE   ("%fx%" + 0x02) 2
                WRITE_BYTE   ("%fx%" + 0x03) 0
                WRITE_LONG   ("%fx%" + 0x04) "%specval%"
                WRITE_LONG   ("%fx%" + 0x08) 6
                WRITE_BYTE   ("%fx%" + 0x0c) 9
                WRITE_BYTE   ("%fx%" + 0x0d) 0
                WRITE_LONG   ("%fx%" + 0x0e) 0
                WRITE_BYTE   ("%fx%" + 0x12) 100
                WRITE_BYTE   ("%fx%" + 0x13) 0
                WRITE_ASCIIE ("%fx%" + 0x14) "%effname%" #8
                WRITE_LONG   ("%fx%" + 0x1c) 0
                WRITE_LONG   ("%fx%" + 0x20) 0
                WRITE_LONG   ("%fx%" + 0x24) 0
                WRITE_LONG   ("%fx%" + 0x28) 0
                WRITE_LONG   ("%fx%" + 0x2c) 0
        END
        
END

// Creates eff files from the spell effects headers with index in the range
// ["fxstart", "fxstart" + "fxcount").
DEFINE_ACTION_FUNCTION ~m7#dump_effects_to_eff_file~
        INT_VAR
                "fxstart" = 0
                "fxcount" = 0
                "suffixid" = 0
                "specval" = 0
                "base_fx_offset" = 0
        STR_VAR
                "sourcespell" = ""
                "destspell" = ""
                "fxprefix" = ""
        RET
                "lastsuffix"
BEGIN
        // Initialize the return value:
        OUTER_SET "lastsuffix" = "%suffixid%"
        // Size of an effect header:
        OUTER_SET "fx_size" = 0x30
        OUTER_SET "first_fx_offset" = "%base_fx_offset%"  + ("%fxstart%" * "%fx_size%")
        OUTER_SET "final_fx_offset" = "%first_fx_offset%" + ("%fxcount%" * "%fx_size%")
        OUTER_FOR ("%fx%" = "%first_fx_offset%"; "%fx%" < "%final_fx_offset%"; "%fx%" += "%fx_size%") BEGIN
                LAUNCH_ACTION_FUNCTION ~m7#get_suffix_padded~
                        INT_VAR
                                "number" = "%lastsuffix%"
                        RET
                                "suffix" = "suffixstr" END
                OUTER_SET "lastsuffix" += 1
                COPY ~%modpath%/m7mkap.eff~ ~override/%fxprefix%%suffix%.eff~
                        // Read original effect:
                        INNER_PATCH_FILE ~%sourcespell%.spl~ BEGIN
                                READ_LONG  (         0x18) "val0"
                                READ_SHORT ("%fx%" + 0x00) "val1"
                                READ_BYTE  ("%fx%" + 0x02) "val2"
                                READ_BYTE  ("%fx%" + 0x03) "val3"
                                READ_LONG  ("%fx%" + 0x04) "val4"
                                READ_LONG  ("%fx%" + 0x08) "val5"
                                READ_BYTE  ("%fx%" + 0x0c) "val6"
                                READ_BYTE  ("%fx%" + 0x0d) "val7"
                                READ_LONG  ("%fx%" + 0x0e) "val8"
                                READ_BYTE  ("%fx%" + 0x12) "val9"
                                READ_BYTE  ("%fx%" + 0x13) "vala"
                                READ_ASCII ("%fx%" + 0x14) "valb" (8)
                                READ_LONG  ("%fx%" + 0x1c) "valc"
                                READ_LONG  ("%fx%" + 0x20) "vald"
                                READ_LONG  ("%fx%" + 0x24) "vale"
                                READ_LONG  ("%fx%" + 0x28) "valf"
                        END
                        // Convert to eff file:
                        WRITE_LONG   0x10 "%val1%"
                        WRITE_LONG   0x14 "%val2%"
                        WRITE_LONG   0x18 "%val3%"
                        WRITE_LONG   0x1c "%val4%"
                        WRITE_LONG   0x20 "%val5%"
                        WRITE_SHORT  0x24 "%val6%"
                        WRITE_LONG   0x5c "%val7%"
                        WRITE_LONG   0x28 "%val8%"
                        WRITE_SHORT  0x2c "%val9%"
                        WRITE_SHORT  0x2e "%vala%"
                        WRITE_ASCIIE 0x30 "%valb%" #8
                        WRITE_LONG   0x38 "%valc%"
                        WRITE_LONG   0x3c "%vald%"
                        WRITE_LONG   0x40 "%vale%"
                        WRITE_LONG   0x44 "%valf%"
                        // Parent information:
                        WRITE_LONG   0x90 1
                        WRITE_ASCIIE 0x94 "%destspell%" #8
                        WRITE_LONG   0x9c "%val0%"
                        WRITE_LONG   0xd0 1
        END
END

// 'Explodes' a spell into its component effects plus another spell that will
// conditionally apply them by way of opcode 177.
DEFINE_ACTION_FUNCTION ~m7#explode_spell_effects~
        INT_VAR
                "suffixid" = 0
                "specval" = 0
        STR_VAR
                "sourcespell" = ""
                "destspell" = ""
                "fxprefix" = ""
        RET
                "lastsuffix"
BEGIN
        // Size of an ability header:
        OUTER_SET "abil_size" = 0x28
        // Size of an effect header:
        OUTER_SET "fx_size" = 0x30
        
        // Internal conuter:
        OUTER_SET "currsuffix" = "%suffixid%"

        // Internal variables:
        OUTER_SET "mspecval" = "%specval%"
        OUTER_SPRINT "msourcespell" "%sourcespell%"
        OUTER_SPRINT "mdestspell" "%destspell%"
        OUTER_SPRINT "mfxprefix" "%fxprefix%"
        ACTION_DEFINE_ARRAY "abil_fx_start" BEGIN END
        ACTION_DEFINE_ARRAY "abil_fx_count" BEGIN END
        OUTER_SET "num_abil" = 0
        OUTER_SET "global_fx_first" = 0
        OUTER_SET "global_fx_count" = 0
        OUTER_SET "base_fx_offset" = 0

        // Begin by making the caller spell.
        COPY_EXISTING ~%sourcespell%.spl~ ~override/%destspell%.spl~
                // Where the effects are in the file:
                READ_LONG  0x6a "base_fx_offset" ELSE 0
                SET "mbase_fx_offset" = "%base_fx_offset%"
                // Index of the first global effect:
                READ_SHORT 0x6e "global_fx_first" ELSE 0
                // How many global effects there are:
                READ_SHORT 0x70 "global_fx_count" ELSE 0
                // First, convert global effects into 177 effects:
                LAUNCH_PATCH_FUNCTION ~m7#convert_effects_to_indirect~
                        INT_VAR
                                "fxstart" = "%global_fx_first%"
                                "fxcount" = "%global_fx_count%"
                                "suffixid" = "%currsuffix%"
                                "specval" = "%mspecval%"
                                "base_fx_offset" = "%mbase_fx_offset%"
                        STR_VAR
                                "fxprefix" = EVAL "%mfxprefix%"
                        RET
                                "currsuffix" = "lastsuffix" END
                // Where the first ability is:
                READ_LONG 0x64 "base_abil_offset" ELSE 0
                // How many abilities there are:
                READ_SHORT 0x68 "num_abil" ELSE 0
                // For convenience:
                SET "abil_offset" = "%base_abil_offset%"
                // Go through each ability:
                FOR ("%abil%" = 0; "%abil%" < "%num_abil%"; "%abil%" += 1) BEGIN
                        // Number of effects in ability:
                        READ_SHORT ("%abil_offset%" + 0x1e) "num_fx" ELSE 0
                        // Index of ability's first effect:
                        READ_SHORT ("%abil_offset%" + 0x20) "ind_fx" ELSE 0
                        // Store count:
                        SET $abil_fx_count("%abil%") = "%num_fx%"
                        SET $abil_fx_start("%abil%") = "%ind_fx%"
                        // Convert all ability effects into 177 effects:
                        LAUNCH_PATCH_FUNCTION ~m7#convert_effects_to_indirect~
                                INT_VAR
                                        "fxstart" = "%ind_fx%"
                                        "fxcount" = "%num_fx%"
                                        "suffixid" = "%currsuffix%"
                                        "specval" = "%mspecval%"
                                        "base_fx_offset" = "%mbase_fx_offset%"
                                STR_VAR
                                        "fxprefix" = EVAL "%mfxprefix%"
                                RET
                                        "currsuffix" = "lastsuffix" END
                        // Advance to next ability:
                        SET "abil_offset" += "%abil_size%"
                END
        // And reset internal counter:
        OUTER_SET "currsuffix" = "%suffixid%"

        // We will now craft each of the effects we need.
        // Start with global effects, as above.
        LAUNCH_ACTION_FUNCTION ~m7#dump_effects_to_eff_file~
                INT_VAR
                        "fxstart" = "%global_fx_first%"
                        "fxcount" = "%global_fx_count%"
                        "suffixid" = "%currsuffix%"
                        "specval" = "%mspecval%"
                        "base_fx_offset" = "%mbase_fx_offset%"
                STR_VAR
                        "sourcespell" = EVAL "%msourcespell%"
                        "destspell" = EVAL "%mdestspell%"
                        "fxprefix" = EVAL "%mfxprefix%"
                RET
                        "currsuffix" = "lastsuffix" END
        // Continue doing ability effects.
        OUTER_FOR ("%abil%" = 0; "%abil%" < "%num_abil%"; "%abil%" += 1) BEGIN
                LAUNCH_ACTION_FUNCTION ~m7#dump_effects_to_eff_file~
                        INT_VAR
                                "fxstart" = $abil_fx_start("%abil%")
                                "fxcount" = $abil_fx_count("%abil%")
                                "suffixid" = "%currsuffix%"
                                "specval" = "%mspecval%"
                                "base_fx_offset" = "%mbase_fx_offset%"
                        STR_VAR
                                "sourcespell" = EVAL "%msourcespell%"
                                "destspell" = EVAL "%mdestspell%"
                                "fxprefix" = EVAL "%mfxprefix%"
                        RET
                                "currsuffix" = "lastsuffix" END
        END

        // Set return value now that we know it:
        OUTER_SET "lastsuffix" = "%currsuffix%"
END 

// Finds text surrounded by tildes.
DEFINE_PATCH_FUNCTION ~m7#find_name~
        INT_VAR
                "offset" = 0
        RET
                "name"
                "position"
BEGIN
        SET "pos" = "%offset%"
        SET "len" = BUFFER_LENGTH
        SET "start" = 0 - 1
        // Sane defaults.
        SPRINT "str" ""
        SET "position" = BUFFER_LENGTH - 1
        WHILE ("%pos%" < "%len%") BEGIN
                // Read one char at a time.
                READ_ASCII "%pos%" "char" (1)
                // Looking for a tilde.
                PATCH_IF ("%char%" STRING_EQUAL "~") BEGIN
                        // Already have a tilde?
                        PATCH_IF ("%start%" >= 0) BEGIN
                                // Yes; read the entire title...
                                READ_ASCII ("%start%" + 1) "str" ("%pos%" - "%start%" - 1)
                                SET "position" = "%pos%"
                                // ... and flag we found it.
                                SET "pos" = "%len%"
                        END ELSE BEGIN
                                // Flag where the first tilde is.
                                SET "start" = "%pos%"
                        END
                END
                SET "pos" += 1
        END
        SPRINT "name" "%str%"
END

// Finds a number at the end of the buffer.
DEFINE_PATCH_FUNCTION ~m7#find_designation~
        INT_VAR
                "offset" = 0
        RET
                "numid"
BEGIN
        SET "pos" = "%offset%"
        // Sane default.
        SPRINT "str" "0"
        SET "numid" = 0
        WHILE ("%pos%" < BUFFER_LENGTH) BEGIN
                // Read one char at a time.
                READ_ASCII "%pos%" "char" (1)
                // Looking for a number.
                PATCH_IF (("%char%" STRING_MATCHES_REGEXP "[0-9]") == 0) BEGIN
                        // Found. Read number...
                        SET "pos2" = "%pos%" + 1
                        READ_ASCII "%pos2%" "char" (1)
                        WHILE (("%char%" STRING_MATCHES_REGEXP "[0-9]") == 0) BEGIN
                                SET "pos2" += 1
                                READ_ASCII "%pos2%" "char" (1)
                        END
                        READ_ASCII "%pos%" "str" ("%pos2%" - "%pos%")
                        // ... and flag we found it.
                        SET "pos" = BUFFER_LENGTH
                END
                SET "pos" += 1
        END
        SET "numid" = "%str%"
END

// Skips all cr/lf characters and returns the position of the first non-crlf
// character found.
DEFINE_PATCH_FUNCTION ~m7#skip_crlf~
        INT_VAR
                "offset" = 0
        RET
                "position"
BEGIN
        SET "pos" = "%offset%"
        // Sane default.
        SET "position" = BUFFER_LENGTH - 1
        WHILE ("%pos%" < BUFFER_LENGTH) BEGIN
                // Read one char at a time.
                READ_BYTE "%pos%" "char"
                // We want neither carriage returns nor line feeds.
                PATCH_IF (("%char%" != 10) AND ("%char%" != 13)) BEGIN
                        SET "position" = "%pos%"
                        // Break.
                        SET "pos" = BUFFER_LENGTH
                END
                SET "pos" += 1
        END
END

// Skips all characters until a cr or a lf is found. Returns the position of the
// last non-crlf character found.
DEFINE_PATCH_FUNCTION ~m7#skip_to_crlf~
        INT_VAR
                "offset" = 0
        RET
                "position"
BEGIN
        SET "pos" = "%offset%"
        // Sane default.
        SET "position" = BUFFER_LENGTH - 1
        WHILE ("%pos%" < BUFFER_LENGTH) BEGIN
                // Read one char at a time.
                READ_BYTE "%pos%" "char"
                // We want either a carriage return or a line feed.
                PATCH_IF (("%char%" == 10) OR ("%char%" == 13)) BEGIN
                        SET "position" = "%pos%" - 1
                        // Break.
                        SET "pos" = BUFFER_LENGTH
                END
                SET "pos" += 1
        END
END

// Reads a non-empty line from a text file. The position returned points to the
// first non-empty line following the line read.
// Parses carriage returns, line-feeds or combinations, so should work on
// Windows, Mac OS and Linux line endings.
DEFINE_PATCH_FUNCTION ~m7#read_line~
        INT_VAR
                "offset" = 0
        RET
                "position"
                "line_text"
BEGIN
        SET "moff" = "%offset%"
        // Find first non-crlf character.
        LAUNCH_PATCH_FUNCTION ~m7#skip_crlf~
                INT_VAR
                        "offset" = "%moff%"
                RET
                        "start" = "position" END
        // Find next crlf character.
        LAUNCH_PATCH_FUNCTION ~m7#skip_to_crlf~
                INT_VAR
                        "offset" = "%start%"
                RET
                        "pos" = "position" END
        // Guard againt end of file.
        PATCH_IF ("%pos%" >= "%start%") BEGIN
                // Read between the stored locations.
                READ_ASCII "%start%" "line_text" ("%pos%" - "%start%" + 1)
        END ELSE BEGIN
                SPRINT "line_text" ""
        END
        // Skip to next non-crlf character.
        LAUNCH_PATCH_FUNCTION ~m7#skip_crlf~
                INT_VAR
                        "offset" = "%pos%" + 1
                RET
                        "pos" = "position" END
        // Store our position.
        SET "position" = "%pos%"
END

// Fix old tp2.
DEFINE_ACTION_FUNCTION ~m7#fix_old_tp2~
BEGIN
        COPY_EXISTING ~%basepath%/multikits.tp2~ ~%basepath%/multikits.tp2~
                SET "pos" = 0
                SET "cid" = 0
                SET "nsize" = BUFFER_LENGTH
                WHILE ("%pos%" < "%nsize%") BEGIN
                        SET "line" = "%pos%"
                        // Read one line at a time.
                        LAUNCH_PATCH_FUNCTION ~m7#read_line~
                                INT_VAR
                                        "offset" = EVAL "%line%"
                                RET
                                        "pos" = "position"
                                        "linestr" = "line_text" END
                        // Sanity check.
                        PATCH_IF ((STRING_LENGTH "%linestr%") == 0) BEGIN
                                // This should be picked up already; why isn't it?
                                SET "pos" = BUFFER_LENGTH
                        END ELSE PATCH_IF (("%linestr%" STRING_MATCHES_REGEXP "^BEGIN[   ]+~'[^']+'[     ]+multikit~[    ]*$") == 0) BEGIN
                                // Found where to add the forced designation.
                                SPRINT "componid" " DESIGNATED %cid% REQUIRE_PREDICATE MOD_IS_INSTALLED ~m7multikit.tp2~ 10 @1300033"
                                SET "cid" += 1
                                // Number of bytes needed, plus location.
                                SET "nbytes" = STRING_LENGTH "%componid%"
                                SET "offset" = "%line%" + (STRING_LENGTH "%linestr%")
                                // Add the bytes needed.
                                INSERT_BYTES "%offset%" "%nbytes%"
                                // Increase file size too.
                                SET "nsize" += "%nbytes%"
                                // Write the designation.
                                WRITE_ASCIIE "%offset%" "%componid%"
                        END ELSE PATCH_IF (("%linestr%" STRING_MATCHES_REGEXP "^BEGIN[   ]+~'[^']+'[     ]+multikit~[    ]+DESIGNATED[   ]+[0-9]+[       ]*$") == 0) BEGIN
                                // Found where to add the forced designation.
                                INNER_PATCH "%linestr%" BEGIN
                                        // Find the component designation.
                                        LAUNCH_PATCH_FUNCTION ~m7#find_designation~
                                                INT_VAR
                                                        "offset" = 0
                                                RET
                                                        "cid" = "numid" END
                                END
                                SPRINT "componid" " REQUIRE_PREDICATE MOD_IS_INSTALLED ~m7multikit.tp2~ 10 @1300033"
                                SET "cid" += 1
                                // Number of bytes needed, plus location.
                                SET "nbytes" = STRING_LENGTH "%componid%"
                                SET "offset" = "%line%" + (STRING_LENGTH "%linestr%")
                                // Add the bytes needed.
                                INSERT_BYTES "%offset%" "%nbytes%"
                                // Increase file size too.
                                SET "nsize" += "%nbytes%"
                                // Write the designation.
                                WRITE_ASCIIE "%offset%" "%componid%"
                        END
                END
                BUT_ONLY
END

// Find last used designation.
// Maybe rewrite for backward parsing?
DEFINE_PATCH_FUNCTION ~m7#find_last_multikit_designation~
        STR_VAR
                kit_file_path = "" // if this isn't set, installation WILL fail
        RET
                "numid"
BEGIN
        INNER_PATCH_FILE ~%kit_file_path%/multikits.tp2~ BEGIN
                SET "pos" = 0
                SET "cid" = 0 - 1
                WHILE ("%pos%" < BUFFER_LENGTH) BEGIN
                        SET "line" = "%pos%"
                        // Read one line at a time.
                        LAUNCH_PATCH_FUNCTION ~m7#read_line~
                                INT_VAR
                                        "offset" = EVAL "%line%"
                                RET
                                        "pos" = "position"
                                        "linestr" = "line_text" END
                        // Sanity check.
                        PATCH_IF ((STRING_LENGTH "%linestr%") == 0) BEGIN
                                // This should be picked up already; why isn't it?
                                SET "pos" = BUFFER_LENGTH
                        END ELSE PATCH_IF (("%linestr%" STRING_CONTAINS_REGEXP "^BEGIN[  ]+~'[^']+'[     ]+multikit~[    ]+DESIGNATED[   ]+[0-9]+") == 0) BEGIN
                                INNER_PATCH "%linestr%" BEGIN
                                        // Find the component name in this mess.
                                        LAUNCH_PATCH_FUNCTION ~m7#find_name~
                                                INT_VAR
                                                        "offset" = 0
                                                RET
                                                        "namestr" = "name" END
                                        // Find the component designation.
                                        LAUNCH_PATCH_FUNCTION ~m7#find_designation~
                                                INT_VAR
                                                        "offset" = 0
                                                RET
                                                        "desid" = "numid" END
                                END
                                PATCH_IF ("%desid%" > "%cid%") BEGIN
                                        SET "cid" = "%desid%"
                                END
                        END
                END
        END
        // The last found designation.
        SET "numid" = "%cid%"
END

/******************************************************************************
 *      
 *      m7#build_multikit
 *      
 *      This function prompts for the creation of one multikit then creates an entry
 *      for it in a tp2 file. The parameters, and their descriptions, are:
 *      
 *      ****    String parameters (SPRINT or OUTER_SPRINT)
 *      Name               Description
 *      "modprefix"        This is your modder prefix. THIS MUST BE AT MOST 2 CHARACTERS!
 *      "modpath"          This is the path to your mod, to make it convenient.
 *      "kit_file_path"    By default set to weidu_external/m7multikit, dictates
                           where multikits.tp2 goes after kits are created.
 *      
 *      ****    Integer parameters (SET or OUTER_SET)
 *      Name                Description
 *      "wanttitle"         If this is set to anything non-zero, the TPP will ask
 *                          you for a custom title for the multikit. If a title is
 *                          not specified like this, or if it is empty, the final
 *                          multikit will have an autogenerated title.
 *      "explode_spells"    If this is set to anything non-zero, the new method of
 *                          'exploding' applied spells into their component effects
 *                          will be used. This allows full removal of the multikit.
 *
 ******************************************************************************/
DEFINE_ACTION_FUNCTION ~m7#build_multikit~
        INT_VAR
                "wanttitle" = 0
                "explode_spells" = 0
        STR_VAR
                "modprefix" = ""
                "modpath" = ""
                "kit_file_path" = "weidu_external/m7multikit"
BEGIN
        // Just in case we have a freshly added kit from elsewhere.
        CLEAR_IDS_MAP

        // Default class names. The multi-class ones should not be used,
        // ever, by this tp2 file if everything works as it should.
        ACTION_DEFINE_ARRAY "classnum"  BEGIN
                ~0~ ~10176~ ~10174~ ~10177~ ~10175~ ~10179~ ~10194~ ~10189~ ~10187~
                ~10178~ ~10191~ ~10186~ ~10173~ ~10193~ ~10180~ ~10184~ ~10188~
                ~10190~ ~10182~ ~12837~ ~9410~
        END
        ACTION_DEFINE_ARRAY "classnam"  BEGIN END
        OUTER_PATCH "dummy" BEGIN
                PHP_EACH "classnum" AS "id" => "num" BEGIN
                        GET_STRREF "%num%" $classnam("%id%")
                END
        END
        // These are placeholders:
        ACTION_DEFINE_ARRAY "classes"  BEGIN END
        ACTION_DEFINE_ARRAY "names"    BEGIN END

        // Multikit building prompts.
        OUTER_PATCH "dummy" BEGIN
                // The multiclasses:
                DEFINE_ARRAY "multilist" BEGIN
                        ~FIGHTER_MAGE~ ~FIGHTER_CLERIC~ ~FIGHTER_THIEF~ ~FIGHTER_MAGE_THIEF~
                        ~MAGE_THIEF~ ~CLERIC_MAGE~ ~CLERIC_THIEF~ ~FIGHTER_DRUID~
                        ~FIGHTER_MAGE_CLERIC~ ~CLERIC_RANGER~
                END
                SPRINT "list" ""
                // Build a friendly name multiclass list.
                PHP_EACH "multilist" AS "id" => "idsname" BEGIN
                        SET "sym" = IDS_OF_SYMBOL (~class~ ~%idsname%~)
                        SPRINT "name" $classnam("%sym%")
                        SPRINT "list" "%list%[%id%] %name%
"
                END
                SET "kitclassids" = 0 - 1
                // Multiclass selection:
                WHILE ("%kitclassids%" < 0) BEGIN
                        // Prompt for a multiclass:
                        PATCH_PRINT @1300001
                        PATCH_PRINT ~%list%~
                        PATCH_READLN "val"
                        // Check return value:
                        PATCH_IF (NOT (IS_AN_INT "%val%")) BEGIN
                                // We want an integer:
                                PATCH_PRINT @1300002
                        END ELSE PATCH_IF ("%val%" < 0 OR "%val%" >= 10) BEGIN
                                // An integer, but not on the list...
                                PATCH_PRINT @1300003
                        END ELSE BEGIN
                                // Store the multiclass and its numeric code.
                                SPRINT "kitclass" $multilist("%val%")
                                SET "kitclassids" = IDS_OF_SYMBOL (~class~ ~%kitclass%~)
                        END
                END
                
                // Basically a switch to get the multiclass component classes.
                SET "numkits" = 2
                CLEAR_ARRAY "classes"
                PATCH_IF ("%kitclassids%" == 7) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~MAGE~
                END ELSE PATCH_IF ("%kitclassids%" == 8) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~CLERIC~
                END ELSE PATCH_IF ("%kitclassids%" == 9) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 10) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~MAGE~
                        SPRINT $classes(2) ~THIEF~
                        SET "numkits" = 3
                END ELSE PATCH_IF ("%kitclassids%" == 13) BEGIN
                        SPRINT $classes(0) ~MAGE~
                        SPRINT $classes(1) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 14) BEGIN
                        SPRINT $classes(0) ~CLERIC~
                        SPRINT $classes(1) ~MAGE~
                END ELSE PATCH_IF ("%kitclassids%" == 15) BEGIN
                        SPRINT $classes(0) ~CLERIC~
                        SPRINT $classes(1) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 16) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~DRUID~
                END ELSE PATCH_IF ("%kitclassids%" == 17) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~MAGE~
                        SPRINT $classes(2) ~CLERIC~
                        SET "numkits" = 3
                END ELSE PATCH_IF ("%kitclassids%" == 18) BEGIN
                        SPRINT $classes(0) ~CLERIC~
                        SPRINT $classes(1) ~RANGER~
                END

                CLEAR_ARRAY "kits"
                DEFINE_ARRAY "kitlist"  BEGIN END
                DEFINE_ARRAY "namelist" BEGIN END
                // Iterate through the component classes.
                PHP_EACH "classes" AS "id" => "idsname" BEGIN
                        // Get ids symbol.
                        SET "idsval" = IDS_OF_SYMBOL (~class~ ~%idsname%~)
                        CLEAR_ARRAY "kitlist"
                        CLEAR_ARRAY "namelist"
                        // Start building kit prompt for class.
                        SPRINT "list" @1300004
                        SPRINT "clsname" $classnam("%idsval%")
                        SPRINT $namelist(0) "%clsname%"
                        SPRINT $kitlist(0) ~%idsname%~
                        SET "kitcnt" = 1
                        // We now list the kits of this class.
                        INNER_PATCH_FILE ~kitlist.2da~ BEGIN
                                COUNT_2DA_COLS "cols"
                                COUNT_2DA_ROWS "%cols%" "rows"
                                FOR ("%index%" = 1; "%index%" < "%rows%"; "%index%" += 1) BEGIN
                                        // This column has the base class of the kit.
                                        READ_2DA_ENTRY "%index%" 8 "%cols%" "val"
                                        // If it matches our current class, nab it.
                                        PATCH_IF ("%val%" == "%idsval%") BEGIN
                                                // Kit symbol.
                                                READ_2DA_ENTRY "%index%" 1 "%cols%" "name"
                                                PATCH_IF // list taken from level1npcs, needs update
                                                        ~%name%~ STR_CMP ~sswashtF~ &&
                                                        ~%name%~ STR_CMP ~sswashtw~ &&
                                                        ~%name%~ STR_CMP ~LATHANDER_X~ &&
                                                        ~%name%~ STR_CMP ~trueres~ &&
                                                        ~%name%~ STR_CMP ~shadowdancertw~ &&
                                                        ~%name%~ STR_CMP ~shadowdancertf~ &&
                                                        ~%name%~ STR_CMP ~truequi~ &&
                                                        ~%name%~ STR_CMP ~truequF~ &&
                                                        ~%name%~ STR_CMP ~assatF~ &&
                                                        ~%name%~ STR_CMP ~assatw~ &&
                                                        ~%name%~ STR_CMP ~bountF~ &&
                                                        ~%name%~ STR_CMP ~bountw~ &&
                                                        ~%name%~ STR_CMP ~bersetF~ &&
                                                        ~%name%~ STR_CMP ~bersetw~ &&
                                                        ~%name%~ STR_CMP ~kensatF~ &&
                                                        ~%name%~ STR_CMP ~kensatw~ &&
                                                        ~%name%~ STR_CMP ~talostF~ &&
                                                        ~%name%~ STR_CMP ~talostw~ &&
                                                        ~%name%~ STR_CMP ~helmtF~ &&
                                                        ~%name%~ STR_CMP ~helmtw~ &&
                                                        ~%name%~ STR_CMP ~lathtF~ &&
                                                        ~%name%~ STR_CMP ~lathtw~ &&
                                                        ~%name%~ STR_CMP ~magetw~ &&
                                                        ~%name%~ STR_CMP ~bladetw~ &&
                                                        ~%name%~ STR_CMP ~shaptw~ &&
                                                        ~%name%~ STR_CMP ~shaptF~ &&
                                                        ~%name%~ STR_CMP ~WWANTItF~ &&
                                                        ~%name%~ STR_CMP ~WWANTItw~ &&
                                                        ~%name%~ STR_CMP ~WWARCHtF~ &&
                                                        ~%name%~ STR_CMP ~WWARCHtw~ &&
                                                        ~%name%~ STR_CMP ~PEERARCHtw~ &&
                                                        ~%name%~ STR_CMP ~PEERARCHtf~ &&
                                                        ~%name%~ STR_CMP ~A#SHARPSHOOTERtw~ &&
                                                        ~%name%~ STR_CMP ~A#SHARPSHOOTERtF~ &&
                                                        ~%name%~ STR_CMP ~C!Selunetw~ &&
                                                        ~%name%~ STR_CMP ~C!SelunetF~ &&
                                                        ~%name%~ STR_CMP ~A#SHARtw~ &&
                                                        ~%name%~ STR_CMP ~A#SHARtF~ &&
                                                        ~%name%~ STR_CMP ~A#TEMPtw~ &&
                                                        ~%name%~ STR_CMP ~A#TEMPtF~ &&
                                                        ~%name%~ STR_CMP ~barbtF~ &&
                                                        ~%name%~ STR_CMP ~barbtwF~ &&
                                                        ~%name%~ STR_CMP ~YRKENSAI~ &&
                                                        ~%name%~ STR_CMP ~m#ambkit~ &&
                                                        ~%name%~ STR_CMP ~A!ADVENTURERtf~ &&
                                                        ~%name%~ STR_CMP ~A!ADVENTURERtw~ &&
                                                        ~%name%~ STR_CMP ~A!BURGLARtf~ &&
                                                        ~%name%~ STR_CMP ~A!BURGLARtw~ &&
                                                        ~%name%~ STR_CMP ~A!SOULKNIFEtf~ &&
                                                        ~%name%~ STR_CMP ~A!SOULKNIFEtw~ &&
                                                        ~%name%~ STR_CMP ~A!SHARPSHOOTERtf~ &&
                                                        ~%name%~ STR_CMP ~A!SHARPSHOOTERtw~ &&
                                                        ~%name%~ STR_CMP ~A#SHADOWDANCERtf~ &&
                                                        ~%name%~ STR_CMP ~A#SHADOWDANCERtw~ &&
                                                        ~%name%~ STR_CMP ~A!SHADOWDANCERtw~ &&
                                                        ~%name%~ STR_CMP ~A!SHADOWDANCERtf~ &&
                                                        ~%name%~ STR_CMP ~OHTYR_OLD~ &&
                                                        ~%name%~ STR_CMP ~FAKIE~ &&
                                                        ~%name%~ STR_CMP ~GRIZZLY_BEAR~

                                                BEGIN
                                                        SPRINT $kitlist("%kitcnt%") "%name%"
                                                        // Mixed name.
                                                        READ_2DA_ENTRY "%index%" 3 "%cols%" "val"
                                                        GET_STRREF "%val%" "name"
                                                        SPRINT $namelist("%kitcnt%") "%name%"
                                                        // The list of kits.
                                                        SPRINT "list" "%list%[%kitcnt%] %name%
"
                                                        SET "kitcnt" += 1
                                                END
                                        END
                                END
                        END
                        SET "looping" = 1
                        // Kit selection for current class:
                        WHILE ("%looping%" == 1) BEGIN
                                // Prompt:
                                PATCH_PRINT @1300005
                                PATCH_PRINT ~%list%~
                                PATCH_READLN "val"
                                // Input check:
                                PATCH_IF (NOT (IS_AN_INT "%val%")) BEGIN
                                        // Not an integer.
                                        PATCH_PRINT @1300002
                                END ELSE PATCH_IF ("%val%" < 0 OR "%val%" >= "%kitcnt%") BEGIN
                                        // Integer not on the list...
                                        PATCH_PRINT @1300003
                                END ELSE BEGIN
                                        // Finally! Store kit symbol and mixed name, break loop.
                                        SET "looping" = 0
                                        SPRINT "kitstr"  $kitlist("%val%")
                                        SPRINT $kits("%id%") "%kitstr%"
                                        SPRINT "kitname" $namelist("%val%")
                                        SPRINT $names("%id%") "%kitname%"
                                END
                        END
                END
                
                // An empty title is also a valid one, as we build one in this case.
                SPRINT "title" ""
                
                PATCH_IF ("%wanttitle%" != 0) BEGIN
                        PATCH_PRINT @1300006
                        PATCH_READLN "title"
                END
                
                // The kit internal identifier, used, e.g., in kit.ids.
                SPRINT "kitid" ""
                SET "len" = STRING_LENGTH "%kitid%"
                WHILE ("%len%" < 5) BEGIN
                        PATCH_PRINT @1300009
                        PATCH_READLN "kitid"
                        SET "len" = STRING_LENGTH "%kitid%"
                        // This must be a nonempty string built from letters, numbers and
                        // underscores; chide the user if he didn't read the prompt.
                        PATCH_IF ("%len%" == 0) BEGIN
                                PATCH_PRINT @1300008
                        END ELSE PATCH_IF (("%kitid%" STRING_MATCHES_REGEXP "[A-Za-z0-9_]*") != 0) BEGIN
                                PATCH_PRINT @1300008
                        END
                END
                // Silently convert identifier to uppercase.
                TO_UPPER "kitid"
                // Do we have a title?
                PATCH_IF ((STRING_LENGTH "%title%") != 0) BEGIN
                        // Yes; so we use it.
                        SPRINT "mixname" "%title%"
                END ELSE BEGIN
                        // No, build one from scratch.
                        SPRINT "intitle" $classnam("%kitclassids%")
                        INNER_PATCH_SAVE "mixname" "%intitle%" BEGIN
                                PHP_EACH "classes" AS "id" => "cls" BEGIN
                                        SPRINT "nm" $names("%id%")
                                        SET "idsval" = IDS_OF_SYMBOL (~class~ ~%cls%~)
                                        SPRINT "find" $classnam("%idsval%")
                                        REPLACE_TEXTUALLY CASE_INSENSITIVE EXACT_MATCH "%find%" "%nm%"
                                END
                        END
                END

                // Time for a luXXXXXX.2da file.
                // Start by assigning the default value, which means the normal hla file
                // for the base multiclass.
                SPRINT "hlafile" ""
                SPRINT "desthlafile" ""
                SET "looping" = 1
                // Wait until we have a valid choice.
                WHILE ("%looping%" == 1) BEGIN
                        PATCH_PRINT @1300019
                        PATCH_READLN "val"
                        PATCH_IF (NOT (IS_AN_INT "%val%")) BEGIN
                                // Not an integer.
                                PATCH_PRINT @1300002
                        END
                        PATCH_IF GAME_IS bgee && val == 2 BEGIN
                                 PATCH_PRINT @1300046
                                 SET val = 1
                        END
                        PATCH_IF ("%val%" == 1) BEGIN
                                // Flag loop as done.
                                SET "looping" = 0
                        END ELSE PATCH_IF ("%val%" == 2) BEGIN
                                // We need to create one.
                                // Flag loop as done.
                                SET "looping" = 0
                                // Read the luXXXXXX.2da files for the component kits.
                                DEFINE_ARRAY "luabbrs"  BEGIN END
                                INNER_PATCH_FILE ~luabbr.2da~ BEGIN
                                        COUNT_2DA_COLS "cols"
                                        COUNT_2DA_ROWS "%cols%" "rows"
                                        SET "idx" = 0
                                        WHILE ("%idx%" < "%rows%") BEGIN
                                                // Read kit/class name.
                                                READ_2DA_ENTRY "%idx%" 0 "%cols%" "name"
                                                // Check all kits in our multikit.
                                                PHP_EACH "kits" AS "id" => "kit" BEGIN
                                                        // Is this on our multikit?
                                                        PATCH_IF ("%name%" STRING_EQUAL_CASE "%kit%") BEGIN
                                                                // Read in the file name.
                                                                READ_2DA_ENTRY "%idx%" 1 "%cols%" "val"
                                                                // Store the actual resulting file name.
                                                                SPRINT $luabbrs("%id%") "lu%val%.2da"
                                                        END
                                                END
                                                SET "idx" += 1
                                        END
                                END
                                // The following arrays will store the HLA data.
                                DEFINE_ARRAY "abl_file"  BEGIN END      // File name for HLA.
                                DEFINE_ARRAY "abl_name"  BEGIN END      // Ability name, for display.
                                DEFINE_ARRAY "abl_splt"  BEGIN END      // Innate, priest or wizard.
                                DEFINE_ARRAY "abl_type"  BEGIN END      // 0 = AP_, 1 = GA_
                                DEFINE_ARRAY "abl_icon"  BEGIN END      // ICON column.
                                DEFINE_ARRAY "abl_text"  BEGIN END      // STRREF column.
                                DEFINE_ARRAY "abl_minl"  BEGIN END      // Min level.
                                DEFINE_ARRAY "abl_maxl"  BEGIN END      // Max level.
                                DEFINE_ARRAY "abl_numa"  BEGIN END      // Maximum allowed.
                                DEFINE_ARRAY "abl_reqi"  BEGIN END      // Prerequisite HLA index or -1 for none.
                                DEFINE_ARRAY "abl_excl"  BEGIN END      // Exclusion HLA index or -1 for none.
                                DEFINE_ARRAY "abl_algn"  BEGIN END      // -1 = ALL_EVIL, 1 = ALL_GOOD, 0 = *
                                DEFINE_ARRAY "abl_depi"  BEGIN END      // # of directly dependent entries.
                                DEFINE_ARRAY "abl_dele"  BEGIN END      // 1 if the ability has been removed from HLA table.
                                SET "abl_count" = 0
                                PHP_EACH "luabbrs" AS "id" => "file" BEGIN
                                        INNER_PATCH_FILE ~%file%~ BEGIN
                                                COUNT_2DA_COLS "cols"
                                                COUNT_2DA_ROWS "%cols%" "rows"
                                                SET "idx" = 0
                                                WHILE ("%idx%" < "%rows%") BEGIN
                                                        READ_2DA_ENTRY "%idx%" 0 "%cols%" "m0"
                                                        READ_2DA_ENTRY "%idx%" 1 "%cols%" "ability"
                                                        PATCH_IF ("%ability%" STRING_COMPARE "*") BEGIN
                                                                // We have an actual ability here.
                                                                INNER_PATCH ~%ability%~ BEGIN
                                                                        // Type of ability.
                                                                        READ_ASCII 0 type (3)
                                                                        // Ability name.
                                                                        READ_ASCII 3 ability (BUFFER_LENGTH - 3)
                                                                END
                                                                // Check for uniqueness.
                                                                SET "unique" = 1
                                                                PHP_EACH "abl_file" AS "id2" => "abl2" BEGIN
                                                                        PATCH_IF ("%abl2%" STRING_EQUAL_CASE "%ability%") BEGIN
                                                                                SET "unique" = 0
                                                                        END
                                                                END
                                                                PATCH_IF ("%unique%" == 1) BEGIN
                                                                        // Unique ability.
                                                                        // Store filename.
                                                                        SPRINT $abl_file("%abl_count%") "%ability%"
                                                                        PATCH_IF FILE_EXISTS_IN_GAME ~%ability%.spl~ BEGIN
                                                                                INNER_PATCH_FILE ~%ability%.spl~ BEGIN
                                                                                        // Store ability name.
                                                                                        READ_STRREF NAME1 $abl_name("%abl_count%")
                                                                                        READ_SHORT  0x1c  $abl_splt("%abl_count%")
                                                                                END
                                                                        END ELSE BEGIN
                                                                                PATCH_PRINT @1300044
                                                                        END
                                                                        // Store type: GA_ = 1, AP_ = 0.
                                                                        SET $abl_type("%abl_count%") = ("%type%" STRING_EQUAL_CASE "GA_")
                                                                        // Icon.
                                                                        READ_2DA_ENTRY "%idx%" 2 "%cols%" "val"
                                                                        SPRINT $abl_icon("%abl_count%") "%val%"
                                                                        // Text.
                                                                        READ_2DA_ENTRY "%idx%" 3 "%cols%" "val"
                                                                        SPRINT $abl_text("%abl_count%") "%val%"
                                                                        // Minimum level.
                                                                        READ_2DA_ENTRY "%idx%" 4 "%cols%" "val"
                                                                        SET $abl_minl("%abl_count%") = "%val%"
                                                                        // Maximum level.
                                                                        READ_2DA_ENTRY "%idx%" 5 "%cols%" "val"
                                                                        SET $abl_maxl("%abl_count%") = "%val%"
                                                                        // Maximum allowed count.
                                                                        READ_2DA_ENTRY "%idx%" 6 "%cols%" "val"
                                                                        SET $abl_numa("%abl_count%") = "%val%"
                                                                        // HLA requirement.
                                                                        READ_2DA_ENTRY "%idx%" 7 "%cols%" "val"
                                                                        PATCH_IF ((STRING_LENGTH "%val%") > 3) BEGIN
                                                                                INNER_PATCH ~%val%~ BEGIN
                                                                                        // Ability name.
                                                                                        READ_ASCII 3 val (BUFFER_LENGTH - 3)
                                                                                END
                                                                        END
                                                                        SPRINT $abl_reqi("%abl_count%") "%val%"
                                                                        // HLA exclusion.
                                                                        READ_2DA_ENTRY "%idx%" 8 "%cols%" "val"
                                                                        PATCH_IF ((STRING_LENGTH "%val%") > 3) BEGIN
                                                                                INNER_PATCH ~%val%~ BEGIN
                                                                                        // Ability name.
                                                                                        READ_ASCII 3 val (BUFFER_LENGTH - 3)
                                                                                END
                                                                        END
                                                                        SPRINT $abl_excl("%abl_count%") "%val%"
                                                                        // Alignment restriction: -1 = evil, 1 = good, 0 = none.
                                                                        READ_2DA_ENTRY "%idx%" 9 "%cols%" "val"
                                                                        SET $abl_algn("%abl_count%") = ("%val%" STRING_EQUAL_CASE "ALL_GOOD") - ("%val%" STRING_EQUAL_CASE "ALL_EVIL")
                                                                        // We will fill this later.
                                                                        SET $abl_depi("%abl_count%") = 0
                                                                        // Default to include all abilities.
                                                                        SET $abl_dele("%abl_count%") = 0
                                                                        SET "abl_count" += 1
                                                                END
                                                        END ELSE BEGIN
                                                                // Non-ability, means end of loop.
                                                                SET "idx" = "%rows%"
                                                        END
                                                        SET "idx" += 1
                                                END
                                        END
                                END
                                // Now we have all abilities.
                                // Check all requirements and exclusions and replace them by
                                // the indexes.
                                SET "idx" = 0
                                WHILE ("%idx%" < "%abl_count%") BEGIN
                                        // No req. or excl.
                                        SET "indexreq" = 0 - 1
                                        SET "indexexc" = 0 - 1
                                        // Get the strings.
                                        SPRINT "val_reqi" $abl_reqi(EVAL "%idx%")
                                        SPRINT "val_excl" $abl_excl(EVAL "%idx%")
                                        // Find index of abilities.
                                        PHP_EACH "abl_file" AS "id2" => "abl2" BEGIN
                                                PATCH_IF ("%abl2%" STRING_EQUAL_CASE "%val_reqi%") BEGIN
                                                        SET "indexreq" = EVAL "%id2%"
                                                        // We have a dependency!
                                                        SET $abl_depi(EVAL "%id2%") += 1
                                                END ELSE PATCH_IF ("%abl2%" STRING_EQUAL_CASE "%val_excl%") BEGIN
                                                        SET "indexexc" = EVAL "%id2%"
                                                END
                                        END
                                        // Set to index. If not on list, it is -1.
                                        SET $abl_reqi("%idx%") = "%indexreq%"
                                        SET $abl_excl("%idx%") = "%indexexc%"
                                        SET "idx" += 1
                                END

                                PATCH_IF ENGINE_IS tob BEGIN // Crevs: if EE, one HLA more can be addded to the lu file.
                                         __max_hla_ = 24
                                END ELSE BEGIN
                                         __max_hla_ = 25
                                END

                                // Do we need to do anything other than to generate the file?
                                PATCH_IF ("%abl_count%" > __max_hla_) BEGIN
                                        // Yes. Prompt the user to remove abilities from table.
                                        // Build the prompt first.
                                        DEFINE_ARRAY "trail_strs"  BEGIN END
                                        SPRINT $trail_strs(0) @1300023
                                        SPRINT $trail_strs(1) "<HEAD>"
                                        // Loop flag.
                                        SET "looping2" = 1
                                        WHILE ("%looping2%" == 1) BEGIN
                                                SPRINT "baseprompt" @1300020
                                                SPACES "buffer" "%baseprompt%"
                                                // This counts how many abilities are in the list.
                                                // We start from the total and remove those abilities
                                                // that have been removed.
                                                SET "curr_count" = "%abl_count%"
                                                // There are two separate lists, the removed and the
                                                // still oresent lists.
                                                PHP_EACH "trail_strs" AS "id" => "trail" BEGIN
                                                        SET "idx" = 0
                                                        WHILE ("%idx%" < "%abl_count%") BEGIN
                                                                SPRINT "currline" ""
                                                                SET "doappend" = 0
                                                                // We will write to the buffer string.
                                                                INNER_PATCH_SAVE "currline" "%buffer%" BEGIN
                                                                        // The 'deleted' flag.
                                                                        SET "val" = $abl_dele("%idx%")
                                                                        PATCH_IF ("%val%" == "%id%") BEGIN
                                                                                // By doing this, we reduce the count by
                                                                                // the number of removed abilities.
                                                                                SET "curr_count" -= "%val%"
                                                                                // Yes, append it to this list.
                                                                                SET "doappend" = 1
                                                                                // Use 2 characters for the numeric id.
                                                                                PATCH_IF (EVAL "%idx%" < 10) BEGIN
                                                                                        WRITE_ASCIIE  0 EVAL "[ %idx%]"
                                                                                END ELSE BEGIN
                                                                                        WRITE_ASCIIE  0 EVAL "[%idx%]"
                                                                                END
                                                                                // Write the ability name.
                                                                                SPRINT "val" EVAL $abl_name("%idx%")
                                                                                WRITE_ASCIIE  6 EVAL "%val%"
                                                                                // Time now for the HLA requirement.
                                                                                SET "val" = EVAL $abl_reqi("%idx%")
                                                                                PATCH_IF (EVAL "%val%" < 0) BEGIN
                                                                                        SPRINT "val" "----"
                                                                                END ELSE PATCH_IF (EVAL "%val%" < 10) BEGIN
                                                                                        SPRINT "val" EVAL "[ %val%]"
                                                                                END ELSE BEGIN
                                                                                        SPRINT "val" EVAL "[%val%]"
                                                                                END
                                                                                WRITE_ASCIIE 41 EVAL "%val%"
                                                                                // HLA exclusion.
                                                                                SET "val" = EVAL $abl_excl("%idx%")
                                                                                PATCH_IF (EVAL "%val%" < 0) BEGIN
                                                                                        SPRINT "val" "----"
                                                                                END ELSE PATCH_IF (EVAL "%val%" < 10) BEGIN
                                                                                        SPRINT "val" EVAL "[ %val%]"
                                                                                END ELSE BEGIN
                                                                                        SPRINT "val" EVAL "[%val%]"
                                                                                END
                                                                                WRITE_ASCIIE 47 EVAL "%val%"
                                                                                // Finally, alignment restriction.
                                                                                SET "val" = EVAL $abl_algn("%idx%")
                                                                                PATCH_IF (EVAL "%val%" > 0) BEGIN
                                                                                        SPRINT "val" @1300021
                                                                                END ELSE PATCH_IF (EVAL "%val%" < 0) BEGIN
                                                                                        SPRINT "val" @1300022
                                                                                END ELSE BEGIN
                                                                                        SPRINT "val" ""
                                                                                END
                                                                                WRITE_ASCIIE 53 EVAL "%val%"
                                                                        END
                                                                END
                                                                // Append it if needed.
                                                                PATCH_IF ("%doappend%" != 0) BEGIN
                                                                        SPRINT "baseprompt" "%baseprompt%
%currline%"
                                                                END
                                                                SET "idx" += 1
                                                        END
                                                        // Append extra prompts.
                                                        SPRINT "baseprompt" "%baseprompt%

%trail%"
                                                END
                                                // Replace prompt variables indicating progress.
                                                INNER_PATCH_SAVE "prompt" "%baseprompt%" BEGIN
                                                        // Be sure to let the user know that he can quit
                                                        // if already at desired size.
                                                        PATCH_IF ("%curr_count%" > __max_hla_) BEGIN
                                                                SPRINT "repl" @1300024
                                                        END ELSE BEGIN
                                                                SPRINT "repl" @1300025
                                                        END
                                                        REPLACE_TEXTUALLY EXACT_MATCH "<HEAD>" "%repl%"
                                                        REPLACE_TEXTUALLY EXACT_MATCH "<NUM>"  "%curr_count%"
                                                END
                                                PATCH_PRINT "%prompt%"
                                                PATCH_READLN "val"
                                                PATCH_IF (NOT (IS_AN_INT "%val%")) BEGIN
                                                        // We want an integer:
                                                        PATCH_PRINT @1300002
                                                END ELSE PATCH_IF ("%val%" < 0 AND "%curr_count%" <= __max_hla_) BEGIN
                                                        // Negative number when list is at right size.
                                                        // Time to quit this loop.
                                                        SET "looping2" = 0
                                                END ELSE PATCH_IF ("%val%" < 0 OR "%val%" >= "%abl_count%") BEGIN
                                                        // An integer, but not on the list...
                                                        PATCH_PRINT @1300003
                                                END ELSE BEGIN
                                                        // In which list it is?
                                                        SET "state" = $abl_dele("%val%")
                                                        PATCH_IF ("%state%" == 0) BEGIN
                                                                // It is on the included list.
                                                                // Flag it as removed.
                                                                SET $abl_dele("%val%") = 1
                                                                // We need to check the dependencies for this HLA.
                                                                // We also must check the dependencies of those
                                                                // dependencies, and so on recursively.
                                                                DEFINE_ARRAY "remove_queue" BEGIN "%val%" END
                                                                SET "nqueue" = 1
                                                                SET "lastval" = 0
                                                                SET "nreqs" = $abl_depi("%val%")
                                                                SET "nrem" = 0
                                                                WHILE ("%nrem%" < "%nreqs%") BEGIN
                                                                        SET "idx" = 0
                                                                        WHILE ("%idx%" < "%abl_count%") BEGIN
                                                                                SET "req" = $abl_reqi("%idx%")
                                                                                PATCH_IF ("%req%" == "%val%") BEGIN
                                                                                        // Remove HLAs that require this.
                                                                                        SET $abl_dele("%idx%") = 1
                                                                                        SET "ndeps" = $abl_depi("%idx%")
                                                                                        SET "nrem" += 1
                                                                                        PATCH_IF ("%ndeps%" > 0) BEGIN
                                                                                                // This HLA also has dependencies.
                                                                                                // Queue them for removal.
                                                                                                SET $remove_queue("%nqueue%") = "%idx%"
                                                                                                SET "nreqs" += "%ndeps%"
                                                                                                SET "nqueue" += 1
                                                                                        END
                                                                                END
                                                                                SET "idx" += 1
                                                                        END
                                                                        SET "lastval" += 1
                                                                        PATCH_IF ("%nqueue%" > "%lastval%") BEGIN
                                                                                SET "val" = $remove_queue("%lastval%")
                                                                        END
                                                                END
                                                        END ELSE PATCH_IF ("%state%" == 1) BEGIN
                                                                // It is on the removed list.
                                                                // We need to check the requisites for this HLA.
                                                                // We also must check the requisites of those
                                                                // requisites, and so on recursively.
                                                                SET "req" = "%val%"
                                                                WHILE ("%req%" >= 0) BEGIN
                                                                        // Flag it as added back.
                                                                        SET $abl_dele("%req%") = 0
                                                                        // Get HLA requirement.
                                                                        SET "req" = $abl_reqi("%req%")
                                                                END
                                                        END
                                                END
                                        END
                                END
                                // Nothing to do now but generate the HLA file.
                                SPRINT "desthlafile" "<<<<<<<< ../%modpath%/multikit-inlined/lu%modprefix%%kitid%-inlined.2da
2DA                V1.0
*
                   ABILITY            ICON               STRREF             MIN_LEV            MAX_LEVEL          NUM_ALLOWED        PREREQUISITE       EXCLUDED_BY        ALIGNMENT_RESTRICT"
                                SET "idx" = 0
                                SET "cnt" = 1
                                WHILE ("%idx%" < "%abl_count%") BEGIN
                                        // Is it still on?
                                        SET "state" = $abl_dele("%idx%")
                                        PATCH_IF ("%state%" == 0) BEGIN
                                                SPRINT "ability" $abl_file("%idx%")
                                                // Store type: GA_ = 1, AP_ = 0.
                                                SET "type" = $abl_type("%idx%")
                                                PATCH_IF ("%type%" == 1) BEGIN
                                                        SPRINT "ability" "GA_%ability%"
                                                END ELSE BEGIN
                                                        SPRINT "ability" "AP_%ability%"
                                                END
                                                // Icon.
                                                SPRINT "icon" $abl_icon("%idx%")
                                                // Text.
                                                SPRINT "text" $abl_text("%idx%")
                                                // Minimum level.
                                                SET "minl" = $abl_minl("%idx%")
                                                // Spell type.
                                                SET "splt" = $abl_splt("%idx%")
                                                // If GA_ HLA:
                                                PATCH_IF ("%type%" == 1) BEGIN
                                                        // Which is a wizard or priest spell, we set
                                                        // a different (higher) minimum level.
                                                        PATCH_IF ("%splt%" == 1) BEGIN
                                                                SET "minl" = 32
                                                        END ELSE PATCH_IF ("%splt%" == 2) BEGIN
                                                                SET "minl" = 16
                                                        END
                                                END
                                                // Maximum level.
                                                SET "maxl" = $abl_maxl("%idx%")
                                                // Maximum allowed count.
                                                SET "numa" = $abl_numa("%idx%")
                                                // HLA requirement.
                                                SET "reqi" = $abl_reqi("%idx%")
                                                PATCH_IF ("%reqi%" >= 0) BEGIN
                                                        SPRINT "reqabl" $abl_file("%reqi%")
                                                        // Store type: GA_ = 1, AP_ = 0.
                                                        SET "reqtype" = $abl_type("%reqi%")
                                                        PATCH_IF ("%reqtype%" == 1) BEGIN
                                                                SPRINT "reqis" "GA_%reqabl%"
                                                        END ELSE BEGIN
                                                                SPRINT "reqis" "AP_%reqabl%"
                                                        END
                                                END ELSE BEGIN
                                                        SPRINT "reqis" "*"
                                                END
                                                // HLA exclusion.
                                                SET "excl" = $abl_excl("%idx%")
                                                PATCH_IF ("%excl%" >= 0) BEGIN
                                                        SPRINT "exclabl" $abl_file("%excl%")
                                                        // Store type: GA_ = 1, AP_ = 0.
                                                        SET "excltype" = $abl_type("%excl%")
                                                        PATCH_IF ("%excltype%" == 1) BEGIN
                                                                SPRINT "excls" "GA_%exclabl%"
                                                        END ELSE BEGIN
                                                                SPRINT "excls" "AP_%exclabl%"
                                                        END
                                                END ELSE BEGIN
                                                        SPRINT "excls" "*"
                                                END
                                                // Alignment restriction: -1 = evil, 1 = good, 0 = none.
                                                SET "algn" = EVAL $abl_algn("%idx%")
                                                PATCH_IF ("%algn%" > 0) BEGIN
                                                        SPRINT "algns" "ALL_GOOD"
                                                END ELSE PATCH_IF ("%algn%" < 0) BEGIN
                                                        SPRINT "algns" "ALL_EVIL"
                                                END ELSE BEGIN
                                                        SPRINT "algns" "*"
                                                END
                                                SPRINT "desthlafile" "%desthlafile%
%cnt% %ability% %icon% %text% %minl% %maxl% %numa% %reqis% %excls% %algns%"
                                                SET "cnt" += 1
                                        END
                                        SET "idx" += 1
                                END
                                SPRINT "desthlafile" "%desthlafile%
>>>>>>>>"
                                SPRINT "hlafile" "../%modpath%/multikit-inlined/lu%modprefix%%kitid%-inlined.2da"
                        END ELSE BEGIN
                                // Integer not on the list...
                                PATCH_PRINT @1300003
                        END
                END

                // Unroll kits array.
                PATCH_IF ("%numkits%" > 0) BEGIN
                        SPRINT "kit0" $kits(0)
                END ELSE BEGIN
                        SPRINT "kit0" ""
                END
                PATCH_IF ("%numkits%" > 1) BEGIN
                        SPRINT "kit1" $kits(1)
                END ELSE BEGIN
                        SPRINT "kit1" ""
                END
                PATCH_IF ("%numkits%" == 3) BEGIN
                        SPRINT "kit2" $kits(2)
                END ELSE BEGIN
                        SPRINT "kit2" ""
                END

                INNER_ACTION BEGIN
                        ACTION_IF !FILE_EXISTS "%kit_file_path%/multikits.tp2" BEGIN
                                COPY "%modpath%/multikits.tp2" "%kit_file_path%"
                        END                
                END
                // Find last used component designation.
                LAUNCH_PATCH_FUNCTION ~m7#find_last_multikit_designation~
                        STR_VAR
                                kit_file_path = EVAL "%kit_file_path%"
                        RET
                                "cid" = "numid" END
                // Advance to next.
                SET "cid" += 1
        END
        
        // What we want to append to the setup file.
        APPEND_OUTER ~%kit_file_path%/multikits.tp2~ ~~~~~BEGIN ~'%mixname%' multikit~ DESIGNATED %cid% REQUIRE_PREDICATE MOD_IS_INSTALLED ~m7multikit.tp2~ 10 @1300033
%desthlafile%
        LAUNCH_ACTION_FUNCTION "m7#install_multikit"
                INT_VAR
                        "numkits" = %numkits%
                        "explode_spells" = %explode_spells%
                STR_VAR
                        "modprefix" = "%modprefix%"
                        "modpath" = "%modpath%/multikit"
                        "kitid" = "%kitid%"
                        "kitclass" = "%kitclass%"
                        "title" = "%title%"
                        "hlafile" = "%hlafile%"
                        "kit0" = "%kit0%"
                        "kit1" = "%kit1%"
                        "kit2" = "%kit2%" END
~~~~~
END

/******************************************************************************
 *      
 *      m7#install_multikit
 *      
 *      This function installs a pregenerated multikit.
 *      The parameters, and their descriptions, are:
 *      
 *      ****    String parameters (SPRINT or OUTER_SPRINT)
 *      Name          Description
 *      "modprefix"   This is your modder prefix. THIS MUST BE AT MOST 2 CHARACTERS!
 *      "modpath"     This is the path to your mod, to make it convenient.
 *      "kitid"       The internal identifier for the kit combo, the one used in the
 *                    IDS and 2DA files and in scripts.
 *                    If empty, the TPP will raise an error.
 *      "kitclass"    The class name for the multiclass multikit in question, taken
 *                    from class.ids. If empty, or anything not from class.ids,
 *                    the TPP will raise an error.
 *      "title"       If you want a custom kit title, this is the place for it. If
 *                    this is set to an empty string, the title will be built from
 *                    the multiclass string by simple string replacement.
 *      "hlafile"     If you want a special HLA table for your multikit, then you
 *                    should place it here.
 *                    If this is a full file/path name, this function will copy the
 *                    specified file to override with an auto-generated name, then
 *                    the correct info will be passed to AddKit.
 *                    If it is not a full file name, the function will check if the
 *                    file lu%hlafile%.2da exists in the game and forward this var
 *                    verbatim to AddKit if it does.
 *                    If this is empty, or if none of the above cases point to an
 *                    existing or installable HLA table, the function will default
 *                    to the multikit's base multiclass HLA table.
 *      "kit0"        The kit identifier (taken from kit.ids) or class identifier
 *                    taken from class.ids) of the kit of first class component of
 *                    the base multiclass.
 *      "kit1"        The kit identifier (taken from kit.ids) or class identifier
 *                    taken from class.ids) of the kit of second class component of
 *                    the base multiclass.
 *      "kit2"        The kit identifier (taken from kit.ids) or class identifier
 *                    taken from class.ids) of the kit of third class component of
 *                    the base multiclass, for the triple multiclasses.
 *      
 *      ****    Integer parameters (SET or OUTER_SET)
 *      Name          Description
 *      "numkits"           This will be always 2 or 3, depending on the multiclass:
 *                          it is the number of classes in the multiclass.
 *      "explode_spells"    If this is set to anything non-zero, the new method of
 *                          'exploding' applied spells into their component effects
 *                          will be used. This allows full removal of the multikit.
 *
 ******************************************************************************/
DEFINE_ACTION_FUNCTION ~m7#install_multikit~
        INT_VAR
                "numkits" = 0
                "explode_spells" = 1
        STR_VAR
                "modprefix" = ""
                "modpath" = ""
                "kitid" = ""
                "kitclass" = ""
                "title" = ""
                "hlafile" = ""
                "kit0" = ""
                "kit1" = ""
                "kit2" = ""
BEGIN
        // Just in case we have a freshly added kit from elsewhere.
        CLEAR_IDS_MAP

        // Default class clabs and names. The multi-class ones should not be used,
        // ever, by this tp2 file if everything works as it should.
        ACTION_DEFINE_ARRAY "claborig"  BEGIN
                ~~ ~clabma01~ ~clabfi01~ ~clabpr01~ ~clabth01~ ~clabba01~
                ~clabpa01~ ~~ ~~ ~~ ~~ ~clabdr01~ ~clabrn01~ ~~ ~~ ~~ ~~
                ~~ ~~ ~clabma01~ ~clabmo01~
        END
        ACTION_DEFINE_ARRAY "clablist"  BEGIN
                ~~ ~clabma00~ ~clabfi00~ ~clabpr00~ ~clabth00~ ~clabba00~
                ~clabpa00~ ~~ ~~ ~~ ~~ ~clabdr00~ ~clabrn00~ ~~ ~~ ~~ ~~
                ~~ ~~ ~clabma00~ ~clabmo00~
        END
        ACTION_DEFINE_ARRAY "classtok"  BEGIN
                ~i~ ~w~ ~f~ ~c~ ~t~ ~b~ ~p~ ~fm~ ~fc~ ~ft~ ~fmt~ ~d~ ~r~ ~mt~ ~cm~ ~ct~
                ~fd~ ~fmc~ ~cr~ ~w~ ~m~
        END
        ACTION_DEFINE_ARRAY "baseprofs" BEGIN
                 0   4   5   6   7   8   9   12   13   14   15   10  11   16   17   18
                 19  20    21   4   51
        END
        ACTION_DEFINE_ARRAY "classnum"  BEGIN
                ~0~ ~10176~ ~10174~ ~10177~ ~10175~ ~10179~ ~10194~ ~10189~ ~10187~
                ~10178~ ~10191~ ~10186~ ~10173~ ~10193~ ~10180~ ~10184~ ~10188~
                ~10190~ ~10182~ ~9411~ ~9410~
        END
        ACTION_DEFINE_ARRAY "classnam"  BEGIN END
        OUTER_PATCH "dummy" BEGIN
                PHP_EACH "classnum" AS "id" => "num" BEGIN
                        GET_STRREF "%num%" $classnam("%id%")
                END
                // Find free specific.
                SET "ii" = 10
                SET "kitspec" = 0 - 1
                WHILE ("%ii%" < 256) BEGIN
                        LOOKUP_IDS_SYMBOL_OF_INT "sym" ~specific~ "%ii%"
                        // If it is free, we will get the current value back.
                        PATCH_IF (IS_AN_INT "%sym%") BEGIN
                                SET "kitspec" = "%sym%"
                                // Stop loop.
                                SET "ii" = 256
                        END
                        SET "ii" += 1
                END
                PATCH_IF ("%kitspec%" < 0) BEGIN
                        INNER_ACTION BEGIN
                                FAIL @1300015
                        END
                END
        END
        // The kits array:
        ACTION_DEFINE_ARRAY "kits"  BEGIN END
        
        ACTION_IF ("%numkits%" > 0) BEGIN
                OUTER_SPRINT $kits(0) "%kit0%"
        END ELSE BEGIN
                OUTER_SPRINT $kits(0) ""
        END
        ACTION_IF ("%numkits%" > 1) BEGIN
                OUTER_SPRINT $kits(1) "%kit1%"
        END ELSE BEGIN
                OUTER_SPRINT $kits(1) ""
        END
        ACTION_IF ("%numkits%" == 3) BEGIN
                OUTER_SPRINT $kits(2) "%kit2%"
        END ELSE BEGIN
                OUTER_SPRINT $kits(2) ""
        END
        // These are placeholders:
        ACTION_DEFINE_ARRAY "classes"  BEGIN END
        ACTION_DEFINE_ARRAY "luabbrs"  BEGIN END
        ACTION_DEFINE_ARRAY "descs"    BEGIN END
        ACTION_DEFINE_ARRAY "spls"     BEGIN END
        ACTION_DEFINE_ARRAY "clabs"    BEGIN END
        ACTION_DEFINE_ARRAY "names"    BEGIN END
        ACTION_DEFINE_ARRAY "profs"    BEGIN END
        ACTION_DEFINE_ARRAY "clsids"   BEGIN END
        ACTION_DEFINE_ARRAY "unuses"   BEGIN END
        ACTION_DEFINE_ARRAY "lownames" BEGIN END
        OUTER_SET "unusability" = 0

        // Multikit building prompts.
        OUTER_PATCH "dummy" BEGIN
                SET "kitclassids" = IDS_OF_SYMBOL (~class~ ~%kitclass%~)
                PATCH_IF ("%kitclassids%" < 0) BEGIN
                        SPRINT "prompt" @1300014
                        INNER_ACTION BEGIN
                                FAIL "%prompt%
IDS_OF_SYMBOL (~class~ ~%kitclass%~) < 0"
                        END
                END
                
                // Basically a switch to get the multiclass component classes.
                CLEAR_ARRAY "classes"
                PATCH_IF ("%kitclassids%" == 7) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~MAGE~
                END ELSE PATCH_IF ("%kitclassids%" == 8) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~CLERIC~
                END ELSE PATCH_IF ("%kitclassids%" == 9) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 10) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~MAGE~
                        SPRINT $classes(2) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 13) BEGIN
                        SPRINT $classes(0) ~MAGE~
                        SPRINT $classes(1) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 14) BEGIN
                        SPRINT $classes(0) ~CLERIC~
                        SPRINT $classes(1) ~MAGE~
                END ELSE PATCH_IF ("%kitclassids%" == 15) BEGIN
                        SPRINT $classes(0) ~CLERIC~
                        SPRINT $classes(1) ~THIEF~
                END ELSE PATCH_IF ("%kitclassids%" == 16) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~DRUID~
                END ELSE PATCH_IF ("%kitclassids%" == 17) BEGIN
                        SPRINT $classes(0) ~FIGHTER~
                        SPRINT $classes(1) ~MAGE~
                        SPRINT $classes(2) ~CLERIC~
                END ELSE PATCH_IF ("%kitclassids%" == 18) BEGIN
                        SPRINT $classes(0) ~CLERIC~
                        SPRINT $classes(1) ~RANGER~
                END

                SET "len" = STRING_LENGTH "%kitid%"
                PATCH_IF ("%len%" == 0) BEGIN
                        SPRINT "prompt" @1300014
                        INNER_ACTION BEGIN
                                FAIL ~%prompt%
STRING_LENGTH kitid == 0~
                        END
                END

                // Use kit specific to define kit prefix.
                LAUNCH_PATCH_FUNCTION ~m7#get_suffix2~
                        INT_VAR
                                "number" = "%kitspec%"
                        RET
                                "kitprefix" = "suffixstr" END

                // Load up some defaults, to be safe.
                PHP_EACH "classes" AS "id" => "cls" BEGIN
                        SET "idsval" = IDS_OF_SYMBOL (~class~ ~%cls%~)
                        SPRINT $clabs("%id%") $clablist("%idsval%")
                        SPRINT $names("%id%") $classnam("%idsval%")
                        SET $profs("%id%")  = $baseprofs("%idsval%")
                        SET $clsids("%id%") = "%idsval%"
                        SET $unuses("%id%") = 0x4000
                END
                PHP_EACH names AS "id" => "nm" BEGIN
                        SPRINT "low" "%nm%"
                        TO_LOWER "low"
                        SPRINT $lownames("%id%") "%low%"
                END
        END

        // Make clean backup copies of the clab files which we will use for
        // base-class to kit comparisons later.
        ACTION_PHP_EACH "claborig" AS "id" => "clab" BEGIN
                OUTER_SPRINT "clabsafe" $clablist("%id%")
                ACTION_IF (((STRING_LENGTH "%clab%") > 0) AND (NOT (FILE_EXISTS_IN_GAME "%clabsafe%.2da"))) BEGIN
                        ACTION_IF (FILE_EXISTS_IN_GAME "%clab%.2da") BEGIN
                                COPY_EXISTING ~%clab%.2da~ ~override/%clabsafe%.2da~ 
                                        PRETTY_PRINT_2DA
                        END ELSE BEGIN
                                // This should always exist.
                                COPY_EXISTING ~%modpath%/clabkit.2da~ ~override/%clabsafe%.2da~ 
                                        PRETTY_PRINT_2DA
                        END
                END
        END
        OUTER_PATCH "dummy" BEGIN
                // Read information from kitlist.2da:
                INNER_PATCH_FILE ~kitlist.2da~ BEGIN
                        COUNT_2DA_COLS "cols"
                        COUNT_2DA_ROWS "%cols%" "rows"
                        FOR ("%index%" = 0; "%index%" < "%rows%"; "%index%" += 1) BEGIN
                                READ_2DA_ENTRY "%index%" 1 "%cols%" "name"
                                PHP_EACH "kits" AS "id" => "kit" BEGIN
                                        PATCH_IF ("%name%" STRING_EQUAL_CASE "%kit%") BEGIN
                                                READ_2DA_ENTRY "%index%" 2 "%cols%" "val"
                                                GET_STRREF "%val%" $lownames("%id%")
                                                READ_2DA_ENTRY "%index%" 3 "%cols%" "val"
                                                GET_STRREF "%val%" $names("%id%")
                                                READ_2DA_ENTRY "%index%" 4 "%cols%" "val"
                                                GET_STRREF "%val%" $descs("%id%")
                                                READ_2DA_ENTRY "%index%" 5 "%cols%" "val"
                                                SPRINT $clabs("%id%") "%val%"
                                                READ_2DA_ENTRY "%index%" 6 "%cols%" "val"
                                                SET $profs("%id%") = "%val%"
                                                READ_2DA_ENTRY "%index%" 7 "%cols%" "val"
                                                SET $unuses("%id%") = "%val%"
                                                SET "unusability" |= "%val%"
                                                READ_2DA_ENTRY "%index%" 8 "%cols%" "val"
                                                SET $clsids("%id%") = "%val%"
                                        END
                                END
                        END
                END

                // Read information from luabbr.2da:
                INNER_PATCH_FILE ~luabbr.2da~ BEGIN
                        COUNT_2DA_COLS "cols"
                        COUNT_2DA_ROWS "%cols%" "rows"
                        FOR ("%index%" = 0; "%index%" < "%rows%"; "%index%" += 1) BEGIN
                                READ_2DA_ENTRY "%index%" 0 "%cols%" name
                                // The default multiclass HLA table.
                                PATCH_IF ("%name%" STRING_EQUAL_CASE "%kitclass%") BEGIN
                                        READ_2DA_ENTRY "%index%" 1 "%cols%" kitclassluabbr
                                END
                        END
                END
                PATCH_IF ((STRING_LENGTH "%hlafile%") > 0) && "%hlafile%" STR_CMP "" BEGIN
                        // We have a custom HLA table specified; use it instead.
                        PATCH_IF (!FILE_EXISTS "%hlafile%") BEGIN // reverted in v0.27.11 from previous version
                                // We have a full path file for the luXXXXXX.2da file.
                                // Use it, but generate the final file name ourselves.
                                // Install the file.
                                INNER_ACTION BEGIN
                                        COPY "%hlafile%" ~override/lu%modprefix%%kitprefix%.2da~
                                                PRETTY_PRINT_2DA
                                END
                                SPRINT kitclassluabbr "%modprefix%%kitprefix%"
                        END ELSE BEGIN
                                // File already exists in game, and we got only the XXXXXX
                                // in luXXXXXX.2da; simply add it to luabbr.2da normally.
                                SPRINT kitclassluabbr "%hlafile%"
                        END
                END

                // Check the widest clab size so we can extend the others as needed.
                SET "maxw" = 0
                PHP_EACH "clabs" AS "id" => "clab" BEGIN
                        PATCH_IF (FILE_EXISTS_IN_GAME "%clab%.2da") BEGIN       // None otherwise
                                INNER_PATCH_FILE ~%clab%.2da~ BEGIN
                                        COUNT_2DA_COLS "cols"
                                        PATCH_IF ("%cols%" >= "%maxw%") BEGIN
                                                SET "maxw" = "%cols%"
                                        END
                                END
                        END
                END
        END
        
        // These two are used for the 'Gained ability' messages.
        OUTER_SET "laststr" = 0
        OUTER_SPRINT "strpat" "%modprefix%%kitprefix%s"
        // Now we read-extend the files into memory. Then, we generate the necessary
        // spell files, effect files and clab files.
        ACTION_DEFINE_ARRAY "abilities" BEGIN END
        ACTION_DEFINE_ARRAY "uniqueabl" BEGIN END
        OUTER_SPRINT "kit_swapping" ""
        OUTER_SPRINT "extra_actions" ""
        // Used to determining which mage spells (if any) have to be deleted.
        ACTION_DEFINE_ARRAY "excl_flags" BEGIN END
        // Fill flag array.
        OUTER_SET "idx" = 1
        OUTER_WHILE ("%idx%" < 9) BEGIN
                OUTER_SET $excl_flags("%idx%") = (1 << ("%idx%" + 5))
                OUTER_SET "idx" += 1
        END
        // Check usability flags. We do this here to remove once and for all the
        // spells for inapropriate mage components. This also removes them even if
        // the "wrong" kit has the unusability flag set.
        ACTION_PHP_EACH "excl_flags" AS "id" => "flag" BEGIN
                ACTION_IF (("%unusability%" & "%flag%") != 0) BEGIN
                        OUTER_SPRINT "extra_actions" ~%extra_actions%
                ActionOverride(Myself,ReallyForceSpellRES("m7mkwsp%id%",Myself))~
                END
        END
        // Also watch for wild magic:
        ACTION_IF (("%unusability%" & 0x80000000) != 0) BEGIN
                // Wild mage. Add the extra spells known and remove the extra
                // experience gained by learning wild magic:
                OUTER_SPRINT "extra_actions" ~%extra_actions%
                ActionOverride(Myself,ReallyForceSpellRES("m7wild",Myself))~
                // Old way of handling wild magi (now for EE games only)
                ACTION_IF !ENGINE_IS tob BEGIN
                        COPY_EXISTING - xpbonus.2da override
                                COUNT_2DA_COLS colsn
                                READ_2DA_ENTRY 2 1 colsn lvl1xp
                                READ_2DA_ENTRY 2 2 colsn lvl2xp
                                READ_2DA_ENTRY 2 7 colsn lvl7xp
                                wild_mage_xp_remove = (0 - lvl1xp) + (0 - lvl2xp) + (0 - lvl7xp)
                        BUT_ONLY
                        // Wild mage. Add the extra spells known and remove the extra
                        // experience gained by learning wild magic:
                        OUTER_SPRINT "extra_actions" EVAL ~%extra_actions%
                                     AddexperienceParty(%wild_mage_xp_remove%)~
                END
        END

        ACTION_PHP_EACH "clabs" AS "id" => "clab" BEGIN
                ACTION_CLEAR_ARRAY "abilities"
                ACTION_CLEAR_ARRAY "uniqueabl"
                OUTER_SET "abl_rows" = 0
                OUTER_SET "uniq_abl" = 0
                OUTER_SET "class" = $clsids("%id%")
                OUTER_SPRINT "defclab" $clablist("%class%")
                // Need this to prevent repeated recounting.
                // WARNING: should the file change in the mean time, bad things could
                // happen; I don't think it is terribly likely, though...
                ACTION_IF (FILE_EXISTS_IN_GAME "%defclab%.2da") BEGIN
                        COPY_EXISTING ~%defclab%.2da~ ~override~
                                COUNT_2DA_COLS "scols"
                                COUNT_2DA_ROWS "%scols%" "srows"
                                BUT_ONLY
                END ELSE BEGIN
                        // Just in case.
                        OUTER_SET "scols" = 0
                        OUTER_SET "srows" = 0
                END
                
                ACTION_IF ((NOT ("%defclab%" STRING_EQUAL_CASE "%clab%")) AND (FILE_EXISTS_IN_GAME "%clab%.2da")) BEGIN // None otherwise
                        OUTER_PATCH "dummy" BEGIN
                                INNER_PATCH_FILE ~%clab%.2da~ BEGIN
                                        COUNT_2DA_COLS "cols"
                                        COUNT_2DA_ROWS "%cols%" "rows"
                                        DEFINE_ARRAY "rowentries" BEGIN END
                                        FOR ("%i%" = 0; "%i%" < "%rows%"; "%i%" += 1) BEGIN
                                                // First, check if the row is non-trivial, as well as
                                                // add the non-trivial entries to the unique list.
                                                CLEAR_ARRAY "rowentries"
                                                SET "pos" = 0
                                                SET "trivial" = 1
                                                READ_2DA_ENTRY "%i%" 0 "%cols%" "val"
                                                FOR ("%j%" = 1; "%j%" < "%cols%"; "%j%" += 1) BEGIN
                                                        READ_2DA_ENTRY "%i%" "%j%" "%cols%" "val"
                                                        // Check if the base class does not gain this ability at
                                                        // the same level.
                                                        PATCH_IF (NOT ("%val%" STRING_EQUAL "****")) BEGIN
                                                                // No need to check if we are past the last column
                                                                // in the unkitted clab.
                                                                PATCH_IF ("%j%" < "%scols%") BEGIN
                                                                        INNER_PATCH_FILE ~%defclab%.2da~ BEGIN
                                                                                FOR ("%si%" = 0; "%si%" < "%srows%"; "%si%" += 1) BEGIN
                                                                                        READ_2DA_ENTRY "%si%" "%j%" "%scols%" "sval"
                                                                                        PATCH_IF ("%sval%" STRING_EQUAL_CASE "%val%") BEGIN
                                                                                                // Base already gains ability at the desired
                                                                                                // level, so we don't add it again.
                                                                                                SPRINT "val" "****"
                                                                                                SET "si" = "%srows%"
                                                                                        END
                                                                                END
                                                                        END
                                                                END
                                                        END
                                                        SPRINT $rowentries("%pos%") "%val%"
                                                        SET "pos" += 1
                                                        PATCH_IF (NOT ("%val%" STRING_EQUAL "****")) BEGIN
                                                                SET "trivial" = 0
                                                                SET "isunique" = 1
                                                                PHP_EACH "uniqueabl" AS "id2" => "abl" BEGIN
                                                                        PATCH_IF ("%val%" STRING_EQUAL_CASE "%abl%") BEGIN
                                                                                SET "isunique" = 0
                                                                        END
                                                                END
                                                                PATCH_IF ("%isunique%" != 0) BEGIN
                                                                        SPRINT $uniqueabl("%uniq_abl%") "%val%"
                                                                        SET "uniq_abl" += 1
                                                                END
                                                        END
                                                END
                                                // Do we want this row?
                                                PATCH_IF ("%trivial%" != 1) BEGIN
                                                        PHP_EACH "rowentries" AS "j" => "val" BEGIN
                                                                SPRINT $abilities("%abl_rows%") "%val%"
                                                                SET "abl_rows" += 1
                                                        END
                                                        // Fill the remainder of the line.
                                                        FOR ("%j%" = "%cols%"; "%j%" < "%maxw%"; "%j%" += 1) BEGIN
                                                                SPRINT $abilities("%abl_rows%") "****"
                                                                SET "abl_rows" += 1
                                                        END
                                                END
                                        END
                                END
                        END
                END

                OUTER_SPRINT "kit" $kits("%id%")
                ACTION_IF ("%class%" == 1) BEGIN
                        ACTION_IF (IDS_OF_SYMBOL (~kit~ ~%kit%~) >= 0) BEGIN
                                OUTER_SPRINT "kitids" "%kit%"
                        END ELSE ACTION_IF (IDS_OF_SYMBOL (~kit~ ~MAGESCHOOL_%kit%~) >= 0) BEGIN
                                OUTER_SPRINT "kitids" "MAGESCHOOL_%kit%"
                        END ELSE BEGIN
                                OUTER_SPRINT "kitids" "TRUECLASS"
                        END
                END ELSE ACTION_IF ("%class%" == 3) BEGIN
                        ACTION_IF (IDS_OF_SYMBOL (~kit~ ~%kit%~) >= 0) BEGIN
                                OUTER_SPRINT "kitids" "%kit%"
                        END ELSE ACTION_IF (IDS_OF_SYMBOL (~kit~ ~GOD%kit%~) >= 0) BEGIN
                                OUTER_SPRINT "kitids" "GOD%kit%"
                        END ELSE BEGIN
                                OUTER_SPRINT "kitids" "TRUECLASS"
                        END
                END ELSE ACTION_IF (IDS_OF_SYMBOL (~kit~ ~%kit%~) >= 0) BEGIN
                        OUTER_SPRINT "kitids" "%kit%"
                END ELSE ACTION_IF (~%kit%~ STRING_CONTAINS_REGEXP ~_~ == 0) BEGIN
                        OUTER_SPRINT "kitids" "%kit%"
                        OUTER_PATCH_SAVE "kitids" "%kit%" BEGIN
                                REPLACE_TEXTUALLY "_" ""
                        END
                        ACTION_IF (IDS_OF_SYMBOL (~kit~ ~%kit%~) < 0) BEGIN
                                OUTER_SPRINT "kitids" "TRUECLASS"
                        END
                END ELSE BEGIN
                        OUTER_SPRINT "kitids" "%kit%"
                END
                OUTER_SPRINT "kit_swapping" ~%kit_swapping%
                ActionOverride(Myself,AddKit(%kitids%))~
                // Special case for true-class mage components.
                OUTER_SPRINT "newabl" ""
                ACTION_IF ("%class%" == 1) BEGIN
                        ACTION_IF ("%kitids%" STRING_EQUAL_CASE "TRUECLASS") BEGIN
                                // True class mage. This spell removes the extra spell per level
                                // gained by any kitted mage (even multiclassed kits with a kit
                                // not from a mage class).
                                OUTER_SPRINT "newabl" "AP_m7tcwiz"
                                // Add new line for this ability.
                                OUTER_SPRINT $abilities("%abl_rows%") "%newabl%"
                                OUTER_SET "abl_rows" += 1
                                // And add it to the unique ability list.
                                OUTER_SPRINT $uniqueabl("%uniq_abl%") "%newabl%"
                                OUTER_SET "uniq_abl" += 1
                                // Fill the remainder of the line.
                                OUTER_FOR ("%j%" = 2; "%j%" < "%maxw%"; "%j%" += 1) BEGIN
                                        OUTER_SPRINT $abilities("%abl_rows%") "****"
                                        OUTER_SET "abl_rows" += 1
                                END
                        END
                END
                // Do we have anything to do?
                ACTION_IF ("uniq_abl" != 0) BEGIN
                        OUTER_SET "class" = $clsids("%id%")
                        OUTER_SPRINT "defclab"  $claborig("%class%")
                        OUTER_SPRINT "safeclab" $clablist("%class%")
                        OUTER_SPRINT "pat" $classtok("%class%")
                        OUTER_SPRINT "spellpat" "%modprefix%%kitprefix%%pat%"
                        ACTION_DEFINE_ARRAY "destabls" BEGIN END
                        OUTER_SET "lastefftok" = 0
                        // Generate the "gain ability" and "apply spell" eff files, as well
                        // as the spl file that calls them conditionally. Output is an array
                        // with the spells to be applied on the level ups.
                        ACTION_PHP_EACH "uniqueabl" AS "id2" => "abl" BEGIN
                                //OUTER_SPRINT "tok" $tokens("%id2%")
                                LAUNCH_ACTION_FUNCTION ~m7#get_suffix_padded~
                                        INT_VAR
                                                "number" = "%id2%"
                                        RET
                                                "tok" = "suffixstr" END

                                // Read the bare spell name.
                                OUTER_SET "len" = (STRING_LENGTH "%abl%") - 3
                                OUTER_PATCH "%abl%" BEGIN
                                        READ_ASCII 0x3 "spl" ("%len%") NULL
                                        INNER_PATCH_FILE "%spl%.spl" BEGIN
                                                READ_STRREF 0x8 "splname"
                                        END
                                END
                                // Will be one or the other.
                                ACTION_IF (("%abl%" STRING_MATCHES_REGEXP "[Aa][Pp]_.*") == 0) BEGIN
                                        // Explode spell into conditionally applied eff files.
                                        ACTION_IF ("%explode_spells%" != 0) BEGIN
                                                // New way:
                                                LAUNCH_ACTION_FUNCTION ~m7#explode_spell_effects~
                                                        INT_VAR
                                                                "suffixid" = "%lastefftok%"
                                                                "specval" = "%kitspec%"
                                                        STR_VAR
                                                                "sourcespell" = EVAL "%spl%"
                                                                "destspell" = EVAL "%spellpat%%tok%"
                                                                "fxprefix" = EVAL "%spellpat%"
                                                        RET
                                                                "lastefftok" = "lastsuffix" END
                                        END ELSE BEGIN
                                                // Old way:
                                                LAUNCH_ACTION_FUNCTION ~m7#get_suffix_padded~
                                                        INT_VAR
                                                                "number" = "%lastefftok%"
                                                        RET
                                                                "strtok" = "suffixstr" END
                                                OUTER_SET "lastefftok" += 1
                                                OUTER_SPRINT "apeffect" "%spellpat%%strtok%"
                                                // This effect will either give an ability or apply a spell.
                                                // It is called conditionally.
                                                COPY ~%modpath%/m7mkap.eff~ ~override/%apeffect%.eff~
                                                        WRITE_ASCIIE 0x30 "%spl%" #8
                                                        WRITE_LONG   0x90 1
                                                        WRITE_ASCIIE 0x94 "%spellpat%%tok%" #8
                                                        WRITE_LONG   0x9c 0x4000
                                                        WRITE_LONG   0xd0 1

                                                // This spell will conditionally call an effect to apply
                                                // the level up effects.
                                                COPY ~%modpath%/m7mkeff1.spl~ ~override/%spellpat%%tok%.spl~
                                                        WRITE_LONG   0x18 0x4000
                                                        WRITE_LONG   (0x9e + 0x00) "%kitspec%"
                                                        WRITE_ASCIIE (0xae + 0x00) "%apeffect%" #8
                                        END
                                END ELSE ACTION_IF (("%abl%" STRING_MATCHES_REGEXP "[Gg][Aa]_.*") == 0) BEGIN
                                        // Construct the display string for gaining the ability.
                                        //OUTER_SPRINT "strtok" $tokens("%laststr%")
                                        LAUNCH_ACTION_FUNCTION ~m7#get_suffix_padded~
                                                INT_VAR
                                                        "number" = "%laststr%"
                                                RET
                                                        "strtok" = "suffixstr" END
                                        OUTER_SET "laststr" += 1
                                        OUTER_SPRINT "streffect" "%strpat%%strtok%"
                                        OUTER_SPRINT "abltext" #10514
                                        OUTER_PATCH_SAVE "outbuf" "%abltext%" BEGIN
                                                REPLACE_TEXTUALLY EXACT_MATCH "<SPECIALABILITYNAME>" "%splname%"
                                        END
                                        // Now put it on the freshly minted effect.
                                        COPY ~%modpath%/m7mkstr.eff~ ~override/%streffect%.eff~
                                                SAY_EVALUATED 0x1c "%outbuf%"
                                                WRITE_LONG  0x9c 0x4000
                                                WRITE_LONG  0xd0 1
                        
                                        LAUNCH_ACTION_FUNCTION ~m7#get_suffix_padded~
                                                INT_VAR
                                                        "number" = "%lastefftok%"
                                                RET
                                                        "strtok" = "suffixstr" END
                                        OUTER_SET "lastefftok" += 1
                                        OUTER_SPRINT "gaeffect" "%spellpat%%strtok%"
                                        // This effect will conditionally give an ability.
                                        COPY ~%modpath%/m7mkga.eff~ ~override/%gaeffect%.eff~
                                                WRITE_ASCIIE 0x30 "%spl%" #8
                                                WRITE_LONG   0x90 1
                                                WRITE_ASCIIE 0x94 "%spellpat%%tok%" #8
                                                WRITE_LONG   0x9c 0x4000
                                                WRITE_LONG   0xd0 1
                        
                                        // This spell will conditionally call two effects: one to
                                        // grant the ability and the other to display the ability
                                        // gained string.
                                        COPY ~%modpath%/m7mkeff2.spl~ ~override/%spellpat%%tok%.spl~
                                                WRITE_LONG   0x18 0x4000
                                                WRITE_LONG   (0x9e + 0x00) "%kitspec%"
                                                WRITE_ASCIIE (0xae + 0x00) "%gaeffect%" #8
                                                WRITE_LONG   (0x9e + 0x30) "%kitspec%"
                                                WRITE_ASCIIE (0xae + 0x30) "%streffect%" #8
                                END
                        
                                // Put the new replacement ability in the list, for later use.
                                OUTER_SPRINT $destabls("%id2%") "AP_%spellpat%%tok%"
                        END
                
                        // Now we generate the bulk of the lines to be appended to the clab
                        // file of the unkitted class. Still missing is column zero.
                        OUTER_SET "jj" = 1
                        OUTER_SET "k" = 0
                        ACTION_DEFINE_ARRAY "rows_2da" BEGIN END
                        ACTION_CLEAR_ARRAY "rows_2da"
                        OUTER_SPRINT "buff" ""
                        ACTION_PHP_EACH "abilities" AS "id2" => "abl" BEGIN
                                ACTION_IF ("%jj%" >= "%maxw%") BEGIN
                                        OUTER_SPRINT $rows_2da("%k%") "%buff%"
                                        OUTER_SPRINT "buff" ""
                                        OUTER_SET "jj" = 1
                                        OUTER_SET "k" += 1
                                END
                                OUTER_SPRINT "buff" "%buff% %abl%"
                                OUTER_SET "jj" += 1
                        END
                        // We need to have this here because the loop terminates without
                        // adding the last row.
                        OUTER_SPRINT $rows_2da("%k%") "%buff%"
                        OUTER_SET "k" += 1

                        // Time now to generate the files.
                        ACTION_IF (NOT (FILE_EXISTS_IN_GAME "%defclab%.2da")) BEGIN
                                // Use the 'clean' 2da file we created above.
                                COPY_EXISTING ~%safeclab%.2da~ ~override/%defclab%.2da~
                        END

                        // Need to reobtain these values, as defclab is now the file in
                        // override dir.
                        ACTION_IF (FILE_EXISTS_IN_GAME "%defclab%.2da") BEGIN
                                COPY_EXISTING ~%defclab%.2da~ ~override~
                                        COUNT_2DA_COLS "scols"
                                        COUNT_2DA_ROWS "%scols%" "srows"
                                        BUT_ONLY
                        END ELSE BEGIN
                                // Just in case.
                                OUTER_SET "scols" = 0
                                OUTER_SET "srows" = 0
                        END

                        // Start by filling the columns addequatelly up to the maximum.
                        ACTION_IF (scols < maxw) && FILE_EXISTS_IN_GAME "%defclab%.2da" BEGIN //check pls
                                OUTER_SPRINT buff ""
                                OUTER_FOR (j = 0; j < srows; j += 1) BEGIN
                                        OUTER_SPRINT buff "%buff% ****"
                                END
                                OUTER_FOR (i = scols + 1; i <= maxw; i += 1) BEGIN
                                        // here things start going south...
                                        OUTER_SPRINT __c7_final_clab_append_ "__c7_replace_me_1_ __c7_replace_me_2_ %i%%buff%" //it's the only way it works, sadly... lol
                                        APPEND_COL ~%defclab%.2da~ "%__c7_final_clab_append_%"
                                        COPY_EXISTING ~%defclab%.2da~ override
                                          REPLACE_TEXTUALLY ~__c7_replace_me_1_~ "" //as I've said before, this is sadly the only way lmfao
                                          REPLACE_TEXTUALLY ~__c7_replace_me_2_~ "" // RIP the worst bug this mod ever had
                                        BUT_ONLY
                                END
                        END

                        // Finally, we can finish up the clab file!
                        // First, we append the rows together, including the row label.
                        OUTER_SPRINT "buff" ""
                        ACTION_PHP_EACH "rows_2da" AS "id2" => "abl" BEGIN
                                //OUTER_SPRINT "tok" $tokens("%index%")
                                OUTER_SET "idx" = "%srows%" + "%id2%" + 1
                                LAF ~m7#get_suffix_padded~
                                        INT_VAR
                                                "number" = "%idx%"
                                        RET
                                                "tok" = "suffixstr" END
                                OUTER_SPRINT "buff" ~%buff%ABILITY%tok%%abl%
~
                        END

                        // Now we replace the source abilities (from the original kit) with
                        // the destination (conditional) abilities we created earlier.
                        OUTER_PATCH_SAVE "outbuf" "%buff%" BEGIN
                                PHP_EACH "uniqueabl" AS "id2" => "abl2" BEGIN
                                        SPRINT "repl" $destabls("%id2%")
                                        REPLACE_TEXTUALLY CASE_INSENSITIVE EXACT_MATCH "%abl2%" "%repl%"
                                END
                        END
                        ACTION_CLEAR_ARRAY "destabls"

                        // Append it all to the 2da file.
                        APPEND ~%defclab%.2da~ "%outbuf%"

                        // Finally, leave it looking good...
                        COPY_EXISTING ~%defclab%.2da~ ~override~
                                PRETTY_PRINT_2DA
                                BUT_ONLY
                END
        END

        OUTER_PATCH "dummy" BEGIN
                // Time now to process weapprof.2da. We pick the most restrictive set of
                // weapon skills for all of the kits.
                INNER_PATCH_FILE ~weapprof.2da~ BEGIN
                        COUNT_2DA_COLS "cols"
                        COUNT_2DA_ROWS "%cols%" "rows"
                        SPRINT "profsrow" "%kitid%"
                        SET "multicol" = $baseprofs("%kitclassids%")
                        FOR ("%i%" = 0; "%i%" < "%rows%"; "%i%" += 1) BEGIN
                                // The value for the multi-class entry:
                                READ_2DA_ENTRY "%i%" "%multicol%" "%cols%" "valm"
                                // Start with multiclass value.
                                SET "val" = "%valm%"
                                PHP_EACH profs AS "j" => "col" BEGIN
                                        SET "idsval" = $clsids("%j%")
                                        SET "basecol" = $baseprofs("%idsval%")
                                        // Value for one of the base classes:
                                        READ_2DA_ENTRY "%i%" "%basecol%" "%cols%" "valb"
                                        // Value for the kit:
                                        READ_2DA_ENTRY "%i%" ("%col%"+1) "%cols%" "valk"
                                        PATCH_IF ("%valb%" > "%valk%") BEGIN
                                                // Kit has lower value than base class.
                                                // If kit forbids prof., use kit value; otherwise, use
                                                // best of multiclass and current values.
                                                PATCH_IF ("%valk%" == 0) BEGIN
                                                        SET "val" = "0"
                                                END ELSE PATCH_IF ("%valm%" > "%val%") BEGIN
                                                        SET "val" = "%valm%"
                                                END
                                        END ELSE PATCH_IF ("%valb%" < "%valk%") BEGIN
                                                // Kit has higher value than base class.
                                                // Pick best of kit value, current value and
                                                // multiclass value.
                                                LAUNCH_PATCH_FUNCTION ~m7#max3~
                                                        INT_VAR
                                                                "n1" = %valk%
                                                                "n2" = %val%
                                                                "n3" = %valm%
                                                        RET
                                                                "val" = "maxval" END
                                        END ELSE PATCH_IF ("%valb%" == "%valk%") BEGIN
                                                // Kit has the same value as base class.
                                                // Keep current value.
                                        END
                                END
                                SPRINT "profsrow" "%profsrow% %val%"
                        END
                END

                // Time now to process alignmnt.2da. We pick the most restrictive options.
                INNER_PATCH_FILE ~alignmnt.2da~ BEGIN
                        COUNT_2DA_COLS "cols"
                        COUNT_2DA_ROWS "%cols%" "rows"
                        DEFINE_ARRAY "aligns" BEGIN END
                        SET "pos" = 0
                        // Picking the most restrictive alignment set.
                        PHP_EACH "kits" AS "id" => "kit" BEGIN
                                FOR ("%row%" = 0; "%row%" < "%rows%"; "%row%" += 1) BEGIN
                                        READ_2DA_ENTRY "%row%" 0 "%cols%" "name"
                                        PATCH_IF ("%name%" STRING_EQUAL_CASE "%kit%") BEGIN
                                                FOR ("%j%" = 1; "%j%" < "%cols%"; "%j%" += 1) BEGIN
                                                        READ_2DA_ENTRY "%row%" "%j%" "%cols%" "val"
                                                        SET $aligns("%pos%") = "%val%"
                                                        SET "pos" += 1
                                                END
                                        END
                                END
                        END
                        SPRINT "alignrow" "%kitid%"
                        SET "max" = "%cols%" - 1
                        // Now we create the alignment row.
                        FOR ("%id%" = 0; "%id%" < "%max%"; "%id%" += 1) BEGIN
                                SET "allow" = 1
                                SET "ind" = "%id%"
                                WHILE ("%ind%" < "%pos%") BEGIN
                                        SET "val" = $aligns("%ind%")
                                        PATCH_IF ("%val%" == 0) BEGIN
                                                SET "ind" = "%pos%"
                                                SET "allow" = 0
                                        END ELSE BEGIN
                                                SET "ind" += "%max%"
                                        END
                                END
                                SPRINT "alignrow" "%alignrow% %allow%"
                        END
                END
        
                // Stat requirements. Again, picking the most restrictive set.
                DEFINE_ARRAY "abrqfiles" BEGIN ~abclasrq~ ~abdcdsrq~ ~abdcscrq~ END
                DEFINE_ARRAY "abrqrows"  BEGIN END
                DEFINE_ARRAY "statvals"  BEGIN END
                PHP_EACH "abrqfiles" AS "index" => "file" BEGIN
                        INNER_PATCH_FILE ~%file%.2da~ BEGIN
                                COUNT_2DA_COLS "cols"
                                COUNT_2DA_ROWS "%cols%" "rows"
                                CLEAR_ARRAY "statvals"
                                SET "pos" = 0
                                // Picking the most restrictive stat requirements.
                                PHP_EACH "kits" AS "id" => "kit" BEGIN
                                        FOR ("%row%" = 0; "%row%" < "%rows%"; "%row%" += 1) BEGIN
                                                READ_2DA_ENTRY "%row%" 0 "%cols%" "name"
                                                PATCH_IF ("%name%" STRING_EQUAL_CASE "%kit%") BEGIN
                                                        FOR ("%j%" = 1; "%j%" < "%cols%"; "%j%" += 1) BEGIN
                                                                READ_2DA_ENTRY "%row%" "%j%" "%cols%" "val"
                                                                SET $statvals("%pos%") = "%val%"
                                                                SET "pos" += 1
                                                        END
                                                END
                                        END
                                END
                                SPRINT "buff" "%kitid%"
                                SET "max" = "%cols%" - 1
                                // Now we create the stat requirement row.
                                FOR ("%id%" = 0; "%id%" < "%max%"; "%id%" += 1) BEGIN
                                        SET "maxval" = 0
                                        SET "ind" = "%id%"
                                        WHILE ("%ind%" < "%pos%") BEGIN
                                                SET "val" = $statvals("%ind%")
                                                PATCH_IF ("%val%" > "%maxval%") BEGIN
                                                        SET "maxval" = "%val%"
                                                END
                                                SET "ind" += "%max%"
                                        END
                                        SPRINT "buff" "%buff% %maxval%"
                                END
                                SPRINT $abrqrows("%index%") "%buff%"
                        END
                END

                // Stat modifiers. All are added up.
                INNER_PATCH_FILE ~abclsmod.2da~ BEGIN
                        COUNT_2DA_COLS "cols"
                        COUNT_2DA_ROWS "%cols%" "rows"
                        CLEAR_ARRAY "statvals"
                        SET "pos" = 0
                        // Tally the stat modifiers for all kits.
                        PHP_EACH "kits" AS "id" => "kit" BEGIN
                                FOR ("%row%" = 0; "%row%" < "%rows%"; "%row%" += 1) BEGIN
                                        READ_2DA_ENTRY "%row%" 0 "%cols%" "name"
                                        PATCH_IF ("%name%" STRING_EQUAL_CASE "%kit%") BEGIN
                                                FOR ("%j%" = 1; "%j%" < "%cols%"; "%j%" += 1) BEGIN
                                                        READ_2DA_ENTRY "%row%" "%j%" "%cols%" "val"
                                                        SET $statvals("%pos%") = "%val%"
                                                        SET "pos" += 1
                                                END
                                        END
                                END
                        END
                        SPRINT "buff" "%kitid%"
                        SET "max" = "%cols%" - 1
                        // Now we create the stat mod row.
                        FOR ("%id%" = 0; "%id%" < "%max%"; "%id%" += 1) BEGIN
                                SET "maxval" = 0
                                SET "ind" = "%id%"
                                WHILE ("%ind%" < "%pos%") BEGIN
                                        SET "val" = $statvals("%ind%")
                                        SET "maxval" += "%val%"
                                        SET "ind" += "%max%"
                                END
                                SPRINT "buff" "%buff% %maxval%"
                        END
                        SPRINT "abclsmod" "%buff%"
                END
        END

        ACTION_IF ((STRING_LENGTH "%title%") != 0) BEGIN
                OUTER_PATCH "dummy" BEGIN
                        SPRINT "lowname" "%title%"
                        SPRINT "mixname" "%title%"
                        TO_LOWER "lowname"
                END
        END ELSE BEGIN
                // Lower and mixed names, description.
                OUTER_SPRINT "title" $classnam("%kitclassids%")
                OUTER_PATCH_SAVE "lowname" "%title%" BEGIN
                        PHP_EACH "lownames" AS "id" => "nm" BEGIN
                                SET "i" = $clsids("%id%")
                                SPRINT "find" $classnam("%i%")
                                REPLACE_TEXTUALLY CASE_INSENSITIVE EXACT_MATCH "%find%" "%nm%"
                        END
                END
                OUTER_PATCH_SAVE "mixname" "%title%" BEGIN
                        PHP_EACH "names" AS "id" => "nm" BEGIN
                                SET "i" = $clsids("%id%")
                                SPRINT "find" $classnam("%i%")
                                REPLACE_TEXTUALLY CASE_INSENSITIVE EXACT_MATCH "%find%" "%nm%"
                        END
                END
        END

        OUTER_SPRINT "descript" "%mixname%"
        ACTION_PHP_EACH "descs" AS "id" => "nm" BEGIN
                OUTER_SPRINT "descript" ~%descript%

%nm%~
        END

        OUTER_SPRINT "abclasrq" $abrqrows(0)
        OUTER_SPRINT "abdcdsrq" $abrqrows(1)
        OUTER_SPRINT "abdcscrq" $abrqrows(2)

        LAUNCH_ACTION_FUNCTION ~m7#int_to_hex_str~ INT_VAR "number" = "%unusability%" RET "unusstr" = "hexstr" END
//        PRINT ~%mixname% %lowname%~
//        PRINT ~%descript%~
        ADD_KIT ~%kitid%~
                // appended to CLASWEAP.2da; does it even matter in BG2????
                ~%kitid% 1 1 1 1 1 1 1 1~
                // appended column-wise to WEAPPROF.2da
                ~%profsrow%~
                // appended to ABCLASRQ.2da
                ~%abclasrq%~
                // appended to ABCLSMOD.2da
                ~%abclsmod%~
                // appended to ABDCDSRQ.2da
                ~%abdcdsrq%~
                // appended to ABDCSCRQ.2da
                ~%abdcscrq%~
                // appended to ALIGNMNT.2da
                ~%alignrow%~
                // appended to DUALCLAS.2da
                // Can't dual to anything, so...
                ~%kitid% 0 0 0 0 0 0~
                // Dummy clab file; it isn't used for anything.
                ~%modpath%/clabkit.2da~
                // PC races and classes allowed to use this kit, from KITTABLE.2da
                // Leaving empty for now as the kit can't be selected at character
                // creation anyway.
                ~~
                // usability flags, added to the end of the KITLIST.2da entry
                ~%unusstr%      %kitclassids%~
                // HLA table to use; see LUABBR.2da
                // Defaulting to the value set for the unkitted multiclass; this should
                // be changed if a given multikit demands a custom HLA table.
                ~%kitclassluabbr%~
                // list of starting equipment for PCs starting in ToB. Appended column-wise to 25STWEAP.2da
                // It is not like you can start with a multikit anyway...
                ~* * * * * * * * * * * * * * * * * * * *~
                // Lower, mixed, and help kit names and descriptions, added to KITLIST.2da
                SAY "%lowname%"
                SAY "%mixname%"
                SAY "%descript%"

        ACTION_IF ENGINE_IS tob BEGIN
                APPEND ~specific.ids~ ~%kitspec% SPEC_%kitid%~
        END

        CLEAR_IDS_MAP

        ACTION_IF !ENGINE_IS tob BEGIN
                INCLUDE "%basepath%/lib/7c#ee_multikit.tph"
        END

        ACTION_IF ENGINE_IS tob BEGIN
        // The kit changer script.
<<<<<<<< ../m7multikit-inlined/multikit.baf
IF
        HotKey(K)
        !Kit(Myself,%kitid%)
        ActionListEmpty()
THEN
        RESPONSE #100
                ChangeSpecifics(Myself,SPEC_%kitid%)
                ActionOverride(Myself,AddKit(%kitid%))%extra_actions%
END

IF
        HotKey(N)
        Kit(Myself,%kitid%)
        ActionListEmpty()
THEN
        RESPONSE #100
                ChangeSpecifics(Myself,NORMAL)%kit_swapping%
                ActionOverride(Myself,AddKit(TRUECLASS))
END
>>>>>>>>

        // Compile it.
                COPY ~../m7multikit-inlined/multikit.baf~ ~scripts/%modprefix%%kitprefix%.bs~
                        EVAL
                        COMPILE_BAF_TO_BCS

                // Name and description for the script.
                APPEND ~scrpdesc.2da~ ~%modprefix%%kitprefix% c7scripname c7scripdesc~

                // Replace name and description with the correct values.
                COPY_EXISTING ~scrpdesc.2da~ ~override~
                        REPLACE ~c7scripname~ ~%mixname%~
                        REPLACE ~c7scripdesc~ @1300010
                        PRETTY_PRINT_2DA
                BUT_ONLY

                ACTION_IF "%WEIDU_OS%" STR_CMP "WIN32" BEGIN
                        AT_UNINSTALL ~rm -f scripts/%modprefix%%kitprefix%.bs~
                END ELSE BEGIN /* honestly hope this works. no fucking clue about windows lol */
                        AT_UNINSTALL ~del scripts/%modprefix%%kitprefix%.bs~
                END
        END
        // Pretty-print them all.
        COPY_EXISTING ~clasweap.2da~ ~override~
                          ~weapprof.2da~ ~override~
                          ~abclasrq.2da~ ~override~
                          ~abdcdsrq.2da~ ~override~
                          ~abdcscrq.2da~ ~override~
                          ~abclsmod.2da~ ~override~
                          ~alignmnt.2da~ ~override~
                          ~dualclas.2da~ ~override~
                          ~kitlist.2da~  ~override~
                PRETTY_PRINT_2DA
        BUT_ONLY

        // Working around a bug regarding variables in WeiDU AddKit.
        // I wonder if this still applies...
        COPY_EXISTING ~25stweap.2da~ ~override~
                SPRINT "buff" "kitid"
                REPLACE_TEXTUALLY CASE_INSENSITIVE EXACT_MATCH "%%buff%%" "%kitid%"
                PRETTY_PRINT_2DA
        BUT_ONLY

        ACTION_IF ENGINE_IS tob BEGIN
                OUTER_SPRINT "prompt" @1300011
                OUTER_PATCH_SAVE "prompt2" "%prompt%" BEGIN
                        REPLACE_TEXTUALLY EXACT_MATCH "<SCRIPTNAME>" "%mixname%"
                END

                PRINT ~%prompt2%~
        END
END