/* OggDec
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Copyright 2002, John Edwards
 *
 */


#ifndef AUDIO_H_INCLUDED
#define AUDIO_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#define MAXWAVESIZE     4294967040LU

#define WAV_FMT_8BIT  1
#define WAV_FMT_16BIT 2
#define WAV_FMT_24BIT 3
#define WAV_FMT_32BIT 4
#define WAV_FMT_FLOAT 5


enum {
	OUTPUT_WAV = 1,
	OUTPUT_RAW
} output_format;

typedef struct
{
	int           outputFormat;
	FILE          *sndfile;
	unsigned int  fileType;
	unsigned long samplerate;
	unsigned int  bits_per_sample;
	unsigned int  channels;
	unsigned long samples;
} audio_file;

audio_file *open_output_audio_file(char *infile,
                                   int samplerate,
                                   int channels,
                                   int outputFormat,
                                   int fileType,
                                   unsigned int knownlength);

int write_audio_file(audio_file *aufile,
                     void *sample_buffer,
                     int samples);

void close_audio_file(audio_file *aufile,
                      char       *fileName);

static int write_wav_header(audio_file *aufile);

static int write_audio_8bit(audio_file *aufile,
                            void *sample_buffer,
                            unsigned int samples);

static int write_audio_16bit(audio_file *aufile,
                             void *sample_buffer,
                             unsigned int samples);

static int write_audio_24bit(audio_file *aufile,
                             void *sample_buffer,
                             unsigned int samples);

static int write_audio_32bit(audio_file *aufile,
                             void *sample_buffer,
                             unsigned int samples);

static int write_audio_float(audio_file *aufile,
                             void *sample_buffer,
                             unsigned int samples);

void* output_to_PCM(float          **input,
                    void           *samplebuffer,
                    unsigned char  channels,
                    unsigned int   samples,
                    unsigned char  format);


#ifdef __cplusplus
}
#endif
#endif
