<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>SubtleMods: 5E-style spellcasting</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" href="style/g3readme_cam.css" type="text/css" />
<link href="style/g3icon.ico" rel="icon" type="image/bmp" />
</head>
<body>
<h1>SubtleMods: D&D 5th Edition-style Spellcasting</h1>
<div class="section">
  <p><strong> Version 2.5 </strong><br />
  <strong> Languages:</strong> English</p>
  <p><strong>Author: <a href="http://forums.gibberlings3.net/index.php?showuser=6306">The Subtle Doctor</a></strong></p>
  <p><strong><a href="https://github.com/UnearthedArcana/5E_spellcasting">Home page</a></strong></p>
  <p><strong><a href="https://www.gibberlings3.net/forums/topic/32551-subtlemods-5e-spellcasting-rules-conversion/">Discussion Forum</a></strong></p>
  <p><strong><a href="https://github.com/UnearthedArcana/5E_spellcasting/releases">Download</a></strong></p>
</div>
<h2>Overview</h2>
<div class="section">
  <p>This mod will allow 2E 'Vancian' spellcasters in the game to instead use 5E-style spellcasting, what I call "semi-spontaneous" casting (as opposed to the "full spontaneous" system that sorcerers use).  Thus, casters will have the flexibility of normal casters in learning lots of spells, and the flexibility of sorcerers in casting spells spontaneously.</p>
  <p><b>Note:</b> this mod makes heavy use of the EE 2.0+ engine features. I would not even try to install this on a game version lower than 2.5.</p>
</div>
<h2>Installation</h2>
<div class="section">
  <p><strong>Windows:</strong><br />
    The mod archive should be extracted into your game folder from the archive (or just unzipped and then copied there). If properly extracted, you should have a "5E_spellcasting" folder and "setup-5E_spellcasting.exe" in your game folder. To install, simply double-click "setup-5E_spellcasting.exe" and then follow the instructions on screen.</p>
  <p><strong>MacOS:</strong><br />
    This mod is packaged with the abre mod folder. IMO the easiest way to install this on Macs is with the Mac Weidu Launcher (MWL). To install, simply extract the contents of the mod and then move them into your game folder. If properly extracted, you should now have a folder called "5E_spellcasting" and the "Mac WeiDU Launcher" in your game directory. To install, simply double-click the MWL, choose "5E_spellcasting" from the list, and then follow the instructions on the screen.</p>
</div>
<h2>Compatibility</h2>
<div class="section">
  <p>This mod should be installed after mods that add spells to the game, like Spell Revisions, IWDification, and SCS IWD Spells. It should be installed after Tome & Blood and Faiths & Powers; but before Might & Guile and Faiths & Powers Multiclass.</p>
  <p>The mod converts any arcane spells that have a scroll from which you can learn - since it changes the spellcasting method of casters who learn spells from scrolls. On the divien side of things, it will convert any spell that is typically available to clerics - that is, any spell with a 'SPPR' prefix and numbered from 101 to 150, 201 to 250, etc. Notably, this excludes divine spells that are added by mods that don't use the traditional naming structure and apply them via a UI hack. At the moment there is no way for me to effectively find and capture such spells. If you use the Faiths & Powers sphere system, then this mod will convert all divine spells in that sphere system, instead of using the traditional method.</p>
  <p>See the bottom of the mod description below for some more detailed inter-mod compatibility notes.</p>
</div>
<h2>Contents</h2>
<div class="section">
  <h4 class="subheader">5E-Style Spellcasting for All Casters</h4>
  <div class="section">
    <p>This mod has an ambitious scope: to change the fundamental spellcasting mechanism for all spellcasters in the game. The short description is, it makes the game use D&D 5E rules for how spell slots work.</p>
    <p>For a proper, longer explanation, let's start with a brief run-down of spellcasting in BG games. You can <b>know</b> spells, and you can <b>memorize</b> spells, and you can <b>cast</b> spells. In the old AD&D 2E rules, which the BG games use, your known spells are one thing, but the spells you memorize and the spells you can cast are identical - memorize Magic Missile twice, and you can cast Magic Missile twice. Contrast with sorcerers: their known spells and the spells they can cast are identical, but there is no memorization. If you have two 1st-level casting slots, then you can cast any of your known 1st-level spells as many as two times. (This mod does not change sorcerers at all, I'm just mentioning them to tease out the way these systems work.)</p>
    <p>The D&D 5E system separates memorized spells from spellcasting slots, and ends up as a bit of a hybrid system between 2E mages and sorcerers. You have a certain number of memorization slots that allow you to 'prepare' spells for the next day; then, the next day, you can cast any of those prepared spells like a sorcerer. If you prepare Magic Missile and Shield, and you cast Magic Missile, you do not lose your only Magic Missile spell; you still have a 1st-level casting slot and you can still use it to cast either Shield or Magic Missile. So you can learn and memorize spells like a mage, and them cast them spontaneously like a sorcerer.</p>
    <p>If you think this gives mages a serious boost compared to sorcerers, you are not wrong. It does level the playing field to an extent. But sorcerers still pack more brute power. They have more casting slots then these 5E wizards - this 5E system give mages the same number of casting slots as Dragin Disciples, i.e. one fewer than a sorcerer at any given level. So sorcerers can still just cast more spells and power their way through a situation.</p>
    <p>(<b>NOTE:</b> I've been talking about wizards and sorcerers, but this mod affects all traditional spellcasters: mages, bards, clerics, druids, paladins, and rangers. At some point I may split these up and allow the changes to be made for some classes but not others... but for now this is an all-or-nothing total rules conversion.)</p>
    <p>As for the mechanics of how this works: you have to be a bit more intentional in playing spellcasters. During the normal course of things, you will not have access to your spellbook. In order to prepare spells - either because you want to change your prepared spells or because you have leveled up and can prepare more spells - you need to intentionally open the spellbook right before you rest. In-game, the way you do this is by activating an innate ability called 'Change Prepared Spells.' This will <b>disable your spellcasting</b> until you rest, but will give you access to your memorization slots. Fill the slots with whatever spells you want to prepare, just like in normal gameplay, and then rest. When you wake up, wait for 1-3 seconds and you will see your spellcasting button go dark and then light up again. Now you no longer have access to your memorization slots, but you can spontaneously cast any of your prepared spells.</p>
    <p>You don't <i>have</i> to use the 'Change Prepared Spells' button every time you rest. If you are happy with the spells you have prepared, then you can simply cast them and rest, cast them and rest - gameplay will be a lot like with a sorcerer. The innate ability is there for when you learn new spells or would like to prepare different spells for this or that dungeon, or whatever.</p>
    <p><b>A note about dual-classing:</b> when dual-classing from cleric to mage, or from mage to cleric, the 5E spellcasting system will not kick in until you use the "Change Prepared Spells ability. You may have memorization slots in your new class and it might look like you can rest and begin casting like a 5E magic user, but you can't - your new class will have unmodded Vancian spellcasting until you use that ability and then get eight hours' rest.</p>
    <p><b>A further note about dual-classing:</b> this is just a little bonus. If your first class has any "free cast" spells that don't need to be memorized - this might happen with specialist wizards, and wi certain cleric kits and the Faiths & Powers sphere system - then you will be able to continue casting those free-to-cast spells from your old class while you level up in the new class. Enjoy.</p>
    <p><b>Limitations:</b> this system very faithfully recreates the method sorcerers use for spellcasting in the game, but I'm at a bit of a disadvantage since they are hard-coded and this is just a mod. There are several limitations involved in this spellcasting system. 
    <ul>
      <li><p> 5E Spellcasters cannot use the traditional 'Identify' spell. That spell is hard-coded to work in the inventory screen. As a workaround, this mod installs a small UI tweak and a new Identify spell yhat you cast from the main game screen, instead of using in the inventory. A small bonus: now the spell gets better as you level up, allowing you to identify up to four items with one casting.</p>
      <li><p> 5E spellcasters cannot use traditional Contingency or Spell Sequencer spells. This is due to how they are hard-coded to work. To address this, the mod will modify these spells, allowing you to choose from any known spells, instead of any memorized spells. A side-effect of this is that they will not longer exhaust memorized spells (for any casters of any type) when this is done.</p>
      <li><p> 5E spellcasters cannot use quickspell slots on the main UI screen. They are hard-coded to function in a way that doesn't work with this system. There is no workaround for this one... sorry. It is an inconvenience, but not a huge one. Several spellcasting classes don't even have quickspell buttons in their UI. Hopefully the added utility and flexibility of this spellcasting system more than make up for the small UI  limitation.</p>
      <li><p>The last limitation has to do with items that increase your spellcasting slots, like the Ring of Wizardry. In the base game these increase both memorization slots and casting slots for mages (since those are identical for mages), and increase casting slots for sorcerers. Here, I faced the question of how they should work: should they increase your memorization slots (for more flexibility), or increaser your casting slots (for more power, like sorcerers), or both? If a 5E caster wears an unmodded Ring of Wizardry, it will only increase their meorization slots. But most people like increasing their casting slots, so there is a secondary component in this mod that will change those items to do that. The caveat is, such items can only add one casting slot per spell level. So for example, BG2's Ring of Acuity usually gives you two bonus 2nd-level slots... now it will only give you one. However, you <b>can</b> stil combine different items to get multiple +1 bonuses. For special items that double your spell slots like BG1's Evermemory ring and IWD's Kontik's Ring of Wizardry, this mod will give them an active item ability to refresh your casting slots of the appropriate spell level, instead of having the passive effect of adding memorization slots. Use that ability once per day, and you've doubled your casting slots. So the original design is replicated, just in a different way.</p>
    </ul>
    <p>I am happy to say this mod should now be compatible with the 'Revised Specialists' component of Tome & Blood. That component allows specialist mages to spontaneously cast spells in their chosen school, but the mechanism is clunky; this mod removes that mechanism and replaces it with a more streamlined version: specialists: are automatically able to cast any spell in their chosen school without having to prepare them. They lose one memorization slot per level in exchange, but they will often have more than one spell in their specialty at most levels, so it should be a net gain. (I particularly recommend the 'Rebalance Spell Schools' component on Tome & Blood in conjunction with this, since it makes sure that there are two or more spells from each school at each spell level.) The other specialist advantages in Tome & Blood's Revised Specialists component will be retained if this mod is installed after it.</p>
    <p>This should be compatible with other mods that affect spells and spellcasting. For example it should work with Tome & Blood's 'Revised Invisibility' and 'Revised Illusionary Clones,' and I have gone to great lengths to make sure it is compatible with all aspects of the Faiths & Powers mod. Though note, F&P has an option to give all priests the option to learn and cast spells like a sorcerer... if that component is installed, then priests will <b>not</b> get 5E-style spellcasting from this mod. In that case arcane casters will use 5E casting, and divine casters will have the option to choose between Vancian casting and sorcerer-style castsing.</p>
  </div>
</div>
<div class="section">
  <h4 class="subheader">5E-Style Spellcasting</h4>
  <div class="section">
    <p>This mod has an ambitious scope: to change the fundamental spellcasting mechanism for all spellcasters in the game. The short description is, it makes the game use D&D 5E rules for how spell slots work.</p>
    <p>NOTE: this will also affect the multiclass "Revised Bard" kits from Might & Guile, if that mod is installed first.</p>
  </div>
</div>
<div class="section">
  <h4 class="subheader">Bonus Spell Slot Items and 5E Casting</h4>
  <div class="section">
    <p>These components allow you to choose how bonus slot items will work with 5E casters. By default they increase spellbook slots, i.e. memorization slots, for wizards and casting slots for sorcerers. You can choose how they should affect 5E casters: change to increasing casting slots, or increase both memorization slots <b>and</b> casting slots. <b>NOTE:</b> for technical reasons, in the latter two instances, slot-increasing items can only increase one casting slot of each spell level. So the Ring of Acuity which normally gives +2 2nd-level slots and +1 3rd- and 4th-level slots, will now give +1 2nd-, 3rd-, and 4th-level slots. This is unavoidable, sorry. (You can still get +2 or more slots of a given spell level if you mix two or more bonus-slot items.)</p>
  </div>
</div>
<h2>Contact Information</h2>
<div class="section">
  <p>This mod was created by SubtleDoctor. You can visit <a href="http://forums.gibberlings3.net/index.php">The
    Gibberlings Three</a> for information on this and many other fine mods.</p>
</div>
<h2>Thanks and Acknowledgements</h2>
<div class="section">
  <p>Thanks to the still active and vibrant Infinity Engine modding community. </p>
  <p><strong>Tools Used in Creation</strong><br />
    <a href="http://www.weidu.org/"><acronym title="Weimer Dialogue Utility">WeiDU</acronym></a> by
    Wes Weimer, and then the bigg and then Wisp<br />
    <a href="http://www.idi.ntnu.no/~joh/ni/">Near Infinity</a> by Jon Olav Hauglid, and then Argent77 and Astrobryguy<br />
    <a href="http://iesdp.gibberlings3.net/"><acronym title="Infinity Engine Structures Description Project">IESDP</acronym></a> maintained by igi</p>
</div>
<h2>Credits and Copyright Information</h2>
<div class="section">
  <p>Copyright 2021. If you want to use or adapt any part of this mod in another mod or similar endeavor, please try to contact me at forums.gibberlings3.net to discuss it. As a general rule, I have no problem with that as long as you credit the source of the work. If you cannot get in touch with me, assume that you have my permission to use any of this code for any project that is non-commercial, offered for free, and intended for the greater enjoyment of players of Infinity Engine games. If you do so, please credit me, and mention how awesome I am in a comment in the code, or something like that. You may NOT use this code for any profit-making or commercial venture, without express permission from me.</p>
</div>
</body>
</html>
