<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>SubtleMods: Combat Skills & Proficiencies</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" href="style/g3readme_cam.css" type="text/css" />
<link href="style/g3icon.ico" rel="icon" type="image/bmp" />
</head>
<body>
<h1>SubtleMods: Combat Skills & Proficiencies</h1>
<div class="section">
  <p><strong> Version 1.4 </strong><br />
  <strong> Languages:</strong> English</p>
  <p><strong>Author: <a href="http://forums.gibberlings3.net/index.php?showuser=6306">The Subtle Doctor</a></strong></p>
  <p><strong><a href="https://github.com/subtledoctor/Combat_Skill_Proficiencies">Home page</a></strong></p>
  <p><strong><a href="http://">Discussion Forum</a></strong></p>
  <p><strong><a href="https://github.com/subtledoctor/Combat_Skill_Proficiencies/releases">Download</a></strong></p>
</div>
<h2>Overview</h2>
<div class="section">
  <p>This mod is all about improving gameplay.  While I love mods that bring the game closer to PnP, like Rogue Rebalancing and aTweaks, BG is a single-player computer game.  If tweaking a rule makes this specific game more fun, then it's a good tweak, PnP be damned.  Consider this mod as a collection of 'house rules' specific to the proficiency systems in Baldur's Gate campaigns. Every choice has been made with an eye to the particular gameplay mechanics of BG2 and the EEs.</p>
  <p><strong><u>Everything is completely optional.  You can use as many or as few of the mod components as you want.  There is no 'core' component; use what you like, ignore what you don't.</u></strong> </p>
</div>
<h2>Contents</h2>
<div class="section">
  <h4 class="subheader">Component 10: </h4>
  <div class="section">
    <p><strong><em>Weapon Proficiency Overhaul (WPO): Overall Overhaul</em></strong></p>
      <p><b>INSTALL NOTE:</b> if you choose to install this component, it will also, of necessity, install component #50 (Weapon Category Combination).</p>
      <p>This component can be considered a convenience tweak; it will give most classes natably more proficiency points to spend. But it incentivizes spreading those points more widely instead of focusing on a single weapon (like the vanilla game), and your overall level of power at any given moment should roughly on par with an unmodded game. The aim is, with more points in more weapons, when you complete a quest and find a wonderful magical artifact, you can actually *use* it instead of just tossing it into your pack to sell later.</p>
      <p>Weapon use is slightly liberalized: all weapons are usable by clerics, but single-class clerics can only be proficient in traditional cleric weapons (the exception being kitted clerics' favored weapons.) Multiclass clerics primarily benefit from this: cleric/thieves can use thief weapons, and fighter/clerics can use any weapon.</p>
      <p>Clubs are truly universal, simple weapons: everyone can use them. Crossbows are usable by everyone except druids and Beastmasters.</p>
      <p>Warriors, rogues, and priests start with 5 proficiency points; wizards, sorcerers, and shamans start with 3. Warriors receive up the 3 more proficiencies, chosen by dialogue, if their INT score is 11 (+1), 12 (+2), or 13 (+3).  At 1st level, nonwarriors may only put one point in any weapon or style, so you must spread those proficiencies among many weapons. Warriors may specialize at 1st level. </p>
      <p>Warriors gain another proficiency point every 3 levels. Rogues gain a new point every 4 levels. Druids, clerics and shamans gain a new point every 5 levels. Wizards, sorcerers, and monks can never move past their initial proficiencies (<b>NOTE</b> - this means no more weapon advancement <b>at all</b> after dual-classing into a mage!).</p>
      <ul>
        <li> Trueclass fighters and Kensai can attain Mastery (+++) at 6th level, and High Mastery (++++) at 9th level, in any weapons they focus on.</li>
        <li> Other kitted fighters plus barbarians, paladins, rangers, and multiclass fighters can attain Mastery (+++) at 6th level.</li>
        <li> Rogues, clerics and druids, as well as mage/thieves, cleric/thieves and cleric/mages, can attain Specialization (++) after 6th level, with any weapons they can normally use.</li>
        <li> Multiclass fighter/mages can attain Mastery (+++) in any weapon but the only available styles are Single-Weapon and Two-Handed Weapon. </li>
        <li> Fighter/clerics and Fighter/thieves can attain Mastery (+++) in any weapon they can use.</li>
      </ul>
      <p>Beyond that, certain kits will be able to reach 1 point higher or lower in certain weapons (e.g. Archers can reach (++++) with missile weapons, and only (++) with melee weapons; Assassins can reach (+++) with daggers; etc.). </p>
      <div class="kit_description">
        <p>Proficiency benefits (cumulative totals)<br />
        &ndash; ** = +1 thac0; +1 damage; +0.5 APR<br />
        &ndash; *** = +3 thac0; +2 damage; +1 APR<br />
        &ndash; **** = +4 thac0; +4 damage; +1.5 APR<br />.</p>
      </div>
      <p>At 12th level, warriors will get a +1/2 APR bonus with all weapons. (This is in place of the unmodded game's 1/2 APR bonuses at 7th and 13th levels. Because you can get an extra APR bonus from proficiencies, the late-game total max APR for warriors will end up the same as in the unmodded game.)
      <p>(The APR bonuses will only benefit warriors, unless you also install the WPO part 5, "APR on Spec.")
    <p>This component makes serious changes and it has been rather hard to get various game mechanisms to work with it, especially dual-classing and NPCs. To catch them up, joinable NPCs will have several innate abilities that allow you to choose more proficiencies for them.</p>
    <p><b>Compatibility:</b> this component is generally not compatible with stuff like the weapon proficiency changes in Tweaks Anthology. Choose one proficiency system mod and stick with it.</p>
  </div>
  <h4 class="subheader">Component 30: </h4>
  <div class="section">
    <p><strong><em>Combat Skill System</em></strong></p>
      <p><b>INSTALL NOTE:</b> if you choose to install this component, it will also, of necessity, install component #50 (Weapon Category Combination).</p>
      <p>This component adds a lot of new abilities to the weapon proficiency system. Its chief aim is to expand the definition of "proficiency" into a broader set of "skills." It folds in a number of 3E-style feats borrowed from the Might & Guile mod, and uses a single currency - proficiency points - to manage both weapon skills and other feats.</p>
      <p>First off, to recap the combined weapon categories:
      <ul>
        <li> Long swords and bastard swords are combined.</li>
        <li> Clubs and Maces are combined.</li>
        <li> Spears and halberds are combined.</li>
        <li> Daggers and darts are combined.</li>
        <li> Long bows and short bows are combined.</li>
      </ul>
    <p>Second, this component introduces six new impovable combat skills that act similar to weapon styles:
      <ul>
        <li> The <b>Backstab</b> skill applies a 1-point bonus to a character's backstab damage multiplier. Most thieves can take four ranks in this proficiency; Assassins can take six; Shadowdancers and Stalkers can take two. (And this replaces thieves' automatic level-based bonuses to backstab multiplier.)</li>
        <li> The <b>Set Snares</b> skill grants a character the ability set one snare per day, for each rank taken. Bounty Hunters can set one normal snare and one special snare for each rank taken. (This replaces thieves' automatic level-based Set Snare ability.) <b>Note:</b> an attempt to set a snare may still fail without investing thief skill points into the Set Snares skill.</li>
        <li> The <b>Dodge</b> skill grants a 1-point bonus to armor class with each rank. Most character may take two ranks in this proficiency; Swashbucklers get one rank for free and can take up to five more. (And this replaces Swashbucklers' automatic level-based AC bonus.) <b>Note:</b> this armor class bonus is <b>not</b> cumulative with any bonuses from using a shield - it is only applied when equipping a one-handed weapon, a two-handed weapon, or two weapons.</li>
        <li> The <b>Melee Training</b> skill grants a 1-point bonus to attack rolls with all melee weapons, regardless of proficiency, for each rank taken. Most characters can take up to two ranks in this proficiency; Swashbucklers get one rank for free and can take five more. (And this replaces Swashbucklers' automatic level-based bonuses.)</li>
        <li> The <b>Ranged Accuracy</b> skill grants a 1-point bonus to attack and damage rolls with ranged weapons, for each rank taken. Most characters can take up to two ranks in this proficiency; Archers get one rank for free and can take five more. (And this replaces Archers' automatic level-based bonuses.)</li>
        <li>The <b>Thrown Weapons</b> skill makes a character more likely to successfully strike enemies with thrown weapons like daggers and axes. A baseline 3-point penalty to ranged attack rolls is applied to all such weapons; one rank in this proficiency reduces that to a -1 penalty, and a second rank results in a 1-point bonus. Halflings automatically begin the game with two ranks in this proficiency.</li>
      </ul>
    <p>Third, this component introduces four more groups of feats that characters can learn. Each of these is tied to a single proficiency; each point spent on that proficiency grants an innate spell which, when cast, allows the character to choose one feat via a dialogue. These groups of feats are:</p>
    <p><b>Combat Postures:</b> these abilities represent the style and approach a character uses in combat. These are exclusive to each other - a character can only use one posture at any given time. But characters can learn more than one posture, and switch between them as it is convenient. 
      <ul>
        <li> Leadership: when in this posture all nearby allies gain a 1-point bonus to attack rolls, armoor class, and casting speed.</li>
        <li> Grappling: when using this approach, in addition to attacking the character will attempt to grab and hold a nearby enemy. Each round a nearby enemy must save vs. breath weapon or have their movement restricted for 3 seconds and be slowed for 6 seconds. If this occurs, the grappling character will also have their movement restricted for 3 seconds.</li>
        <li> Precise Strike: when in this posture, a character focuses on delivering penetrating attacks, and is thereby 5% more likely to land a critical hit.</li>
        <li> Reckless Attack: in this posture, attacks can be made faster (1/2 extra attack per round), but all attacks incur a 3-point penalty to attack rolls.</li>
        <li> Fighting Dirty: this posture involves the use of dirty tricks to gain advantage over enemies. Once each round the nearest attacker must save vs. breath weapon or be briefly tripped, blinded or weakened.</li>
        <li> Parrying: this posture gives a 50% chance to block the physical damage (slashing, piercing, or crushing) of one successful attack. Only one attack can be parried in this way each round.</li>
        <li> Missile Snaring: in this posture a character can block one otherwise-successful missile attack each round. (Elemental damage attached to the attack will still affect the character, however.)</li>
        <li> Spell Evasion: when in this posture a character can make an extra save vs. breath weapon in order to evade the effects of certain targeted and wide-area spells, such as Magic Missile and Fireball.</li>
      </ul>
    <p><b>Physical Fitness:</b> These are ways a character can improve their physical capabilities.
      <ul>
        <li> Health Conditioning: this permanently grants the character 7 extra hit points.</li>
        <li> Toughness: this grants the character 10% resistance to slashing, piercing, and crushing damage.</li>
        <li> Resistance: this grants the character 10% resistance to fire, cold, and electric damage.</li>
        <li> Quickstride: this allows the character to move faster, or to toggle the ability off and move at the same speed as the rest of the party. (The exact bonus to movement speed can be controlled by a settings file in the "ini" subfolder.)</li>
        <li> Intestinal Fortitude: this allows the character an extra chance to save vs. death/poison to avoid the effects of any disease or poison to which they are exposed.</li>
        <li> Unflagging Determination: this allows the character an extra chance to save vs. petrification to avoid sleep, paralysis, fear, and stunning effects.</li>
        <li> Strength Training: this grants the character a permanent +1 bonus to Strength.</li>
        <li> Agility Training: this grants the character a permanent +1 bonus to Dexterity.</li>
      </ul>
    <p><b>Miscellaneous Feats:</b> these are an assortment of generally roguish abilities that may be helpful in a pinch. 
      <ul>
        <li> Lore: this increases the character's Lore stat by 25 points.</li>
        <li> Tracking: this allows the at-will use of the Tracking ability, which can identify the general types of enemies nearby, and which direction they are in.</li>
        <li> Flaming Weapon: this skill enables the character to coat a weapon with viscous oil and light it aflame, thereby doing extra fire damage with successful attacks. The flame lasts for 2 turns, and the character can craft enough of the oil to use the ability once per day.</li>
        <li> Grease Jar/Smoke Bomb: this allows a character to create improvised semi-explosive devices which can cover a small area with slippery grease, or with noxious smoke. These mimic the effects of the wizard spells Grease and Stinking Cloud, respectively. Each device can be created and used once pr day.</li>
        <li> Escape Artist: this ability is the result of a character learning to untie knots, dodge tangling briars and webs, and generally escape when bound. Whenever the character is physically or magically restrained, there is a 50% chance each round that this character will be able to free themselves.</li>
        <li> Slippery Mind: this allows the character an extra chance to save vs. spells to avoid charm, domination, confusion, feeblemind, and maze effects.</li>
        <li> Luck: this grants a permanent 1-point bonus to a character's Luck. This can make the character slightly more likely to succeed with thieving skills and weapon attacks, and to take a bit less damage from enemy spell attacks.</li>
        <li> Wild Talent: this ability instantly grants a character the use of a psionic power, which is chosen at random. (NOTE, this ability will only be present if the 'Will to Power' psionics mod is installed.)</li>
      </ul>
    <p><b>Magical Abilities:</b> smart rogues can sometimes learn the basic tenets of magic, without studying enough to become a proper mage. They can learn to Use Magical Devices, a.k.a. cast spells from wands and scrolls. Additionally, they can learn some select low-level magic spells, generally those associated with illusions and hiding. Each time a character learns a spell this way they gain one 'spell slot,' which can be used to cast any spell they know (similar to how sorcerers cast spells). Shadowdancers automatically know the Shadowstep spell, and get two extra spell slots. The spells that can be learned this way include:
      <ul>
        <li> Color Spray</li>
        <li> Reflected Image</li>
        <li> Blur</li>
        <li> Knock</li>
        <li> Luck</li>
        <li> Glitterdust</li>
        <li> Sanctuary</li>
        <li> Shadowstep</li>
      </ul>
    <p>In order to make use of all these abilities, most characters get more proficiency points to spend. Most of these are available to warriors and rogues; bards and priests can use a few, while mages and sorcerers cannot use any. The number of proficiency points available to character is increased over the base game:
      <div class="kit_description">
        <p>&ndash; Fighters/thieves: 8 at 1st level, plus 1 every two levels thereafter<br />
        &ndash; Rangers/Paladins: 6 at 1st level, plus 1 every two levels thereafter<br />
        &ndash; Priests/Bards/Monks: 5 at 1st level, plus 1 every three levels thereafter<br />
        &ndash; Mages/Sorcerers: 3 at 1st level, no more thereafter<br />.</p>
      </div>
    Additionally the maximum number of points that can be invested in any one proficiency is as follows:
    <div class="kit_description">
	<table style= "width: 40%">
	 <tr>
	  <th> class </th>
	  <th> level 1 </th>
	  <th> level 2 </th>
	  <th> level 5 </th>
	  <th> level 9 </th>
	 </tr>
	 <tr>
	  <td><b>Warriors:</b></td>
	  <td>1</td>
	  <td>2</td>
	  <td>3</td>
	  <td>4</td>
	 </tr>
	 <tr>
	  <td><b>Thieves:</b></td>
	  <td>1</td>
	  <td>2</td>
	  <td>3</td>
	  <td>4</td>
	 </tr>
	 <tr>
	  <td><b>Bards:</b></td>
	  <td>1</td>
	  <td>1</td>
	  <td>2</td>
	  <td>3</td>
	 </tr>
	 <tr>
	  <td><b>Priests:</b></td>
	  <td>1</td>
	  <td>1</td>
	  <td>2</td>
	  <td>3</td>
	 </tr>
	 <tr>
	  <td><b>Mages:</b></td>
	  <td>1</td>
	  <td>1</td>
	  <td>1</td>
	  <td>1</td>
	 </tr>
	</table>
    </div>
    <p><b>Compatibility:</b> this component is probably not compatible with most other proficiency system changes. However, it <b>IS</b> compatible with the <i>first subcomponent</i> of the "Revised Proficiencies" options in Tweaks Anthology - the one that basically just merges maces and morning stars. If you install that first, then clubs maces & morning stars will all share a proficiency.</p>
  </div>
  <h4 class="subheader">Component 50: </h4>
  <div class="section">
    <p><strong><em>Weapon Category Grouping</em></strong></p>
      <p><b>INSTALL NOTE:</b> if you choose to install component #122, the Weapon Proficiency Overhaul, then this component will also be installed automatically. </p>
      <p>This component groups certain proficiencies together:</p>
      <ul>
        <li> Longswords and bastard swords are combined into a single longswords proficiency.</li>
        <li> Clubs and Maces are combined into a "club/mace" proficiency.</li>
        <li> Spears and halberds are combined into a "spear/polearm" proficiency.</li>
        <li> Daggers and darts are combined into a "dagger/dart" proficiency.</li>
        <li> Long bows and short bows are combined into a "bows" proficiency.</li>
      </ul>
    <p><b>Compatibility:</b> this component is probably not compatible with most other proficiency system changes, such as CDTweaks BG1 and IWD profiencies, or the Skills & Abilities system. However, it <b>IS</b> compatible with the <i>first subcomponent</i> of the "Revised Proficiencies" options in Tweaks Anthology - the one that basically just merges maces and morning stars. If you install that first, then clubs, maces, & morning stars will all share a proficiency. This component <b>IS</b> compatible with Item Revisions.</p>
  </div>
  <h4 class="subheader">Component 70: </h4>
  <div class="section">
    <p><strong><em>Fighting Styles Overhaul</em></strong></p>
      <p>This component rebalances fighting styles in order to make them each more distinct and useful (instead of everything playing 2nd-fiddle to dual-wielding).  The benefits of each style are listed below:</p>
      <div class="kit_description">
        <p>Single-Weapon Style:<br />
        &ndash; (+) = +1 thac0, -2 to weapon speed, +2 to saves vs. Breath Weapon<br />
        &ndash; (++) = one extra attack every two rounds<br /></p>
        <p>Shield-Fighting Style:<br />
        &ndash; (+) = -1 melee AC bonus, -2 missile AC bonus<br />
        &ndash; (++) = perform a shield bash once per round (1d3 damage per 5 levels and knockback on failed save vs. Breath)<br /></p>
        <p>Two-Handed Weapon Style:<br />
        &ndash; (+) = +1 thac0, +2 damage, +5% crit chance<br />
        &ndash; (++) = additional +1 thac0, +2 damage, and +5% crit chance<br /></p>
        <p>Two-Weapon Style:<br />
        &ndash; ( ) = No off-hand attacks, no bonuses for dual-wielding<br />
        &ndash; (+) = 0 to 2 point melee AC bonus; off-hand attack with 6-point thac0 penalty compared to main hand<br />
        &ndash; (++) = off-hand attack with same thac0 penalty as main hand (see below)<br />.</p>
      </div> 
      <p>When dual-wielding, your main-hand thac0 will depend on the size and weight of the weapons you have equipped, as described below.</p>
      <div class="kit_description">
      	<p><b>&ndash; wielding two daggers:</b> 1-point thac0 penalty, 2-point melee AC bonus.<br />
      	<b>&ndash; dagger + anything:</b> 2-point thac0 penalty, 2-point AC bonus.<br />
      	<b>&ndash; medium + medium:</b> 2-point thac0 penalty, 1-point AC bonus.<br />
      	<b>&ndash; large + medium:</b> 3-point thac0 penalty, no AC bonus.<br />
      	<b>&ndash; large + large:</b> 4-point thac0 penalty, no AC bonus.<br />.</p>
      </div> 
      <p><b>Medium weapons are:</b> short sword, ninjato, wakizashi, club, war hammmer, mace, morning star.<br />
      <b>Large weapons are:</b> long sword, scimitar, bastard sword, katana, flail, battle axe.</p>
      <p><b>Note:</b> bastard swords and katanas are unusually large; they cannot be equipped in the off-hand position.</p>
      <p><b>Also note:</b> your thac0 and/or AC may briefly be incorrect when you equip two weapons and begin dual-wielding them. If your thac0 seems wrong, the first thing you should try it simply waiting a couple seconds with the game clock running. They should quickly resolve to the proper numbers.</p>
      <p><b>Shield bash:</b> in addition to the knockdown effect, it stuns opponents for 1 second starting at level 5; and the saving throw is at a -1 penalty for each 5 levels, up to level 20.</p>
      <p><b>Thrown daggers and darts:</b> will have their base APR reduced from 2 to 1.5, and from 3 to 2.5, respectively.  So you will need to be specialized in Fencing/SWS to get the full benefit of those items.</p>
      <p><b>OPTION:</b> by editing Scales_of_Balance/ini/styles.ini, you can set Two-Handed Weapon Style to match Single Weapon Style (it is a single weapon, after all) in granting extra APR for specialization, instead of extra damage and crit chance.</p>
      <p><b>Compatibility:</b> this component covers the same ground as the "Dual-Wielding Changes for Light and Heavy Weapons" component of Item Revisions. You can probably use both together, but the effects will be compounded and will likely be somewhat extreme. Best to choose one or the other. If the Item Revisions "Revised Shields" is installed and applies thac0 penalties to medium and large shields, then being proficient in shield-fighting will offset one point of those penalties.</p>
  </div>
  <h4 class="subheader">Component 90: </h4>
  <div class="section">
    <p><strong><em>WPO: APR on Spec</em></strong></p>
      <p>This component enables any class to gain APR benefits from weapon specialization - not just warriors.</p>
      <p>(NB if you install component 122 without this one, only warriors will get the benefit of the APR bonus for basic proficiency.)</p>
    <p><b>Compatibility:</b> this component is not compatible with the APR on Spec component of Tweaks Anthology (which I wrote, and is based on this one). The other version is specifically designed for the vanilla proficiency system; this one is specifically designed for the WPO proficiency system. If you installed the "WPO" component #10 of this mod, then use this version of APR on Spec.</p>
  </div>
</div>
<h2>Contact Information</h2>
<div class="section">
  <p>This mod was created by SubtleDoctor. You can visit <a href="http://forums.gibberlings3.net/index.php">The
    Gibberlings Three</a> for information on this and many other fine mods.</p>
</div>
<h2>Thanks and Acknowledgements</h2>
<div class="section">
  <p>Huge thanks in particular to Smeagolheart, Crevsdaak, kjeron, Camdawg, Mike1072, kreso, Grammarsalad, Aquadrizzt, and The Imp for advice and help with the code. And to everyone participating in the Dev thread at forum.baldursgate.com, for helping to sort through my good and bad ideas and helping me get the best ones implemented. </p>
  <p>Special thanks to Galactygon, Demivrgvs, DreamSlaveOne, and Pecca for directly contributing mod resources </p>
  <p>Big thanks to Etamin for providing a Polish translation. </p>
  <p>Thanks to the still active and vibrant Infinity Engine modding community. </p>
  <p><strong>Tools Used in Creation</strong><br />
    <a href="http://www.weidu.org/"><acronym title="Weimer Dialogue Utility">WeiDU</acronym></a> by
    Wes Weimer, and then the bigg and then Wisp<br />
    <a href="http://www.idi.ntnu.no/~joh/ni/">Near Infinity</a> by Jon Olav Hauglid, and then Argent77 and Astrobryguy<br />
    <a href="http://iesdp.gibberlings3.net/"><acronym title="Infinity Engine Structures Description Project">IESDP</acronym></a> maintained by igi</p>
</div>
<h2>Credits and Copyright Information</h2>
<div class="section">
  <p>Copyright 2023. If you want to use or adapt any part of this mod in another mod or similar endeavor, please try to contact me at forums.gibberlings3.net or forum.baldursgate.com to discuss it. As a general rule, I have no problem with that as long as you credit the source of the work. If you cannot get in touch with me, assume that you have my permission to use any of this code for any project that is non-commercial, offered for free, and intended for the greater enjoyment of players of Infinity Engine games. You may NOT use this code for any profit-making or commercial venture, without express permission from me.</p>
</div>
</body>
</html>
