<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>SubtleMods: SubtleD's Item Tweaks</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" href="style/g3readme_cam.css" type="text/css" />
<link href="style/g3icon.ico" rel="icon" type="image/bmp" />
</head>
<body>
<h1>SubtleMods: SubtleD's Item Tweaks</h1>
<div class="section">
  <p><strong> Version 1.3 </strong><br />
  <strong> Languages:</strong> English</p>
  <p><strong>Author: <a href="http://forums.gibberlings3.net/index.php?showuser=6306">The Subtle Doctor</a></strong></p>
  <p><strong><a href="https://github.com/subtledoctor/SubtleD_Item_Tweaks/releases">Home page</a></strong></p>
  <p><strong><a href="https://www.gibberlings3.net/forums/topic/37239-subtlemods-subtleds-item-tweaks/#comment-328377">Discussion Forum</a></strong></p>
  <p><strong><a href="https://github.com/subtledoctor/SubtleD_Item_Tweaks/releases">Download</a></strong></p>
</div>
<h2>Overview</h2>
<div class="section">
  <p>Various Item Tweaks</p>
  <p><strong><u>Everything is completely optional.  You can use as many or as few of the mod components as you want.  There is no 'core' component; use what you like, ignore what you don't.</u></strong> </p>
</div>
<h2>Contents</h2>
<div class="section">
  <h4 class="subheader">Component 100: </h4>
  <div class="section">
    <p><strong><em>YARAS - Yet Another Revised Armor System</em></strong></p>
    <p>This component changes armor to give the wearer a mix of Armor Class and Damage Resistance bonuses. The values are listed below:</p>
      <pre>
 Armor:
    leather:	  AC 8 	-1 Dex 	8% DR 	+2 casting time  +0 weapon speed  0% miscast chance  0 movement penalty
    studded:	  AC 7 	-2 Dex 	12% DR 	+2 casting time  +0 weapon speed  0% miscast chance  0 movement penalty
    hide armor:   AC 6 	-3 Dex 	24% DR	+3 casting time  +0 weapon speed  0% miscast chance  0 movement penalty
    chain mail:   AC 5 	-3 Dex 	24% DR	+3 casting time  +1 weapon speed  0% miscast chance  0 movement penalty
    splint mail:  AC 5 	-4 Dex 	30% DR	+4 casting time  +2 weapon speed  0% miscast chance  0 movement penalty
    plate mail:   AC 4 	-5 Dex 	36% DR	+5 casting time  +2 weapon speed  0% miscast chance  0 movement penalty
    full plate:   AC 3 	-4 Dex	42% DR	+5 casting time  +2 weapon speed  0% miscast chance  0 movement penalty<br />
 Enchantment:
    +1:	 	-1 AC	+1 Dex	+1% DR
    +2: 	-2 AC 	   " 	+2% DR
    +3:		-3 AC 	   " 	+3% DR
    +4:		-4 AC 	   " 	+4% DR
    +5:		-5 AC 	   " 	+5% DR
    +6:		-6 AC 	   " 	+6% DR<br />
  * "Caster" armors: no casting speed penalty
  * Elven armors: dex/casting speed equal to leather
  * Scale armors: like plate mail for AC, like chain for DR and penalties
      </pre>
    <p>This component allows casting arcane spells in armor, but with steep casting time penalties. (As of now, these penalties do not affect divine casters.) It also makes changes to Dexterity bonuses: bonuses to AC and thieving skills are increased so that the penalty for wearing armor is more meaningful without being crippling, and the option to go without armor is a bit more reasonable.</p>
    <p>This also makes changes to Dexterity bonuses: bonuses to AC and thieving skills are increased so that the penalty for wearing armor is more meaningful without being crippling, and the option to go without armor is a bit more reasonable.</p>
    <p>Finally, this alters the Armor of Faith spell to only give a flat 10% DR bonus, at all levels; and reduces the DR bonus from Hardiness and Defensive Stance form 40% to 20%; and reduces the price of the Defender of Easthaven while reducing its DR bonus from 20% to 5%.</p>
    <p><b>NOTE:</b> you can change these values by editing them in /Scales_of_Balance/ini/YARAS_default.ini. There is another version of these settings, which only applies thief skill penalties a chance of miscast magic... this is meant to mimic the "Allow Thieving in Heavy Armor" and "Allow Spellcasting in Armor" components of Tweaks Anthology, but is compatible with mods like Might & Guile and the 5E spellcasting conversion. To use those settings or your own personal preferences, copy /Scales_of_Balance/ini/YARAS_CD.ini or your modified version of /Scales_of_Balance/ini/YARAS_default.ini into your override folder and rename it to "d5_yaras.ini." If that file is in your override folder at the time of installation, the mod will use those settings instead of the default settings. If you like, you can keep a copy of "d5_yaras.ini" with your own preferred settings and simply drop it into your override folder before each time you install mods.</p>
    <p><b>Compatibility:</b> this component covers the same ground as the IR component "Revised Armors" as well as the "Spellcasting in Armor" component.  Ditto for the Full Plate and Packing Steel mod, and some armor/casting-related components of Tweaks Anthology and Klatu Tweaks. Don't install these things together; choose one armor system mod and stick with it.</p>
  </div>
  <h4 class="subheader">Component 110: </h4>
  <div class="section">
    <p><strong><em>Aesthetic & Enchantment Tweaks</em></strong></p>
    <p>This component removes "+1," "+2," etc. from item names, and standardizes the enchantment levels of weapons for purposes of which enemies they can hit:</p>
    <ul>
      <li> Generic +1 weapons become "Mastercraft" weapons, forged with unusual materials and skill that enable them to strike enemies who are immune to normal weapons.</li>
      <li> Generic +2 and +3 weapons become "Enchanted" weapons, with the enchantment level and stats of +2 weapons.</li>
      <li> All named weapons that were formerly from +1 to +4, become +3 weapons for purposes of what they can hit - though their bonuses and magical abilities remain unchanged.</li>
      <li> All upgraded weapons and originally +5/+6 weapons become +5 for purposes of what they can hit.</li>
    </ul>
    <p>There is an optional "hardcore" version of this component, borrowed from the "Low Magic World" mod.  In this version all generic enchanted weapons, instead of being standardized as +2, are turned into "mastercraft" weapons (i.e. equivalent to +1).</p>
    <p>(This component does not work on IWDEE - too many items are defined and recognized by the "plus" in their names and descriptions.</p>
    <p><b>Compatibility:</b> this component covers the same ground as the SCS component "Make +1 Weapons Into Fine Weapons." This component also has other effects, of course. You should not install that component of SCS if you want to use this component.</p>
  </div>
  <h4 class="subheader">Component 120: </h4>
  <div class="section">
    <p><strong><em>Functional Weapon Tweaks</em></strong></p>
    <p>This component makes tweaks to the base characteristics of various items:</p>
    <ul>
      <li> Spears do 1d10 damage, since in BG games they are of the 2-handed variety (this is Pen-and-Paper rule).</li>
      <li> Quarterstaves get an inherent -1 AC bonus.</li>
      <li> Daggers do 1d5 base damage instead of 1d4. (This includes throwing daggers.)</li>
      <li> Light crossbows can be used 1-handed, with shields. Heavy crossbows have an overall +3 damage bonus to compensate.</li>
      <li> Bolts do 1d6 base damage (and thus, from heavy crossbows they do 1d6+3).</li>
      <li> Bows have their base APR reduced to 3/2; Longbows and composite bows do an extra +2 damage.</li>
      <li> Arrows do 1d5 damage (and thus, 1d5+2 from longbows).</li>
      <li> Sling bullets do blunt damage instead of missile damage.</li>
      <li> Darts have 2 APR instead of 3.</li>
      <li> In the EE games, strength damage bonuses are removed from thrown daggers, darts, and slings.</li>
      <li> Archers (and any kits with the Archer usability flag) can now use Elven Chain armor.</li>
    </ul>
    <p><b>Compatibility:</b> this component covers some of the same ground as the "Weapon Changes" component of Item Revisions. I, for one, use both together. But be aware that this might compound or override some of the IR component's effects.</p>
  </div>
  <h4 class="subheader">Component 140: </h4>
  <div class="section">
    <p><strong><em>IWDEE-specific Item Tweaks</em></strong></p>
    <p>This component patches IWDEE items in several different ways:</p>
    <ul>
      <li> Weapons for sale by Conlan have their prices normalized a bit.</li>
      <li> The Black Knight and White Bishop figurines are usable once per day instead of once ever.</li>
      <li> Melee weapons "of Action" are changed a bit: instead of giving bonus APR, they *set* base APR higher.</li>
      <li> Weapons "of Action" +2 that previously only gave +1 DEX now give an extra 1/2 APR as well.</li>
    </ul>
  </div>
  <h4 class="subheader">Component 160: </h4>
  <div class="section">
    <p><strong><em>Universal Potions</em></strong></p>
    <p>This component removes the usability restrictions from potions, since I don't understand how one's choice of profession can affect the ability to drink certain liquids.</p>
    <p>So now you can waste a potion of Giant Strength on your mage; and you can boost your barbarian's pickpocket skills with a Potion of Thievery. Go crazy.</p>
  </div>
  <h4 class="subheader">Component 170: </h4>
  <div class="section">
    <p><strong><em>Armored Spellcasting for Bards</em></strong></p>
    <p>This component allows bards to cast spells in leather armor.</p>
    <p>This will not be available (for now) if YARAS is installed, since that armor system uses another approach to spellcasting in armor.</p>
  </div>
  <h4 class="subheader">Component 1000: 2 APR for Spell-Created Weapons</h4>
  <div class="section">
    <p>What it says on the tin. This affects Shillelagh, Flame Sword, Spiritual Hammer, Decastave, Moonblade, Starmetal Cudgel, Phantom Blade, and Black Blade of Disaster. If you spend a spell slot to make a magical melee weapon, you should gain a combat <i>benefit</i> for doing so!</p>
  </div>
  <h4 class="subheader">Component 1010: Tweak the Ring of Danger Sense</h4>
  <div class="section">
    <p>Adds a 1-point AC bonus and immunity to backstabs.</p>
  </div>
  <h4 class="subheader">Component 1020: Tweak the Gloves of Missile Snaring (EE-only)</h4>
  <div class="section">
    <p>The gloves now allow you to escape the missile damage (but not elemental damage) from the first missile weapon attack that hits you each round. Big props to OlvynChuru for showing how to do this!</p>
  </div>
  <h4 class="subheader">Component 1030: Tweak Detonating Weapons</h4>
  <div class="section">
    <p>Weapons like the Club of Detonation that can create Fireballs on-hit will now trigger the IWD priest spell "Produce Fire" instead.</p>
  </div>
  <h4 class="subheader">Component 1040: Tweak Skin of the Forest Armor (EE-only)</h4>
  <div class="section">
    <p>This leather armor will now act like a permanent version of the modified Barskin spell described above, absorbing one physical attack each round.</p>
  </div>
  <h4 class="subheader">Component 1051: Make IR's Rod of Absorption Truly Instantaneous (EE-only)</h4>
  <div class="section">
    <p>The Rod of Absorption in Item Revisions only lasts a single round, and can be triggered instantaneously to intercept an incoming spell. This component changes the item to use target mode 7 so that it can truly be used instantaneously, regardless of the other spells or attacks the wielder has performed in the preceding round.</p>
  </div>
  <h4 class="subheader">Component 1052: Give IR's Rod of Absorption a longer duration (EE-only)</h4>
  <div class="section">
    <p>The Rod of Absorption in Item Revisions only lasts a single round, and can be triggered instantaneously to intercept an incoming spell. This component changes the item to provide protection for five rounds.</p>
  </div>
  <h4 class="subheader">Component 1055: Tweak the Badge of the Brave</h4>
  <div class="section">
    <p>This gives permanent Fear protection to the Badge of the Brave, in addition to its existing effects.</p>
  </div>
  <h4 class="subheader">Component 1060: Tweak the Cloak of the Gargoyle (IR-only)</h4>
  <div class="section">
    <p>The Cloak of the Gargoyle will provide five Stoneskins, instead of the original AC bonus. This will be the same as Item Revisions' Gargoyle Boots and Potions of Stone Form.</p>
  </div>
  <h4 class="subheader">Component 1070: Tweak the Dwarven Thrower</h4>
  <div class="section">
    <p>Allows the Dwarven Thrower hammer to be used by any race, not just dwarves.</p>
  </div>
  <h4 class="subheader">Component 1080: Tweak Bard Harps</h4>
  <div class="section">
    <p>Azlaer's Harp will now cast Aid in addition to Resist Fear; Methild's Harp will cast Remove Curse in addition to Remove Paralysis.</p>
  </div>
  <h4 class="subheader">Component 1090: Tweak Edwin's Amulet</h4>
  <div class="section">
    <p>There are options to limit the amulet to providing +1 bonus slot per level, to limit the bonus slots to 7th level spells, or both.</p>
  </div>
</div>
<h2>Contact Information</h2>
<div class="section">
  <p>This mod was created by SubtleDoctor. You can visit <a href="http://forums.gibberlings3.net/index.php">The
    Gibberlings Three</a> for information on this and many other fine mods.</p>
</div>
<h2>Thanks and Acknowledgements</h2>
<div class="section">
  <p>Huge thanks in particular to Smeagolheart, Crevsdaak, kjeron, Camdawg, Mike1072, kreso, Grammarsalad, Aquadrizzt, and The Imp for advice and help with the code. And to everyone participating in the Dev thread at forum.baldursgate.com, for helping to sort through my good and bad ideas and helping me get the best ones implemented. </p>
  <p>Special thanks to Galactygon, Demivrgvs, DreamSlaveOne, and Pecca for directly contributing mod resources </p>
  <p>Big thanks to Etamin for providing a Polish translation. </p>
  <p>Thanks to the still active and vibrant Infinity Engine modding community. </p>
  <p><strong>Tools Used in Creation</strong><br />
    <a href="http://www.weidu.org/"><acronym title="Weimer Dialogue Utility">WeiDU</acronym></a> by
    Wes Weimer, and then the bigg and then Wisp<br />
    <a href="http://www.idi.ntnu.no/~joh/ni/">Near Infinity</a> by Jon Olav Hauglid, and then Argent77 and Astrobryguy<br />
    <a href="http://iesdp.gibberlings3.net/"><acronym title="Infinity Engine Structures Description Project">IESDP</acronym></a> maintained by igi</p>
</div>
<h2>Credits and Copyright Information</h2>
<div class="section">
  <p>Copyright 2023. If you want to use or adapt any part of this mod in another mod or similar endeavor, please try to contact me at forums.gibberlings3.net or forum.baldursgate.com to discuss it. As a general rule, I have no problem with that as long as you credit the source of the work. If you cannot get in touch with me, assume that you have my permission to use any of this code for any project that is non-commercial, offered for free, and intended for the greater enjoyment of players of Infinity Engine games. You may NOT use this code for any profit-making or commercial venture, without express permission from me.</p>
</div>
</body>
</html>
