<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>Subtle Mods: SubtleD's Stat Overhauls (Scales of Balance)</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" href="style/g3readme_cam.css" type="text/css" />
<link href="style/g3icon.ico" rel="icon" type="image/bmp" />
</head>
<body>
<h1>Subtle Mods: SubtleD's Stat Overhauls (Stats of Balance)</h1>
<div class="section">
  <p><strong> Version 1.8 </strong><br />
  <strong> Languages:</strong> English</p>
  <p><strong>Author: <a href="http://forums.gibberlings3.net/index.php?showuser=6306">The Subtle Doctor</a></strong></p>
  <p><strong><a href="https://github.com/subtledoctor/SubtleD_Stat_Overhauls">Home page</a></strong></p>
  <p><strong><a href="http://">Discussion Forum</a></strong></p>
  <p><strong><a href="https://github.com/subtledoctor/SubtleD_Stat_Overhauls/releases">Download</a></strong></p>
  <p><strong> Version 1.0 </strong><br />
    <strong> Languages:</strong> English<br />
</div>
<h2>Overview</h2>
<div class="section">
  <p>This makes a number of tweaks to ability scores and related aspects of the game rules, such as saving throws, experience points, and magic resistance.</p>
  <p><strong><u>Everything is completely optional.  You can use as many or as few of the mod components as you want.  There is no 'core' component; use what you like, ignore what you don't.</u></strong> </p>
</div>
<h2>Contents</h2>
<div class="section">
  <h4 class="subheader">Component 100: </h4>
  <div class="section">
    <p><strong><em>Ability Score Overhaul</em></strong></p>
    <p>To make more meaningful differences between races, demihumans will have more stat bonuses and penalties.  The racial maximums are now:</p>
      <ul>
        <li> Elves: 19 Dex, 19 Int, 17 Str, 16 Con</li>
        <li> Half-elf: 19 Cha, 17 Wis</li>
        <li> Dwarf: 19 Con, 17 Dex, 17 Cha</li>
        <li> Halfling: 19 Dex, 19 Cha, 17 Int, 16 Str</li>
        <li> Gnome: 19 Int, 19 Con, 17 Str, 16 Wis</li>
        <li> Half-orc: 19 Str, 17 Int, 16 Cha</li>
      </ul>
    <p>This component shifts saving throw bonuses to the INT, WIS, and CHA stats. Therefore, and since Constitution is already one of the most important stats in the game, the "shorty save bonuses" for high CON are eradicated.  In their place, dwarves and halflings get a flat +3 bonus to saves vs. Death/Poison, and gnomes get a flat +2 bonus to saves vs. Spells.</p>
    <p>Finally, the major effect of this component: stat bonuses are modified so that every point added above 13 or so results in a tangible benefit; and scores below ~11 have some tangible penalties (down to 5, which is the new minimum).  <b>NOTE:</b> the changes for each stat can be selectively skipped by editing a variable in /Scales_of_Balance/ini/stats.ini.<br />
    <div class="kit_description">
<table style= "width: 40%">
 <tr>
  <th>STRENGTH</th>
  <th> thac0 </th>
  <th> Damage </th>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>-</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>-</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>+1</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>+1</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>+1</td>
  <td>+4</td>
 </tr>
 <tr>
  <td><b>18/51:</b></td>
  <td>+2</td>
  <td>+4</td>
 </tr> <tr>
  <td><b>19:</b></td>
  <td>+2</td>
  <td>+5</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>+2</td>
  <td>+6</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>+3</td>
  <td>+6</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>+3</td>
  <td>+7</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>+4</td>
  <td>+7</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>+4</td>
  <td>+8</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>+4</td>
  <td>+9</td>
 </tr>
</table>

<table style= "width: 50%">
 <tr>
  <th>DEXTERITY</th>
  <th>Armor Class</th>
  <th>Ranged thac0 </th>
  <th>Melee thac0 </th>
 </tr>
 <tr>
  <td><b>13:</b></td>
  <td>-1</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>-1</td>
  <td>+1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>-2</td>
  <td>+1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>-2</td>
  <td>+2</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>-3</td>
  <td>+2</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>-4</td>
  <td>+3</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>19:</b></td>
  <td>-5</td>
  <td>+3</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>-6</td>
  <td>+3</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>-6</td>
  <td>+4</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>-7</td>
  <td>+4</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>-7</td>
  <td>+4</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>-8</td>
  <td>+4</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>-8</td>
  <td>+5</td>
  <td>+3</td>
 </tr>
</table>
<i>Note: the 18/xx "exceptional" Strength doesn't work in BG like it does in PnP; ALL bonuses are supposed to go up that table in steps (including for non-warriors). BG makes it so that the 1-point jump from 18 to 19 is a bigger difference than the <strong>5-point</strong> jump from 13 to 18. I fix that by, essentially, collapsing the 18/xx values to all be about the same. Bonuses are pushed downward, so there is now almost the same difference between 14 and 15 as there is between 18 and 19.</i><br />
<table style= "width: 60%">
 <tr>
  <th>INTELLIGENCE</th>
  <th>Saves vs. Spells</th>
  <th>Extra Proficiencies* </th>
 </tr>
 <tr>
  <td><b>5:</b></td>
  <td>-4</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>6:</b></td>
  <td>-3</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>7:</b></td>
  <td>-2</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>8:</b></td>
  <td>-2</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>9:</b></td>
  <td>-1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>10:</b></td>
  <td>-1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>11-12:</b></td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>13:</b></td>
  <td>-</td>
  <td>+1, +1 per 9 levels</td>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>-</td>
  <td>+1, +1 per 9 levels</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>+1</td>
  <td>+1, +1 per 7 levels</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>+1</td>
  <td>+1, +1 per 7 levels</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>+2</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>+2</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>19:</b></td>
  <td>+3</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>+3</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>+4</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>+4</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>+5</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>+5</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>+6</td>
  <td>+1, +1 per 5 levels</td>
 </tr>
</table>
* <i>(Warriors only. <b>NOTE:</b> these extra proficiencies can be turned off by editing a variable in /SubtleD_Stat_Overhauls/ini/stats.ini.)</i><br />
<table style= "width: 50%">
 <tr>
  <th>WISDOM </th>
  <th>Saves vs. Death</th>
  <th>Saves vs. Polymorph</th>
 </tr>
 <tr>
  <td><b>5:</b></td>
  <td>-3</td>
  <td>-3</td>
 </tr>
 <tr>
  <td><b>6:</b></td>
  <td>-3</td>
  <td>-2</td>
 </tr>
 <tr>
  <td><b>7:</b></td>
  <td>-2</td>
  <td>-2</td>
 </tr>
 <tr>
  <td><b>8:</b></td>
  <td>-2</td>
  <td>-1</td>
 </tr>
 <tr>
  <td><b>9:</b></td>
  <td>-1</td>
  <td>-1</td>
 </tr>
 <tr>
  <td><b>10:</b></td>
  <td>-1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>11-14:</b></td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>13:</b></td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>-</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>+1</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>+1</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>+2</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>19:</b></td>
  <td>+2</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>+3</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>+3</td>
  <td>+4</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>+4</td>
  <td>+4</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>+4</td>
  <td>+5</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>+5</td>
  <td>+5</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>+5</td>
  <td>+6</td>
 </tr>
</table>

<table style= "width: 65%">
 <tr>
  <th>CHARISMA</th>
  <th>Saves vs. Breath</th>
  <th>Saves vs. Wands</th>
  <th>Luck Bonus </th>
  <th>XP Bonus </th>
 </tr>
 <tr>
  <td><b>5:</b></td>
  <td>-3</td>
  <td>-3</td>
  <td>-2</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>6:</b></td>
  <td>-2</td>
  <td>-2</td>
  <td>-1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>7:</b></td>
  <td>-2</td>
  <td>-1</td>
  <td>-1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>8:</b></td>
  <td>-2</td>
  <td>-1</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>9:</b></td>
  <td>-1</td>
  <td>-1</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>10:</b></td>
  <td>-1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>11-12:</b></td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>13:</b></td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>+2%</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>+4%</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>+6%</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>+8%</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+10%</td>
 </tr>
 <tr>
  <td><b>19:</b></td>
  <td>+3</td>
  <td>+2</td>
  <td>+1</td>
  <td>+12%</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>+3</td>
  <td>+3</td>
  <td>+1</td>
  <td>+14%</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>+4</td>
  <td>+3</td>
  <td>+1</td>
  <td>+16%</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>+4</td>
  <td>+4</td>
  <td>+1</td>
  <td>+17%</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>+4</td>
  <td>+4</td>
  <td>+2</td>
  <td>+18%</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>+5</td>
  <td>+4</td>
  <td>+2</td>
  <td>+19%</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>+5</td>
  <td>+5</td>
  <td>+2</td>
  <td>+20%</td>
 </tr>
</table>
* <i>(<b>NOTE:</b> the XP bonuses are off by default, to maximize compatibility with other mods that may use the XP boost opcode. To turn this on, you can edit the variable in /SubtleD_Stat_Overhauls/ini/stats.ini.)</i><br />
    </div>
  </div>
  <h4 class="subheader">Component 110 (for EE 2.0+): </h4>
  <div class="section">
    <p><strong><em>Ability Score-Based Bonus Spells</em></strong></p>
      <p>This component gives you bonus spell memorization slots for having high stats. Clerics and druids already get this in the unmodded game; now similar bonuses are applied to mages (based on INT), bards (based on CHA*), and sorcerers and shamans (based on CHA). (* Note, if you have installed Might & Guile's 'Revised Bards,' those multiclass bards will use INT as their casting stat.) If you have installed the option for priests to cast spells spontaneously from Faiths & Powers, that mechanism will be affecte by these bonuses as well.</p>
      <p>Additionally, these bonuses have been made more uniform - including the unmodded cleric and druid bonuses:</p>
<table style= "width: 50%">
 <tr>
  <th>STAT </th>
  <th>1st level</th>
  <th>2nd level</th>
  <th>3rd level</th>
  <th>4th level</th>
  <th>5th level</th>
  <th>6th level</th>
  <th>7th level</th>
 </tr>
 <tr>
  <td><b>13:</b></td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>19:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
 </tr>
</table>
  <p>NOTE: sorcerers only get bonuses to spells up to 5th level. In addition, they get up to four +1 bonuses to their caster level.</p>
<table style= "width: 50%">
 <tr>
  <th>STAT </th>
  <th>1st level</th>
  <th>2nd level</th>
  <th>3rd level</th>
  <th>4th level</th>
  <th>5th level</th>
  <th>Caster level</th>
 </tr>
 <tr>
  <td><b>13:</b></td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>14:</b></td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>15:</b></td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
 </tr>
 <tr>
  <td><b>16:</b></td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>-</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>17:</b></td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>18:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>+1</td>
 </tr>
 <tr>
  <td><b>19:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>-</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>20:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>-</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>21:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>+2</td>
 </tr>
 <tr>
  <td><b>22:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>-</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>23:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+1</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>24:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+3</td>
 </tr>
 <tr>
  <td><b>25:</b></td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+2</td>
  <td>+1</td>
  <td>+4</td>
 </tr>
</table>
  </div>
  <h4 class="subheader">Component 120: </h4>
  <div class="section">
    <p><strong><em>Ability Score Bonus Spells for 5E-Style Casting</em></strong></p>
      <p>These components are only available if component 201 is installed. They represent options for how the ability score-based bonus spells should operate if the '5E Spellcasting' mod is installed, or a mod that uses it such as Tome & Blood's Arcanist or Might & Guile's Revised bards. With only component 201, those spellcasters will get bonus memorization slots, but no bonus casting slots. These components allow you to change that: 
    <ul>
      <li><b>Component 2012:</b> ability score bonuses increase <i>both</i> memorization slots and casting slots. <br />
      <li><b>Component 2013:</b> ability score bonuses increase casting slots but do <i>not</i> increase memorization slots. </p>
    </ul>
    <p>NOTE: if you combine component 2012 this with the component in the 5E casting mod that grants bonus casting slots for the Ring of Wizardry and similar magical items, you will end up with a <b>LOT</b> of both memorization and casting slots. I'm surprised to hear myself say this, but it is too many. With such bonuses a 5E mage can easily overpower a sorcerer, which is not supposed to happen. In particular, large numbers of <i>memorization</i> slots can unbalance things; 5E casters can change out their prepared spells every day, so limits on ho many spells they can have prepared is a key balancing mechanism. My suggestion for finding a happy medium is to skip the 5E items component, thereby setting magic items to only increase memorization slots; and to install component 2013 here, thereby setting stat bonuses to only increase casting slots. (Or, if you really want a lot of casting slots, install the 5E items component with component 2013 - that will give you lots of casting slots but retain some limits on memorization slots.)</p>
  </div>
  <h4 class="subheader">Component 130: </h4>
  <div class="section">
    <p><strong><em>SBO: Full Strength from 2-Hand Weapons Only</em></strong></p>
      <p>This small component simply adds a -1 STR penalty to every 1-handed weapon.  The idea behind it is, your "STR" score measures your total bodily strength. If you attempt a feat of strength one-handed, naturally the result will not be as effective as if you used both arms. </p>
      <p>Note: this penalty stacks, so you will have a -2 penalty when dual-wielding. That weapon style is all about speed - not power! </p>
  </div>
  <h4 class="subheader">Component 140: </h4>
  <div class="section">
    <p><strong><em>SBO: Plinkification</em></strong></p>
      <p>This small component, currently in beta (!), was inspired by seeing that my party members tend to do much more damage in melee than even similarly-equipped and similarly-leveled opponents. My team members just stacked more outright damage bonuses in ways that enemies cannot match. So this component broadly reduces damage output from all weapon attacks - in ways that will likely affect the player more than the AI.</p>
      <p>First, it adopts a 5E-inspired "bounded accuracy" approach to attacks... which basically means it slows down thac0 progression for all classes. Then, it shifts some of the melee damage bonuses available to the player to instead give greater thac0 bonuses. STR-based damage bonuses are roughly cut in half, to a max of +7 at 25 STR. Likewise, the bonuses from weapon specialization and mastery are again shifted away from damage (bonuses cut to about 2/3) and toward accuracy (greater thac0 bonuses). Finally, all enchanted weapons will have their basic enchantment bonuses <b>only</b> affect thac0 - they will have no damage bonus at all. (Any extra elemental damage done by weapons is untouched, which means these weapons are relatively more powerful). The intended result of all this should be PCs doing similar damage to their opponents, and relying instead on tactics to win.</p>
      <p><b>NOTE:</b> this component is in need of serious playtesting to make sure the adjustments are fine-tuned just right.</p>
  </div>
  <h4 class="subheader">Component 150: </h4>
  <div class="section">
    <p><strong><em>Hit Dice Overhaul (HDO): Revised Hit Point Progression</em></strong></p>
      <p>This component takes some of the randomness out of hit point rolls. In the vanilla system, a warrior with 16 CON can actually get *fewer* hit points at level-up than a mage with 8 CON. That only leads to annoying reloads or constant moving of the difficulty bar to get max hp (which is just too cheaty, and perverts various game mechanics). With this component, there are still rolls, but the roll will usually seem "fair" and should never cause you to feel you need to reload or go below Core difficulty. That 16 CON warrior will get between 9 and 12 hit points per level, instead of from 3 to 12. Higher average rolls, and more satisfying numbers, but not overpowered.<br />
      <ul>
      	<li>Wizard hit dice is now 1d3+1. Rogue and priest hit dice is 2d3+1. And warrior hit dice is 3d3+1 (3d4+1 for barbarians).</li>
      	<li>Everyone gets an extra hit point at 14 CON and 16 CON, and warriors get an extra hit point at 18 CON.  Everyone also gets an extra hit point at 20, 22, and 24 CON (so stat-boosting spells and effects can actually increase non-warriors' hit points).</li>
      	<li>The minimum roll for those d3 rolls is 2 at 15 CON, and 3 at 17 CON. (So 17 CON means max hit points.)</li>
      	<li>Everyone gets very slow hit point regeneration (1 hp per 2 turns) at 19 CON. The regeneration speeds up a bit at 20 CON (1 per turn), 21 CON (1 per 4 rounds), 22 CON (1 per 2 rounds), 23 CON (1 per round), 24 CON (2 per round), and 25 CON (1 per second).</li>
      </ul>
      <p>This slightly front-loads HD progression: you get about 2HD at first level, but HD only goes to 7th level (so you get 8HD total). From 8th level on::
      <ul>
      	<li>Warriors get 4/level from 8 to 15, then 3/level from 16 to 25, and 2/level after that. </li>
      	<li>Rogues and priests get 3/level from 8 to 15, 2/level from 16 to 25, and 1 per level after that. </li>
      	<li>Wizards get 2/level from 8 to 15, and 1/level after that. </li>
      </ul>
      <p>Additionally, there is an alternate hardcore version of this component, which eliminates 1 hp from each class (so wizards are 1d3, rogues/priests are 2d3, and warriors are 3d3). The regular component should give hit points somewhere between the vanilla game's mean and max values; the hardcore variant should result in hit points closer to vanilla's mean. </p>
      <p>Finally, there is a third version of the Hit Dice progression, labeled "Reduced." This is unrelated to the system described above; it is a simpler modification for players who want to retain the original game's mechanic and who tend to play with the "max hit point rolls" option, but who do not want monstrous amounts of hit points. This option reduces wizard hit dice to 1d3, rogues to 1d4, priests to 1d5, warriors to 1d6, and barbarians to 1d7. It also gives +1 hit point per level for every even point of CON starting at 12 for warriors, and at 14 for non-warriors. If you use the "max hit point rolls" game option, this should approximate higher-than-average rolls in the original system, but with zero variability. Like the other two components, it doubles the hit die at 1st level, but unlike them it allows hit dice rolls until 9th level. After that you only get 2-3 hp/level, slowly tapering to just 1 hp/level at level 25.</p>
  </div>
  <h4 class="subheader">Component 160: </h4>
  <div class="section">
    <p><strong><em>Saving Throw Overhaul (STO)</em></strong></p>
    <p>This component changes all spells such that the saving throws they offer target follow these guidelines:<br />
    <ul>
      <li>Direct magical and mental effects like Charms and Illusions offer saves vs. Spells. This includes spells like Blindness and Confusion.</li>
      <li>Area effects and physical that can be dodged offer saves vs. Breath Weapon. This includes spells like Fireball, Web, and Entangle.</li>
      <li>Necromantic effects and those that affect the subject's life and health offer saves vs. Poison/Death. This includes all Necromancy effects (including vampire Level Drain), fog spells like Cloudkill, and all poisons.</li>
      <li>Spells that affect the subject's physical form or movement offer saves vs. Petrification/Polymorph. This includes spells like Flesh to Stone and Polymorph Other, as well as Hold and Slow.</li>
      <li>Saving throws vs. Rod/Staff/Wands are basically unused.</li>
    </ul></p> 
    <p>Additionally, saving throw tables are made more sensible.  No earth-shaking changes, just sensible progression: wizards save well against spells, priests save well against death, rogues save well against breath, and warriors save well against almost everything.</p>
  </div>
  <h4 class="subheader">Component 180: </h4>
  <div class="section">
    <p><strong><em>Lower Dual-Class requirements (DCR)</em></strong></p>
    <p>This very quick and simple component sets all stat requirements to 15 to dual-class <i>from</i> a given class and <i>to</i> a given class - instead of some requirements being 15 and others being 17. This will make it much easier to dual-class, it makes things easier and is just a convenience tweak to the AD&D 2E ruleset.</p> 
  </div>
  <h4 class="subheader">Component 200: </h4>
  <div class="section">
    <p><strong><em>Experience Point Overhaul: Revised Tables</em></strong></p>
      <p>XP advancement and thac0/spell/skill advancement are two ends of the same rope; you only need to pull on one end to get the desired effect, but for some reason the 2e rules pull both. I've streamlined it to a fast path and a slow path. Fighters, thieves, bards, and clerics are on the faster table; paladins, rangers, druids and wizards are on the slower table. (No more thieves with more hp than fighters with the same XP!) Advancement is a bit faster than vanilla in the middle levels, and then gets progressively slower at epic levels. You'll be at or near level 20 with 3 million XP, like in vanilla; but won't hit level 30 until 8 million XP. HLAs will be rarer with this component, so choose wisely!</p>
      <p>The unmodded game sets HLAs to be available at certain levels based on when each class hits 3 million XP. Because these new XP tables change that, the mod will also change when you get HLAs for the sake of uniformity and convenience, all classes will get HLAas when you achieve "epic levels," i.e. level 21. <b>NOTE</b> this is true for multiclasses too! No more getting HLAs at 13th level or whatever, instead multiclasses wil get HLAs starting at level 20, when they have close to 6 million XP. Multiclassing will just have to be, like virtue, its own reward. :P </p>
      <p>This component also switches the druid spellcasting table to match the priest one (since the PnP druid XP and spell tables were only for Grand/Hierophant Druids who settle down in a grove and stop adventuring).</p>
  </div>
  <h4 class="subheader">Component 210: </h4>
  <div class="section">
    <p><strong><em>No Murder XP</em></strong></p>
      <p>This component very simply divides the XP reward for killing creatures by 2, 5, or 10.  The aim is to make quest XP derived from role-playing relatively more important, compared to combat experience. Quest XP is not changed at all; so this component will result in a substantial reduction in total XP available over the course of the game.</p>
      <p>Do not install this unless you are looking for more of a challenge!</p>
  </div>
  <h4 class="subheader">Components 221-224: </h4>
  <div class="section">
    <p><strong><em>Revised Starting XP in Siege of Dragonspear</em></strong></p>
    <p>This component gives you four choices for how much XP you will have if you begin a new campaign in Siege of Dragonspear: 
    <ul>
      <li>65,000</li>
      <li>90,000</li>
      <li>125,000</li>
      <li>161,000</li>
    </ul></p>
    <p>This works in the standalone SoD games, in SoD campaigns when the expansion has been purchased for BGEE, and in EET games.</p>
  </div>
  <h4 class="subheader">Components 231-234: </h4>
  <div class="section">
    <p><strong><em>Revised Starting XP in Shadows of Amn</em></strong></p>
    <p>This component gives you four choices for how much XP you will have if you begin a new campaign in BG2 Shadows of Amn: 
    <ul>
      <li>90,000</li>
      <li>161,000</li>
      <li>240,000</li>
      <li>400,000</li>
    </ul></p>
    <p>This works in BG2EE, as well as in EET games. I have not tested it in the pre-EE engine, but if the game includes STARTARE.2DA, then this should work on TOB and BGT games.</p>
  </div>
  <h4 class="subheader">Component 251: </h4>
  <div class="section">
    <p><strong><em>Magic Resistance Overhaul: Replace MR With Other Effects</em></strong></p>
    <p>WARNING: This component makes very severe changes to the way the game works, and should be considered as 'beta' quality. Its purpose is to largely (but not completely) remove the probability-based "magic resistance" mechanic from the game. It makes the following changes:</p>
    <ul>
      <li>All creatures in the game, such as drow, dragons, skeleton warriors, etc., will have their MR set to zero. Instead, they will receive +3 bonuses to saving throws vs. Breath, Petrification, and Wands, and a +6 bonus to saving throws vs. Spells. (No bonus to saves vs. Death - this should make necromancy magic a little stronger and more special.)</li>
      <li>Monks and Wizard Slayers will not get MR; instead, they will get a +1 bonus to all saving throws at level 1, and at every 4th level thereafter (5th, 9th, 13th, etc. up to 25th).</li>
      <li>Almost all items in the game that grant MR have been changed. Some, like the Amulet of Magic Resistance, have their MR converted into resistance to all elemental and magic damage. Others, like Carsomyr, instead get large bonuses to saving throws. Some are very different, like the Sword of Balduran which now grants a movement rate bonus.</li>
      <li>It is still possible to get *some* MR, from the Hell Trials and the Machine of Lum the Mad. That's okay, 15% MR isn't game-breaking... it only gets stupid when it is stacked to high levels.</li>
      <li>Likewise, the "Magic Resistance" spell is left untouched. It can be used as another form of magic protection along with the likes of Spell Deflections and Globes of Invulnerability. Lower Resistance, Pierce Magic, and Pierce Shield are still effective against this spell, and SCS enemies will use them against you.</li>
    </ul></p>
    <p><b>Compatibility:</b> this should be installed after all mods that add creatures and items that may be subject to magic resistance. Notably, if you want this to affect fiends (removing their MR), then this component should be installed after Spell Revisions, SCS, and aTweaks.</p>
  </div>
  <h4 class="subheader">Component 232: </h4>
  <div class="section">
    <p><strong><em>Magic Resistance Overhaul: Reduce MR</em></strong></p>
    <p>This is a less severe version of the prior component. It reduces the MR of creatures and equipped items, and prevents MR from stacking.</p>
    <ul>
      <li>All creatures in the game, such as drow, dragons, skeleton warriors, etc., will have their MR set to 1/2 of its normal value.</li>
      <li>Monks and Wizard Slayers get their normal MR progression.</li>
      <li>Many items in the game that grant MR an an equipping effect have the effect reduced: 50%-->30%, 40%-->25%, 30%-->20%, and 25%-->15%. Any items that grant a different amount of MR are unchanged.</li>
      <li>All items that grant MR as an equipping effect now apply it by <b>setting</b> the MR value, instead of increasing it. So wearing two MR items will no longer result in a cumulative benefit.</li>
      <li>Again, the "Magic Resistance" spell is left untouched. It can be used as another form of magic protection along with the likes of Spell Deflections and Globes of Invulnerability. Lower Resistance, Pierce Magic, and Pierce Shield are still effective against this spell, and SCS enemies will use them against you.</li>
    </ul></p>
    <p><b>Compatibility:</b> this should be installed after all mods that add creatures and items that may be subject to magic resistance. Notably, if you want this to affect fiends (removing their MR), then this component should be installed after Spell Revisions, SCS, and aTweaks.</p>
  </div>
</div>
<h2>Contact Information</h2>
<div class="section">
  <p>This mod was created by SubtleDoctor. You can visit <a href="http://forums.gibberlings3.net/index.php">The
    Gibberlings Three</a> for information on this and many other fine mods.</p>
</div>
<h2>Thanks and Acknowledgements</h2>
<div class="section">
  <p>Huge thanks in particular to Smeagolheart, Crevsdaak, kjeron, Camdawg, Mike1072, kreso, Grammarsalad, Aquadrizzt, and The Imp for advice and help with the code. And to everyone participating in the Dev thread at forum.baldursgate.com, for helping to sort through my good and bad ideas and helping me get the best ones implemented. </p>
  <p>Special thanks to Galactygon, Demivrgvs, DreamSlaveOne, and Pecca for directly contributing mod resources </p>
  <p>Big thanks to Etamin for providing a Polish translation. </p>
  <p>Thanks to the still active and vibrant Infinity Engine modding community. </p>
  <p><strong>Tools Used in Creation</strong><br />
    <a href="http://www.weidu.org/"><acronym title="Weimer Dialogue Utility">WeiDU</acronym></a> by
    Wes Weimer, and then the bigg and then Wisp<br />
    <a href="http://www.idi.ntnu.no/~joh/ni/">Near Infinity</a> by Jon Olav Hauglid, and then Argent77 and Astrobryguy<br />
    <a href="http://iesdp.gibberlings3.net/"><acronym title="Infinity Engine Structures Description Project">IESDP</acronym></a> maintained by igi</p>
</div>
<h2>Credits and Copyright Information</h2>
<div class="section">
  <p>Copyright 2014-2017. If you want to use or adapt any part of this mod in another mod or similar endeavor, please try to contact me at forums.gibberlings3.net or forum.baldursgate.com to discuss it. As a general rule, I have no problem with that as long as you credit the source of the work. If you cannot get in touch with me, assume that you have my permission to use any of this code for any project that is non-commercial, offered for free, and intended for the greater enjoyment of players of Infinity Engine games. You may NOT use this code for any profit-making or commercial venture, without express permission from me.</p>
</div>
</body>
</html>
