<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<title>SubtleMods: Magic Battles Revised</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link rel="stylesheet" href="style/g3readme_cam.css" type="text/css" />
<link href="style/g3icon.ico" rel="icon" type="image/bmp" />
</head>
<body>
<h1>SubtleMods: Magic Battles Revised</h1>
<div class="section">
  <p><strong> Version 1.9 </strong><br />
  <strong> Languages:</strong> English</p>
  <p><strong>Author: <a href="http://forums.gibberlings3.net/index.php?showuser=6306">The Subtle Doctor</a></strong></p>
  <p><strong><a href="https://github.com/UnearthedArcana/magic_battles_revised">Home page</a></strong></p>
  <p><strong><a href="https://www.gibberlings3.net/forums/topic/33351-subtlemods-magic-battles-revised-streamlined-rules-for-mage-duels/">Discussion Forum</a></strong></p>
  <p><strong><a href="https://github.com/UnearthedArcana/magic_battles_revised/releases">Download</a></strong></p>
</div>
<h2>Overview</h2>
<div class="section">
  <p>This mod intends to address the mish-mash of rules and tactics that are involved when your party, which presumably includes magic users, faces enemy magic users in battle. Some people, especially those who install SCS, find these battles to be overly long and complicated. (A common piece of advice on various message boards is "wait until the enemy mage's defenses wear off, then beat them with a club.") On the other side, especially among people who play with no spell system mods, some players find magic defenses maddeningly easy to circumvent. ("Ignore spell defenses entirely, just Breach the wizard and then beat them with a club.") Some find the limitations of various spells to be inane - why can 5th-level Minor Spell Turning not block a Feeblemind, when a 3rd-level Minor Spell Deflection can?</p>
  <p>This mod tries to make spell defenses something useful, something worth engaging with. It wants to preserve the idea that magic users can be very powerful, even temporarily invincible, while giving opposing mages efective tools to overcome that invincibility and allow magic battles to be resoled in fairly fast, decisive, and satisfying ways.</p>
  <p>The <i>description</i> in section 1 of how these new rules work may seem wordy and complicated, but the goal hopefully achieved by the mod is that you won't have to think too hard about it in-game - just attack the spell defenses until they are gone, then attack the mage. All of the tools at hand will work for that, though of course stronger tools will work better.</p>
  <p>This mod should be installed after spell mods like Spell Revisions, IWDification, and SCS IWD Spells.</p>
</div>
<h2>1. The Rules of Spell Battles</h2>
<div class="section">
  <p>The first major change to the spell battle system is that the reflection and absorption effects of Spell Turning and Spell Trap are gone. See section 3 below for the reasons why; what you need to know is that with this mod there are only three kinds of spell defenses. 
  <ul>
    <li>The first category is <b>deflections</b>, which block spells of any level, but only block a certain number of them, measured in 'spell levels.' An example is the vanilla spell "Spell Deflection." It blocks ten 'levels' of incoming spells, which means it can block ten 1st-level spells, or it can block one 9th-level spell and one other spell. After that the protection dissipates. Generally, deflections only block magic targeted directly at the caster - they will not block area-of-effect or stationary cloud-type magic. Unlike the base game, all deflection defenses can block all spells, up to 9th level; they are limited not by the level of incoming spells, but solely by how many spell levels they can deflect. With this mod, the three deflections are <i>Minor Spell Deflection</i>, <i>Spell Deflection</i>, <i>Greater Spell Deflection</i>, and <i>Shield of the Archons</i>.<br />
    <b>COMPATIBILITY NOTE:</b> this mod is totally compatible with Spell Revisions, including its 'NWN-Style Deflection' component which allows spell deflections to deflect most are-of-effect spells (but still not stationary effects).</li>
    <li>The second category is <b>invulnerability</b>, which blocks an unlimited number of spells, but can only block magic up to a certain spell level. This is basically unchanged from the unmodded game: <i>Minor Globe of Invulnerability</i> blocks magic of up the 3rd level, and <i>Globe of Invulnerability</i> blocks magic of up to 4th level. Unlike deflections, invulnerability spells block area effects like Fireball as well as stationary effects like Stinking Cloud. The difference with this mod is that <i>Spell Trap</i> is moved into this category. It blocks all magic of up to 9th level.</li>
    <li>The third category is spell shields. These do not offer any direct protection against magic, but they can protect spell defenses in the first two categories from being dispelled. The prime example of this is <i>Spell Shield</i>. Additionally, with this mod, <i>Spell Trap</i> acts as a second spell shield in addition to granting invulnerability to magic.</p></li>
  </ul>
  <p>A key thing to remember, and which defines how magic attacks are designed (described below), is that spell defenses can be layered. The <b>effects</b> of <i>Spell Deflection</i> and <i>Minor Spell Deflection</i> do not stack - they can together only absorb the ten spell levels of the high-level <i>Spell Deflection</i> - but they coexist and provide two separate layers of defense when subject to magic attacks like Spell Thrust or Secret Word. A <i>Greater Spell Deflection</i> adds a third layer of defense; Globe of Invulnerability add a fourth; Spell Shield adds a fifth; and Spell Trap adds a sixth. The <i>Spell Deflection</i> spells will actually auto-cast the lesser versions of themselves; so casting <i>Greater Spell Deflection</i> gives you <i>Spell Deflection</i> and <i>Minor Spell Deflection</i> for free, which means you get 20 spell levels of protection against regular spells, and 3 layers of protection against magic attacks.</p>
  <p>The number of defensive layers insulating a wizard is what decides how well-protected they are from attack. When attacking a protected enemy (like an SCS mage who gets pre-buffs plus contingencies and sequencers activated as soon as a fight starts) the question is no longer "is it possible to breach their defenses?" but rather "can I breach their defenses quickly, or slowly?" If you cast Secret Word on an enemy and they are still protected afterward, you can usually assume that you have at least stripped away <b>some</b> of their protections, and if you keep chipping away you will soon make them vulnerable. (Unless they have <i>Spell Trap</i> - <i>Spell Trap</i> is special in that it completely blocks all lower-level magic attacks except <i>Ruby Ray</i> and <i>Pierce Shield</i>.) So when playing, you can try to figure out how many layers of protection the enemy has and think tactically about the optimal way to attack them; or you can just pound away with magic attacks until the enemy is vulnerable. With this mod, both of those approaches are viable.</p>
  <p>Magic attacks like Spell Thrust and Pierce Magic are modified to play into this system. Gone is the limitation that they can only affect defenses of a certain spell level. All magic attacks, from the lowly Spell Thrust up, can affect all spell defenses, with the exception of the apex defenses <i>Shield of the Archons</i> and <i>Spell Trap</i>. (You need a 6th-level </i>Pierce Magic</i> or better to affect <i>Shield of the Archons</i>, and a <i>Ruby Ray</i>, <i>Pierce Shield</i>, or <i>Spellstrike</i> to affect <i>Spell Trap</i>.) Instead, magic attacks are differentiated by how many <b>layers</b> of spell defenses they can remove at once.</p>
  <p>I have also given several magic attacks small secondary effects so that they can have some effect on even the most highly protected enemies.</p>
  <ul>
    <li><i>Spell Thrust</i> destroys one layer of protection. If the target has a <i>Spell Shield</i>, it will destroy the spell shield and will not remove any layers of deflection or invulnerability.</li>
    <li><i>Secret Word</i> destroys two layers of protection. Additionally, even if the target is still protected, it can cause one round of deafness (50% casting failure) if the target fails a save vs. spells. If the target has a <i>Spell Shield</i>, it will destroy the spell shield and will not remove any layers of deflectoin or invulnerability.</li>
    <li>The "<i>Pierce...</i>" spells are special in that they can take out a spell shield in addition to removing other protections, rather than instead of removing other protections. So <i>Pierce Magic</i> destroys two layers of protection <b>plus</b> a <i>Spell Shield</i>. Additionally, even if the target is still protected, it will reduce their magic resistance, if any, to zero for two rounds. </li>
    <li><i>Warding Whip</i> is a bit like casting <i>Secret Word</i> three times in a row: it will remove either one <i>Spell Shield</i> or two layers of protection (in that order), each round for three rounds. (It does not have the secondary deafness effect, though.)</li>
    <li><i>Ruby Ray of Reversal</i> is the first spell capable of defeating a <i>Spell Trap</i>, and it is also more effective at defeating normal spell defenses. It will remove either a <i>Spell Shield</i>, or a <i>Spell Trap</i>, or three layers of normal spell defenses (in that order). Additionally, even if the target is still protected, it can cause blindness for one round if the target fails a save vs. spells with a -2 penalty.</li>
    <li><i>Pierce Shield</i> destroys a <i>Spell Shield</i> <b>and</b> either one <i>Spell Trap</i> or three layers of normal spell defenses. </li>
    <li><i>Spellstrike</i> will remove all of a target's spell defenses in one fell swoop, and additionally will apply 100% casting failure to the target for one round, thus preventing the target from raising new defenses. This is basically god-level magic, and it can pretty much render anyone vulnerable.</p></li>
  </ul>
  <p>Magic attacks that remove multiple layers of spell defenses remove the highest-level defenses first, with the exception that a <i>Spell Shield</i> will always be the first defense to be removed.</p>
  <p></p>
</div>
<h2>2. Related Systems</h2>
<div class="section">
  <p><i>Breach</i> will be blocked by all deflection defenses and by invulnerability effects where it makes sense (just <i>Spell Trap</i>, essentially). So it will be blocked once by <i>Minor Spell Deflection</i> since that blocks 5 spell levels, but will not be blocked by <i>Globe of Invulnerability</i> since that only blocks up to 4th level spells.</p>
  <p>This mod incorporates my "breachier breach" concept in that it allows <i>Breach</i> to affect enemies such as liches and rakshasa which have innate invulnerability to certain spell levels.</p>
  <p>This mod changes <i>Remove Magic</i> to be a sort of miniature <i>Breach</i>, so that you have another way to achieve <i>Breach</i>-style effects. Whereas <i>Breach</i> destroys all combat protections and specific protections, <i>Remove Magic</i> will remove <b>one</b> combat protection and <b>one</b> specific protection of up to 6th level. Like <i>Breach</i>, Remove Magic will work against liches and rakshasa.</p>
  <p><i>Dispel Magic</i> works as usual, though there are several configuration options to modify its behavior; read more about them below. <b>COMPATIBILITY NOTE:</b> if this mod is installed after Polytope's Revised Dispel Magic mod (PolyDisp.tp2), then depending on your PolyDisp install options it may render spell defenses dispellable, which they ordinarily are not. Conversely, if you install PolyDisp after this mod, then PolyDisp will overwrite this new 'mini-Breach' version of <i>Remove Magic</i> and revert it to the spell's original 'similar-to-Dispel-Magic' behavior.</p>
  <p>A note about Dispel Magic and Remove Magic and their area-of-effect design: while Deflections generally do not block area-of-effect spells, with this mod they <b>will</b> block <i>Dispel Magic</i> and <i>Remove Magic</i>. Globes of Invulnerability and creatures' innate spell level invulnerability will not block <i>Dispel Magic</i> and <i>Remove Magic</i>, though that is configurable (see below).</p>
</div>
<h2>3. Aesthetic Tweaks</h2>
<div class="section">
  <p>This mod incorporates a version of DavidNYC's excellent work to systematize and distinguish the visual effects for various spells and defenses in the game. It removes the visual effects of ioun stones (a necessary evil, and let's admit it, they are comically large to represent small floating pebbles) and removes the visual effects for various spells (Spell Shield, Spell Turning) and then applies recolored variants to various defensive effects so that you can recognize which protections an enemy has. Roughly, the applied effects are these:</p>
  <ul>
    <li><i>Protection from Normal Weapons</i> shows a stationary green-tinted light above the caster's head.</li>
    <li><i>Protection from Magic Weapons</i> shows a stationary purple-tinted light above the caster's's head.</li>
    <li><i>Absolute Immunity</i> shows a stationary light above the caster's's head that continually changes colors.</li>
    <li><i>Protection from Missiles</i> shows a red rotating ioun stone animation.</li>
    <li><i>Non-Detection</i> shows a black rotating ioun stone animation.</li>
    <li><i>Minor Spell Deflection</i> shows three white swirling motes.</li>
    <li><i>Spell Deflection</i> shows three blue swirling motes.</li>
    <li><i>Greater Spell Deflection</i> shows three gold swirling motes.</li>
    <li><i>Shield of the Archons</i> shows three teal swirling motes.</li>
    <li><i>Spell Trap</i> shows three purple swirling motes.</li>
    <li><i>Spell Shield</i> shows a tall semi-transparent blue oval around the caster.</li>
    <li><i>Spell Immunity</i> (or <i>Dispelling Screen</i> if you have Spell Revisions installed) shows a glowing silver disc on the ground beneath the caster's feet.</li>
    <li><i>Globes of Invulnerability</i> are the same semi-transparent globes that you know from the unmodded game.</p></li>
  </ul>
  <p>You may come to recognize defensive spell effects by these visuals, or you may not care and rely on the combat log instead. Either way I think this is an overall visual improvement over the base game.</p>
  <p>The mod folder has a "visuals" subfolder with some pictures to show a protected mage being steadily disarmed by Secret Word/Secret Word/Breach. You can see more example pictures on pages 75-77 of the "SR Revised" thread in the Spell Revisions forum at Gibberlings3.net.</p>
</div>
<h2>5. Justifications for Certain Changes</h2>
<div class="section">
  <p>Why remove Spell Turning effects??</p>
  <p>First, they add needless complexity with the way they could only block low-level incoming spells. Second, they make the game easy because human players can recognize them and avoid reflected effects while the AI enemies cannot. Third, because of that, if you use SCS then SCS casters will never be so stupid as to have spells reflected at them; but this means spell turning prevents SCS enemies from casting at you at all, so it is sort fo more powerful than it should be. AT the end of the day, they just don't add much to these fights. Only using Deflections gives mages adequate protection while really streamlining the systems for dealing with that protection. Props to Demi/Ardanis/kreso of Spell Revisions fame for initially making this change and convincing me of its superiority</p>
  <p>(I think I had more to write here, but now I forget...)</p>
</div>
<h2>5. Configuration Options</h2>
<div class="section">
  <p>There are lots. They are controlled by the 'MBR_settings.ini' file. You can modify these settings before installing the mod. I will explain each one here.</p>
  <p>"<b>minor_deflection_levels_blocked</b>" These settings determine how many spell levels are blocked by the various Deflection spells. The default values are 5/10/20, and 30 for <i>Shield of the Archons</i>.</p>
  <p><b>spell_attack_delay</b> You can set this between 1 and 5, and it will mean that the effects of magic attacks will be slightly delayed. So instead of slamming an opponent with Breach immediately after your Ruby Ray destroys his spell protections, you will have to wait for a second or two. Theoretically this can add some tension and drama to magic attacks. But I haven't played around with it very much. The default value is 0.</p>
  <p><b>dispel_bypass_globes</b> As I said above, the default behavior is for <i>Dispel Magic</i> and <i>Remove Magic</i> to bypass <i>Globes of Invulnerability</i> and innate spell-level immunity. By setting this value to 0 you can reverse that, such that <i>DM</i> and <i>RM</i> are completely blocked by spell-level immunities.</p>
  <p><b>party_friendly_dispel</b> This makes <i>Dispel Magic</i> only affect enemies. Effectively, this means instead of <i>Dispel Magic</i> and the new version of <i>Remove Magic</i>, you will have the old version of </i>Remove Magic</i> and the new version of </i>Remove Magic</i>.</p>
  <p><b>mini_breach_dispel</b> This will change <i>Dispel Magic</i> to have the same 'mini-Breach' effect as the new <i>Remove Magic</i>, removing one combat protection and one specific protection from the target. It still affects both enemies and party member, however. (If you set both this value and the 'party_friendly_dispel' value to 1, then both <i>Dispel Magic</i> and <i>Remove Magic</i> will effectively be the same.)</p>
  <p><b>mini_breach_remove</b> This is set to 1 by default, and this is what gives <i>Remove Magic</i> the new 'mini-Breach' behavior. If you set this to 0, then <i>Remove Magic</i> will behave the old way, with a random chance to dispel incluenced by caster level.</p>
  <p><b>breach_combat_protections</b> et cetera. These variables set which kinds of protections <i>Breach</i> will remove. In the base game this only includes "combat protections" (think Armor or Stoneskin) and "specific protections" (think Resist Fire or Chaotic Commands). You can optionally add "combination protections" and "noncombat protections" as well, though this only affects a select few spells.</p>
</div>
<h2>Contact Information</h2>
<div class="section">
  <p>This mod was created by SubtleDoctor. You can visit <a href="http://forums.gibberlings3.net/index.php">The
    Gibberlings Three</a> for information on this and many other fine mods.</p>
</div>
<h2>Thanks and Acknowledgements</h2>
<div class="section">
  <p>Thanks to the still active and vibrant Infinity Engine modding community. </p>
  <p>Thanks to Demi, Ardanis, Mike1072, kreso, and others who worked in Spell Revisions, and to DavidNYC for the work on the excellent modified spell visual effects. </p>
  <p><strong>Tools Used in Creation</strong><br />
    <a href="http://www.weidu.org/"><acronym title="Weimer Dialogue Utility">WeiDU</acronym></a> by Wes Weimer, and then the bigg and then Wisp<br />
    <a href="http://www.idi.ntnu.no/~joh/ni/">Near Infinity</a> by Jon Olav Hauglid, and then Argent77 and Astrobryguy<br />
    <a href="http://iesdp.gibberlings3.net/"><acronym title="Infinity Engine Structures Description Project">IESDP</acronym></a> maintained by igi and then the G3 community</p>
</div>
<h2>Credits and Copyright Information</h2>
<div class="section">
  <p>Copyright 2021. If you want to use or adapt any part of this mod in another mod or similar endeavor, please try to contact me at forums.gibberlings3.net to discuss it. As a general rule, I have no problem with that as long as you credit the source of the work. If you cannot get in touch with me, assume that you have my permission to use any of this code for any project that is non-commercial, offered for free, and intended for the greater enjoyment of players of Infinity Engine games. If you do so, please credit me, and mention how awesome I am in a comment in the code, or something like that. You may NOT use this code for any profit-making or commercial venture, without express permission from me.</p>
</div>
</body>
</html>
